# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualInterfaceArgs', 'VirtualInterface']

@pulumi.input_type
class VirtualInterfaceArgs:
    def __init__(__self__, *,
                 direct_connect_connection_id: pulumi.Input[str],
                 direct_connect_gateway_id: pulumi.Input[str],
                 local_ip: pulumi.Input[str],
                 peer_ip: pulumi.Input[str],
                 vlan_id: pulumi.Input[int],
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 bfd_detect_interval: Optional[pulumi.Input[int]] = None,
                 bfd_detect_multiplier: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_bfd: Optional[pulumi.Input[bool]] = None,
                 enable_nqa: Optional[pulumi.Input[bool]] = None,
                 nqa_detect_interval: Optional[pulumi.Input[int]] = None,
                 nqa_detect_multiplier: Optional[pulumi.Input[int]] = None,
                 route_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualInterfaceTagArgs']]]] = None,
                 virtual_interface_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VirtualInterface resource.
        :param pulumi.Input[str] direct_connect_connection_id: The direct connect connection ID which associated with.
        :param pulumi.Input[str] direct_connect_gateway_id: The direct connect gateway ID which associated with.
        :param pulumi.Input[str] local_ip: The local IP that associated with.
        :param pulumi.Input[str] peer_ip: The peer IP that associated with.
        :param pulumi.Input[int] vlan_id: The VLAN ID used to connect to the local IDC, please ensure that this VLAN ID is not occupied, the value range: 0 ~ 2999.
        :param pulumi.Input[int] bandwidth: The band width limit of virtual interface,in Mbps.
        :param pulumi.Input[int] bfd_detect_interval: The BFD detect interval.
        :param pulumi.Input[int] bfd_detect_multiplier: The BFD detect times.
        :param pulumi.Input[str] description: The description of virtual interface.
        :param pulumi.Input[bool] enable_bfd: Whether enable BFD detect.
        :param pulumi.Input[bool] enable_nqa: Whether enable NQA detect.
        :param pulumi.Input[int] nqa_detect_interval: The NQA detect interval.
        :param pulumi.Input[int] nqa_detect_multiplier: The NAQ detect times.
        :param pulumi.Input[str] route_type: The route type of virtual interface,valid value contains `Static`,`BGP`.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualInterfaceTagArgs']]] tags: The tags that direct connect gateway added.
        :param pulumi.Input[str] virtual_interface_name: The name of virtual interface.
        """
        pulumi.set(__self__, "direct_connect_connection_id", direct_connect_connection_id)
        pulumi.set(__self__, "direct_connect_gateway_id", direct_connect_gateway_id)
        pulumi.set(__self__, "local_ip", local_ip)
        pulumi.set(__self__, "peer_ip", peer_ip)
        pulumi.set(__self__, "vlan_id", vlan_id)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if bfd_detect_interval is not None:
            pulumi.set(__self__, "bfd_detect_interval", bfd_detect_interval)
        if bfd_detect_multiplier is not None:
            pulumi.set(__self__, "bfd_detect_multiplier", bfd_detect_multiplier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_bfd is not None:
            pulumi.set(__self__, "enable_bfd", enable_bfd)
        if enable_nqa is not None:
            pulumi.set(__self__, "enable_nqa", enable_nqa)
        if nqa_detect_interval is not None:
            pulumi.set(__self__, "nqa_detect_interval", nqa_detect_interval)
        if nqa_detect_multiplier is not None:
            pulumi.set(__self__, "nqa_detect_multiplier", nqa_detect_multiplier)
        if route_type is not None:
            pulumi.set(__self__, "route_type", route_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_interface_name is not None:
            pulumi.set(__self__, "virtual_interface_name", virtual_interface_name)

    @property
    @pulumi.getter(name="directConnectConnectionId")
    def direct_connect_connection_id(self) -> pulumi.Input[str]:
        """
        The direct connect connection ID which associated with.
        """
        return pulumi.get(self, "direct_connect_connection_id")

    @direct_connect_connection_id.setter
    def direct_connect_connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "direct_connect_connection_id", value)

    @property
    @pulumi.getter(name="directConnectGatewayId")
    def direct_connect_gateway_id(self) -> pulumi.Input[str]:
        """
        The direct connect gateway ID which associated with.
        """
        return pulumi.get(self, "direct_connect_gateway_id")

    @direct_connect_gateway_id.setter
    def direct_connect_gateway_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "direct_connect_gateway_id", value)

    @property
    @pulumi.getter(name="localIp")
    def local_ip(self) -> pulumi.Input[str]:
        """
        The local IP that associated with.
        """
        return pulumi.get(self, "local_ip")

    @local_ip.setter
    def local_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "local_ip", value)

    @property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> pulumi.Input[str]:
        """
        The peer IP that associated with.
        """
        return pulumi.get(self, "peer_ip")

    @peer_ip.setter
    def peer_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_ip", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Input[int]:
        """
        The VLAN ID used to connect to the local IDC, please ensure that this VLAN ID is not occupied, the value range: 0 ~ 2999.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The band width limit of virtual interface,in Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="bfdDetectInterval")
    def bfd_detect_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The BFD detect interval.
        """
        return pulumi.get(self, "bfd_detect_interval")

    @bfd_detect_interval.setter
    def bfd_detect_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bfd_detect_interval", value)

    @property
    @pulumi.getter(name="bfdDetectMultiplier")
    def bfd_detect_multiplier(self) -> Optional[pulumi.Input[int]]:
        """
        The BFD detect times.
        """
        return pulumi.get(self, "bfd_detect_multiplier")

    @bfd_detect_multiplier.setter
    def bfd_detect_multiplier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bfd_detect_multiplier", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of virtual interface.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableBfd")
    def enable_bfd(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable BFD detect.
        """
        return pulumi.get(self, "enable_bfd")

    @enable_bfd.setter
    def enable_bfd(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_bfd", value)

    @property
    @pulumi.getter(name="enableNqa")
    def enable_nqa(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable NQA detect.
        """
        return pulumi.get(self, "enable_nqa")

    @enable_nqa.setter
    def enable_nqa(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_nqa", value)

    @property
    @pulumi.getter(name="nqaDetectInterval")
    def nqa_detect_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The NQA detect interval.
        """
        return pulumi.get(self, "nqa_detect_interval")

    @nqa_detect_interval.setter
    def nqa_detect_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nqa_detect_interval", value)

    @property
    @pulumi.getter(name="nqaDetectMultiplier")
    def nqa_detect_multiplier(self) -> Optional[pulumi.Input[int]]:
        """
        The NAQ detect times.
        """
        return pulumi.get(self, "nqa_detect_multiplier")

    @nqa_detect_multiplier.setter
    def nqa_detect_multiplier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nqa_detect_multiplier", value)

    @property
    @pulumi.getter(name="routeType")
    def route_type(self) -> Optional[pulumi.Input[str]]:
        """
        The route type of virtual interface,valid value contains `Static`,`BGP`.
        """
        return pulumi.get(self, "route_type")

    @route_type.setter
    def route_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualInterfaceTagArgs']]]]:
        """
        The tags that direct connect gateway added.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualInterfaceTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="virtualInterfaceName")
    def virtual_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of virtual interface.
        """
        return pulumi.get(self, "virtual_interface_name")

    @virtual_interface_name.setter
    def virtual_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_interface_name", value)


@pulumi.input_type
class _VirtualInterfaceState:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 bfd_detect_interval: Optional[pulumi.Input[int]] = None,
                 bfd_detect_multiplier: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direct_connect_connection_id: Optional[pulumi.Input[str]] = None,
                 direct_connect_gateway_id: Optional[pulumi.Input[str]] = None,
                 enable_bfd: Optional[pulumi.Input[bool]] = None,
                 enable_nqa: Optional[pulumi.Input[bool]] = None,
                 local_ip: Optional[pulumi.Input[str]] = None,
                 nqa_detect_interval: Optional[pulumi.Input[int]] = None,
                 nqa_detect_multiplier: Optional[pulumi.Input[int]] = None,
                 peer_ip: Optional[pulumi.Input[str]] = None,
                 route_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualInterfaceTagArgs']]]] = None,
                 virtual_interface_name: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering VirtualInterface resources.
        :param pulumi.Input[int] bandwidth: The band width limit of virtual interface,in Mbps.
        :param pulumi.Input[int] bfd_detect_interval: The BFD detect interval.
        :param pulumi.Input[int] bfd_detect_multiplier: The BFD detect times.
        :param pulumi.Input[str] description: The description of virtual interface.
        :param pulumi.Input[str] direct_connect_connection_id: The direct connect connection ID which associated with.
        :param pulumi.Input[str] direct_connect_gateway_id: The direct connect gateway ID which associated with.
        :param pulumi.Input[bool] enable_bfd: Whether enable BFD detect.
        :param pulumi.Input[bool] enable_nqa: Whether enable NQA detect.
        :param pulumi.Input[str] local_ip: The local IP that associated with.
        :param pulumi.Input[int] nqa_detect_interval: The NQA detect interval.
        :param pulumi.Input[int] nqa_detect_multiplier: The NAQ detect times.
        :param pulumi.Input[str] peer_ip: The peer IP that associated with.
        :param pulumi.Input[str] route_type: The route type of virtual interface,valid value contains `Static`,`BGP`.
        :param pulumi.Input[Sequence[pulumi.Input['VirtualInterfaceTagArgs']]] tags: The tags that direct connect gateway added.
        :param pulumi.Input[str] virtual_interface_name: The name of virtual interface.
        :param pulumi.Input[int] vlan_id: The VLAN ID used to connect to the local IDC, please ensure that this VLAN ID is not occupied, the value range: 0 ~ 2999.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if bfd_detect_interval is not None:
            pulumi.set(__self__, "bfd_detect_interval", bfd_detect_interval)
        if bfd_detect_multiplier is not None:
            pulumi.set(__self__, "bfd_detect_multiplier", bfd_detect_multiplier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direct_connect_connection_id is not None:
            pulumi.set(__self__, "direct_connect_connection_id", direct_connect_connection_id)
        if direct_connect_gateway_id is not None:
            pulumi.set(__self__, "direct_connect_gateway_id", direct_connect_gateway_id)
        if enable_bfd is not None:
            pulumi.set(__self__, "enable_bfd", enable_bfd)
        if enable_nqa is not None:
            pulumi.set(__self__, "enable_nqa", enable_nqa)
        if local_ip is not None:
            pulumi.set(__self__, "local_ip", local_ip)
        if nqa_detect_interval is not None:
            pulumi.set(__self__, "nqa_detect_interval", nqa_detect_interval)
        if nqa_detect_multiplier is not None:
            pulumi.set(__self__, "nqa_detect_multiplier", nqa_detect_multiplier)
        if peer_ip is not None:
            pulumi.set(__self__, "peer_ip", peer_ip)
        if route_type is not None:
            pulumi.set(__self__, "route_type", route_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_interface_name is not None:
            pulumi.set(__self__, "virtual_interface_name", virtual_interface_name)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The band width limit of virtual interface,in Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="bfdDetectInterval")
    def bfd_detect_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The BFD detect interval.
        """
        return pulumi.get(self, "bfd_detect_interval")

    @bfd_detect_interval.setter
    def bfd_detect_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bfd_detect_interval", value)

    @property
    @pulumi.getter(name="bfdDetectMultiplier")
    def bfd_detect_multiplier(self) -> Optional[pulumi.Input[int]]:
        """
        The BFD detect times.
        """
        return pulumi.get(self, "bfd_detect_multiplier")

    @bfd_detect_multiplier.setter
    def bfd_detect_multiplier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bfd_detect_multiplier", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of virtual interface.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="directConnectConnectionId")
    def direct_connect_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        The direct connect connection ID which associated with.
        """
        return pulumi.get(self, "direct_connect_connection_id")

    @direct_connect_connection_id.setter
    def direct_connect_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direct_connect_connection_id", value)

    @property
    @pulumi.getter(name="directConnectGatewayId")
    def direct_connect_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The direct connect gateway ID which associated with.
        """
        return pulumi.get(self, "direct_connect_gateway_id")

    @direct_connect_gateway_id.setter
    def direct_connect_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direct_connect_gateway_id", value)

    @property
    @pulumi.getter(name="enableBfd")
    def enable_bfd(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable BFD detect.
        """
        return pulumi.get(self, "enable_bfd")

    @enable_bfd.setter
    def enable_bfd(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_bfd", value)

    @property
    @pulumi.getter(name="enableNqa")
    def enable_nqa(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable NQA detect.
        """
        return pulumi.get(self, "enable_nqa")

    @enable_nqa.setter
    def enable_nqa(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_nqa", value)

    @property
    @pulumi.getter(name="localIp")
    def local_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The local IP that associated with.
        """
        return pulumi.get(self, "local_ip")

    @local_ip.setter
    def local_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_ip", value)

    @property
    @pulumi.getter(name="nqaDetectInterval")
    def nqa_detect_interval(self) -> Optional[pulumi.Input[int]]:
        """
        The NQA detect interval.
        """
        return pulumi.get(self, "nqa_detect_interval")

    @nqa_detect_interval.setter
    def nqa_detect_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nqa_detect_interval", value)

    @property
    @pulumi.getter(name="nqaDetectMultiplier")
    def nqa_detect_multiplier(self) -> Optional[pulumi.Input[int]]:
        """
        The NAQ detect times.
        """
        return pulumi.get(self, "nqa_detect_multiplier")

    @nqa_detect_multiplier.setter
    def nqa_detect_multiplier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nqa_detect_multiplier", value)

    @property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The peer IP that associated with.
        """
        return pulumi.get(self, "peer_ip")

    @peer_ip.setter
    def peer_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_ip", value)

    @property
    @pulumi.getter(name="routeType")
    def route_type(self) -> Optional[pulumi.Input[str]]:
        """
        The route type of virtual interface,valid value contains `Static`,`BGP`.
        """
        return pulumi.get(self, "route_type")

    @route_type.setter
    def route_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VirtualInterfaceTagArgs']]]]:
        """
        The tags that direct connect gateway added.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VirtualInterfaceTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="virtualInterfaceName")
    def virtual_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of virtual interface.
        """
        return pulumi.get(self, "virtual_interface_name")

    @virtual_interface_name.setter
    def virtual_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_interface_name", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[int]]:
        """
        The VLAN ID used to connect to the local IDC, please ensure that this VLAN ID is not occupied, the value range: 0 ~ 2999.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_id", value)


class VirtualInterface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 bfd_detect_interval: Optional[pulumi.Input[int]] = None,
                 bfd_detect_multiplier: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direct_connect_connection_id: Optional[pulumi.Input[str]] = None,
                 direct_connect_gateway_id: Optional[pulumi.Input[str]] = None,
                 enable_bfd: Optional[pulumi.Input[bool]] = None,
                 enable_nqa: Optional[pulumi.Input[bool]] = None,
                 local_ip: Optional[pulumi.Input[str]] = None,
                 nqa_detect_interval: Optional[pulumi.Input[int]] = None,
                 nqa_detect_multiplier: Optional[pulumi.Input[int]] = None,
                 peer_ip: Optional[pulumi.Input[str]] = None,
                 route_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualInterfaceTagArgs']]]]] = None,
                 virtual_interface_name: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a resource to manage direct connect virtual interface
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.direct_connect.VirtualInterface("foo",
            description="tf-test",
            direct_connect_connection_id="dcc-rtkzeotzst1cu3numzi****",
            direct_connect_gateway_id="dcg-638x4bjvjawwn3gd5xw****",
            enable_bfd=False,
            local_ip="**.**.**.**/**",
            peer_ip="**.**.**.**/**",
            route_type="Static",
            tags=[volcengine.direct_connect.VirtualInterfaceTagArgs(
                key="k1",
                value="v1",
            )],
            virtual_interface_name="tf-test-vi",
            vlan_id=2)
        ```

        ## Import

        DirectConnectVirtualInterface can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:direct_connect/virtualInterface:VirtualInterface default resource_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bandwidth: The band width limit of virtual interface,in Mbps.
        :param pulumi.Input[int] bfd_detect_interval: The BFD detect interval.
        :param pulumi.Input[int] bfd_detect_multiplier: The BFD detect times.
        :param pulumi.Input[str] description: The description of virtual interface.
        :param pulumi.Input[str] direct_connect_connection_id: The direct connect connection ID which associated with.
        :param pulumi.Input[str] direct_connect_gateway_id: The direct connect gateway ID which associated with.
        :param pulumi.Input[bool] enable_bfd: Whether enable BFD detect.
        :param pulumi.Input[bool] enable_nqa: Whether enable NQA detect.
        :param pulumi.Input[str] local_ip: The local IP that associated with.
        :param pulumi.Input[int] nqa_detect_interval: The NQA detect interval.
        :param pulumi.Input[int] nqa_detect_multiplier: The NAQ detect times.
        :param pulumi.Input[str] peer_ip: The peer IP that associated with.
        :param pulumi.Input[str] route_type: The route type of virtual interface,valid value contains `Static`,`BGP`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualInterfaceTagArgs']]]] tags: The tags that direct connect gateway added.
        :param pulumi.Input[str] virtual_interface_name: The name of virtual interface.
        :param pulumi.Input[int] vlan_id: The VLAN ID used to connect to the local IDC, please ensure that this VLAN ID is not occupied, the value range: 0 ~ 2999.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualInterfaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage direct connect virtual interface
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.direct_connect.VirtualInterface("foo",
            description="tf-test",
            direct_connect_connection_id="dcc-rtkzeotzst1cu3numzi****",
            direct_connect_gateway_id="dcg-638x4bjvjawwn3gd5xw****",
            enable_bfd=False,
            local_ip="**.**.**.**/**",
            peer_ip="**.**.**.**/**",
            route_type="Static",
            tags=[volcengine.direct_connect.VirtualInterfaceTagArgs(
                key="k1",
                value="v1",
            )],
            virtual_interface_name="tf-test-vi",
            vlan_id=2)
        ```

        ## Import

        DirectConnectVirtualInterface can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:direct_connect/virtualInterface:VirtualInterface default resource_id
        ```

        :param str resource_name: The name of the resource.
        :param VirtualInterfaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualInterfaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 bfd_detect_interval: Optional[pulumi.Input[int]] = None,
                 bfd_detect_multiplier: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direct_connect_connection_id: Optional[pulumi.Input[str]] = None,
                 direct_connect_gateway_id: Optional[pulumi.Input[str]] = None,
                 enable_bfd: Optional[pulumi.Input[bool]] = None,
                 enable_nqa: Optional[pulumi.Input[bool]] = None,
                 local_ip: Optional[pulumi.Input[str]] = None,
                 nqa_detect_interval: Optional[pulumi.Input[int]] = None,
                 nqa_detect_multiplier: Optional[pulumi.Input[int]] = None,
                 peer_ip: Optional[pulumi.Input[str]] = None,
                 route_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualInterfaceTagArgs']]]]] = None,
                 virtual_interface_name: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualInterfaceArgs.__new__(VirtualInterfaceArgs)

            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["bfd_detect_interval"] = bfd_detect_interval
            __props__.__dict__["bfd_detect_multiplier"] = bfd_detect_multiplier
            __props__.__dict__["description"] = description
            if direct_connect_connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'direct_connect_connection_id'")
            __props__.__dict__["direct_connect_connection_id"] = direct_connect_connection_id
            if direct_connect_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'direct_connect_gateway_id'")
            __props__.__dict__["direct_connect_gateway_id"] = direct_connect_gateway_id
            __props__.__dict__["enable_bfd"] = enable_bfd
            __props__.__dict__["enable_nqa"] = enable_nqa
            if local_ip is None and not opts.urn:
                raise TypeError("Missing required property 'local_ip'")
            __props__.__dict__["local_ip"] = local_ip
            __props__.__dict__["nqa_detect_interval"] = nqa_detect_interval
            __props__.__dict__["nqa_detect_multiplier"] = nqa_detect_multiplier
            if peer_ip is None and not opts.urn:
                raise TypeError("Missing required property 'peer_ip'")
            __props__.__dict__["peer_ip"] = peer_ip
            __props__.__dict__["route_type"] = route_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["virtual_interface_name"] = virtual_interface_name
            if vlan_id is None and not opts.urn:
                raise TypeError("Missing required property 'vlan_id'")
            __props__.__dict__["vlan_id"] = vlan_id
        super(VirtualInterface, __self__).__init__(
            'volcengine:direct_connect/virtualInterface:VirtualInterface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth: Optional[pulumi.Input[int]] = None,
            bfd_detect_interval: Optional[pulumi.Input[int]] = None,
            bfd_detect_multiplier: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            direct_connect_connection_id: Optional[pulumi.Input[str]] = None,
            direct_connect_gateway_id: Optional[pulumi.Input[str]] = None,
            enable_bfd: Optional[pulumi.Input[bool]] = None,
            enable_nqa: Optional[pulumi.Input[bool]] = None,
            local_ip: Optional[pulumi.Input[str]] = None,
            nqa_detect_interval: Optional[pulumi.Input[int]] = None,
            nqa_detect_multiplier: Optional[pulumi.Input[int]] = None,
            peer_ip: Optional[pulumi.Input[str]] = None,
            route_type: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualInterfaceTagArgs']]]]] = None,
            virtual_interface_name: Optional[pulumi.Input[str]] = None,
            vlan_id: Optional[pulumi.Input[int]] = None) -> 'VirtualInterface':
        """
        Get an existing VirtualInterface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bandwidth: The band width limit of virtual interface,in Mbps.
        :param pulumi.Input[int] bfd_detect_interval: The BFD detect interval.
        :param pulumi.Input[int] bfd_detect_multiplier: The BFD detect times.
        :param pulumi.Input[str] description: The description of virtual interface.
        :param pulumi.Input[str] direct_connect_connection_id: The direct connect connection ID which associated with.
        :param pulumi.Input[str] direct_connect_gateway_id: The direct connect gateway ID which associated with.
        :param pulumi.Input[bool] enable_bfd: Whether enable BFD detect.
        :param pulumi.Input[bool] enable_nqa: Whether enable NQA detect.
        :param pulumi.Input[str] local_ip: The local IP that associated with.
        :param pulumi.Input[int] nqa_detect_interval: The NQA detect interval.
        :param pulumi.Input[int] nqa_detect_multiplier: The NAQ detect times.
        :param pulumi.Input[str] peer_ip: The peer IP that associated with.
        :param pulumi.Input[str] route_type: The route type of virtual interface,valid value contains `Static`,`BGP`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VirtualInterfaceTagArgs']]]] tags: The tags that direct connect gateway added.
        :param pulumi.Input[str] virtual_interface_name: The name of virtual interface.
        :param pulumi.Input[int] vlan_id: The VLAN ID used to connect to the local IDC, please ensure that this VLAN ID is not occupied, the value range: 0 ~ 2999.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualInterfaceState.__new__(_VirtualInterfaceState)

        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["bfd_detect_interval"] = bfd_detect_interval
        __props__.__dict__["bfd_detect_multiplier"] = bfd_detect_multiplier
        __props__.__dict__["description"] = description
        __props__.__dict__["direct_connect_connection_id"] = direct_connect_connection_id
        __props__.__dict__["direct_connect_gateway_id"] = direct_connect_gateway_id
        __props__.__dict__["enable_bfd"] = enable_bfd
        __props__.__dict__["enable_nqa"] = enable_nqa
        __props__.__dict__["local_ip"] = local_ip
        __props__.__dict__["nqa_detect_interval"] = nqa_detect_interval
        __props__.__dict__["nqa_detect_multiplier"] = nqa_detect_multiplier
        __props__.__dict__["peer_ip"] = peer_ip
        __props__.__dict__["route_type"] = route_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["virtual_interface_name"] = virtual_interface_name
        __props__.__dict__["vlan_id"] = vlan_id
        return VirtualInterface(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[int]:
        """
        The band width limit of virtual interface,in Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="bfdDetectInterval")
    def bfd_detect_interval(self) -> pulumi.Output[Optional[int]]:
        """
        The BFD detect interval.
        """
        return pulumi.get(self, "bfd_detect_interval")

    @property
    @pulumi.getter(name="bfdDetectMultiplier")
    def bfd_detect_multiplier(self) -> pulumi.Output[Optional[int]]:
        """
        The BFD detect times.
        """
        return pulumi.get(self, "bfd_detect_multiplier")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of virtual interface.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="directConnectConnectionId")
    def direct_connect_connection_id(self) -> pulumi.Output[str]:
        """
        The direct connect connection ID which associated with.
        """
        return pulumi.get(self, "direct_connect_connection_id")

    @property
    @pulumi.getter(name="directConnectGatewayId")
    def direct_connect_gateway_id(self) -> pulumi.Output[str]:
        """
        The direct connect gateway ID which associated with.
        """
        return pulumi.get(self, "direct_connect_gateway_id")

    @property
    @pulumi.getter(name="enableBfd")
    def enable_bfd(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether enable BFD detect.
        """
        return pulumi.get(self, "enable_bfd")

    @property
    @pulumi.getter(name="enableNqa")
    def enable_nqa(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether enable NQA detect.
        """
        return pulumi.get(self, "enable_nqa")

    @property
    @pulumi.getter(name="localIp")
    def local_ip(self) -> pulumi.Output[str]:
        """
        The local IP that associated with.
        """
        return pulumi.get(self, "local_ip")

    @property
    @pulumi.getter(name="nqaDetectInterval")
    def nqa_detect_interval(self) -> pulumi.Output[Optional[int]]:
        """
        The NQA detect interval.
        """
        return pulumi.get(self, "nqa_detect_interval")

    @property
    @pulumi.getter(name="nqaDetectMultiplier")
    def nqa_detect_multiplier(self) -> pulumi.Output[Optional[int]]:
        """
        The NAQ detect times.
        """
        return pulumi.get(self, "nqa_detect_multiplier")

    @property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> pulumi.Output[str]:
        """
        The peer IP that associated with.
        """
        return pulumi.get(self, "peer_ip")

    @property
    @pulumi.getter(name="routeType")
    def route_type(self) -> pulumi.Output[str]:
        """
        The route type of virtual interface,valid value contains `Static`,`BGP`.
        """
        return pulumi.get(self, "route_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.VirtualInterfaceTag']]]:
        """
        The tags that direct connect gateway added.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="virtualInterfaceName")
    def virtual_interface_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of virtual interface.
        """
        return pulumi.get(self, "virtual_interface_name")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[int]:
        """
        The VLAN ID used to connect to the local IDC, please ensure that this VLAN ID is not occupied, the value range: 0 ~ 2999.
        """
        return pulumi.get(self, "vlan_id")

