# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'VirtualInterfacesResult',
    'AwaitableVirtualInterfacesResult',
    'virtual_interfaces',
    'virtual_interfaces_output',
]

@pulumi.output_type
class VirtualInterfacesResult:
    """
    A collection of values returned by VirtualInterfaces.
    """
    def __init__(__self__, direct_connect_connection_id=None, direct_connect_gateway_id=None, id=None, ids=None, local_ip=None, name_regex=None, output_file=None, peer_ip=None, route_type=None, tag_filters=None, total_count=None, virtual_interface_name=None, virtual_interfaces=None, vlan_id=None):
        if direct_connect_connection_id and not isinstance(direct_connect_connection_id, str):
            raise TypeError("Expected argument 'direct_connect_connection_id' to be a str")
        pulumi.set(__self__, "direct_connect_connection_id", direct_connect_connection_id)
        if direct_connect_gateway_id and not isinstance(direct_connect_gateway_id, str):
            raise TypeError("Expected argument 'direct_connect_gateway_id' to be a str")
        pulumi.set(__self__, "direct_connect_gateway_id", direct_connect_gateway_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if local_ip and not isinstance(local_ip, str):
            raise TypeError("Expected argument 'local_ip' to be a str")
        pulumi.set(__self__, "local_ip", local_ip)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if peer_ip and not isinstance(peer_ip, str):
            raise TypeError("Expected argument 'peer_ip' to be a str")
        pulumi.set(__self__, "peer_ip", peer_ip)
        if route_type and not isinstance(route_type, str):
            raise TypeError("Expected argument 'route_type' to be a str")
        pulumi.set(__self__, "route_type", route_type)
        if tag_filters and not isinstance(tag_filters, list):
            raise TypeError("Expected argument 'tag_filters' to be a list")
        pulumi.set(__self__, "tag_filters", tag_filters)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if virtual_interface_name and not isinstance(virtual_interface_name, str):
            raise TypeError("Expected argument 'virtual_interface_name' to be a str")
        pulumi.set(__self__, "virtual_interface_name", virtual_interface_name)
        if virtual_interfaces and not isinstance(virtual_interfaces, list):
            raise TypeError("Expected argument 'virtual_interfaces' to be a list")
        pulumi.set(__self__, "virtual_interfaces", virtual_interfaces)
        if vlan_id and not isinstance(vlan_id, int):
            raise TypeError("Expected argument 'vlan_id' to be a int")
        pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter(name="directConnectConnectionId")
    def direct_connect_connection_id(self) -> Optional[str]:
        """
        The direct connect connection ID which associated with this virtual interface.
        """
        return pulumi.get(self, "direct_connect_connection_id")

    @property
    @pulumi.getter(name="directConnectGatewayId")
    def direct_connect_gateway_id(self) -> Optional[str]:
        """
        The direct connect gateway ID which associated with this virtual interface.
        """
        return pulumi.get(self, "direct_connect_gateway_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="localIp")
    def local_ip(self) -> Optional[str]:
        """
        The local IP that associated with this virtual interface.
        """
        return pulumi.get(self, "local_ip")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> Optional[str]:
        """
        The peer IP that associated with this virtual interface.
        """
        return pulumi.get(self, "peer_ip")

    @property
    @pulumi.getter(name="routeType")
    def route_type(self) -> Optional[str]:
        """
        The route type of this virtual interface.
        """
        return pulumi.get(self, "route_type")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[Sequence['outputs.VirtualInterfacesTagFilterResult']]:
        return pulumi.get(self, "tag_filters")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="virtualInterfaceName")
    def virtual_interface_name(self) -> Optional[str]:
        """
        The name of virtual interface.
        """
        return pulumi.get(self, "virtual_interface_name")

    @property
    @pulumi.getter(name="virtualInterfaces")
    def virtual_interfaces(self) -> Sequence['outputs.VirtualInterfacesVirtualInterfaceResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "virtual_interfaces")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[int]:
        """
        The VLAN ID of virtual interface.
        """
        return pulumi.get(self, "vlan_id")


class AwaitableVirtualInterfacesResult(VirtualInterfacesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return VirtualInterfacesResult(
            direct_connect_connection_id=self.direct_connect_connection_id,
            direct_connect_gateway_id=self.direct_connect_gateway_id,
            id=self.id,
            ids=self.ids,
            local_ip=self.local_ip,
            name_regex=self.name_regex,
            output_file=self.output_file,
            peer_ip=self.peer_ip,
            route_type=self.route_type,
            tag_filters=self.tag_filters,
            total_count=self.total_count,
            virtual_interface_name=self.virtual_interface_name,
            virtual_interfaces=self.virtual_interfaces,
            vlan_id=self.vlan_id)


def virtual_interfaces(direct_connect_connection_id: Optional[str] = None,
                       direct_connect_gateway_id: Optional[str] = None,
                       ids: Optional[Sequence[str]] = None,
                       local_ip: Optional[str] = None,
                       name_regex: Optional[str] = None,
                       output_file: Optional[str] = None,
                       peer_ip: Optional[str] = None,
                       route_type: Optional[str] = None,
                       tag_filters: Optional[Sequence[pulumi.InputType['VirtualInterfacesTagFilterArgs']]] = None,
                       virtual_interface_name: Optional[str] = None,
                       vlan_id: Optional[int] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableVirtualInterfacesResult:
    """
    Use this data source to query detailed information of direct connect virtual interfaces
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.direct_connect.virtual_interfaces(virtual_interface_name="tf-test")
    ```


    :param str direct_connect_connection_id: The direct connect connection ID that associated with this virtual interface.
    :param str direct_connect_gateway_id: The direct connect gateway ID that associated with this virtual interface.
    :param Sequence[str] ids: A list of IDs.
    :param str local_ip: The local IP that associated with this virtual interface.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param str peer_ip: The peer IP that associated with this virtual interface.
    :param str route_type: The route type of virtual interface.
    :param Sequence[pulumi.InputType['VirtualInterfacesTagFilterArgs']] tag_filters: The filter tag of direct connect virtual interface.
    :param str virtual_interface_name: The name of virtual interface.
    :param int vlan_id: The VLAN ID of virtual interface.
    """
    __args__ = dict()
    __args__['directConnectConnectionId'] = direct_connect_connection_id
    __args__['directConnectGatewayId'] = direct_connect_gateway_id
    __args__['ids'] = ids
    __args__['localIp'] = local_ip
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['peerIp'] = peer_ip
    __args__['routeType'] = route_type
    __args__['tagFilters'] = tag_filters
    __args__['virtualInterfaceName'] = virtual_interface_name
    __args__['vlanId'] = vlan_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:direct_connect/virtualInterfaces:VirtualInterfaces', __args__, opts=opts, typ=VirtualInterfacesResult).value

    return AwaitableVirtualInterfacesResult(
        direct_connect_connection_id=pulumi.get(__ret__, 'direct_connect_connection_id'),
        direct_connect_gateway_id=pulumi.get(__ret__, 'direct_connect_gateway_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        local_ip=pulumi.get(__ret__, 'local_ip'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        peer_ip=pulumi.get(__ret__, 'peer_ip'),
        route_type=pulumi.get(__ret__, 'route_type'),
        tag_filters=pulumi.get(__ret__, 'tag_filters'),
        total_count=pulumi.get(__ret__, 'total_count'),
        virtual_interface_name=pulumi.get(__ret__, 'virtual_interface_name'),
        virtual_interfaces=pulumi.get(__ret__, 'virtual_interfaces'),
        vlan_id=pulumi.get(__ret__, 'vlan_id'))


@_utilities.lift_output_func(virtual_interfaces)
def virtual_interfaces_output(direct_connect_connection_id: Optional[pulumi.Input[Optional[str]]] = None,
                              direct_connect_gateway_id: Optional[pulumi.Input[Optional[str]]] = None,
                              ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                              local_ip: Optional[pulumi.Input[Optional[str]]] = None,
                              name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                              output_file: Optional[pulumi.Input[Optional[str]]] = None,
                              peer_ip: Optional[pulumi.Input[Optional[str]]] = None,
                              route_type: Optional[pulumi.Input[Optional[str]]] = None,
                              tag_filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['VirtualInterfacesTagFilterArgs']]]]] = None,
                              virtual_interface_name: Optional[pulumi.Input[Optional[str]]] = None,
                              vlan_id: Optional[pulumi.Input[Optional[int]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[VirtualInterfacesResult]:
    """
    Use this data source to query detailed information of direct connect virtual interfaces
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.direct_connect.virtual_interfaces(virtual_interface_name="tf-test")
    ```


    :param str direct_connect_connection_id: The direct connect connection ID that associated with this virtual interface.
    :param str direct_connect_gateway_id: The direct connect gateway ID that associated with this virtual interface.
    :param Sequence[str] ids: A list of IDs.
    :param str local_ip: The local IP that associated with this virtual interface.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param str peer_ip: The peer IP that associated with this virtual interface.
    :param str route_type: The route type of virtual interface.
    :param Sequence[pulumi.InputType['VirtualInterfacesTagFilterArgs']] tag_filters: The filter tag of direct connect virtual interface.
    :param str virtual_interface_name: The name of virtual interface.
    :param int vlan_id: The VLAN ID of virtual interface.
    """
    ...
