# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VolumeArgs', 'Volume']

@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 size: pulumi.Input[int],
                 volume_name: pulumi.Input[str],
                 volume_type: pulumi.Input[str],
                 zone_id: pulumi.Input[str],
                 delete_with_instance: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 volume_charge_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Volume resource.
        :param pulumi.Input[str] kind: The kind of Volume, the value is `data`.
        :param pulumi.Input[int] size: The size of Volume.
        :param pulumi.Input[str] volume_name: The name of Volume.
        :param pulumi.Input[str] volume_type: The type of Volume, the value is `PTSSD` or `ESSD_PL0` or `ESSD_PL1` or `ESSD_PL2` or `ESSD_FlexPL`.
        :param pulumi.Input[str] zone_id: The id of the Zone.
        :param pulumi.Input[bool] delete_with_instance: Delete Volume with Attached Instance.
        :param pulumi.Input[str] description: The description of the Volume.
        :param pulumi.Input[str] instance_id: The ID of the instance to which the created volume is automatically attached. Please note this field needs to ask the
               system administrator to apply for a whitelist. When use this field to attach ecs instance, the attached volume cannot be
               deleted by terraform, please use `terraform state rm volcengine_volume.resource_name` command to remove it from
               terraform state file and management.
        :param pulumi.Input[str] project_name: The ProjectName of the Volume.
        :param pulumi.Input[str] volume_charge_type: The charge type of the Volume, the value is `PostPaid` or `PrePaid`. The `PrePaid` volume cannot be detached. Cannot convert `PrePaid` volume to `PostPaid`.Please note that `PrePaid` type needs to ask the system administrator to apply for a whitelist.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volume_name", volume_name)
        pulumi.set(__self__, "volume_type", volume_type)
        pulumi.set(__self__, "zone_id", zone_id)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if volume_charge_type is not None:
            pulumi.set(__self__, "volume_charge_type", volume_charge_type)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        The kind of Volume, the value is `data`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size of Volume.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> pulumi.Input[str]:
        """
        The name of Volume.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_name", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Input[str]:
        """
        The type of Volume, the value is `PTSSD` or `ESSD_PL0` or `ESSD_PL1` or `ESSD_PL2` or `ESSD_FlexPL`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_type", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        The id of the Zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[pulumi.Input[bool]]:
        """
        Delete Volume with Attached Instance.
        """
        return pulumi.get(self, "delete_with_instance")

    @delete_with_instance.setter
    def delete_with_instance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_with_instance", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Volume.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the instance to which the created volume is automatically attached. Please note this field needs to ask the
        system administrator to apply for a whitelist. When use this field to attach ecs instance, the attached volume cannot be
        deleted by terraform, please use `terraform state rm volcengine_volume.resource_name` command to remove it from
        terraform state file and management.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ProjectName of the Volume.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="volumeChargeType")
    def volume_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The charge type of the Volume, the value is `PostPaid` or `PrePaid`. The `PrePaid` volume cannot be detached. Cannot convert `PrePaid` volume to `PostPaid`.Please note that `PrePaid` type needs to ask the system administrator to apply for a whitelist.
        """
        return pulumi.get(self, "volume_charge_type")

    @volume_charge_type.setter
    def volume_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_charge_type", value)


@pulumi.input_type
class _VolumeState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 delete_with_instance: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 trade_status: Optional[pulumi.Input[int]] = None,
                 volume_charge_type: Optional[pulumi.Input[str]] = None,
                 volume_name: Optional[pulumi.Input[str]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Volume resources.
        :param pulumi.Input[str] created_at: Creation time of Volume.
        :param pulumi.Input[bool] delete_with_instance: Delete Volume with Attached Instance.
        :param pulumi.Input[str] description: The description of the Volume.
        :param pulumi.Input[str] instance_id: The ID of the instance to which the created volume is automatically attached. Please note this field needs to ask the
               system administrator to apply for a whitelist. When use this field to attach ecs instance, the attached volume cannot be
               deleted by terraform, please use `terraform state rm volcengine_volume.resource_name` command to remove it from
               terraform state file and management.
        :param pulumi.Input[str] kind: The kind of Volume, the value is `data`.
        :param pulumi.Input[str] project_name: The ProjectName of the Volume.
        :param pulumi.Input[int] size: The size of Volume.
        :param pulumi.Input[str] status: Status of Volume.
        :param pulumi.Input[int] trade_status: Status of Trade.
        :param pulumi.Input[str] volume_charge_type: The charge type of the Volume, the value is `PostPaid` or `PrePaid`. The `PrePaid` volume cannot be detached. Cannot convert `PrePaid` volume to `PostPaid`.Please note that `PrePaid` type needs to ask the system administrator to apply for a whitelist.
        :param pulumi.Input[str] volume_name: The name of Volume.
        :param pulumi.Input[str] volume_type: The type of Volume, the value is `PTSSD` or `ESSD_PL0` or `ESSD_PL1` or `ESSD_PL2` or `ESSD_FlexPL`.
        :param pulumi.Input[str] zone_id: The id of the Zone.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if trade_status is not None:
            pulumi.set(__self__, "trade_status", trade_status)
        if volume_charge_type is not None:
            pulumi.set(__self__, "volume_charge_type", volume_charge_type)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Creation time of Volume.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[pulumi.Input[bool]]:
        """
        Delete Volume with Attached Instance.
        """
        return pulumi.get(self, "delete_with_instance")

    @delete_with_instance.setter
    def delete_with_instance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_with_instance", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Volume.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the instance to which the created volume is automatically attached. Please note this field needs to ask the
        system administrator to apply for a whitelist. When use this field to attach ecs instance, the attached volume cannot be
        deleted by terraform, please use `terraform state rm volcengine_volume.resource_name` command to remove it from
        terraform state file and management.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        The kind of Volume, the value is `data`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ProjectName of the Volume.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of Volume.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of Volume.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tradeStatus")
    def trade_status(self) -> Optional[pulumi.Input[int]]:
        """
        Status of Trade.
        """
        return pulumi.get(self, "trade_status")

    @trade_status.setter
    def trade_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "trade_status", value)

    @property
    @pulumi.getter(name="volumeChargeType")
    def volume_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The charge type of the Volume, the value is `PostPaid` or `PrePaid`. The `PrePaid` volume cannot be detached. Cannot convert `PrePaid` volume to `PostPaid`.Please note that `PrePaid` type needs to ask the system administrator to apply for a whitelist.
        """
        return pulumi.get(self, "volume_charge_type")

    @volume_charge_type.setter
    def volume_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_charge_type", value)

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of Volume.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_name", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of Volume, the value is `PTSSD` or `ESSD_PL0` or `ESSD_PL1` or `ESSD_PL2` or `ESSD_FlexPL`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_type", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the Zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class Volume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_with_instance: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 volume_charge_type: Optional[pulumi.Input[str]] = None,
                 volume_name: Optional[pulumi.Input[str]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            security_group_name="acc-test-security-group",
            vpc_id=foo_vpc.id)
        foo_images = volcengine.ecs.images(os_type="Linux",
            visibility="public",
            instance_type_id="ecs.g1.large")
        foo_instance = volcengine.ecs.Instance("fooInstance",
            instance_name="acc-test-ecs",
            description="acc-test",
            host_name="tf-acc-test",
            image_id=foo_images.images[0].image_id,
            instance_type="ecs.g1.large",
            password="93f0cb0614Aab12",
            instance_charge_type="PrePaid",
            period=1,
            system_volume_type="ESSD_PL0",
            system_volume_size=40,
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id],
            project_name="default",
            tags=[volcengine.ecs.InstanceTagArgs(
                key="k1",
                value="v1",
            )])
        pre_volume = volcengine.ebs.Volume("preVolume",
            volume_name="acc-test-volume",
            volume_type="ESSD_PL0",
            description="acc-test",
            kind="data",
            size=40,
            zone_id=foo_zones.zones[0].id,
            volume_charge_type="PrePaid",
            instance_id=foo_instance.id,
            project_name="default",
            delete_with_instance=True)
        post_volume = volcengine.ebs.Volume("postVolume",
            volume_name="acc-test-volume",
            volume_type="ESSD_PL0",
            description="acc-test",
            kind="data",
            size=40,
            zone_id=foo_zones.zones[0].id,
            volume_charge_type="PostPaid",
            project_name="default")
        ```

        ## Import

        Volume can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:ebs/volume:Volume default vol-mizl7m1kqccg5smt1bdpijuj
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] delete_with_instance: Delete Volume with Attached Instance.
        :param pulumi.Input[str] description: The description of the Volume.
        :param pulumi.Input[str] instance_id: The ID of the instance to which the created volume is automatically attached. Please note this field needs to ask the
               system administrator to apply for a whitelist. When use this field to attach ecs instance, the attached volume cannot be
               deleted by terraform, please use `terraform state rm volcengine_volume.resource_name` command to remove it from
               terraform state file and management.
        :param pulumi.Input[str] kind: The kind of Volume, the value is `data`.
        :param pulumi.Input[str] project_name: The ProjectName of the Volume.
        :param pulumi.Input[int] size: The size of Volume.
        :param pulumi.Input[str] volume_charge_type: The charge type of the Volume, the value is `PostPaid` or `PrePaid`. The `PrePaid` volume cannot be detached. Cannot convert `PrePaid` volume to `PostPaid`.Please note that `PrePaid` type needs to ask the system administrator to apply for a whitelist.
        :param pulumi.Input[str] volume_name: The name of Volume.
        :param pulumi.Input[str] volume_type: The type of Volume, the value is `PTSSD` or `ESSD_PL0` or `ESSD_PL1` or `ESSD_PL2` or `ESSD_FlexPL`.
        :param pulumi.Input[str] zone_id: The id of the Zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            security_group_name="acc-test-security-group",
            vpc_id=foo_vpc.id)
        foo_images = volcengine.ecs.images(os_type="Linux",
            visibility="public",
            instance_type_id="ecs.g1.large")
        foo_instance = volcengine.ecs.Instance("fooInstance",
            instance_name="acc-test-ecs",
            description="acc-test",
            host_name="tf-acc-test",
            image_id=foo_images.images[0].image_id,
            instance_type="ecs.g1.large",
            password="93f0cb0614Aab12",
            instance_charge_type="PrePaid",
            period=1,
            system_volume_type="ESSD_PL0",
            system_volume_size=40,
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id],
            project_name="default",
            tags=[volcengine.ecs.InstanceTagArgs(
                key="k1",
                value="v1",
            )])
        pre_volume = volcengine.ebs.Volume("preVolume",
            volume_name="acc-test-volume",
            volume_type="ESSD_PL0",
            description="acc-test",
            kind="data",
            size=40,
            zone_id=foo_zones.zones[0].id,
            volume_charge_type="PrePaid",
            instance_id=foo_instance.id,
            project_name="default",
            delete_with_instance=True)
        post_volume = volcengine.ebs.Volume("postVolume",
            volume_name="acc-test-volume",
            volume_type="ESSD_PL0",
            description="acc-test",
            kind="data",
            size=40,
            zone_id=foo_zones.zones[0].id,
            volume_charge_type="PostPaid",
            project_name="default")
        ```

        ## Import

        Volume can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:ebs/volume:Volume default vol-mizl7m1kqccg5smt1bdpijuj
        ```

        :param str resource_name: The name of the resource.
        :param VolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_with_instance: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 volume_charge_type: Optional[pulumi.Input[str]] = None,
                 volume_name: Optional[pulumi.Input[str]] = None,
                 volume_type: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeArgs.__new__(VolumeArgs)

            __props__.__dict__["delete_with_instance"] = delete_with_instance
            __props__.__dict__["description"] = description
            __props__.__dict__["instance_id"] = instance_id
            if kind is None and not opts.urn:
                raise TypeError("Missing required property 'kind'")
            __props__.__dict__["kind"] = kind
            __props__.__dict__["project_name"] = project_name
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["volume_charge_type"] = volume_charge_type
            if volume_name is None and not opts.urn:
                raise TypeError("Missing required property 'volume_name'")
            __props__.__dict__["volume_name"] = volume_name
            if volume_type is None and not opts.urn:
                raise TypeError("Missing required property 'volume_type'")
            __props__.__dict__["volume_type"] = volume_type
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["trade_status"] = None
        super(Volume, __self__).__init__(
            'volcengine:ebs/volume:Volume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            delete_with_instance: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            kind: Optional[pulumi.Input[str]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            trade_status: Optional[pulumi.Input[int]] = None,
            volume_charge_type: Optional[pulumi.Input[str]] = None,
            volume_name: Optional[pulumi.Input[str]] = None,
            volume_type: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'Volume':
        """
        Get an existing Volume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: Creation time of Volume.
        :param pulumi.Input[bool] delete_with_instance: Delete Volume with Attached Instance.
        :param pulumi.Input[str] description: The description of the Volume.
        :param pulumi.Input[str] instance_id: The ID of the instance to which the created volume is automatically attached. Please note this field needs to ask the
               system administrator to apply for a whitelist. When use this field to attach ecs instance, the attached volume cannot be
               deleted by terraform, please use `terraform state rm volcengine_volume.resource_name` command to remove it from
               terraform state file and management.
        :param pulumi.Input[str] kind: The kind of Volume, the value is `data`.
        :param pulumi.Input[str] project_name: The ProjectName of the Volume.
        :param pulumi.Input[int] size: The size of Volume.
        :param pulumi.Input[str] status: Status of Volume.
        :param pulumi.Input[int] trade_status: Status of Trade.
        :param pulumi.Input[str] volume_charge_type: The charge type of the Volume, the value is `PostPaid` or `PrePaid`. The `PrePaid` volume cannot be detached. Cannot convert `PrePaid` volume to `PostPaid`.Please note that `PrePaid` type needs to ask the system administrator to apply for a whitelist.
        :param pulumi.Input[str] volume_name: The name of Volume.
        :param pulumi.Input[str] volume_type: The type of Volume, the value is `PTSSD` or `ESSD_PL0` or `ESSD_PL1` or `ESSD_PL2` or `ESSD_FlexPL`.
        :param pulumi.Input[str] zone_id: The id of the Zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeState.__new__(_VolumeState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["delete_with_instance"] = delete_with_instance
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["kind"] = kind
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        __props__.__dict__["trade_status"] = trade_status
        __props__.__dict__["volume_charge_type"] = volume_charge_type
        __props__.__dict__["volume_name"] = volume_name
        __props__.__dict__["volume_type"] = volume_type
        __props__.__dict__["zone_id"] = zone_id
        return Volume(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Creation time of Volume.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> pulumi.Output[bool]:
        """
        Delete Volume with Attached Instance.
        """
        return pulumi.get(self, "delete_with_instance")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Volume.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The ID of the instance to which the created volume is automatically attached. Please note this field needs to ask the
        system administrator to apply for a whitelist. When use this field to attach ecs instance, the attached volume cannot be
        deleted by terraform, please use `terraform state rm volcengine_volume.resource_name` command to remove it from
        terraform state file and management.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        The kind of Volume, the value is `data`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The ProjectName of the Volume.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        The size of Volume.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of Volume.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tradeStatus")
    def trade_status(self) -> pulumi.Output[int]:
        """
        Status of Trade.
        """
        return pulumi.get(self, "trade_status")

    @property
    @pulumi.getter(name="volumeChargeType")
    def volume_charge_type(self) -> pulumi.Output[Optional[str]]:
        """
        The charge type of the Volume, the value is `PostPaid` or `PrePaid`. The `PrePaid` volume cannot be detached. Cannot convert `PrePaid` volume to `PostPaid`.Please note that `PrePaid` type needs to ask the system administrator to apply for a whitelist.
        """
        return pulumi.get(self, "volume_charge_type")

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> pulumi.Output[str]:
        """
        The name of Volume.
        """
        return pulumi.get(self, "volume_name")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[str]:
        """
        The type of Volume, the value is `PTSSD` or `ESSD_PL0` or `ESSD_PL1` or `ESSD_PL2` or `ESSD_FlexPL`.
        """
        return pulumi.get(self, "volume_type")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The id of the Zone.
        """
        return pulumi.get(self, "zone_id")

