# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AvailableResourcesResult',
    'AwaitableAvailableResourcesResult',
    'available_resources',
    'available_resources_output',
]

@pulumi.output_type
class AvailableResourcesResult:
    """
    A collection of values returned by AvailableResources.
    """
    def __init__(__self__, available_zones=None, destination_resource=None, id=None, instance_charge_type=None, instance_type_id=None, output_file=None, spot_strategy=None, total_count=None, zone_id=None):
        if available_zones and not isinstance(available_zones, list):
            raise TypeError("Expected argument 'available_zones' to be a list")
        pulumi.set(__self__, "available_zones", available_zones)
        if destination_resource and not isinstance(destination_resource, str):
            raise TypeError("Expected argument 'destination_resource' to be a str")
        pulumi.set(__self__, "destination_resource", destination_resource)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_charge_type and not isinstance(instance_charge_type, str):
            raise TypeError("Expected argument 'instance_charge_type' to be a str")
        pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_type_id and not isinstance(instance_type_id, str):
            raise TypeError("Expected argument 'instance_type_id' to be a str")
        pulumi.set(__self__, "instance_type_id", instance_type_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if spot_strategy and not isinstance(spot_strategy, str):
            raise TypeError("Expected argument 'spot_strategy' to be a str")
        pulumi.set(__self__, "spot_strategy", spot_strategy)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> Sequence['outputs.AvailableResourcesAvailableZoneResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "available_zones")

    @property
    @pulumi.getter(name="destinationResource")
    def destination_resource(self) -> str:
        return pulumi.get(self, "destination_resource")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[str]:
        return pulumi.get(self, "instance_charge_type")

    @property
    @pulumi.getter(name="instanceTypeId")
    def instance_type_id(self) -> Optional[str]:
        return pulumi.get(self, "instance_type_id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[str]:
        return pulumi.get(self, "spot_strategy")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[str]:
        """
        The id of the available zone.
        """
        return pulumi.get(self, "zone_id")


class AwaitableAvailableResourcesResult(AvailableResourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return AvailableResourcesResult(
            available_zones=self.available_zones,
            destination_resource=self.destination_resource,
            id=self.id,
            instance_charge_type=self.instance_charge_type,
            instance_type_id=self.instance_type_id,
            output_file=self.output_file,
            spot_strategy=self.spot_strategy,
            total_count=self.total_count,
            zone_id=self.zone_id)


def available_resources(destination_resource: Optional[str] = None,
                        instance_charge_type: Optional[str] = None,
                        instance_type_id: Optional[str] = None,
                        output_file: Optional[str] = None,
                        spot_strategy: Optional[str] = None,
                        zone_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableAvailableResourcesResult:
    """
    Use this data source to query detailed information of ecs available resources
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.ecs.available_resources(destination_resource="InstanceType")
    ```


    :param str destination_resource: The type of resource to query. Valid values: `InstanceType`, `DedicatedHost`.
    :param str instance_charge_type: The charge type of instance. Valid values: `PostPaid`, `PrePaid`, `ReservedInstance`. Default is `PostPaid`.
    :param str instance_type_id: The id of instance type.
    :param str output_file: File name where to save data source results.
    :param str spot_strategy: The spot strategy of PostPaid instance. Valid values: `NoSpot`, `SpotAsPriceGo`. Default is `NoSpot`.
    :param str zone_id: The id of available zone.
    """
    __args__ = dict()
    __args__['destinationResource'] = destination_resource
    __args__['instanceChargeType'] = instance_charge_type
    __args__['instanceTypeId'] = instance_type_id
    __args__['outputFile'] = output_file
    __args__['spotStrategy'] = spot_strategy
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:ecs/availableResources:AvailableResources', __args__, opts=opts, typ=AvailableResourcesResult).value

    return AwaitableAvailableResourcesResult(
        available_zones=pulumi.get(__ret__, 'available_zones'),
        destination_resource=pulumi.get(__ret__, 'destination_resource'),
        id=pulumi.get(__ret__, 'id'),
        instance_charge_type=pulumi.get(__ret__, 'instance_charge_type'),
        instance_type_id=pulumi.get(__ret__, 'instance_type_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        spot_strategy=pulumi.get(__ret__, 'spot_strategy'),
        total_count=pulumi.get(__ret__, 'total_count'),
        zone_id=pulumi.get(__ret__, 'zone_id'))


@_utilities.lift_output_func(available_resources)
def available_resources_output(destination_resource: Optional[pulumi.Input[str]] = None,
                               instance_charge_type: Optional[pulumi.Input[Optional[str]]] = None,
                               instance_type_id: Optional[pulumi.Input[Optional[str]]] = None,
                               output_file: Optional[pulumi.Input[Optional[str]]] = None,
                               spot_strategy: Optional[pulumi.Input[Optional[str]]] = None,
                               zone_id: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[AvailableResourcesResult]:
    """
    Use this data source to query detailed information of ecs available resources
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.ecs.available_resources(destination_resource="InstanceType")
    ```


    :param str destination_resource: The type of resource to query. Valid values: `InstanceType`, `DedicatedHost`.
    :param str instance_charge_type: The charge type of instance. Valid values: `PostPaid`, `PrePaid`, `ReservedInstance`. Default is `PostPaid`.
    :param str instance_type_id: The id of instance type.
    :param str output_file: File name where to save data source results.
    :param str spot_strategy: The spot strategy of PostPaid instance. Valid values: `NoSpot`, `SpotAsPriceGo`. Default is `NoSpot`.
    :param str zone_id: The id of available zone.
    """
    ...
