# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['CommandArgs', 'Command']

@pulumi.input_type
class CommandArgs:
    def __init__(__self__, *,
                 command_content: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Command resource.
        :param pulumi.Input[str] command_content: The base64 encoded content of the ecs command.
        :param pulumi.Input[str] description: The description of the ecs command.
        :param pulumi.Input[str] name: The name of the ecs command.
        :param pulumi.Input[int] timeout: The timeout of the ecs command. Valid value range: 10-600.
        :param pulumi.Input[str] username: The username of the ecs command.
        :param pulumi.Input[str] working_dir: The working directory of the ecs command.
        """
        pulumi.set(__self__, "command_content", command_content)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter(name="commandContent")
    def command_content(self) -> pulumi.Input[str]:
        """
        The base64 encoded content of the ecs command.
        """
        return pulumi.get(self, "command_content")

    @command_content.setter
    def command_content(self, value: pulumi.Input[str]):
        pulumi.set(self, "command_content", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the ecs command.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ecs command.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout of the ecs command. Valid value range: 10-600.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username of the ecs command.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        The working directory of the ecs command.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


@pulumi.input_type
class _CommandState:
    def __init__(__self__, *,
                 command_content: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 invocation_times: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Command resources.
        :param pulumi.Input[str] command_content: The base64 encoded content of the ecs command.
        :param pulumi.Input[str] created_at: The create time of the ecs command.
        :param pulumi.Input[str] description: The description of the ecs command.
        :param pulumi.Input[int] invocation_times: The invocation times of the ecs command. Public commands do not display the invocation times.
        :param pulumi.Input[str] name: The name of the ecs command.
        :param pulumi.Input[int] timeout: The timeout of the ecs command. Valid value range: 10-600.
        :param pulumi.Input[str] updated_at: The update time of the ecs command.
        :param pulumi.Input[str] username: The username of the ecs command.
        :param pulumi.Input[str] working_dir: The working directory of the ecs command.
        """
        if command_content is not None:
            pulumi.set(__self__, "command_content", command_content)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if invocation_times is not None:
            pulumi.set(__self__, "invocation_times", invocation_times)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter(name="commandContent")
    def command_content(self) -> Optional[pulumi.Input[str]]:
        """
        The base64 encoded content of the ecs command.
        """
        return pulumi.get(self, "command_content")

    @command_content.setter
    def command_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "command_content", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of the ecs command.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the ecs command.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="invocationTimes")
    def invocation_times(self) -> Optional[pulumi.Input[int]]:
        """
        The invocation times of the ecs command. Public commands do not display the invocation times.
        """
        return pulumi.get(self, "invocation_times")

    @invocation_times.setter
    def invocation_times(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "invocation_times", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ecs command.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout of the ecs command. Valid value range: 10-600.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of the ecs command.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username of the ecs command.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        The working directory of the ecs command.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


class Command(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 command_content: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage ecs command
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.ecs.Command("foo",
            command_content="IyEvYmluL2Jhc2gKCgplY2hvICJvcGVyYXRpb24gc3VjY2VzcyEi",
            description="tf",
            timeout=100,
            username="root",
            working_dir="/home")
        ```

        ## Import

        EcsCommand can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:ecs/command:Command default cmd-ychkepkhtim0tr3bcsw1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] command_content: The base64 encoded content of the ecs command.
        :param pulumi.Input[str] description: The description of the ecs command.
        :param pulumi.Input[str] name: The name of the ecs command.
        :param pulumi.Input[int] timeout: The timeout of the ecs command. Valid value range: 10-600.
        :param pulumi.Input[str] username: The username of the ecs command.
        :param pulumi.Input[str] working_dir: The working directory of the ecs command.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CommandArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage ecs command
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.ecs.Command("foo",
            command_content="IyEvYmluL2Jhc2gKCgplY2hvICJvcGVyYXRpb24gc3VjY2VzcyEi",
            description="tf",
            timeout=100,
            username="root",
            working_dir="/home")
        ```

        ## Import

        EcsCommand can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:ecs/command:Command default cmd-ychkepkhtim0tr3bcsw1
        ```

        :param str resource_name: The name of the resource.
        :param CommandArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CommandArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 command_content: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CommandArgs.__new__(CommandArgs)

            if command_content is None and not opts.urn:
                raise TypeError("Missing required property 'command_content'")
            __props__.__dict__["command_content"] = command_content
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["username"] = username
            __props__.__dict__["working_dir"] = working_dir
            __props__.__dict__["created_at"] = None
            __props__.__dict__["invocation_times"] = None
            __props__.__dict__["updated_at"] = None
        super(Command, __self__).__init__(
            'volcengine:ecs/command:Command',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            command_content: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            invocation_times: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            timeout: Optional[pulumi.Input[int]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None,
            working_dir: Optional[pulumi.Input[str]] = None) -> 'Command':
        """
        Get an existing Command resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] command_content: The base64 encoded content of the ecs command.
        :param pulumi.Input[str] created_at: The create time of the ecs command.
        :param pulumi.Input[str] description: The description of the ecs command.
        :param pulumi.Input[int] invocation_times: The invocation times of the ecs command. Public commands do not display the invocation times.
        :param pulumi.Input[str] name: The name of the ecs command.
        :param pulumi.Input[int] timeout: The timeout of the ecs command. Valid value range: 10-600.
        :param pulumi.Input[str] updated_at: The update time of the ecs command.
        :param pulumi.Input[str] username: The username of the ecs command.
        :param pulumi.Input[str] working_dir: The working directory of the ecs command.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CommandState.__new__(_CommandState)

        __props__.__dict__["command_content"] = command_content
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["invocation_times"] = invocation_times
        __props__.__dict__["name"] = name
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["username"] = username
        __props__.__dict__["working_dir"] = working_dir
        return Command(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="commandContent")
    def command_content(self) -> pulumi.Output[str]:
        """
        The base64 encoded content of the ecs command.
        """
        return pulumi.get(self, "command_content")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The create time of the ecs command.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the ecs command.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="invocationTimes")
    def invocation_times(self) -> pulumi.Output[int]:
        """
        The invocation times of the ecs command. Public commands do not display the invocation times.
        """
        return pulumi.get(self, "invocation_times")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the ecs command.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[int]:
        """
        The timeout of the ecs command. Valid value range: 10-600.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The update time of the ecs command.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        The username of the ecs command.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> pulumi.Output[str]:
        """
        The working directory of the ecs command.
        """
        return pulumi.get(self, "working_dir")

