# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'CommandsResult',
    'AwaitableCommandsResult',
    'commands',
    'commands_output',
]

@pulumi.output_type
class CommandsResult:
    """
    A collection of values returned by Commands.
    """
    def __init__(__self__, command_id=None, command_provider=None, commands=None, id=None, name=None, name_regex=None, order=None, output_file=None, total_count=None, type=None):
        if command_id and not isinstance(command_id, str):
            raise TypeError("Expected argument 'command_id' to be a str")
        pulumi.set(__self__, "command_id", command_id)
        if command_provider and not isinstance(command_provider, str):
            raise TypeError("Expected argument 'command_provider' to be a str")
        pulumi.set(__self__, "command_provider", command_provider)
        if commands and not isinstance(commands, list):
            raise TypeError("Expected argument 'commands' to be a list")
        pulumi.set(__self__, "commands", commands)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="commandId")
    def command_id(self) -> Optional[str]:
        """
        The id of the ecs command.
        """
        return pulumi.get(self, "command_id")

    @property
    @pulumi.getter(name="commandProvider")
    def command_provider(self) -> Optional[str]:
        """
        The provider of the public command.
        """
        return pulumi.get(self, "command_provider")

    @property
    @pulumi.getter
    def commands(self) -> Sequence['outputs.CommandsCommandResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the ecs command.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def order(self) -> Optional[str]:
        return pulumi.get(self, "order")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the ecs command.
        """
        return pulumi.get(self, "type")


class AwaitableCommandsResult(CommandsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return CommandsResult(
            command_id=self.command_id,
            command_provider=self.command_provider,
            commands=self.commands,
            id=self.id,
            name=self.name,
            name_regex=self.name_regex,
            order=self.order,
            output_file=self.output_file,
            total_count=self.total_count,
            type=self.type)


def commands(command_id: Optional[str] = None,
             command_provider: Optional[str] = None,
             name: Optional[str] = None,
             name_regex: Optional[str] = None,
             order: Optional[str] = None,
             output_file: Optional[str] = None,
             type: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableCommandsResult:
    """
    Use this data source to query detailed information of ecs commands
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.ecs.commands(command_id="cmd-ychkepkhtim0tr3b****")
    ```


    :param str command_id: The id of ecs command.
    :param str command_provider: The provider of public command. When this field is not specified, query for custom commands.
    :param str name: The name of ecs command. This field support fuzzy query.
    :param str name_regex: A Name Regex of Resource.
    :param str order: The order of ecs command query result.
    :param str output_file: File name where to save data source results.
    :param str type: The type of ecs command. Valid values: `Shell`.
    """
    __args__ = dict()
    __args__['commandId'] = command_id
    __args__['commandProvider'] = command_provider
    __args__['name'] = name
    __args__['nameRegex'] = name_regex
    __args__['order'] = order
    __args__['outputFile'] = output_file
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:ecs/commands:Commands', __args__, opts=opts, typ=CommandsResult).value

    return AwaitableCommandsResult(
        command_id=pulumi.get(__ret__, 'command_id'),
        command_provider=pulumi.get(__ret__, 'command_provider'),
        commands=pulumi.get(__ret__, 'commands'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        order=pulumi.get(__ret__, 'order'),
        output_file=pulumi.get(__ret__, 'output_file'),
        total_count=pulumi.get(__ret__, 'total_count'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(commands)
def commands_output(command_id: Optional[pulumi.Input[Optional[str]]] = None,
                    command_provider: Optional[pulumi.Input[Optional[str]]] = None,
                    name: Optional[pulumi.Input[Optional[str]]] = None,
                    name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                    order: Optional[pulumi.Input[Optional[str]]] = None,
                    output_file: Optional[pulumi.Input[Optional[str]]] = None,
                    type: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[CommandsResult]:
    """
    Use this data source to query detailed information of ecs commands
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.ecs.commands(command_id="cmd-ychkepkhtim0tr3b****")
    ```


    :param str command_id: The id of ecs command.
    :param str command_provider: The provider of public command. When this field is not specified, query for custom commands.
    :param str name: The name of ecs command. This field support fuzzy query.
    :param str name_regex: A Name Regex of Resource.
    :param str order: The order of ecs command query result.
    :param str output_file: File name where to save data source results.
    :param str type: The type of ecs command. Valid values: `Shell`.
    """
    ...
