# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DeploymentSetArgs', 'DeploymentSet']

@pulumi.input_type
class DeploymentSetArgs:
    def __init__(__self__, *,
                 deployment_set_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 granularity: Optional[pulumi.Input[str]] = None,
                 strategy: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DeploymentSet resource.
        :param pulumi.Input[str] deployment_set_name: The name of ECS DeploymentSet.
        :param pulumi.Input[str] description: The description of ECS DeploymentSet.
        :param pulumi.Input[str] granularity: The granularity of ECS DeploymentSet.Valid values: switch, host, rack,Default is host.
        :param pulumi.Input[str] strategy: The strategy of ECS DeploymentSet.Valid values: Availability.Default is Availability.
        """
        pulumi.set(__self__, "deployment_set_name", deployment_set_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @property
    @pulumi.getter(name="deploymentSetName")
    def deployment_set_name(self) -> pulumi.Input[str]:
        """
        The name of ECS DeploymentSet.
        """
        return pulumi.get(self, "deployment_set_name")

    @deployment_set_name.setter
    def deployment_set_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_set_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of ECS DeploymentSet.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def granularity(self) -> Optional[pulumi.Input[str]]:
        """
        The granularity of ECS DeploymentSet.Valid values: switch, host, rack,Default is host.
        """
        return pulumi.get(self, "granularity")

    @granularity.setter
    def granularity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "granularity", value)

    @property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The strategy of ECS DeploymentSet.Valid values: Availability.Default is Availability.
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "strategy", value)


@pulumi.input_type
class _DeploymentSetState:
    def __init__(__self__, *,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 deployment_set_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 granularity: Optional[pulumi.Input[str]] = None,
                 strategy: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DeploymentSet resources.
        :param pulumi.Input[str] deployment_set_id: The ID of ECS DeploymentSet.
        :param pulumi.Input[str] deployment_set_name: The name of ECS DeploymentSet.
        :param pulumi.Input[str] description: The description of ECS DeploymentSet.
        :param pulumi.Input[str] granularity: The granularity of ECS DeploymentSet.Valid values: switch, host, rack,Default is host.
        :param pulumi.Input[str] strategy: The strategy of ECS DeploymentSet.Valid values: Availability.Default is Availability.
        """
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if deployment_set_name is not None:
            pulumi.set(__self__, "deployment_set_name", deployment_set_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if granularity is not None:
            pulumi.set(__self__, "granularity", granularity)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of ECS DeploymentSet.
        """
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_set_id", value)

    @property
    @pulumi.getter(name="deploymentSetName")
    def deployment_set_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of ECS DeploymentSet.
        """
        return pulumi.get(self, "deployment_set_name")

    @deployment_set_name.setter
    def deployment_set_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_set_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of ECS DeploymentSet.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def granularity(self) -> Optional[pulumi.Input[str]]:
        """
        The granularity of ECS DeploymentSet.Valid values: switch, host, rack,Default is host.
        """
        return pulumi.get(self, "granularity")

    @granularity.setter
    def granularity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "granularity", value)

    @property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The strategy of ECS DeploymentSet.Valid values: Availability.Default is Availability.
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "strategy", value)


class DeploymentSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deployment_set_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 granularity: Optional[pulumi.Input[str]] = None,
                 strategy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage ecs deployment set
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.ecs.DeploymentSet("foo",
            deployment_set_name="acc-test-ecs-ds",
            description="acc-test",
            granularity="switch",
            strategy="Availability")
        ```

        ## Import

        ECS deployment set can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:ecs/deploymentSet:DeploymentSet default i-mizl7m1kqccg5smt1bdpijuj
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] deployment_set_name: The name of ECS DeploymentSet.
        :param pulumi.Input[str] description: The description of ECS DeploymentSet.
        :param pulumi.Input[str] granularity: The granularity of ECS DeploymentSet.Valid values: switch, host, rack,Default is host.
        :param pulumi.Input[str] strategy: The strategy of ECS DeploymentSet.Valid values: Availability.Default is Availability.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage ecs deployment set
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.ecs.DeploymentSet("foo",
            deployment_set_name="acc-test-ecs-ds",
            description="acc-test",
            granularity="switch",
            strategy="Availability")
        ```

        ## Import

        ECS deployment set can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:ecs/deploymentSet:DeploymentSet default i-mizl7m1kqccg5smt1bdpijuj
        ```

        :param str resource_name: The name of the resource.
        :param DeploymentSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deployment_set_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 granularity: Optional[pulumi.Input[str]] = None,
                 strategy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentSetArgs.__new__(DeploymentSetArgs)

            if deployment_set_name is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_set_name'")
            __props__.__dict__["deployment_set_name"] = deployment_set_name
            __props__.__dict__["description"] = description
            __props__.__dict__["granularity"] = granularity
            __props__.__dict__["strategy"] = strategy
            __props__.__dict__["deployment_set_id"] = None
        super(DeploymentSet, __self__).__init__(
            'volcengine:ecs/deploymentSet:DeploymentSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            deployment_set_id: Optional[pulumi.Input[str]] = None,
            deployment_set_name: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            granularity: Optional[pulumi.Input[str]] = None,
            strategy: Optional[pulumi.Input[str]] = None) -> 'DeploymentSet':
        """
        Get an existing DeploymentSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] deployment_set_id: The ID of ECS DeploymentSet.
        :param pulumi.Input[str] deployment_set_name: The name of ECS DeploymentSet.
        :param pulumi.Input[str] description: The description of ECS DeploymentSet.
        :param pulumi.Input[str] granularity: The granularity of ECS DeploymentSet.Valid values: switch, host, rack,Default is host.
        :param pulumi.Input[str] strategy: The strategy of ECS DeploymentSet.Valid values: Availability.Default is Availability.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeploymentSetState.__new__(_DeploymentSetState)

        __props__.__dict__["deployment_set_id"] = deployment_set_id
        __props__.__dict__["deployment_set_name"] = deployment_set_name
        __props__.__dict__["description"] = description
        __props__.__dict__["granularity"] = granularity
        __props__.__dict__["strategy"] = strategy
        return DeploymentSet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> pulumi.Output[str]:
        """
        The ID of ECS DeploymentSet.
        """
        return pulumi.get(self, "deployment_set_id")

    @property
    @pulumi.getter(name="deploymentSetName")
    def deployment_set_name(self) -> pulumi.Output[str]:
        """
        The name of ECS DeploymentSet.
        """
        return pulumi.get(self, "deployment_set_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of ECS DeploymentSet.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def granularity(self) -> pulumi.Output[Optional[str]]:
        """
        The granularity of ECS DeploymentSet.Valid values: switch, host, rack,Default is host.
        """
        return pulumi.get(self, "granularity")

    @property
    @pulumi.getter
    def strategy(self) -> pulumi.Output[Optional[str]]:
        """
        The strategy of ECS DeploymentSet.Valid values: Availability.Default is Availability.
        """
        return pulumi.get(self, "strategy")

