# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DeploymentSetAssociateArgs', 'DeploymentSetAssociate']

@pulumi.input_type
class DeploymentSetAssociateArgs:
    def __init__(__self__, *,
                 deployment_set_id: pulumi.Input[str],
                 instance_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a DeploymentSetAssociate resource.
        :param pulumi.Input[str] deployment_set_id: The ID of ECS DeploymentSet Associate.
        :param pulumi.Input[str] instance_id: The ID of ECS Instance.
        """
        pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> pulumi.Input[str]:
        """
        The ID of ECS DeploymentSet Associate.
        """
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_set_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The ID of ECS Instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)


@pulumi.input_type
class _DeploymentSetAssociateState:
    def __init__(__self__, *,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DeploymentSetAssociate resources.
        :param pulumi.Input[str] deployment_set_id: The ID of ECS DeploymentSet Associate.
        :param pulumi.Input[str] instance_id: The ID of ECS Instance.
        """
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of ECS DeploymentSet Associate.
        """
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_set_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of ECS Instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)


class DeploymentSetAssociate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage ecs deployment set associate
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            security_group_name="acc-test-security-group",
            vpc_id=foo_vpc.id)
        foo_images = volcengine.ecs.images(os_type="Linux",
            visibility="public",
            instance_type_id="ecs.g1.large")
        foo_instance = volcengine.ecs.Instance("fooInstance",
            instance_name="acc-test-ecs",
            image_id=foo_images.images[0].image_id,
            instance_type="ecs.g1.large",
            password="93f0cb0614Aab12",
            instance_charge_type="PostPaid",
            system_volume_type="ESSD_PL0",
            system_volume_size=40,
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id])
        foo_state = volcengine.ecs.State("fooState",
            instance_id=foo_instance.id,
            action="Stop",
            stopped_mode="KeepCharging")
        foo_deployment_set = volcengine.ecs.DeploymentSet("fooDeploymentSet",
            deployment_set_name="acc-test-ecs-ds",
            description="acc-test",
            granularity="switch",
            strategy="Availability")
        foo_deployment_set_associate = volcengine.ecs.DeploymentSetAssociate("fooDeploymentSetAssociate",
            deployment_set_id=foo_deployment_set.id,
            instance_id=foo_instance.id,
            opts=pulumi.ResourceOptions(depends_on=[foo_state]))
        ```

        ## Import

        ECS deployment set associate can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:ecs/deploymentSetAssociate:DeploymentSetAssociate default dps-ybti5tkpkv2udbfolrft:i-mizl7m1kqccg5smt1bdpijuj
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] deployment_set_id: The ID of ECS DeploymentSet Associate.
        :param pulumi.Input[str] instance_id: The ID of ECS Instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentSetAssociateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage ecs deployment set associate
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            security_group_name="acc-test-security-group",
            vpc_id=foo_vpc.id)
        foo_images = volcengine.ecs.images(os_type="Linux",
            visibility="public",
            instance_type_id="ecs.g1.large")
        foo_instance = volcengine.ecs.Instance("fooInstance",
            instance_name="acc-test-ecs",
            image_id=foo_images.images[0].image_id,
            instance_type="ecs.g1.large",
            password="93f0cb0614Aab12",
            instance_charge_type="PostPaid",
            system_volume_type="ESSD_PL0",
            system_volume_size=40,
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id])
        foo_state = volcengine.ecs.State("fooState",
            instance_id=foo_instance.id,
            action="Stop",
            stopped_mode="KeepCharging")
        foo_deployment_set = volcengine.ecs.DeploymentSet("fooDeploymentSet",
            deployment_set_name="acc-test-ecs-ds",
            description="acc-test",
            granularity="switch",
            strategy="Availability")
        foo_deployment_set_associate = volcengine.ecs.DeploymentSetAssociate("fooDeploymentSetAssociate",
            deployment_set_id=foo_deployment_set.id,
            instance_id=foo_instance.id,
            opts=pulumi.ResourceOptions(depends_on=[foo_state]))
        ```

        ## Import

        ECS deployment set associate can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:ecs/deploymentSetAssociate:DeploymentSetAssociate default dps-ybti5tkpkv2udbfolrft:i-mizl7m1kqccg5smt1bdpijuj
        ```

        :param str resource_name: The name of the resource.
        :param DeploymentSetAssociateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentSetAssociateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentSetAssociateArgs.__new__(DeploymentSetAssociateArgs)

            if deployment_set_id is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_set_id'")
            __props__.__dict__["deployment_set_id"] = deployment_set_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
        super(DeploymentSetAssociate, __self__).__init__(
            'volcengine:ecs/deploymentSetAssociate:DeploymentSetAssociate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            deployment_set_id: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None) -> 'DeploymentSetAssociate':
        """
        Get an existing DeploymentSetAssociate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] deployment_set_id: The ID of ECS DeploymentSet Associate.
        :param pulumi.Input[str] instance_id: The ID of ECS Instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeploymentSetAssociateState.__new__(_DeploymentSetAssociateState)

        __props__.__dict__["deployment_set_id"] = deployment_set_id
        __props__.__dict__["instance_id"] = instance_id
        return DeploymentSetAssociate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> pulumi.Output[str]:
        """
        The ID of ECS DeploymentSet Associate.
        """
        return pulumi.get(self, "deployment_set_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The ID of ECS Instance.
        """
        return pulumi.get(self, "instance_id")

