# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['IamRoleAttachmentArgs', 'IamRoleAttachment']

@pulumi.input_type
class IamRoleAttachmentArgs:
    def __init__(__self__, *,
                 iam_role_name: pulumi.Input[str],
                 instance_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a IamRoleAttachment resource.
        :param pulumi.Input[str] iam_role_name: The name of the iam role.
        :param pulumi.Input[str] instance_id: The id of the ecs instance.
        """
        pulumi.set(__self__, "iam_role_name", iam_role_name)
        pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="iamRoleName")
    def iam_role_name(self) -> pulumi.Input[str]:
        """
        The name of the iam role.
        """
        return pulumi.get(self, "iam_role_name")

    @iam_role_name.setter
    def iam_role_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "iam_role_name", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The id of the ecs instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)


@pulumi.input_type
class _IamRoleAttachmentState:
    def __init__(__self__, *,
                 iam_role_name: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IamRoleAttachment resources.
        :param pulumi.Input[str] iam_role_name: The name of the iam role.
        :param pulumi.Input[str] instance_id: The id of the ecs instance.
        """
        if iam_role_name is not None:
            pulumi.set(__self__, "iam_role_name", iam_role_name)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="iamRoleName")
    def iam_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the iam role.
        """
        return pulumi.get(self, "iam_role_name")

    @iam_role_name.setter
    def iam_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_role_name", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the ecs instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)


class IamRoleAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 iam_role_name: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage iam role attachment

        ## Import

        IamRoleAttachment can be imported using the iam_role_name:instance_id, e.g.

        ```sh
         $ pulumi import volcengine:ecs/iamRoleAttachment:IamRoleAttachment default role_name:instance_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] iam_role_name: The name of the iam role.
        :param pulumi.Input[str] instance_id: The id of the ecs instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IamRoleAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage iam role attachment

        ## Import

        IamRoleAttachment can be imported using the iam_role_name:instance_id, e.g.

        ```sh
         $ pulumi import volcengine:ecs/iamRoleAttachment:IamRoleAttachment default role_name:instance_id
        ```

        :param str resource_name: The name of the resource.
        :param IamRoleAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IamRoleAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 iam_role_name: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IamRoleAttachmentArgs.__new__(IamRoleAttachmentArgs)

            if iam_role_name is None and not opts.urn:
                raise TypeError("Missing required property 'iam_role_name'")
            __props__.__dict__["iam_role_name"] = iam_role_name
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
        super(IamRoleAttachment, __self__).__init__(
            'volcengine:ecs/iamRoleAttachment:IamRoleAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            iam_role_name: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None) -> 'IamRoleAttachment':
        """
        Get an existing IamRoleAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] iam_role_name: The name of the iam role.
        :param pulumi.Input[str] instance_id: The id of the ecs instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IamRoleAttachmentState.__new__(_IamRoleAttachmentState)

        __props__.__dict__["iam_role_name"] = iam_role_name
        __props__.__dict__["instance_id"] = instance_id
        return IamRoleAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="iamRoleName")
    def iam_role_name(self) -> pulumi.Output[str]:
        """
        The name of the iam role.
        """
        return pulumi.get(self, "iam_role_name")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The id of the ecs instance.
        """
        return pulumi.get(self, "instance_id")

