# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 image_id: pulumi.Input[str],
                 instance_type: pulumi.Input[str],
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 subnet_id: pulumi.Input[str],
                 system_volume_size: pulumi.Input[int],
                 system_volume_type: pulumi.Input[str],
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 cpu_options: Optional[pulumi.Input['InstanceCpuOptionsArgs']] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataVolumeArgs']]]] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[str]] = None,
                 include_data_volumes: Optional[pulumi.Input[bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 ipv6_address_count: Optional[pulumi.Input[int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 keep_image_credential: Optional[pulumi.Input[bool]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 primary_ip_address: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 secondary_network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSecondaryNetworkInterfaceArgs']]]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 spot_price_limit: Optional[pulumi.Input[float]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] image_id: The Image ID of ECS instance.
        :param pulumi.Input[str] instance_type: The instance type of ECS instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The security group ID set of primary networkInterface.
        :param pulumi.Input[str] subnet_id: The subnet ID of primary networkInterface.
        :param pulumi.Input[int] system_volume_size: The size of system volume. The value range of the system volume size is ESSD_PL0: 20~2048, ESSD_FlexPL: 20~2048, PTSSD: 10~500.
        :param pulumi.Input[str] system_volume_type: The type of system volume, the value is `PTSSD` or `ESSD_PL0` or `ESSD_PL1` or `ESSD_PL2` or `ESSD_FlexPL`.
        :param pulumi.Input[bool] auto_renew: The auto renew flag of ECS instance.Only effective when instance_charge_type is PrePaid. Default is true.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[int] auto_renew_period: The auto renew period of ECS instance.Only effective when instance_charge_type is PrePaid. Default is 1.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input['InstanceCpuOptionsArgs'] cpu_options: The option of cpu,only support for ebm.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDataVolumeArgs']]] data_volumes: The data volumes collection of  ECS instance.
        :param pulumi.Input[str] deployment_set_id: The ID of Ecs Deployment Set.
        :param pulumi.Input[str] description: The description of ECS instance.
        :param pulumi.Input[str] host_name: The host name of ECS instance.
        :param pulumi.Input[str] hpc_cluster_id: The hpc cluster ID of ECS instance.
        :param pulumi.Input[bool] include_data_volumes: The include data volumes flag of ECS instance.Only effective when change instance charge type.include_data_volumes.
        :param pulumi.Input[str] instance_charge_type: The charge type of ECS instance, the value can be `PrePaid` or `PostPaid`.
        :param pulumi.Input[str] instance_name: The name of ECS instance.
        :param pulumi.Input[int] ipv6_address_count: The number of IPv6 addresses to be automatically assigned from within the CIDR block of the subnet that hosts the ENI. Valid values: 1 to 10.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv6_addresses: One or more IPv6 addresses selected from within the CIDR block of the subnet that hosts the ENI. Support up to 10.
               You cannot specify both the ipv6_addresses and ipv6_address_count parameters.
        :param pulumi.Input[bool] keep_image_credential: Whether to keep the mirror settings. Only custom images and shared images support this field.
               When the value of this field is true, the Password and KeyPairName cannot be specified.
               When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] key_pair_name: The ssh key name of ECS instance.
        :param pulumi.Input[str] password: The password of ECS instance.
        :param pulumi.Input[int] period: The period of ECS instance.Only effective when instance_charge_type is PrePaid. Default is 12. Unit is Month.
        :param pulumi.Input[str] primary_ip_address: The private ip address of primary networkInterface.
        :param pulumi.Input[str] project_name: The ProjectName of the ecs instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceSecondaryNetworkInterfaceArgs']]] secondary_network_interfaces: The secondary networkInterface detail collection of ECS instance.
        :param pulumi.Input[str] security_enhancement_strategy: The security enhancement strategy of ECS instance. The value can be Active or InActive. Default is Active.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[float] spot_price_limit: The maximum hourly price for spot instances supports up to three decimal places. This parameter only takes effect when SpotStrategy=SpotWithPriceLimit.
        :param pulumi.Input[str] spot_strategy: The spot strategy will autoremove instance in some conditions.Please make sure you can maintain instance lifecycle before auto remove.The spot strategy of ECS instance, values:
               NoSpot (default): indicates creating a normal pay-as-you-go instance.
               SpotAsPriceGo: spot instance with system automatically bidding and following the current market price.
               SpotWithPriceLimit: spot instance with a set upper limit for bidding price.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]] tags: Tags.
        :param pulumi.Input[str] user_data: The user data of ECS instance, this field must be encrypted with base64.
        :param pulumi.Input[str] zone_id: The available zone ID of ECS instance.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "system_volume_size", system_volume_size)
        pulumi.set(__self__, "system_volume_type", system_volume_type)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if cpu_options is not None:
            pulumi.set(__self__, "cpu_options", cpu_options)
        if data_volumes is not None:
            pulumi.set(__self__, "data_volumes", data_volumes)
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if hpc_cluster_id is not None:
            pulumi.set(__self__, "hpc_cluster_id", hpc_cluster_id)
        if include_data_volumes is not None:
            pulumi.set(__self__, "include_data_volumes", include_data_volumes)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if keep_image_credential is not None:
            pulumi.set(__self__, "keep_image_credential", keep_image_credential)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if primary_ip_address is not None:
            pulumi.set(__self__, "primary_ip_address", primary_ip_address)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if secondary_network_interfaces is not None:
            pulumi.set(__self__, "secondary_network_interfaces", secondary_network_interfaces)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        The Image ID of ECS instance.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        The instance type of ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The security group ID set of primary networkInterface.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The subnet ID of primary networkInterface.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="systemVolumeSize")
    def system_volume_size(self) -> pulumi.Input[int]:
        """
        The size of system volume. The value range of the system volume size is ESSD_PL0: 20~2048, ESSD_FlexPL: 20~2048, PTSSD: 10~500.
        """
        return pulumi.get(self, "system_volume_size")

    @system_volume_size.setter
    def system_volume_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "system_volume_size", value)

    @property
    @pulumi.getter(name="systemVolumeType")
    def system_volume_type(self) -> pulumi.Input[str]:
        """
        The type of system volume, the value is `PTSSD` or `ESSD_PL0` or `ESSD_PL1` or `ESSD_PL2` or `ESSD_FlexPL`.
        """
        return pulumi.get(self, "system_volume_type")

    @system_volume_type.setter
    def system_volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "system_volume_type", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        The auto renew flag of ECS instance.Only effective when instance_charge_type is PrePaid. Default is true.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        The auto renew period of ECS instance.Only effective when instance_charge_type is PrePaid. Default is 1.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> Optional[pulumi.Input['InstanceCpuOptionsArgs']]:
        """
        The option of cpu,only support for ebm.
        """
        return pulumi.get(self, "cpu_options")

    @cpu_options.setter
    def cpu_options(self, value: Optional[pulumi.Input['InstanceCpuOptionsArgs']]):
        pulumi.set(self, "cpu_options", value)

    @property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataVolumeArgs']]]]:
        """
        The data volumes collection of  ECS instance.
        """
        return pulumi.get(self, "data_volumes")

    @data_volumes.setter
    def data_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataVolumeArgs']]]]):
        pulumi.set(self, "data_volumes", value)

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of Ecs Deployment Set.
        """
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_set_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of ECS instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The host name of ECS instance.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The hpc cluster ID of ECS instance.
        """
        return pulumi.get(self, "hpc_cluster_id")

    @hpc_cluster_id.setter
    def hpc_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hpc_cluster_id", value)

    @property
    @pulumi.getter(name="includeDataVolumes")
    def include_data_volumes(self) -> Optional[pulumi.Input[bool]]:
        """
        The include data volumes flag of ECS instance.Only effective when change instance charge type.include_data_volumes.
        """
        return pulumi.get(self, "include_data_volumes")

    @include_data_volumes.setter
    def include_data_volumes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_data_volumes", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The charge type of ECS instance, the value can be `PrePaid` or `PostPaid`.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of ECS instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of IPv6 addresses to be automatically assigned from within the CIDR block of the subnet that hosts the ENI. Valid values: 1 to 10.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        One or more IPv6 addresses selected from within the CIDR block of the subnet that hosts the ENI. Support up to 10.
        You cannot specify both the ipv6_addresses and ipv6_address_count parameters.
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @property
    @pulumi.getter(name="keepImageCredential")
    def keep_image_credential(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to keep the mirror settings. Only custom images and shared images support this field.
        When the value of this field is true, the Password and KeyPairName cannot be specified.
        When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "keep_image_credential")

    @keep_image_credential.setter
    def keep_image_credential(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_image_credential", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ssh key name of ECS instance.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of ECS instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The period of ECS instance.Only effective when instance_charge_type is PrePaid. Default is 12. Unit is Month.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="primaryIpAddress")
    def primary_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private ip address of primary networkInterface.
        """
        return pulumi.get(self, "primary_ip_address")

    @primary_ip_address.setter
    def primary_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_ip_address", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ProjectName of the ecs instance.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="secondaryNetworkInterfaces")
    def secondary_network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSecondaryNetworkInterfaceArgs']]]]:
        """
        The secondary networkInterface detail collection of ECS instance.
        """
        return pulumi.get(self, "secondary_network_interfaces")

    @secondary_network_interfaces.setter
    def secondary_network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSecondaryNetworkInterfaceArgs']]]]):
        pulumi.set(self, "secondary_network_interfaces", value)

    @property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The security enhancement strategy of ECS instance. The value can be Active or InActive. Default is Active.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum hourly price for spot instances supports up to three decimal places. This parameter only takes effect when SpotStrategy=SpotWithPriceLimit.
        """
        return pulumi.get(self, "spot_price_limit")

    @spot_price_limit.setter
    def spot_price_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "spot_price_limit", value)

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The spot strategy will autoremove instance in some conditions.Please make sure you can maintain instance lifecycle before auto remove.The spot strategy of ECS instance, values:
        NoSpot (default): indicates creating a normal pay-as-you-go instance.
        SpotAsPriceGo: spot instance with system automatically bidding and following the current market price.
        SpotWithPriceLimit: spot instance with a set upper limit for bidding price.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_strategy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        The user data of ECS instance, this field must be encrypted with base64.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The available zone ID of ECS instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 cpu_options: Optional[pulumi.Input['InstanceCpuOptionsArgs']] = None,
                 cpus: Optional[pulumi.Input[int]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataVolumeArgs']]]] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 gpu_devices: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGpuDeviceArgs']]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 include_data_volumes: Optional[pulumi.Input[bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 ipv6_address_count: Optional[pulumi.Input[int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_gpu: Optional[pulumi.Input[bool]] = None,
                 keep_image_credential: Optional[pulumi.Input[bool]] = None,
                 key_pair_id: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 network_interface_id: Optional[pulumi.Input[str]] = None,
                 os_name: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 primary_ip_address: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 secondary_network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSecondaryNetworkInterfaceArgs']]]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_price_limit: Optional[pulumi.Input[float]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 stopped_mode: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 system_volume_id: Optional[pulumi.Input[str]] = None,
                 system_volume_size: Optional[pulumi.Input[int]] = None,
                 system_volume_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[bool] auto_renew: The auto renew flag of ECS instance.Only effective when instance_charge_type is PrePaid. Default is true.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[int] auto_renew_period: The auto renew period of ECS instance.Only effective when instance_charge_type is PrePaid. Default is 1.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input['InstanceCpuOptionsArgs'] cpu_options: The option of cpu,only support for ebm.
        :param pulumi.Input[int] cpus: The number of ECS instance CPU cores.
        :param pulumi.Input[str] created_at: The create time of ECS instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDataVolumeArgs']]] data_volumes: The data volumes collection of  ECS instance.
        :param pulumi.Input[str] deployment_set_id: The ID of Ecs Deployment Set.
        :param pulumi.Input[str] description: The description of ECS instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGpuDeviceArgs']]] gpu_devices: The GPU device info of Instance.
        :param pulumi.Input[str] host_name: The host name of ECS instance.
        :param pulumi.Input[str] hpc_cluster_id: The hpc cluster ID of ECS instance.
        :param pulumi.Input[str] image_id: The Image ID of ECS instance.
        :param pulumi.Input[bool] include_data_volumes: The include data volumes flag of ECS instance.Only effective when change instance charge type.include_data_volumes.
        :param pulumi.Input[str] instance_charge_type: The charge type of ECS instance, the value can be `PrePaid` or `PostPaid`.
        :param pulumi.Input[str] instance_id: The ID of ECS instance.
        :param pulumi.Input[str] instance_name: The name of ECS instance.
        :param pulumi.Input[str] instance_type: The instance type of ECS instance.
        :param pulumi.Input[int] ipv6_address_count: The number of IPv6 addresses to be automatically assigned from within the CIDR block of the subnet that hosts the ENI. Valid values: 1 to 10.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv6_addresses: One or more IPv6 addresses selected from within the CIDR block of the subnet that hosts the ENI. Support up to 10.
               You cannot specify both the ipv6_addresses and ipv6_address_count parameters.
        :param pulumi.Input[bool] is_gpu: The Flag of GPU instance.If the instance is GPU,The flag is true.
        :param pulumi.Input[bool] keep_image_credential: Whether to keep the mirror settings. Only custom images and shared images support this field.
               When the value of this field is true, the Password and KeyPairName cannot be specified.
               When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] key_pair_id: The ssh key ID of ECS instance.
        :param pulumi.Input[str] key_pair_name: The ssh key name of ECS instance.
        :param pulumi.Input[int] memory_size: The memory size of ECS instance.
        :param pulumi.Input[str] network_interface_id: The ID of primary networkInterface.
        :param pulumi.Input[str] os_name: The os name of ECS instance.
        :param pulumi.Input[str] os_type: The os type of ECS instance.
        :param pulumi.Input[str] password: The password of ECS instance.
        :param pulumi.Input[int] period: The period of ECS instance.Only effective when instance_charge_type is PrePaid. Default is 12. Unit is Month.
        :param pulumi.Input[str] primary_ip_address: The private ip address of primary networkInterface.
        :param pulumi.Input[str] project_name: The ProjectName of the ecs instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceSecondaryNetworkInterfaceArgs']]] secondary_network_interfaces: The secondary networkInterface detail collection of ECS instance.
        :param pulumi.Input[str] security_enhancement_strategy: The security enhancement strategy of ECS instance. The value can be Active or InActive. Default is Active.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The security group ID set of primary networkInterface.
        :param pulumi.Input[float] spot_price_limit: The maximum hourly price for spot instances supports up to three decimal places. This parameter only takes effect when SpotStrategy=SpotWithPriceLimit.
        :param pulumi.Input[str] spot_strategy: The spot strategy will autoremove instance in some conditions.Please make sure you can maintain instance lifecycle before auto remove.The spot strategy of ECS instance, values:
               NoSpot (default): indicates creating a normal pay-as-you-go instance.
               SpotAsPriceGo: spot instance with system automatically bidding and following the current market price.
               SpotWithPriceLimit: spot instance with a set upper limit for bidding price.
        :param pulumi.Input[str] status: The status of ECS instance.
        :param pulumi.Input[str] stopped_mode: The stop mode of ECS instance.
        :param pulumi.Input[str] subnet_id: The subnet ID of primary networkInterface.
        :param pulumi.Input[str] system_volume_id: The ID of system volume.
        :param pulumi.Input[int] system_volume_size: The size of system volume. The value range of the system volume size is ESSD_PL0: 20~2048, ESSD_FlexPL: 20~2048, PTSSD: 10~500.
        :param pulumi.Input[str] system_volume_type: The type of system volume, the value is `PTSSD` or `ESSD_PL0` or `ESSD_PL1` or `ESSD_PL2` or `ESSD_FlexPL`.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]] tags: Tags.
        :param pulumi.Input[str] updated_at: The update time of ECS instance.
        :param pulumi.Input[str] user_data: The user data of ECS instance, this field must be encrypted with base64.
        :param pulumi.Input[str] vpc_id: The VPC ID of ECS instance.
        :param pulumi.Input[str] zone_id: The available zone ID of ECS instance.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if cpu_options is not None:
            pulumi.set(__self__, "cpu_options", cpu_options)
        if cpus is not None:
            pulumi.set(__self__, "cpus", cpus)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if data_volumes is not None:
            pulumi.set(__self__, "data_volumes", data_volumes)
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if gpu_devices is not None:
            pulumi.set(__self__, "gpu_devices", gpu_devices)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if hpc_cluster_id is not None:
            pulumi.set(__self__, "hpc_cluster_id", hpc_cluster_id)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if include_data_volumes is not None:
            pulumi.set(__self__, "include_data_volumes", include_data_volumes)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if is_gpu is not None:
            pulumi.set(__self__, "is_gpu", is_gpu)
        if keep_image_credential is not None:
            pulumi.set(__self__, "keep_image_credential", keep_image_credential)
        if key_pair_id is not None:
            pulumi.set(__self__, "key_pair_id", key_pair_id)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if memory_size is not None:
            pulumi.set(__self__, "memory_size", memory_size)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if os_name is not None:
            pulumi.set(__self__, "os_name", os_name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if primary_ip_address is not None:
            pulumi.set(__self__, "primary_ip_address", primary_ip_address)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if secondary_network_interfaces is not None:
            pulumi.set(__self__, "secondary_network_interfaces", secondary_network_interfaces)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stopped_mode is not None:
            pulumi.set(__self__, "stopped_mode", stopped_mode)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if system_volume_id is not None:
            pulumi.set(__self__, "system_volume_id", system_volume_id)
        if system_volume_size is not None:
            pulumi.set(__self__, "system_volume_size", system_volume_size)
        if system_volume_type is not None:
            pulumi.set(__self__, "system_volume_type", system_volume_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        The auto renew flag of ECS instance.Only effective when instance_charge_type is PrePaid. Default is true.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        The auto renew period of ECS instance.Only effective when instance_charge_type is PrePaid. Default is 1.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> Optional[pulumi.Input['InstanceCpuOptionsArgs']]:
        """
        The option of cpu,only support for ebm.
        """
        return pulumi.get(self, "cpu_options")

    @cpu_options.setter
    def cpu_options(self, value: Optional[pulumi.Input['InstanceCpuOptionsArgs']]):
        pulumi.set(self, "cpu_options", value)

    @property
    @pulumi.getter
    def cpus(self) -> Optional[pulumi.Input[int]]:
        """
        The number of ECS instance CPU cores.
        """
        return pulumi.get(self, "cpus")

    @cpus.setter
    def cpus(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpus", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of ECS instance.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataVolumeArgs']]]]:
        """
        The data volumes collection of  ECS instance.
        """
        return pulumi.get(self, "data_volumes")

    @data_volumes.setter
    def data_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataVolumeArgs']]]]):
        pulumi.set(self, "data_volumes", value)

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of Ecs Deployment Set.
        """
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_set_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of ECS instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="gpuDevices")
    def gpu_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGpuDeviceArgs']]]]:
        """
        The GPU device info of Instance.
        """
        return pulumi.get(self, "gpu_devices")

    @gpu_devices.setter
    def gpu_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGpuDeviceArgs']]]]):
        pulumi.set(self, "gpu_devices", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The host name of ECS instance.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The hpc cluster ID of ECS instance.
        """
        return pulumi.get(self, "hpc_cluster_id")

    @hpc_cluster_id.setter
    def hpc_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hpc_cluster_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Image ID of ECS instance.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="includeDataVolumes")
    def include_data_volumes(self) -> Optional[pulumi.Input[bool]]:
        """
        The include data volumes flag of ECS instance.Only effective when change instance charge type.include_data_volumes.
        """
        return pulumi.get(self, "include_data_volumes")

    @include_data_volumes.setter
    def include_data_volumes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_data_volumes", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The charge type of ECS instance, the value can be `PrePaid` or `PostPaid`.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of ECS instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type of ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of IPv6 addresses to be automatically assigned from within the CIDR block of the subnet that hosts the ENI. Valid values: 1 to 10.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        One or more IPv6 addresses selected from within the CIDR block of the subnet that hosts the ENI. Support up to 10.
        You cannot specify both the ipv6_addresses and ipv6_address_count parameters.
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @property
    @pulumi.getter(name="isGpu")
    def is_gpu(self) -> Optional[pulumi.Input[bool]]:
        """
        The Flag of GPU instance.If the instance is GPU,The flag is true.
        """
        return pulumi.get(self, "is_gpu")

    @is_gpu.setter
    def is_gpu(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_gpu", value)

    @property
    @pulumi.getter(name="keepImageCredential")
    def keep_image_credential(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to keep the mirror settings. Only custom images and shared images support this field.
        When the value of this field is true, the Password and KeyPairName cannot be specified.
        When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "keep_image_credential")

    @keep_image_credential.setter
    def keep_image_credential(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_image_credential", value)

    @property
    @pulumi.getter(name="keyPairId")
    def key_pair_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ssh key ID of ECS instance.
        """
        return pulumi.get(self, "key_pair_id")

    @key_pair_id.setter
    def key_pair_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_id", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ssh key name of ECS instance.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> Optional[pulumi.Input[int]]:
        """
        The memory size of ECS instance.
        """
        return pulumi.get(self, "memory_size")

    @memory_size.setter
    def memory_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size", value)

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of primary networkInterface.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_interface_id", value)

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> Optional[pulumi.Input[str]]:
        """
        The os name of ECS instance.
        """
        return pulumi.get(self, "os_name")

    @os_name.setter
    def os_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_name", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[str]]:
        """
        The os type of ECS instance.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of ECS instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The period of ECS instance.Only effective when instance_charge_type is PrePaid. Default is 12. Unit is Month.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="primaryIpAddress")
    def primary_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The private ip address of primary networkInterface.
        """
        return pulumi.get(self, "primary_ip_address")

    @primary_ip_address.setter
    def primary_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_ip_address", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ProjectName of the ecs instance.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="secondaryNetworkInterfaces")
    def secondary_network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSecondaryNetworkInterfaceArgs']]]]:
        """
        The secondary networkInterface detail collection of ECS instance.
        """
        return pulumi.get(self, "secondary_network_interfaces")

    @secondary_network_interfaces.setter
    def secondary_network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSecondaryNetworkInterfaceArgs']]]]):
        pulumi.set(self, "secondary_network_interfaces", value)

    @property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The security enhancement strategy of ECS instance. The value can be Active or InActive. Default is Active.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The security group ID set of primary networkInterface.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum hourly price for spot instances supports up to three decimal places. This parameter only takes effect when SpotStrategy=SpotWithPriceLimit.
        """
        return pulumi.get(self, "spot_price_limit")

    @spot_price_limit.setter
    def spot_price_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "spot_price_limit", value)

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The spot strategy will autoremove instance in some conditions.Please make sure you can maintain instance lifecycle before auto remove.The spot strategy of ECS instance, values:
        NoSpot (default): indicates creating a normal pay-as-you-go instance.
        SpotAsPriceGo: spot instance with system automatically bidding and following the current market price.
        SpotWithPriceLimit: spot instance with a set upper limit for bidding price.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_strategy", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of ECS instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="stoppedMode")
    def stopped_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The stop mode of ECS instance.
        """
        return pulumi.get(self, "stopped_mode")

    @stopped_mode.setter
    def stopped_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stopped_mode", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet ID of primary networkInterface.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="systemVolumeId")
    def system_volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of system volume.
        """
        return pulumi.get(self, "system_volume_id")

    @system_volume_id.setter
    def system_volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_volume_id", value)

    @property
    @pulumi.getter(name="systemVolumeSize")
    def system_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of system volume. The value range of the system volume size is ESSD_PL0: 20~2048, ESSD_FlexPL: 20~2048, PTSSD: 10~500.
        """
        return pulumi.get(self, "system_volume_size")

    @system_volume_size.setter
    def system_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "system_volume_size", value)

    @property
    @pulumi.getter(name="systemVolumeType")
    def system_volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of system volume, the value is `PTSSD` or `ESSD_PL0` or `ESSD_PL1` or `ESSD_PL2` or `ESSD_FlexPL`.
        """
        return pulumi.get(self, "system_volume_type")

    @system_volume_type.setter
    def system_volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_volume_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of ECS instance.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        The user data of ECS instance, this field must be encrypted with base64.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC ID of ECS instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The available zone ID of ECS instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 cpu_options: Optional[pulumi.Input[pulumi.InputType['InstanceCpuOptionsArgs']]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDataVolumeArgs']]]]] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 include_data_volumes: Optional[pulumi.Input[bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 ipv6_address_count: Optional[pulumi.Input[int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 keep_image_credential: Optional[pulumi.Input[bool]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 primary_ip_address: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 secondary_network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceSecondaryNetworkInterfaceArgs']]]]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_price_limit: Optional[pulumi.Input[float]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 system_volume_size: Optional[pulumi.Input[int]] = None,
                 system_volume_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTagArgs']]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            security_group_name="acc-test-security-group",
            vpc_id=foo_vpc.id)
        foo_images = volcengine.ecs.images(os_type="Linux",
            visibility="public",
            instance_type_id="ecs.g1.large")
        foo_instance = volcengine.ecs.Instance("fooInstance",
            instance_name="acc-test-ecs",
            description="acc-test",
            host_name="tf-acc-test",
            image_id=foo_images.images[0].image_id,
            instance_type="ecs.g1.large",
            password="93f0cb0614Aab12",
            instance_charge_type="PostPaid",
            system_volume_type="ESSD_PL0",
            system_volume_size=40,
            data_volumes=[volcengine.ecs.InstanceDataVolumeArgs(
                volume_type="ESSD_PL0",
                size=50,
                delete_with_instance=True,
            )],
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id],
            project_name="default",
            tags=[volcengine.ecs.InstanceTagArgs(
                key="k1",
                value="v1",
            )])
        ```

        ## Import

        ECS Instance can be imported using the id, e.g. If Import,The data_volumes is sort by volume name

        ```sh
         $ pulumi import volcengine:ecs/instance:Instance default i-mizl7m1kqccg5smt1bdpijuj
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_renew: The auto renew flag of ECS instance.Only effective when instance_charge_type is PrePaid. Default is true.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[int] auto_renew_period: The auto renew period of ECS instance.Only effective when instance_charge_type is PrePaid. Default is 1.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[pulumi.InputType['InstanceCpuOptionsArgs']] cpu_options: The option of cpu,only support for ebm.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDataVolumeArgs']]]] data_volumes: The data volumes collection of  ECS instance.
        :param pulumi.Input[str] deployment_set_id: The ID of Ecs Deployment Set.
        :param pulumi.Input[str] description: The description of ECS instance.
        :param pulumi.Input[str] host_name: The host name of ECS instance.
        :param pulumi.Input[str] hpc_cluster_id: The hpc cluster ID of ECS instance.
        :param pulumi.Input[str] image_id: The Image ID of ECS instance.
        :param pulumi.Input[bool] include_data_volumes: The include data volumes flag of ECS instance.Only effective when change instance charge type.include_data_volumes.
        :param pulumi.Input[str] instance_charge_type: The charge type of ECS instance, the value can be `PrePaid` or `PostPaid`.
        :param pulumi.Input[str] instance_name: The name of ECS instance.
        :param pulumi.Input[str] instance_type: The instance type of ECS instance.
        :param pulumi.Input[int] ipv6_address_count: The number of IPv6 addresses to be automatically assigned from within the CIDR block of the subnet that hosts the ENI. Valid values: 1 to 10.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv6_addresses: One or more IPv6 addresses selected from within the CIDR block of the subnet that hosts the ENI. Support up to 10.
               You cannot specify both the ipv6_addresses and ipv6_address_count parameters.
        :param pulumi.Input[bool] keep_image_credential: Whether to keep the mirror settings. Only custom images and shared images support this field.
               When the value of this field is true, the Password and KeyPairName cannot be specified.
               When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] key_pair_name: The ssh key name of ECS instance.
        :param pulumi.Input[str] password: The password of ECS instance.
        :param pulumi.Input[int] period: The period of ECS instance.Only effective when instance_charge_type is PrePaid. Default is 12. Unit is Month.
        :param pulumi.Input[str] primary_ip_address: The private ip address of primary networkInterface.
        :param pulumi.Input[str] project_name: The ProjectName of the ecs instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceSecondaryNetworkInterfaceArgs']]]] secondary_network_interfaces: The secondary networkInterface detail collection of ECS instance.
        :param pulumi.Input[str] security_enhancement_strategy: The security enhancement strategy of ECS instance. The value can be Active or InActive. Default is Active.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The security group ID set of primary networkInterface.
        :param pulumi.Input[float] spot_price_limit: The maximum hourly price for spot instances supports up to three decimal places. This parameter only takes effect when SpotStrategy=SpotWithPriceLimit.
        :param pulumi.Input[str] spot_strategy: The spot strategy will autoremove instance in some conditions.Please make sure you can maintain instance lifecycle before auto remove.The spot strategy of ECS instance, values:
               NoSpot (default): indicates creating a normal pay-as-you-go instance.
               SpotAsPriceGo: spot instance with system automatically bidding and following the current market price.
               SpotWithPriceLimit: spot instance with a set upper limit for bidding price.
        :param pulumi.Input[str] subnet_id: The subnet ID of primary networkInterface.
        :param pulumi.Input[int] system_volume_size: The size of system volume. The value range of the system volume size is ESSD_PL0: 20~2048, ESSD_FlexPL: 20~2048, PTSSD: 10~500.
        :param pulumi.Input[str] system_volume_type: The type of system volume, the value is `PTSSD` or `ESSD_PL0` or `ESSD_PL1` or `ESSD_PL2` or `ESSD_FlexPL`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTagArgs']]]] tags: Tags.
        :param pulumi.Input[str] user_data: The user data of ECS instance, this field must be encrypted with base64.
        :param pulumi.Input[str] zone_id: The available zone ID of ECS instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            security_group_name="acc-test-security-group",
            vpc_id=foo_vpc.id)
        foo_images = volcengine.ecs.images(os_type="Linux",
            visibility="public",
            instance_type_id="ecs.g1.large")
        foo_instance = volcengine.ecs.Instance("fooInstance",
            instance_name="acc-test-ecs",
            description="acc-test",
            host_name="tf-acc-test",
            image_id=foo_images.images[0].image_id,
            instance_type="ecs.g1.large",
            password="93f0cb0614Aab12",
            instance_charge_type="PostPaid",
            system_volume_type="ESSD_PL0",
            system_volume_size=40,
            data_volumes=[volcengine.ecs.InstanceDataVolumeArgs(
                volume_type="ESSD_PL0",
                size=50,
                delete_with_instance=True,
            )],
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id],
            project_name="default",
            tags=[volcengine.ecs.InstanceTagArgs(
                key="k1",
                value="v1",
            )])
        ```

        ## Import

        ECS Instance can be imported using the id, e.g. If Import,The data_volumes is sort by volume name

        ```sh
         $ pulumi import volcengine:ecs/instance:Instance default i-mizl7m1kqccg5smt1bdpijuj
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 cpu_options: Optional[pulumi.Input[pulumi.InputType['InstanceCpuOptionsArgs']]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDataVolumeArgs']]]]] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 include_data_volumes: Optional[pulumi.Input[bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 ipv6_address_count: Optional[pulumi.Input[int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 keep_image_credential: Optional[pulumi.Input[bool]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 primary_ip_address: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 secondary_network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceSecondaryNetworkInterfaceArgs']]]]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_price_limit: Optional[pulumi.Input[float]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 system_volume_size: Optional[pulumi.Input[int]] = None,
                 system_volume_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTagArgs']]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["cpu_options"] = cpu_options
            __props__.__dict__["data_volumes"] = data_volumes
            __props__.__dict__["deployment_set_id"] = deployment_set_id
            __props__.__dict__["description"] = description
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["hpc_cluster_id"] = hpc_cluster_id
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["include_data_volumes"] = include_data_volumes
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["instance_name"] = instance_name
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["ipv6_address_count"] = ipv6_address_count
            __props__.__dict__["ipv6_addresses"] = ipv6_addresses
            __props__.__dict__["keep_image_credential"] = keep_image_credential
            __props__.__dict__["key_pair_name"] = key_pair_name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["period"] = period
            __props__.__dict__["primary_ip_address"] = primary_ip_address
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["secondary_network_interfaces"] = secondary_network_interfaces
            __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
            if security_group_ids is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_ids'")
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["spot_price_limit"] = spot_price_limit
            __props__.__dict__["spot_strategy"] = spot_strategy
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            if system_volume_size is None and not opts.urn:
                raise TypeError("Missing required property 'system_volume_size'")
            __props__.__dict__["system_volume_size"] = system_volume_size
            if system_volume_type is None and not opts.urn:
                raise TypeError("Missing required property 'system_volume_type'")
            __props__.__dict__["system_volume_type"] = system_volume_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["cpus"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["gpu_devices"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["is_gpu"] = None
            __props__.__dict__["key_pair_id"] = None
            __props__.__dict__["memory_size"] = None
            __props__.__dict__["network_interface_id"] = None
            __props__.__dict__["os_name"] = None
            __props__.__dict__["os_type"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["stopped_mode"] = None
            __props__.__dict__["system_volume_id"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["vpc_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'volcengine:ecs/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            auto_renew_period: Optional[pulumi.Input[int]] = None,
            cpu_options: Optional[pulumi.Input[pulumi.InputType['InstanceCpuOptionsArgs']]] = None,
            cpus: Optional[pulumi.Input[int]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDataVolumeArgs']]]]] = None,
            deployment_set_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            gpu_devices: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceGpuDeviceArgs']]]]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            hpc_cluster_id: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            include_data_volumes: Optional[pulumi.Input[bool]] = None,
            instance_charge_type: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            ipv6_address_count: Optional[pulumi.Input[int]] = None,
            ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            is_gpu: Optional[pulumi.Input[bool]] = None,
            keep_image_credential: Optional[pulumi.Input[bool]] = None,
            key_pair_id: Optional[pulumi.Input[str]] = None,
            key_pair_name: Optional[pulumi.Input[str]] = None,
            memory_size: Optional[pulumi.Input[int]] = None,
            network_interface_id: Optional[pulumi.Input[str]] = None,
            os_name: Optional[pulumi.Input[str]] = None,
            os_type: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            primary_ip_address: Optional[pulumi.Input[str]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            secondary_network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceSecondaryNetworkInterfaceArgs']]]]] = None,
            security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            spot_price_limit: Optional[pulumi.Input[float]] = None,
            spot_strategy: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            stopped_mode: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            system_volume_id: Optional[pulumi.Input[str]] = None,
            system_volume_size: Optional[pulumi.Input[int]] = None,
            system_volume_type: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTagArgs']]]]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            user_data: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_renew: The auto renew flag of ECS instance.Only effective when instance_charge_type is PrePaid. Default is true.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[int] auto_renew_period: The auto renew period of ECS instance.Only effective when instance_charge_type is PrePaid. Default is 1.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[pulumi.InputType['InstanceCpuOptionsArgs']] cpu_options: The option of cpu,only support for ebm.
        :param pulumi.Input[int] cpus: The number of ECS instance CPU cores.
        :param pulumi.Input[str] created_at: The create time of ECS instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDataVolumeArgs']]]] data_volumes: The data volumes collection of  ECS instance.
        :param pulumi.Input[str] deployment_set_id: The ID of Ecs Deployment Set.
        :param pulumi.Input[str] description: The description of ECS instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceGpuDeviceArgs']]]] gpu_devices: The GPU device info of Instance.
        :param pulumi.Input[str] host_name: The host name of ECS instance.
        :param pulumi.Input[str] hpc_cluster_id: The hpc cluster ID of ECS instance.
        :param pulumi.Input[str] image_id: The Image ID of ECS instance.
        :param pulumi.Input[bool] include_data_volumes: The include data volumes flag of ECS instance.Only effective when change instance charge type.include_data_volumes.
        :param pulumi.Input[str] instance_charge_type: The charge type of ECS instance, the value can be `PrePaid` or `PostPaid`.
        :param pulumi.Input[str] instance_id: The ID of ECS instance.
        :param pulumi.Input[str] instance_name: The name of ECS instance.
        :param pulumi.Input[str] instance_type: The instance type of ECS instance.
        :param pulumi.Input[int] ipv6_address_count: The number of IPv6 addresses to be automatically assigned from within the CIDR block of the subnet that hosts the ENI. Valid values: 1 to 10.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipv6_addresses: One or more IPv6 addresses selected from within the CIDR block of the subnet that hosts the ENI. Support up to 10.
               You cannot specify both the ipv6_addresses and ipv6_address_count parameters.
        :param pulumi.Input[bool] is_gpu: The Flag of GPU instance.If the instance is GPU,The flag is true.
        :param pulumi.Input[bool] keep_image_credential: Whether to keep the mirror settings. Only custom images and shared images support this field.
               When the value of this field is true, the Password and KeyPairName cannot be specified.
               When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] key_pair_id: The ssh key ID of ECS instance.
        :param pulumi.Input[str] key_pair_name: The ssh key name of ECS instance.
        :param pulumi.Input[int] memory_size: The memory size of ECS instance.
        :param pulumi.Input[str] network_interface_id: The ID of primary networkInterface.
        :param pulumi.Input[str] os_name: The os name of ECS instance.
        :param pulumi.Input[str] os_type: The os type of ECS instance.
        :param pulumi.Input[str] password: The password of ECS instance.
        :param pulumi.Input[int] period: The period of ECS instance.Only effective when instance_charge_type is PrePaid. Default is 12. Unit is Month.
        :param pulumi.Input[str] primary_ip_address: The private ip address of primary networkInterface.
        :param pulumi.Input[str] project_name: The ProjectName of the ecs instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceSecondaryNetworkInterfaceArgs']]]] secondary_network_interfaces: The secondary networkInterface detail collection of ECS instance.
        :param pulumi.Input[str] security_enhancement_strategy: The security enhancement strategy of ECS instance. The value can be Active or InActive. Default is Active.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The security group ID set of primary networkInterface.
        :param pulumi.Input[float] spot_price_limit: The maximum hourly price for spot instances supports up to three decimal places. This parameter only takes effect when SpotStrategy=SpotWithPriceLimit.
        :param pulumi.Input[str] spot_strategy: The spot strategy will autoremove instance in some conditions.Please make sure you can maintain instance lifecycle before auto remove.The spot strategy of ECS instance, values:
               NoSpot (default): indicates creating a normal pay-as-you-go instance.
               SpotAsPriceGo: spot instance with system automatically bidding and following the current market price.
               SpotWithPriceLimit: spot instance with a set upper limit for bidding price.
        :param pulumi.Input[str] status: The status of ECS instance.
        :param pulumi.Input[str] stopped_mode: The stop mode of ECS instance.
        :param pulumi.Input[str] subnet_id: The subnet ID of primary networkInterface.
        :param pulumi.Input[str] system_volume_id: The ID of system volume.
        :param pulumi.Input[int] system_volume_size: The size of system volume. The value range of the system volume size is ESSD_PL0: 20~2048, ESSD_FlexPL: 20~2048, PTSSD: 10~500.
        :param pulumi.Input[str] system_volume_type: The type of system volume, the value is `PTSSD` or `ESSD_PL0` or `ESSD_PL1` or `ESSD_PL2` or `ESSD_FlexPL`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTagArgs']]]] tags: Tags.
        :param pulumi.Input[str] updated_at: The update time of ECS instance.
        :param pulumi.Input[str] user_data: The user data of ECS instance, this field must be encrypted with base64.
        :param pulumi.Input[str] vpc_id: The VPC ID of ECS instance.
        :param pulumi.Input[str] zone_id: The available zone ID of ECS instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["cpu_options"] = cpu_options
        __props__.__dict__["cpus"] = cpus
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["data_volumes"] = data_volumes
        __props__.__dict__["deployment_set_id"] = deployment_set_id
        __props__.__dict__["description"] = description
        __props__.__dict__["gpu_devices"] = gpu_devices
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["hpc_cluster_id"] = hpc_cluster_id
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["include_data_volumes"] = include_data_volumes
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["ipv6_address_count"] = ipv6_address_count
        __props__.__dict__["ipv6_addresses"] = ipv6_addresses
        __props__.__dict__["is_gpu"] = is_gpu
        __props__.__dict__["keep_image_credential"] = keep_image_credential
        __props__.__dict__["key_pair_id"] = key_pair_id
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["memory_size"] = memory_size
        __props__.__dict__["network_interface_id"] = network_interface_id
        __props__.__dict__["os_name"] = os_name
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["primary_ip_address"] = primary_ip_address
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["secondary_network_interfaces"] = secondary_network_interfaces
        __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["spot_price_limit"] = spot_price_limit
        __props__.__dict__["spot_strategy"] = spot_strategy
        __props__.__dict__["status"] = status
        __props__.__dict__["stopped_mode"] = stopped_mode
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["system_volume_id"] = system_volume_id
        __props__.__dict__["system_volume_size"] = system_volume_size
        __props__.__dict__["system_volume_type"] = system_volume_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["zone_id"] = zone_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[bool]]:
        """
        The auto renew flag of ECS instance.Only effective when instance_charge_type is PrePaid. Default is true.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[Optional[int]]:
        """
        The auto renew period of ECS instance.Only effective when instance_charge_type is PrePaid. Default is 1.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "auto_renew_period")

    @property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> pulumi.Output['outputs.InstanceCpuOptions']:
        """
        The option of cpu,only support for ebm.
        """
        return pulumi.get(self, "cpu_options")

    @property
    @pulumi.getter
    def cpus(self) -> pulumi.Output[int]:
        """
        The number of ECS instance CPU cores.
        """
        return pulumi.get(self, "cpus")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The create time of ECS instance.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> pulumi.Output[Sequence['outputs.InstanceDataVolume']]:
        """
        The data volumes collection of  ECS instance.
        """
        return pulumi.get(self, "data_volumes")

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> pulumi.Output[str]:
        """
        The ID of Ecs Deployment Set.
        """
        return pulumi.get(self, "deployment_set_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of ECS instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="gpuDevices")
    def gpu_devices(self) -> pulumi.Output[Sequence['outputs.InstanceGpuDevice']]:
        """
        The GPU device info of Instance.
        """
        return pulumi.get(self, "gpu_devices")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[str]:
        """
        The host name of ECS instance.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> pulumi.Output[Optional[str]]:
        """
        The hpc cluster ID of ECS instance.
        """
        return pulumi.get(self, "hpc_cluster_id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        The Image ID of ECS instance.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="includeDataVolumes")
    def include_data_volumes(self) -> pulumi.Output[Optional[bool]]:
        """
        The include data volumes flag of ECS instance.Only effective when change instance charge type.include_data_volumes.
        """
        return pulumi.get(self, "include_data_volumes")

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[str]:
        """
        The charge type of ECS instance, the value can be `PrePaid` or `PostPaid`.
        """
        return pulumi.get(self, "instance_charge_type")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The ID of ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[str]:
        """
        The name of ECS instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        The instance type of ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> pulumi.Output[int]:
        """
        The number of IPv6 addresses to be automatically assigned from within the CIDR block of the subnet that hosts the ENI. Valid values: 1 to 10.
        """
        return pulumi.get(self, "ipv6_address_count")

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        One or more IPv6 addresses selected from within the CIDR block of the subnet that hosts the ENI. Support up to 10.
        You cannot specify both the ipv6_addresses and ipv6_address_count parameters.
        """
        return pulumi.get(self, "ipv6_addresses")

    @property
    @pulumi.getter(name="isGpu")
    def is_gpu(self) -> pulumi.Output[bool]:
        """
        The Flag of GPU instance.If the instance is GPU,The flag is true.
        """
        return pulumi.get(self, "is_gpu")

    @property
    @pulumi.getter(name="keepImageCredential")
    def keep_image_credential(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to keep the mirror settings. Only custom images and shared images support this field.
        When the value of this field is true, the Password and KeyPairName cannot be specified.
        When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "keep_image_credential")

    @property
    @pulumi.getter(name="keyPairId")
    def key_pair_id(self) -> pulumi.Output[str]:
        """
        The ssh key ID of ECS instance.
        """
        return pulumi.get(self, "key_pair_id")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[str]:
        """
        The ssh key name of ECS instance.
        """
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> pulumi.Output[int]:
        """
        The memory size of ECS instance.
        """
        return pulumi.get(self, "memory_size")

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Output[str]:
        """
        The ID of primary networkInterface.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> pulumi.Output[str]:
        """
        The os name of ECS instance.
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[str]:
        """
        The os type of ECS instance.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The password of ECS instance.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        The period of ECS instance.Only effective when instance_charge_type is PrePaid. Default is 12. Unit is Month.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="primaryIpAddress")
    def primary_ip_address(self) -> pulumi.Output[str]:
        """
        The private ip address of primary networkInterface.
        """
        return pulumi.get(self, "primary_ip_address")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The ProjectName of the ecs instance.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="secondaryNetworkInterfaces")
    def secondary_network_interfaces(self) -> pulumi.Output[Sequence['outputs.InstanceSecondaryNetworkInterface']]:
        """
        The secondary networkInterface detail collection of ECS instance.
        """
        return pulumi.get(self, "secondary_network_interfaces")

    @property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        The security enhancement strategy of ECS instance. The value can be Active or InActive. Default is Active.When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The security group ID set of primary networkInterface.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> pulumi.Output[Optional[float]]:
        """
        The maximum hourly price for spot instances supports up to three decimal places. This parameter only takes effect when SpotStrategy=SpotWithPriceLimit.
        """
        return pulumi.get(self, "spot_price_limit")

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> pulumi.Output[str]:
        """
        The spot strategy will autoremove instance in some conditions.Please make sure you can maintain instance lifecycle before auto remove.The spot strategy of ECS instance, values:
        NoSpot (default): indicates creating a normal pay-as-you-go instance.
        SpotAsPriceGo: spot instance with system automatically bidding and following the current market price.
        SpotWithPriceLimit: spot instance with a set upper limit for bidding price.
        """
        return pulumi.get(self, "spot_strategy")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of ECS instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="stoppedMode")
    def stopped_mode(self) -> pulumi.Output[str]:
        """
        The stop mode of ECS instance.
        """
        return pulumi.get(self, "stopped_mode")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The subnet ID of primary networkInterface.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemVolumeId")
    def system_volume_id(self) -> pulumi.Output[str]:
        """
        The ID of system volume.
        """
        return pulumi.get(self, "system_volume_id")

    @property
    @pulumi.getter(name="systemVolumeSize")
    def system_volume_size(self) -> pulumi.Output[int]:
        """
        The size of system volume. The value range of the system volume size is ESSD_PL0: 20~2048, ESSD_FlexPL: 20~2048, PTSSD: 10~500.
        """
        return pulumi.get(self, "system_volume_size")

    @property
    @pulumi.getter(name="systemVolumeType")
    def system_volume_type(self) -> pulumi.Output[str]:
        """
        The type of system volume, the value is `PTSSD` or `ESSD_PL0` or `ESSD_PL1` or `ESSD_PL2` or `ESSD_FlexPL`.
        """
        return pulumi.get(self, "system_volume_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceTag']]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The update time of ECS instance.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[str]:
        """
        The user data of ECS instance, this field must be encrypted with base64.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The VPC ID of ECS instance.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The available zone ID of ECS instance.
        """
        return pulumi.get(self, "zone_id")

