# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'InstancesResult',
    'AwaitableInstancesResult',
    'instances',
    'instances_output',
]

@pulumi.output_type
class InstancesResult:
    """
    A collection of values returned by Instances.
    """
    def __init__(__self__, deployment_set_ids=None, hpc_cluster_id=None, id=None, ids=None, instance_charge_type=None, instances=None, key_pair_name=None, name_regex=None, output_file=None, primary_ip_address=None, project_name=None, status=None, tags=None, total_count=None, vpc_id=None, zone_id=None):
        if deployment_set_ids and not isinstance(deployment_set_ids, list):
            raise TypeError("Expected argument 'deployment_set_ids' to be a list")
        pulumi.set(__self__, "deployment_set_ids", deployment_set_ids)
        if hpc_cluster_id and not isinstance(hpc_cluster_id, str):
            raise TypeError("Expected argument 'hpc_cluster_id' to be a str")
        pulumi.set(__self__, "hpc_cluster_id", hpc_cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instance_charge_type and not isinstance(instance_charge_type, str):
            raise TypeError("Expected argument 'instance_charge_type' to be a str")
        pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if key_pair_name and not isinstance(key_pair_name, str):
            raise TypeError("Expected argument 'key_pair_name' to be a str")
        pulumi.set(__self__, "key_pair_name", key_pair_name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if primary_ip_address and not isinstance(primary_ip_address, str):
            raise TypeError("Expected argument 'primary_ip_address' to be a str")
        pulumi.set(__self__, "primary_ip_address", primary_ip_address)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="deploymentSetIds")
    def deployment_set_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "deployment_set_ids")

    @property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> Optional[str]:
        return pulumi.get(self, "hpc_cluster_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[str]:
        """
        The charge type of ECS instance.
        """
        return pulumi.get(self, "instance_charge_type")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.InstancesInstanceResult']:
        """
        The collection of ECS instance query.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[str]:
        """
        The ssh key name of ECS instance.
        """
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="primaryIpAddress")
    def primary_ip_address(self) -> Optional[str]:
        """
        The private ip address of networkInterface.
        """
        return pulumi.get(self, "primary_ip_address")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        """
        The ProjectName of ECS instance.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of ECS instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.InstancesTagResult']]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of ECS instance query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The VPC ID of ECS instance.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[str]:
        """
        The available zone ID of ECS instance.
        """
        return pulumi.get(self, "zone_id")


class AwaitableInstancesResult(InstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return InstancesResult(
            deployment_set_ids=self.deployment_set_ids,
            hpc_cluster_id=self.hpc_cluster_id,
            id=self.id,
            ids=self.ids,
            instance_charge_type=self.instance_charge_type,
            instances=self.instances,
            key_pair_name=self.key_pair_name,
            name_regex=self.name_regex,
            output_file=self.output_file,
            primary_ip_address=self.primary_ip_address,
            project_name=self.project_name,
            status=self.status,
            tags=self.tags,
            total_count=self.total_count,
            vpc_id=self.vpc_id,
            zone_id=self.zone_id)


def instances(deployment_set_ids: Optional[Sequence[str]] = None,
              hpc_cluster_id: Optional[str] = None,
              ids: Optional[Sequence[str]] = None,
              instance_charge_type: Optional[str] = None,
              key_pair_name: Optional[str] = None,
              name_regex: Optional[str] = None,
              output_file: Optional[str] = None,
              primary_ip_address: Optional[str] = None,
              project_name: Optional[str] = None,
              status: Optional[str] = None,
              tags: Optional[Sequence[pulumi.InputType['InstancesTagArgs']]] = None,
              vpc_id: Optional[str] = None,
              zone_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableInstancesResult:
    """
    Use this data source to query detailed information of ecs instances
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
        security_group_name="acc-test-security-group",
        vpc_id=foo_vpc.id)
    foo_images = volcengine.ecs.images(os_type="Linux",
        visibility="public",
        instance_type_id="ecs.g1.large")
    foo_instance = []
    for range in [{"value": i} for i in range(0, 2)]:
        foo_instance.append(volcengine.ecs.Instance(f"fooInstance-{range['value']}",
            instance_name=f"acc-test-ecs-{range['value']}",
            description="acc-test",
            host_name="tf-acc-test",
            image_id=foo_images.images[0].image_id,
            instance_type="ecs.g1.large",
            password="93f0cb0614Aab12",
            instance_charge_type="PostPaid",
            system_volume_type="ESSD_PL0",
            system_volume_size=40,
            data_volumes=[volcengine.ecs.InstanceDataVolumeArgs(
                volume_type="ESSD_PL0",
                size=50,
                delete_with_instance=True,
            )],
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id],
            project_name="default",
            tags=[volcengine.ecs.InstanceTagArgs(
                key="k1",
                value="v1",
            )]))
    foo_instances = volcengine.ecs.instances_output(ids=[__item.id for __item in foo_instance])
    ```


    :param Sequence[str] deployment_set_ids: A list of DeploymentSet IDs.
    :param str hpc_cluster_id: The hpc cluster ID of ECS instance.
    :param Sequence[str] ids: A list of ECS instance IDs.
    :param str instance_charge_type: The charge type of ECS instance.
    :param str key_pair_name: The key pair name of ECS instance.
    :param str name_regex: A Name Regex of ECS instance.
    :param str output_file: File name where to save data source results.
    :param str primary_ip_address: The primary ip address of ECS instance.
    :param str project_name: The ProjectName of ECS instance.
    :param str status: The status of ECS instance.
    :param Sequence[pulumi.InputType['InstancesTagArgs']] tags: Tags.
    :param str vpc_id: The VPC ID of ECS instance.
    :param str zone_id: The available zone ID of ECS instance.
    """
    __args__ = dict()
    __args__['deploymentSetIds'] = deployment_set_ids
    __args__['hpcClusterId'] = hpc_cluster_id
    __args__['ids'] = ids
    __args__['instanceChargeType'] = instance_charge_type
    __args__['keyPairName'] = key_pair_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['primaryIpAddress'] = primary_ip_address
    __args__['projectName'] = project_name
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:ecs/instances:Instances', __args__, opts=opts, typ=InstancesResult).value

    return AwaitableInstancesResult(
        deployment_set_ids=pulumi.get(__ret__, 'deployment_set_ids'),
        hpc_cluster_id=pulumi.get(__ret__, 'hpc_cluster_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instance_charge_type=pulumi.get(__ret__, 'instance_charge_type'),
        instances=pulumi.get(__ret__, 'instances'),
        key_pair_name=pulumi.get(__ret__, 'key_pair_name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        primary_ip_address=pulumi.get(__ret__, 'primary_ip_address'),
        project_name=pulumi.get(__ret__, 'project_name'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        total_count=pulumi.get(__ret__, 'total_count'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))


@_utilities.lift_output_func(instances)
def instances_output(deployment_set_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     hpc_cluster_id: Optional[pulumi.Input[Optional[str]]] = None,
                     ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     instance_charge_type: Optional[pulumi.Input[Optional[str]]] = None,
                     key_pair_name: Optional[pulumi.Input[Optional[str]]] = None,
                     name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                     primary_ip_address: Optional[pulumi.Input[Optional[str]]] = None,
                     project_name: Optional[pulumi.Input[Optional[str]]] = None,
                     status: Optional[pulumi.Input[Optional[str]]] = None,
                     tags: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['InstancesTagArgs']]]]] = None,
                     vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                     zone_id: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[InstancesResult]:
    """
    Use this data source to query detailed information of ecs instances
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
        security_group_name="acc-test-security-group",
        vpc_id=foo_vpc.id)
    foo_images = volcengine.ecs.images(os_type="Linux",
        visibility="public",
        instance_type_id="ecs.g1.large")
    foo_instance = []
    for range in [{"value": i} for i in range(0, 2)]:
        foo_instance.append(volcengine.ecs.Instance(f"fooInstance-{range['value']}",
            instance_name=f"acc-test-ecs-{range['value']}",
            description="acc-test",
            host_name="tf-acc-test",
            image_id=foo_images.images[0].image_id,
            instance_type="ecs.g1.large",
            password="93f0cb0614Aab12",
            instance_charge_type="PostPaid",
            system_volume_type="ESSD_PL0",
            system_volume_size=40,
            data_volumes=[volcengine.ecs.InstanceDataVolumeArgs(
                volume_type="ESSD_PL0",
                size=50,
                delete_with_instance=True,
            )],
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id],
            project_name="default",
            tags=[volcengine.ecs.InstanceTagArgs(
                key="k1",
                value="v1",
            )]))
    foo_instances = volcengine.ecs.instances_output(ids=[__item.id for __item in foo_instance])
    ```


    :param Sequence[str] deployment_set_ids: A list of DeploymentSet IDs.
    :param str hpc_cluster_id: The hpc cluster ID of ECS instance.
    :param Sequence[str] ids: A list of ECS instance IDs.
    :param str instance_charge_type: The charge type of ECS instance.
    :param str key_pair_name: The key pair name of ECS instance.
    :param str name_regex: A Name Regex of ECS instance.
    :param str output_file: File name where to save data source results.
    :param str primary_ip_address: The primary ip address of ECS instance.
    :param str project_name: The ProjectName of ECS instance.
    :param str status: The status of ECS instance.
    :param Sequence[pulumi.InputType['InstancesTagArgs']] tags: Tags.
    :param str vpc_id: The VPC ID of ECS instance.
    :param str zone_id: The available zone ID of ECS instance.
    """
    ...
