# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['InvocationArgs', 'Invocation']

@pulumi.input_type
class InvocationArgs:
    def __init__(__self__, *,
                 command_id: pulumi.Input[str],
                 instance_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 invocation_name: pulumi.Input[str],
                 username: pulumi.Input[str],
                 frequency: Optional[pulumi.Input[str]] = None,
                 invocation_description: Optional[pulumi.Input[str]] = None,
                 launch_time: Optional[pulumi.Input[str]] = None,
                 recurrence_end_time: Optional[pulumi.Input[str]] = None,
                 repeat_mode: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Invocation resource.
        :param pulumi.Input[str] command_id: The command id of the ecs invocation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_ids: The list of ECS instance IDs.
        :param pulumi.Input[str] invocation_name: The name of the ecs invocation.
        :param pulumi.Input[str] username: The username of the ecs command. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        :param pulumi.Input[str] frequency: The frequency of the ecs invocation. This field is valid and required when the value of the repeat_mode field is `Rate`.
        :param pulumi.Input[str] invocation_description: The description of the ecs invocation.
        :param pulumi.Input[str] launch_time: The launch time of the ecs invocation. RFC3339 format. This field is valid and required when the value of the repeat_mode field is `Rate` or `Fixed`.
        :param pulumi.Input[str] recurrence_end_time: The recurrence end time of the ecs invocation. RFC3339 format. This field is valid and required when the value of the repeat_mode field is `Rate`.
        :param pulumi.Input[str] repeat_mode: The repeat mode of the ecs invocation. Valid values: `Once`, `Rate`, `Fixed`.
        :param pulumi.Input[int] timeout: The timeout of the ecs command. Valid value range: 10-600. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        :param pulumi.Input[str] working_dir: The working directory of the ecs invocation. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        """
        pulumi.set(__self__, "command_id", command_id)
        pulumi.set(__self__, "instance_ids", instance_ids)
        pulumi.set(__self__, "invocation_name", invocation_name)
        pulumi.set(__self__, "username", username)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if invocation_description is not None:
            pulumi.set(__self__, "invocation_description", invocation_description)
        if launch_time is not None:
            pulumi.set(__self__, "launch_time", launch_time)
        if recurrence_end_time is not None:
            pulumi.set(__self__, "recurrence_end_time", recurrence_end_time)
        if repeat_mode is not None:
            pulumi.set(__self__, "repeat_mode", repeat_mode)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter(name="commandId")
    def command_id(self) -> pulumi.Input[str]:
        """
        The command id of the ecs invocation.
        """
        return pulumi.get(self, "command_id")

    @command_id.setter
    def command_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "command_id", value)

    @property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of ECS instance IDs.
        """
        return pulumi.get(self, "instance_ids")

    @instance_ids.setter
    def instance_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "instance_ids", value)

    @property
    @pulumi.getter(name="invocationName")
    def invocation_name(self) -> pulumi.Input[str]:
        """
        The name of the ecs invocation.
        """
        return pulumi.get(self, "invocation_name")

    @invocation_name.setter
    def invocation_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "invocation_name", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The username of the ecs command. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[str]]:
        """
        The frequency of the ecs invocation. This field is valid and required when the value of the repeat_mode field is `Rate`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter(name="invocationDescription")
    def invocation_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the ecs invocation.
        """
        return pulumi.get(self, "invocation_description")

    @invocation_description.setter
    def invocation_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invocation_description", value)

    @property
    @pulumi.getter(name="launchTime")
    def launch_time(self) -> Optional[pulumi.Input[str]]:
        """
        The launch time of the ecs invocation. RFC3339 format. This field is valid and required when the value of the repeat_mode field is `Rate` or `Fixed`.
        """
        return pulumi.get(self, "launch_time")

    @launch_time.setter
    def launch_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_time", value)

    @property
    @pulumi.getter(name="recurrenceEndTime")
    def recurrence_end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The recurrence end time of the ecs invocation. RFC3339 format. This field is valid and required when the value of the repeat_mode field is `Rate`.
        """
        return pulumi.get(self, "recurrence_end_time")

    @recurrence_end_time.setter
    def recurrence_end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recurrence_end_time", value)

    @property
    @pulumi.getter(name="repeatMode")
    def repeat_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The repeat mode of the ecs invocation. Valid values: `Once`, `Rate`, `Fixed`.
        """
        return pulumi.get(self, "repeat_mode")

    @repeat_mode.setter
    def repeat_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repeat_mode", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout of the ecs command. Valid value range: 10-600. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        The working directory of the ecs invocation. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


@pulumi.input_type
class _InvocationState:
    def __init__(__self__, *,
                 command_id: Optional[pulumi.Input[str]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 frequency: Optional[pulumi.Input[str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 invocation_description: Optional[pulumi.Input[str]] = None,
                 invocation_name: Optional[pulumi.Input[str]] = None,
                 invocation_status: Optional[pulumi.Input[str]] = None,
                 launch_time: Optional[pulumi.Input[str]] = None,
                 recurrence_end_time: Optional[pulumi.Input[str]] = None,
                 repeat_mode: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Invocation resources.
        :param pulumi.Input[str] command_id: The command id of the ecs invocation.
        :param pulumi.Input[str] end_time: The end time of the ecs invocation.
        :param pulumi.Input[str] frequency: The frequency of the ecs invocation. This field is valid and required when the value of the repeat_mode field is `Rate`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_ids: The list of ECS instance IDs.
        :param pulumi.Input[str] invocation_description: The description of the ecs invocation.
        :param pulumi.Input[str] invocation_name: The name of the ecs invocation.
        :param pulumi.Input[str] invocation_status: The status of the ecs invocation.
        :param pulumi.Input[str] launch_time: The launch time of the ecs invocation. RFC3339 format. This field is valid and required when the value of the repeat_mode field is `Rate` or `Fixed`.
        :param pulumi.Input[str] recurrence_end_time: The recurrence end time of the ecs invocation. RFC3339 format. This field is valid and required when the value of the repeat_mode field is `Rate`.
        :param pulumi.Input[str] repeat_mode: The repeat mode of the ecs invocation. Valid values: `Once`, `Rate`, `Fixed`.
        :param pulumi.Input[str] start_time: The start time of the ecs invocation.
        :param pulumi.Input[int] timeout: The timeout of the ecs command. Valid value range: 10-600. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        :param pulumi.Input[str] username: The username of the ecs command. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        :param pulumi.Input[str] working_dir: The working directory of the ecs invocation. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        """
        if command_id is not None:
            pulumi.set(__self__, "command_id", command_id)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if instance_ids is not None:
            pulumi.set(__self__, "instance_ids", instance_ids)
        if invocation_description is not None:
            pulumi.set(__self__, "invocation_description", invocation_description)
        if invocation_name is not None:
            pulumi.set(__self__, "invocation_name", invocation_name)
        if invocation_status is not None:
            pulumi.set(__self__, "invocation_status", invocation_status)
        if launch_time is not None:
            pulumi.set(__self__, "launch_time", launch_time)
        if recurrence_end_time is not None:
            pulumi.set(__self__, "recurrence_end_time", recurrence_end_time)
        if repeat_mode is not None:
            pulumi.set(__self__, "repeat_mode", repeat_mode)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter(name="commandId")
    def command_id(self) -> Optional[pulumi.Input[str]]:
        """
        The command id of the ecs invocation.
        """
        return pulumi.get(self, "command_id")

    @command_id.setter
    def command_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "command_id", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The end time of the ecs invocation.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[str]]:
        """
        The frequency of the ecs invocation. This field is valid and required when the value of the repeat_mode field is `Rate`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of ECS instance IDs.
        """
        return pulumi.get(self, "instance_ids")

    @instance_ids.setter
    def instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_ids", value)

    @property
    @pulumi.getter(name="invocationDescription")
    def invocation_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the ecs invocation.
        """
        return pulumi.get(self, "invocation_description")

    @invocation_description.setter
    def invocation_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invocation_description", value)

    @property
    @pulumi.getter(name="invocationName")
    def invocation_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ecs invocation.
        """
        return pulumi.get(self, "invocation_name")

    @invocation_name.setter
    def invocation_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invocation_name", value)

    @property
    @pulumi.getter(name="invocationStatus")
    def invocation_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the ecs invocation.
        """
        return pulumi.get(self, "invocation_status")

    @invocation_status.setter
    def invocation_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invocation_status", value)

    @property
    @pulumi.getter(name="launchTime")
    def launch_time(self) -> Optional[pulumi.Input[str]]:
        """
        The launch time of the ecs invocation. RFC3339 format. This field is valid and required when the value of the repeat_mode field is `Rate` or `Fixed`.
        """
        return pulumi.get(self, "launch_time")

    @launch_time.setter
    def launch_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_time", value)

    @property
    @pulumi.getter(name="recurrenceEndTime")
    def recurrence_end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The recurrence end time of the ecs invocation. RFC3339 format. This field is valid and required when the value of the repeat_mode field is `Rate`.
        """
        return pulumi.get(self, "recurrence_end_time")

    @recurrence_end_time.setter
    def recurrence_end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recurrence_end_time", value)

    @property
    @pulumi.getter(name="repeatMode")
    def repeat_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The repeat mode of the ecs invocation. Valid values: `Once`, `Rate`, `Fixed`.
        """
        return pulumi.get(self, "repeat_mode")

    @repeat_mode.setter
    def repeat_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repeat_mode", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The start time of the ecs invocation.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout of the ecs command. Valid value range: 10-600. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username of the ecs command. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        The working directory of the ecs invocation. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


class Invocation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 command_id: Optional[pulumi.Input[str]] = None,
                 frequency: Optional[pulumi.Input[str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 invocation_description: Optional[pulumi.Input[str]] = None,
                 invocation_name: Optional[pulumi.Input[str]] = None,
                 launch_time: Optional[pulumi.Input[str]] = None,
                 recurrence_end_time: Optional[pulumi.Input[str]] = None,
                 repeat_mode: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage ecs invocation
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.ecs.Invocation("foo",
            command_id="cmd-ychkepkhtim0tr3b****",
            frequency="5m",
            instance_ids=["i-ychmz92487l8j00o****"],
            invocation_description="tf",
            invocation_name="tf-test",
            launch_time="2023-06-20T09:48:00Z",
            recurrence_end_time="2023-06-20T09:59:00Z",
            repeat_mode="Rate",
            timeout=90,
            username="root",
            working_dir="/home")
        ```

        ## Import

        EcsInvocation can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:ecs/invocation:Invocation default ivk-ychnxnm45dl8j0mm****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] command_id: The command id of the ecs invocation.
        :param pulumi.Input[str] frequency: The frequency of the ecs invocation. This field is valid and required when the value of the repeat_mode field is `Rate`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_ids: The list of ECS instance IDs.
        :param pulumi.Input[str] invocation_description: The description of the ecs invocation.
        :param pulumi.Input[str] invocation_name: The name of the ecs invocation.
        :param pulumi.Input[str] launch_time: The launch time of the ecs invocation. RFC3339 format. This field is valid and required when the value of the repeat_mode field is `Rate` or `Fixed`.
        :param pulumi.Input[str] recurrence_end_time: The recurrence end time of the ecs invocation. RFC3339 format. This field is valid and required when the value of the repeat_mode field is `Rate`.
        :param pulumi.Input[str] repeat_mode: The repeat mode of the ecs invocation. Valid values: `Once`, `Rate`, `Fixed`.
        :param pulumi.Input[int] timeout: The timeout of the ecs command. Valid value range: 10-600. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        :param pulumi.Input[str] username: The username of the ecs command. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        :param pulumi.Input[str] working_dir: The working directory of the ecs invocation. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InvocationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage ecs invocation
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.ecs.Invocation("foo",
            command_id="cmd-ychkepkhtim0tr3b****",
            frequency="5m",
            instance_ids=["i-ychmz92487l8j00o****"],
            invocation_description="tf",
            invocation_name="tf-test",
            launch_time="2023-06-20T09:48:00Z",
            recurrence_end_time="2023-06-20T09:59:00Z",
            repeat_mode="Rate",
            timeout=90,
            username="root",
            working_dir="/home")
        ```

        ## Import

        EcsInvocation can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:ecs/invocation:Invocation default ivk-ychnxnm45dl8j0mm****
        ```

        :param str resource_name: The name of the resource.
        :param InvocationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InvocationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 command_id: Optional[pulumi.Input[str]] = None,
                 frequency: Optional[pulumi.Input[str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 invocation_description: Optional[pulumi.Input[str]] = None,
                 invocation_name: Optional[pulumi.Input[str]] = None,
                 launch_time: Optional[pulumi.Input[str]] = None,
                 recurrence_end_time: Optional[pulumi.Input[str]] = None,
                 repeat_mode: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InvocationArgs.__new__(InvocationArgs)

            if command_id is None and not opts.urn:
                raise TypeError("Missing required property 'command_id'")
            __props__.__dict__["command_id"] = command_id
            __props__.__dict__["frequency"] = frequency
            if instance_ids is None and not opts.urn:
                raise TypeError("Missing required property 'instance_ids'")
            __props__.__dict__["instance_ids"] = instance_ids
            __props__.__dict__["invocation_description"] = invocation_description
            if invocation_name is None and not opts.urn:
                raise TypeError("Missing required property 'invocation_name'")
            __props__.__dict__["invocation_name"] = invocation_name
            __props__.__dict__["launch_time"] = launch_time
            __props__.__dict__["recurrence_end_time"] = recurrence_end_time
            __props__.__dict__["repeat_mode"] = repeat_mode
            __props__.__dict__["timeout"] = timeout
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["working_dir"] = working_dir
            __props__.__dict__["end_time"] = None
            __props__.__dict__["invocation_status"] = None
            __props__.__dict__["start_time"] = None
        super(Invocation, __self__).__init__(
            'volcengine:ecs/invocation:Invocation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            command_id: Optional[pulumi.Input[str]] = None,
            end_time: Optional[pulumi.Input[str]] = None,
            frequency: Optional[pulumi.Input[str]] = None,
            instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            invocation_description: Optional[pulumi.Input[str]] = None,
            invocation_name: Optional[pulumi.Input[str]] = None,
            invocation_status: Optional[pulumi.Input[str]] = None,
            launch_time: Optional[pulumi.Input[str]] = None,
            recurrence_end_time: Optional[pulumi.Input[str]] = None,
            repeat_mode: Optional[pulumi.Input[str]] = None,
            start_time: Optional[pulumi.Input[str]] = None,
            timeout: Optional[pulumi.Input[int]] = None,
            username: Optional[pulumi.Input[str]] = None,
            working_dir: Optional[pulumi.Input[str]] = None) -> 'Invocation':
        """
        Get an existing Invocation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] command_id: The command id of the ecs invocation.
        :param pulumi.Input[str] end_time: The end time of the ecs invocation.
        :param pulumi.Input[str] frequency: The frequency of the ecs invocation. This field is valid and required when the value of the repeat_mode field is `Rate`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_ids: The list of ECS instance IDs.
        :param pulumi.Input[str] invocation_description: The description of the ecs invocation.
        :param pulumi.Input[str] invocation_name: The name of the ecs invocation.
        :param pulumi.Input[str] invocation_status: The status of the ecs invocation.
        :param pulumi.Input[str] launch_time: The launch time of the ecs invocation. RFC3339 format. This field is valid and required when the value of the repeat_mode field is `Rate` or `Fixed`.
        :param pulumi.Input[str] recurrence_end_time: The recurrence end time of the ecs invocation. RFC3339 format. This field is valid and required when the value of the repeat_mode field is `Rate`.
        :param pulumi.Input[str] repeat_mode: The repeat mode of the ecs invocation. Valid values: `Once`, `Rate`, `Fixed`.
        :param pulumi.Input[str] start_time: The start time of the ecs invocation.
        :param pulumi.Input[int] timeout: The timeout of the ecs command. Valid value range: 10-600. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        :param pulumi.Input[str] username: The username of the ecs command. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        :param pulumi.Input[str] working_dir: The working directory of the ecs invocation. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InvocationState.__new__(_InvocationState)

        __props__.__dict__["command_id"] = command_id
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["instance_ids"] = instance_ids
        __props__.__dict__["invocation_description"] = invocation_description
        __props__.__dict__["invocation_name"] = invocation_name
        __props__.__dict__["invocation_status"] = invocation_status
        __props__.__dict__["launch_time"] = launch_time
        __props__.__dict__["recurrence_end_time"] = recurrence_end_time
        __props__.__dict__["repeat_mode"] = repeat_mode
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["username"] = username
        __props__.__dict__["working_dir"] = working_dir
        return Invocation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="commandId")
    def command_id(self) -> pulumi.Output[str]:
        """
        The command id of the ecs invocation.
        """
        return pulumi.get(self, "command_id")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[str]:
        """
        The end time of the ecs invocation.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[Optional[str]]:
        """
        The frequency of the ecs invocation. This field is valid and required when the value of the repeat_mode field is `Rate`.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of ECS instance IDs.
        """
        return pulumi.get(self, "instance_ids")

    @property
    @pulumi.getter(name="invocationDescription")
    def invocation_description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the ecs invocation.
        """
        return pulumi.get(self, "invocation_description")

    @property
    @pulumi.getter(name="invocationName")
    def invocation_name(self) -> pulumi.Output[str]:
        """
        The name of the ecs invocation.
        """
        return pulumi.get(self, "invocation_name")

    @property
    @pulumi.getter(name="invocationStatus")
    def invocation_status(self) -> pulumi.Output[str]:
        """
        The status of the ecs invocation.
        """
        return pulumi.get(self, "invocation_status")

    @property
    @pulumi.getter(name="launchTime")
    def launch_time(self) -> pulumi.Output[Optional[str]]:
        """
        The launch time of the ecs invocation. RFC3339 format. This field is valid and required when the value of the repeat_mode field is `Rate` or `Fixed`.
        """
        return pulumi.get(self, "launch_time")

    @property
    @pulumi.getter(name="recurrenceEndTime")
    def recurrence_end_time(self) -> pulumi.Output[Optional[str]]:
        """
        The recurrence end time of the ecs invocation. RFC3339 format. This field is valid and required when the value of the repeat_mode field is `Rate`.
        """
        return pulumi.get(self, "recurrence_end_time")

    @property
    @pulumi.getter(name="repeatMode")
    def repeat_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The repeat mode of the ecs invocation. Valid values: `Once`, `Rate`, `Fixed`.
        """
        return pulumi.get(self, "repeat_mode")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[str]:
        """
        The start time of the ecs invocation.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[int]:
        """
        The timeout of the ecs command. Valid value range: 10-600. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        The username of the ecs command. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> pulumi.Output[str]:
        """
        The working directory of the ecs invocation. When this field is not specified, use the value of the field with the same name in ecs command as the default value.
        """
        return pulumi.get(self, "working_dir")

