# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'InvocationResultsResult',
    'AwaitableInvocationResultsResult',
    'invocation_results',
    'invocation_results_output',
]

@pulumi.output_type
class InvocationResultsResult:
    """
    A collection of values returned by InvocationResults.
    """
    def __init__(__self__, command_id=None, id=None, instance_id=None, invocation_id=None, invocation_result_statuses=None, invocation_results=None, output_file=None, total_count=None):
        if command_id and not isinstance(command_id, str):
            raise TypeError("Expected argument 'command_id' to be a str")
        pulumi.set(__self__, "command_id", command_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if invocation_id and not isinstance(invocation_id, str):
            raise TypeError("Expected argument 'invocation_id' to be a str")
        pulumi.set(__self__, "invocation_id", invocation_id)
        if invocation_result_statuses and not isinstance(invocation_result_statuses, list):
            raise TypeError("Expected argument 'invocation_result_statuses' to be a list")
        pulumi.set(__self__, "invocation_result_statuses", invocation_result_statuses)
        if invocation_results and not isinstance(invocation_results, list):
            raise TypeError("Expected argument 'invocation_results' to be a list")
        pulumi.set(__self__, "invocation_results", invocation_results)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="commandId")
    def command_id(self) -> Optional[str]:
        """
        The id of the ecs command.
        """
        return pulumi.get(self, "command_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The id of the ecs instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="invocationId")
    def invocation_id(self) -> str:
        """
        The id of the ecs invocation.
        """
        return pulumi.get(self, "invocation_id")

    @property
    @pulumi.getter(name="invocationResultStatuses")
    def invocation_result_statuses(self) -> Optional[Sequence[str]]:
        """
        The status of ecs invocation in a single instance.
        """
        return pulumi.get(self, "invocation_result_statuses")

    @property
    @pulumi.getter(name="invocationResults")
    def invocation_results(self) -> Sequence['outputs.InvocationResultsInvocationResultResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "invocation_results")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")


class AwaitableInvocationResultsResult(InvocationResultsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return InvocationResultsResult(
            command_id=self.command_id,
            id=self.id,
            instance_id=self.instance_id,
            invocation_id=self.invocation_id,
            invocation_result_statuses=self.invocation_result_statuses,
            invocation_results=self.invocation_results,
            output_file=self.output_file,
            total_count=self.total_count)


def invocation_results(command_id: Optional[str] = None,
                       instance_id: Optional[str] = None,
                       invocation_id: Optional[str] = None,
                       invocation_result_statuses: Optional[Sequence[str]] = None,
                       output_file: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableInvocationResultsResult:
    """
    Use this data source to query detailed information of ecs invocation results
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.ecs.invocation_results(invocation_id="ivk-ych9y4vujvl8j01c****",
        invocation_result_statuses=["Success"])
    ```


    :param str command_id: The id of ecs command.
    :param str instance_id: The id of ecs instance.
    :param str invocation_id: The id of ecs invocation.
    :param Sequence[str] invocation_result_statuses: The list of status of ecs invocation in a single instance. Valid values: `Pending`, `Running`, `Success`, `Failed`, `Timeout`.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['commandId'] = command_id
    __args__['instanceId'] = instance_id
    __args__['invocationId'] = invocation_id
    __args__['invocationResultStatuses'] = invocation_result_statuses
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:ecs/invocationResults:InvocationResults', __args__, opts=opts, typ=InvocationResultsResult).value

    return AwaitableInvocationResultsResult(
        command_id=pulumi.get(__ret__, 'command_id'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        invocation_id=pulumi.get(__ret__, 'invocation_id'),
        invocation_result_statuses=pulumi.get(__ret__, 'invocation_result_statuses'),
        invocation_results=pulumi.get(__ret__, 'invocation_results'),
        output_file=pulumi.get(__ret__, 'output_file'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(invocation_results)
def invocation_results_output(command_id: Optional[pulumi.Input[Optional[str]]] = None,
                              instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                              invocation_id: Optional[pulumi.Input[str]] = None,
                              invocation_result_statuses: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                              output_file: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[InvocationResultsResult]:
    """
    Use this data source to query detailed information of ecs invocation results
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.ecs.invocation_results(invocation_id="ivk-ych9y4vujvl8j01c****",
        invocation_result_statuses=["Success"])
    ```


    :param str command_id: The id of ecs command.
    :param str instance_id: The id of ecs instance.
    :param str invocation_id: The id of ecs invocation.
    :param Sequence[str] invocation_result_statuses: The list of status of ecs invocation in a single instance. Valid values: `Pending`, `Running`, `Success`, `Failed`, `Timeout`.
    :param str output_file: File name where to save data source results.
    """
    ...
