# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['KeyPairArgs', 'KeyPair']

@pulumi.input_type
class KeyPairArgs:
    def __init__(__self__, *,
                 key_pair_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 key_file: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a KeyPair resource.
        :param pulumi.Input[str] key_pair_name: The name of key pair.
        :param pulumi.Input[str] description: The description of key pair.
        :param pulumi.Input[str] key_file: Target file to save private key. It is recommended that the value not be empty. You only have one chance to download the private key, the volcengine will not save your private key, please keep it safe. In the TF import scenario, this field will not write the private key locally.
        :param pulumi.Input[str] public_key: Public key string.
        """
        pulumi.set(__self__, "key_pair_name", key_pair_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Input[str]:
        """
        The name of key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of key pair.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[pulumi.Input[str]]:
        """
        Target file to save private key. It is recommended that the value not be empty. You only have one chance to download the private key, the volcengine will not save your private key, please keep it safe. In the TF import scenario, this field will not write the private key locally.
        """
        return pulumi.get(self, "key_file")

    @key_file.setter
    def key_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_file", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Public key string.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)


@pulumi.input_type
class _KeyPairState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 finger_print: Optional[pulumi.Input[str]] = None,
                 key_file: Optional[pulumi.Input[str]] = None,
                 key_pair_id: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KeyPair resources.
        :param pulumi.Input[str] description: The description of key pair.
        :param pulumi.Input[str] finger_print: The finger print info.
        :param pulumi.Input[str] key_file: Target file to save private key. It is recommended that the value not be empty. You only have one chance to download the private key, the volcengine will not save your private key, please keep it safe. In the TF import scenario, this field will not write the private key locally.
        :param pulumi.Input[str] key_pair_id: The id of key pair.
        :param pulumi.Input[str] key_pair_name: The name of key pair.
        :param pulumi.Input[str] public_key: Public key string.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if finger_print is not None:
            pulumi.set(__self__, "finger_print", finger_print)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if key_pair_id is not None:
            pulumi.set(__self__, "key_pair_id", key_pair_id)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of key pair.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fingerPrint")
    def finger_print(self) -> Optional[pulumi.Input[str]]:
        """
        The finger print info.
        """
        return pulumi.get(self, "finger_print")

    @finger_print.setter
    def finger_print(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "finger_print", value)

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[pulumi.Input[str]]:
        """
        Target file to save private key. It is recommended that the value not be empty. You only have one chance to download the private key, the volcengine will not save your private key, please keep it safe. In the TF import scenario, this field will not write the private key locally.
        """
        return pulumi.get(self, "key_file")

    @key_file.setter
    def key_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_file", value)

    @property
    @pulumi.getter(name="keyPairId")
    def key_pair_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of key pair.
        """
        return pulumi.get(self, "key_pair_id")

    @key_pair_id.setter
    def key_pair_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_id", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Public key string.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)


class KeyPair(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key_file: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage ecs key pair
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.ecs.KeyPair("foo",
            description="acc-test",
            key_pair_name="acc-test-key-name")
        ```

        ## Import

        ECS key pair can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:ecs/keyPair:KeyPair default kp-mizl7m1kqccg5smt1bdpijuj
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of key pair.
        :param pulumi.Input[str] key_file: Target file to save private key. It is recommended that the value not be empty. You only have one chance to download the private key, the volcengine will not save your private key, please keep it safe. In the TF import scenario, this field will not write the private key locally.
        :param pulumi.Input[str] key_pair_name: The name of key pair.
        :param pulumi.Input[str] public_key: Public key string.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyPairArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage ecs key pair
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.ecs.KeyPair("foo",
            description="acc-test",
            key_pair_name="acc-test-key-name")
        ```

        ## Import

        ECS key pair can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:ecs/keyPair:KeyPair default kp-mizl7m1kqccg5smt1bdpijuj
        ```

        :param str resource_name: The name of the resource.
        :param KeyPairArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyPairArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key_file: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyPairArgs.__new__(KeyPairArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["key_file"] = key_file
            if key_pair_name is None and not opts.urn:
                raise TypeError("Missing required property 'key_pair_name'")
            __props__.__dict__["key_pair_name"] = key_pair_name
            __props__.__dict__["public_key"] = public_key
            __props__.__dict__["finger_print"] = None
            __props__.__dict__["key_pair_id"] = None
        super(KeyPair, __self__).__init__(
            'volcengine:ecs/keyPair:KeyPair',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            finger_print: Optional[pulumi.Input[str]] = None,
            key_file: Optional[pulumi.Input[str]] = None,
            key_pair_id: Optional[pulumi.Input[str]] = None,
            key_pair_name: Optional[pulumi.Input[str]] = None,
            public_key: Optional[pulumi.Input[str]] = None) -> 'KeyPair':
        """
        Get an existing KeyPair resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of key pair.
        :param pulumi.Input[str] finger_print: The finger print info.
        :param pulumi.Input[str] key_file: Target file to save private key. It is recommended that the value not be empty. You only have one chance to download the private key, the volcengine will not save your private key, please keep it safe. In the TF import scenario, this field will not write the private key locally.
        :param pulumi.Input[str] key_pair_id: The id of key pair.
        :param pulumi.Input[str] key_pair_name: The name of key pair.
        :param pulumi.Input[str] public_key: Public key string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyPairState.__new__(_KeyPairState)

        __props__.__dict__["description"] = description
        __props__.__dict__["finger_print"] = finger_print
        __props__.__dict__["key_file"] = key_file
        __props__.__dict__["key_pair_id"] = key_pair_id
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["public_key"] = public_key
        return KeyPair(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of key pair.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fingerPrint")
    def finger_print(self) -> pulumi.Output[str]:
        """
        The finger print info.
        """
        return pulumi.get(self, "finger_print")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> pulumi.Output[Optional[str]]:
        """
        Target file to save private key. It is recommended that the value not be empty. You only have one chance to download the private key, the volcengine will not save your private key, please keep it safe. In the TF import scenario, this field will not write the private key locally.
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter(name="keyPairId")
    def key_pair_id(self) -> pulumi.Output[str]:
        """
        The id of key pair.
        """
        return pulumi.get(self, "key_pair_id")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[str]:
        """
        The name of key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[Optional[str]]:
        """
        Public key string.
        """
        return pulumi.get(self, "public_key")

