# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'KeyPairsResult',
    'AwaitableKeyPairsResult',
    'key_pairs',
    'key_pairs_output',
]

@pulumi.output_type
class KeyPairsResult:
    """
    A collection of values returned by KeyPairs.
    """
    def __init__(__self__, finger_print=None, id=None, key_pair_ids=None, key_pair_name=None, key_pair_names=None, key_pairs=None, name_regex=None, output_file=None, total_count=None):
        if finger_print and not isinstance(finger_print, str):
            raise TypeError("Expected argument 'finger_print' to be a str")
        pulumi.set(__self__, "finger_print", finger_print)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_pair_ids and not isinstance(key_pair_ids, list):
            raise TypeError("Expected argument 'key_pair_ids' to be a list")
        pulumi.set(__self__, "key_pair_ids", key_pair_ids)
        if key_pair_name and not isinstance(key_pair_name, str):
            raise TypeError("Expected argument 'key_pair_name' to be a str")
        pulumi.set(__self__, "key_pair_name", key_pair_name)
        if key_pair_names and not isinstance(key_pair_names, list):
            raise TypeError("Expected argument 'key_pair_names' to be a list")
        pulumi.set(__self__, "key_pair_names", key_pair_names)
        if key_pairs and not isinstance(key_pairs, list):
            raise TypeError("Expected argument 'key_pairs' to be a list")
        pulumi.set(__self__, "key_pairs", key_pairs)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="fingerPrint")
    def finger_print(self) -> Optional[str]:
        """
        The finger print info.
        """
        return pulumi.get(self, "finger_print")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyPairIds")
    def key_pair_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "key_pair_ids")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[str]:
        """
        The name of key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter(name="keyPairNames")
    def key_pair_names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "key_pair_names")

    @property
    @pulumi.getter(name="keyPairs")
    def key_pairs(self) -> Sequence['outputs.KeyPairsKeyPairResult']:
        """
        The target query key pairs info.
        """
        return pulumi.get(self, "key_pairs")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of ECS key pair query.
        """
        return pulumi.get(self, "total_count")


class AwaitableKeyPairsResult(KeyPairsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return KeyPairsResult(
            finger_print=self.finger_print,
            id=self.id,
            key_pair_ids=self.key_pair_ids,
            key_pair_name=self.key_pair_name,
            key_pair_names=self.key_pair_names,
            key_pairs=self.key_pairs,
            name_regex=self.name_regex,
            output_file=self.output_file,
            total_count=self.total_count)


def key_pairs(finger_print: Optional[str] = None,
              key_pair_ids: Optional[Sequence[str]] = None,
              key_pair_name: Optional[str] = None,
              key_pair_names: Optional[Sequence[str]] = None,
              name_regex: Optional[str] = None,
              output_file: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableKeyPairsResult:
    """
    Use this data source to query detailed information of ecs key pairs
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_key_pair = volcengine.ecs.KeyPair("fooKeyPair",
        key_pair_name="acc-test-key-name",
        description="acc-test")
    foo_key_pairs = volcengine.ecs.key_pairs_output(key_pair_name=foo_key_pair.key_pair_name)
    ```


    :param str finger_print: The finger print info.
    :param Sequence[str] key_pair_ids: Ids of key pair.
    :param str key_pair_name: Name of key pair.
    :param Sequence[str] key_pair_names: Key pair names info.
    :param str name_regex: A Name Regex of ECS key pairs.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['fingerPrint'] = finger_print
    __args__['keyPairIds'] = key_pair_ids
    __args__['keyPairName'] = key_pair_name
    __args__['keyPairNames'] = key_pair_names
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:ecs/keyPairs:KeyPairs', __args__, opts=opts, typ=KeyPairsResult).value

    return AwaitableKeyPairsResult(
        finger_print=pulumi.get(__ret__, 'finger_print'),
        id=pulumi.get(__ret__, 'id'),
        key_pair_ids=pulumi.get(__ret__, 'key_pair_ids'),
        key_pair_name=pulumi.get(__ret__, 'key_pair_name'),
        key_pair_names=pulumi.get(__ret__, 'key_pair_names'),
        key_pairs=pulumi.get(__ret__, 'key_pairs'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(key_pairs)
def key_pairs_output(finger_print: Optional[pulumi.Input[Optional[str]]] = None,
                     key_pair_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     key_pair_name: Optional[pulumi.Input[Optional[str]]] = None,
                     key_pair_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[KeyPairsResult]:
    """
    Use this data source to query detailed information of ecs key pairs
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_key_pair = volcengine.ecs.KeyPair("fooKeyPair",
        key_pair_name="acc-test-key-name",
        description="acc-test")
    foo_key_pairs = volcengine.ecs.key_pairs_output(key_pair_name=foo_key_pair.key_pair_name)
    ```


    :param str finger_print: The finger print info.
    :param Sequence[str] key_pair_ids: Ids of key pair.
    :param str key_pair_name: Name of key pair.
    :param Sequence[str] key_pair_names: Key pair names info.
    :param str name_regex: A Name Regex of ECS key pairs.
    :param str output_file: File name where to save data source results.
    """
    ...
