# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LaunchTemplateArgs', 'LaunchTemplate']

@pulumi.input_type
class LaunchTemplateArgs:
    def __init__(__self__, *,
                 launch_template_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[int]] = None,
                 eip_billing_type: Optional[pulumi.Input[str]] = None,
                 eip_isp: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type_id: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateNetworkInterfaceArgs']]]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 suffix_index: Optional[pulumi.Input[int]] = None,
                 unique_suffix: Optional[pulumi.Input[bool]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 version_description: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateVolumeArgs']]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LaunchTemplate resource.
        :param pulumi.Input[str] launch_template_name: The name of the launch template.
        :param pulumi.Input[str] description: The description of the instance.
        :param pulumi.Input[int] eip_bandwidth: The EIP bandwidth which the scaling configuration set.
        :param pulumi.Input[str] eip_billing_type: The EIP billing type which the scaling configuration set. Valid values: PostPaidByBandwidth, PostPaidByTraffic.
        :param pulumi.Input[str] eip_isp: The EIP ISP which the scaling configuration set. Valid values: BGP, ChinaMobile, ChinaUnicom, ChinaTelecom.
        :param pulumi.Input[str] host_name: The host name of the instance.
        :param pulumi.Input[str] hpc_cluster_id: The hpc cluster id.
        :param pulumi.Input[str] image_id: The image ID.
        :param pulumi.Input[str] instance_charge_type: The charge type of the instance and volume.
        :param pulumi.Input[str] instance_name: The name of the instance.
        :param pulumi.Input[str] instance_type_id: The compute type of the instance.
        :param pulumi.Input[str] key_pair_name: When you log in to the instance using the SSH key pair, enter the name of the key pair.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchTemplateNetworkInterfaceArgs']]] network_interfaces: The list of network interfaces. When creating an instance, it is supported to bind auxiliary network cards at the same time. The first one is the primary network card, and the others are secondary network cards.
        :param pulumi.Input[str] security_enhancement_strategy: Whether to open the security reinforcement.
        :param pulumi.Input[int] suffix_index: The index of the ordered suffix.
        :param pulumi.Input[bool] unique_suffix: Indicates whether the ordered suffix is automatically added to Hostname and InstanceName when multiple instances are created.
        :param pulumi.Input[str] user_data: Instance custom data. The set custom data must be Base64 encoded, and the size of the custom data before Base64 encoding cannot exceed 16KB.
        :param pulumi.Input[str] version_description: The latest version description of the launch template.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchTemplateVolumeArgs']]] volumes: The list of volume of the scaling configuration.
        :param pulumi.Input[str] vpc_id: The vpc id.
        :param pulumi.Input[str] zone_id: The zone id.
        """
        pulumi.set(__self__, "launch_template_name", launch_template_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_bandwidth is not None:
            pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        if eip_billing_type is not None:
            pulumi.set(__self__, "eip_billing_type", eip_billing_type)
        if eip_isp is not None:
            pulumi.set(__self__, "eip_isp", eip_isp)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if hpc_cluster_id is not None:
            pulumi.set(__self__, "hpc_cluster_id", hpc_cluster_id)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type_id is not None:
            pulumi.set(__self__, "instance_type_id", instance_type_id)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if suffix_index is not None:
            pulumi.set(__self__, "suffix_index", suffix_index)
        if unique_suffix is not None:
            pulumi.set(__self__, "unique_suffix", unique_suffix)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if version_description is not None:
            pulumi.set(__self__, "version_description", version_description)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> pulumi.Input[str]:
        """
        The name of the launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "launch_template_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The EIP bandwidth which the scaling configuration set.
        """
        return pulumi.get(self, "eip_bandwidth")

    @eip_bandwidth.setter
    def eip_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eip_bandwidth", value)

    @property
    @pulumi.getter(name="eipBillingType")
    def eip_billing_type(self) -> Optional[pulumi.Input[str]]:
        """
        The EIP billing type which the scaling configuration set. Valid values: PostPaidByBandwidth, PostPaidByTraffic.
        """
        return pulumi.get(self, "eip_billing_type")

    @eip_billing_type.setter
    def eip_billing_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_billing_type", value)

    @property
    @pulumi.getter(name="eipIsp")
    def eip_isp(self) -> Optional[pulumi.Input[str]]:
        """
        The EIP ISP which the scaling configuration set. Valid values: BGP, ChinaMobile, ChinaUnicom, ChinaTelecom.
        """
        return pulumi.get(self, "eip_isp")

    @eip_isp.setter
    def eip_isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_isp", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The host name of the instance.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The hpc cluster id.
        """
        return pulumi.get(self, "hpc_cluster_id")

    @hpc_cluster_id.setter
    def hpc_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hpc_cluster_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The image ID.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The charge type of the instance and volume.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceTypeId")
    def instance_type_id(self) -> Optional[pulumi.Input[str]]:
        """
        The compute type of the instance.
        """
        return pulumi.get(self, "instance_type_id")

    @instance_type_id.setter
    def instance_type_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type_id", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        When you log in to the instance using the SSH key pair, enter the name of the key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateNetworkInterfaceArgs']]]]:
        """
        The list of network interfaces. When creating an instance, it is supported to bind auxiliary network cards at the same time. The first one is the primary network card, and the others are secondary network cards.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to open the security reinforcement.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @property
    @pulumi.getter(name="suffixIndex")
    def suffix_index(self) -> Optional[pulumi.Input[int]]:
        """
        The index of the ordered suffix.
        """
        return pulumi.get(self, "suffix_index")

    @suffix_index.setter
    def suffix_index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "suffix_index", value)

    @property
    @pulumi.getter(name="uniqueSuffix")
    def unique_suffix(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the ordered suffix is automatically added to Hostname and InstanceName when multiple instances are created.
        """
        return pulumi.get(self, "unique_suffix")

    @unique_suffix.setter
    def unique_suffix(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unique_suffix", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Instance custom data. The set custom data must be Base64 encoded, and the size of the custom data before Base64 encoding cannot exceed 16KB.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> Optional[pulumi.Input[str]]:
        """
        The latest version description of the launch template.
        """
        return pulumi.get(self, "version_description")

    @version_description.setter
    def version_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_description", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateVolumeArgs']]]]:
        """
        The list of volume of the scaling configuration.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vpc id.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone id.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _LaunchTemplateState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[int]] = None,
                 eip_billing_type: Optional[pulumi.Input[str]] = None,
                 eip_isp: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type_id: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 launch_template_id: Optional[pulumi.Input[str]] = None,
                 launch_template_name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateNetworkInterfaceArgs']]]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 suffix_index: Optional[pulumi.Input[int]] = None,
                 unique_suffix: Optional[pulumi.Input[bool]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 version_description: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateVolumeArgs']]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LaunchTemplate resources.
        :param pulumi.Input[str] description: The description of the instance.
        :param pulumi.Input[int] eip_bandwidth: The EIP bandwidth which the scaling configuration set.
        :param pulumi.Input[str] eip_billing_type: The EIP billing type which the scaling configuration set. Valid values: PostPaidByBandwidth, PostPaidByTraffic.
        :param pulumi.Input[str] eip_isp: The EIP ISP which the scaling configuration set. Valid values: BGP, ChinaMobile, ChinaUnicom, ChinaTelecom.
        :param pulumi.Input[str] host_name: The host name of the instance.
        :param pulumi.Input[str] hpc_cluster_id: The hpc cluster id.
        :param pulumi.Input[str] image_id: The image ID.
        :param pulumi.Input[str] instance_charge_type: The charge type of the instance and volume.
        :param pulumi.Input[str] instance_name: The name of the instance.
        :param pulumi.Input[str] instance_type_id: The compute type of the instance.
        :param pulumi.Input[str] key_pair_name: When you log in to the instance using the SSH key pair, enter the name of the key pair.
        :param pulumi.Input[str] launch_template_id: The launch template id.
        :param pulumi.Input[str] launch_template_name: The name of the launch template.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchTemplateNetworkInterfaceArgs']]] network_interfaces: The list of network interfaces. When creating an instance, it is supported to bind auxiliary network cards at the same time. The first one is the primary network card, and the others are secondary network cards.
        :param pulumi.Input[str] security_enhancement_strategy: Whether to open the security reinforcement.
        :param pulumi.Input[int] suffix_index: The index of the ordered suffix.
        :param pulumi.Input[bool] unique_suffix: Indicates whether the ordered suffix is automatically added to Hostname and InstanceName when multiple instances are created.
        :param pulumi.Input[str] user_data: Instance custom data. The set custom data must be Base64 encoded, and the size of the custom data before Base64 encoding cannot exceed 16KB.
        :param pulumi.Input[str] version_description: The latest version description of the launch template.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchTemplateVolumeArgs']]] volumes: The list of volume of the scaling configuration.
        :param pulumi.Input[str] vpc_id: The vpc id.
        :param pulumi.Input[str] zone_id: The zone id.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_bandwidth is not None:
            pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        if eip_billing_type is not None:
            pulumi.set(__self__, "eip_billing_type", eip_billing_type)
        if eip_isp is not None:
            pulumi.set(__self__, "eip_isp", eip_isp)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if hpc_cluster_id is not None:
            pulumi.set(__self__, "hpc_cluster_id", hpc_cluster_id)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type_id is not None:
            pulumi.set(__self__, "instance_type_id", instance_type_id)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if suffix_index is not None:
            pulumi.set(__self__, "suffix_index", suffix_index)
        if unique_suffix is not None:
            pulumi.set(__self__, "unique_suffix", unique_suffix)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if version_description is not None:
            pulumi.set(__self__, "version_description", version_description)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The EIP bandwidth which the scaling configuration set.
        """
        return pulumi.get(self, "eip_bandwidth")

    @eip_bandwidth.setter
    def eip_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eip_bandwidth", value)

    @property
    @pulumi.getter(name="eipBillingType")
    def eip_billing_type(self) -> Optional[pulumi.Input[str]]:
        """
        The EIP billing type which the scaling configuration set. Valid values: PostPaidByBandwidth, PostPaidByTraffic.
        """
        return pulumi.get(self, "eip_billing_type")

    @eip_billing_type.setter
    def eip_billing_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_billing_type", value)

    @property
    @pulumi.getter(name="eipIsp")
    def eip_isp(self) -> Optional[pulumi.Input[str]]:
        """
        The EIP ISP which the scaling configuration set. Valid values: BGP, ChinaMobile, ChinaUnicom, ChinaTelecom.
        """
        return pulumi.get(self, "eip_isp")

    @eip_isp.setter
    def eip_isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_isp", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The host name of the instance.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The hpc cluster id.
        """
        return pulumi.get(self, "hpc_cluster_id")

    @hpc_cluster_id.setter
    def hpc_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hpc_cluster_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The image ID.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The charge type of the instance and volume.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceTypeId")
    def instance_type_id(self) -> Optional[pulumi.Input[str]]:
        """
        The compute type of the instance.
        """
        return pulumi.get(self, "instance_type_id")

    @instance_type_id.setter
    def instance_type_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type_id", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        When you log in to the instance using the SSH key pair, enter the name of the key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The launch template id.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_name", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateNetworkInterfaceArgs']]]]:
        """
        The list of network interfaces. When creating an instance, it is supported to bind auxiliary network cards at the same time. The first one is the primary network card, and the others are secondary network cards.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to open the security reinforcement.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @property
    @pulumi.getter(name="suffixIndex")
    def suffix_index(self) -> Optional[pulumi.Input[int]]:
        """
        The index of the ordered suffix.
        """
        return pulumi.get(self, "suffix_index")

    @suffix_index.setter
    def suffix_index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "suffix_index", value)

    @property
    @pulumi.getter(name="uniqueSuffix")
    def unique_suffix(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the ordered suffix is automatically added to Hostname and InstanceName when multiple instances are created.
        """
        return pulumi.get(self, "unique_suffix")

    @unique_suffix.setter
    def unique_suffix(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unique_suffix", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Instance custom data. The set custom data must be Base64 encoded, and the size of the custom data before Base64 encoding cannot exceed 16KB.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> Optional[pulumi.Input[str]]:
        """
        The latest version description of the launch template.
        """
        return pulumi.get(self, "version_description")

    @version_description.setter
    def version_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_description", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateVolumeArgs']]]]:
        """
        The list of volume of the scaling configuration.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vpc id.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone id.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class LaunchTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[int]] = None,
                 eip_billing_type: Optional[pulumi.Input[str]] = None,
                 eip_isp: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type_id: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 launch_template_name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LaunchTemplateNetworkInterfaceArgs']]]]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 suffix_index: Optional[pulumi.Input[int]] = None,
                 unique_suffix: Optional[pulumi.Input[bool]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 version_description: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LaunchTemplateVolumeArgs']]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.ecs.LaunchTemplate("foo",
            description="acc-test-desc",
            eip_bandwidth=1,
            eip_billing_type="PostPaidByBandwidth",
            eip_isp="ChinaMobile",
            host_name="tf-host-name",
            hpc_cluster_id="hpcCluster-l8u24ovdmoab6opf",
            image_id="image-ycjwwciuzy5pkh54xx8f",
            instance_charge_type="PostPaid",
            instance_name="tf-acc-name",
            instance_type_id="ecs.g1.large",
            key_pair_name="tf-key-pair",
            launch_template_name="tf-acc-template")
        ```

        ## Import

        LaunchTemplate can be imported using the LaunchTemplateId, e.g. When the instance launch template is modified, a new version will be created. When the number of versions reaches the upper limit (30), the oldest version that is not the default version will be deleted.

        ```sh
         $ pulumi import volcengine:ecs/launchTemplate:LaunchTemplate default lt-ysxc16auaugh9zfy****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the instance.
        :param pulumi.Input[int] eip_bandwidth: The EIP bandwidth which the scaling configuration set.
        :param pulumi.Input[str] eip_billing_type: The EIP billing type which the scaling configuration set. Valid values: PostPaidByBandwidth, PostPaidByTraffic.
        :param pulumi.Input[str] eip_isp: The EIP ISP which the scaling configuration set. Valid values: BGP, ChinaMobile, ChinaUnicom, ChinaTelecom.
        :param pulumi.Input[str] host_name: The host name of the instance.
        :param pulumi.Input[str] hpc_cluster_id: The hpc cluster id.
        :param pulumi.Input[str] image_id: The image ID.
        :param pulumi.Input[str] instance_charge_type: The charge type of the instance and volume.
        :param pulumi.Input[str] instance_name: The name of the instance.
        :param pulumi.Input[str] instance_type_id: The compute type of the instance.
        :param pulumi.Input[str] key_pair_name: When you log in to the instance using the SSH key pair, enter the name of the key pair.
        :param pulumi.Input[str] launch_template_name: The name of the launch template.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LaunchTemplateNetworkInterfaceArgs']]]] network_interfaces: The list of network interfaces. When creating an instance, it is supported to bind auxiliary network cards at the same time. The first one is the primary network card, and the others are secondary network cards.
        :param pulumi.Input[str] security_enhancement_strategy: Whether to open the security reinforcement.
        :param pulumi.Input[int] suffix_index: The index of the ordered suffix.
        :param pulumi.Input[bool] unique_suffix: Indicates whether the ordered suffix is automatically added to Hostname and InstanceName when multiple instances are created.
        :param pulumi.Input[str] user_data: Instance custom data. The set custom data must be Base64 encoded, and the size of the custom data before Base64 encoding cannot exceed 16KB.
        :param pulumi.Input[str] version_description: The latest version description of the launch template.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LaunchTemplateVolumeArgs']]]] volumes: The list of volume of the scaling configuration.
        :param pulumi.Input[str] vpc_id: The vpc id.
        :param pulumi.Input[str] zone_id: The zone id.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LaunchTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.ecs.LaunchTemplate("foo",
            description="acc-test-desc",
            eip_bandwidth=1,
            eip_billing_type="PostPaidByBandwidth",
            eip_isp="ChinaMobile",
            host_name="tf-host-name",
            hpc_cluster_id="hpcCluster-l8u24ovdmoab6opf",
            image_id="image-ycjwwciuzy5pkh54xx8f",
            instance_charge_type="PostPaid",
            instance_name="tf-acc-name",
            instance_type_id="ecs.g1.large",
            key_pair_name="tf-key-pair",
            launch_template_name="tf-acc-template")
        ```

        ## Import

        LaunchTemplate can be imported using the LaunchTemplateId, e.g. When the instance launch template is modified, a new version will be created. When the number of versions reaches the upper limit (30), the oldest version that is not the default version will be deleted.

        ```sh
         $ pulumi import volcengine:ecs/launchTemplate:LaunchTemplate default lt-ysxc16auaugh9zfy****
        ```

        :param str resource_name: The name of the resource.
        :param LaunchTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LaunchTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_bandwidth: Optional[pulumi.Input[int]] = None,
                 eip_billing_type: Optional[pulumi.Input[str]] = None,
                 eip_isp: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type_id: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 launch_template_name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LaunchTemplateNetworkInterfaceArgs']]]]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 suffix_index: Optional[pulumi.Input[int]] = None,
                 unique_suffix: Optional[pulumi.Input[bool]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 version_description: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LaunchTemplateVolumeArgs']]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LaunchTemplateArgs.__new__(LaunchTemplateArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["eip_bandwidth"] = eip_bandwidth
            __props__.__dict__["eip_billing_type"] = eip_billing_type
            __props__.__dict__["eip_isp"] = eip_isp
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["hpc_cluster_id"] = hpc_cluster_id
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["instance_type_id"] = instance_type_id
            __props__.__dict__["key_pair_name"] = key_pair_name
            if launch_template_name is None and not opts.urn:
                raise TypeError("Missing required property 'launch_template_name'")
            __props__.__dict__["launch_template_name"] = launch_template_name
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
            __props__.__dict__["suffix_index"] = suffix_index
            __props__.__dict__["unique_suffix"] = unique_suffix
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["version_description"] = version_description
            __props__.__dict__["volumes"] = volumes
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["launch_template_id"] = None
        super(LaunchTemplate, __self__).__init__(
            'volcengine:ecs/launchTemplate:LaunchTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            eip_bandwidth: Optional[pulumi.Input[int]] = None,
            eip_billing_type: Optional[pulumi.Input[str]] = None,
            eip_isp: Optional[pulumi.Input[str]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            hpc_cluster_id: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            instance_charge_type: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            instance_type_id: Optional[pulumi.Input[str]] = None,
            key_pair_name: Optional[pulumi.Input[str]] = None,
            launch_template_id: Optional[pulumi.Input[str]] = None,
            launch_template_name: Optional[pulumi.Input[str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LaunchTemplateNetworkInterfaceArgs']]]]] = None,
            security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
            suffix_index: Optional[pulumi.Input[int]] = None,
            unique_suffix: Optional[pulumi.Input[bool]] = None,
            user_data: Optional[pulumi.Input[str]] = None,
            version_description: Optional[pulumi.Input[str]] = None,
            volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LaunchTemplateVolumeArgs']]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'LaunchTemplate':
        """
        Get an existing LaunchTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the instance.
        :param pulumi.Input[int] eip_bandwidth: The EIP bandwidth which the scaling configuration set.
        :param pulumi.Input[str] eip_billing_type: The EIP billing type which the scaling configuration set. Valid values: PostPaidByBandwidth, PostPaidByTraffic.
        :param pulumi.Input[str] eip_isp: The EIP ISP which the scaling configuration set. Valid values: BGP, ChinaMobile, ChinaUnicom, ChinaTelecom.
        :param pulumi.Input[str] host_name: The host name of the instance.
        :param pulumi.Input[str] hpc_cluster_id: The hpc cluster id.
        :param pulumi.Input[str] image_id: The image ID.
        :param pulumi.Input[str] instance_charge_type: The charge type of the instance and volume.
        :param pulumi.Input[str] instance_name: The name of the instance.
        :param pulumi.Input[str] instance_type_id: The compute type of the instance.
        :param pulumi.Input[str] key_pair_name: When you log in to the instance using the SSH key pair, enter the name of the key pair.
        :param pulumi.Input[str] launch_template_id: The launch template id.
        :param pulumi.Input[str] launch_template_name: The name of the launch template.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LaunchTemplateNetworkInterfaceArgs']]]] network_interfaces: The list of network interfaces. When creating an instance, it is supported to bind auxiliary network cards at the same time. The first one is the primary network card, and the others are secondary network cards.
        :param pulumi.Input[str] security_enhancement_strategy: Whether to open the security reinforcement.
        :param pulumi.Input[int] suffix_index: The index of the ordered suffix.
        :param pulumi.Input[bool] unique_suffix: Indicates whether the ordered suffix is automatically added to Hostname and InstanceName when multiple instances are created.
        :param pulumi.Input[str] user_data: Instance custom data. The set custom data must be Base64 encoded, and the size of the custom data before Base64 encoding cannot exceed 16KB.
        :param pulumi.Input[str] version_description: The latest version description of the launch template.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LaunchTemplateVolumeArgs']]]] volumes: The list of volume of the scaling configuration.
        :param pulumi.Input[str] vpc_id: The vpc id.
        :param pulumi.Input[str] zone_id: The zone id.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LaunchTemplateState.__new__(_LaunchTemplateState)

        __props__.__dict__["description"] = description
        __props__.__dict__["eip_bandwidth"] = eip_bandwidth
        __props__.__dict__["eip_billing_type"] = eip_billing_type
        __props__.__dict__["eip_isp"] = eip_isp
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["hpc_cluster_id"] = hpc_cluster_id
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type_id"] = instance_type_id
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["launch_template_id"] = launch_template_id
        __props__.__dict__["launch_template_name"] = launch_template_name
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
        __props__.__dict__["suffix_index"] = suffix_index
        __props__.__dict__["unique_suffix"] = unique_suffix
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["version_description"] = version_description
        __props__.__dict__["volumes"] = volumes
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["zone_id"] = zone_id
        return LaunchTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> pulumi.Output[Optional[int]]:
        """
        The EIP bandwidth which the scaling configuration set.
        """
        return pulumi.get(self, "eip_bandwidth")

    @property
    @pulumi.getter(name="eipBillingType")
    def eip_billing_type(self) -> pulumi.Output[Optional[str]]:
        """
        The EIP billing type which the scaling configuration set. Valid values: PostPaidByBandwidth, PostPaidByTraffic.
        """
        return pulumi.get(self, "eip_billing_type")

    @property
    @pulumi.getter(name="eipIsp")
    def eip_isp(self) -> pulumi.Output[Optional[str]]:
        """
        The EIP ISP which the scaling configuration set. Valid values: BGP, ChinaMobile, ChinaUnicom, ChinaTelecom.
        """
        return pulumi.get(self, "eip_isp")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[str]]:
        """
        The host name of the instance.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> pulumi.Output[Optional[str]]:
        """
        The hpc cluster id.
        """
        return pulumi.get(self, "hpc_cluster_id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[str]]:
        """
        The image ID.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[Optional[str]]:
        """
        The charge type of the instance and volume.
        """
        return pulumi.get(self, "instance_charge_type")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceTypeId")
    def instance_type_id(self) -> pulumi.Output[Optional[str]]:
        """
        The compute type of the instance.
        """
        return pulumi.get(self, "instance_type_id")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[Optional[str]]:
        """
        When you log in to the instance using the SSH key pair, enter the name of the key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> pulumi.Output[str]:
        """
        The launch template id.
        """
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> pulumi.Output[str]:
        """
        The name of the launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.LaunchTemplateNetworkInterface']]]:
        """
        The list of network interfaces. When creating an instance, it is supported to bind auxiliary network cards at the same time. The first one is the primary network card, and the others are secondary network cards.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        Whether to open the security reinforcement.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @property
    @pulumi.getter(name="suffixIndex")
    def suffix_index(self) -> pulumi.Output[Optional[int]]:
        """
        The index of the ordered suffix.
        """
        return pulumi.get(self, "suffix_index")

    @property
    @pulumi.getter(name="uniqueSuffix")
    def unique_suffix(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the ordered suffix is automatically added to Hostname and InstanceName when multiple instances are created.
        """
        return pulumi.get(self, "unique_suffix")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        Instance custom data. The set custom data must be Base64 encoded, and the size of the custom data before Base64 encoding cannot exceed 16KB.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> pulumi.Output[Optional[str]]:
        """
        The latest version description of the launch template.
        """
        return pulumi.get(self, "version_description")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Optional[Sequence['outputs.LaunchTemplateVolume']]]:
        """
        The list of volume of the scaling configuration.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[str]]:
        """
        The vpc id.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[Optional[str]]:
        """
        The zone id.
        """
        return pulumi.get(self, "zone_id")

