# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'AddressesResult',
    'AwaitableAddressesResult',
    'addresses',
    'addresses_output',
]

@pulumi.output_type
class AddressesResult:
    """
    A collection of values returned by Addresses.
    """
    def __init__(__self__, addresses=None, associated_instance_id=None, associated_instance_type=None, eip_addresses=None, id=None, ids=None, isp=None, name=None, output_file=None, project_name=None, status=None, tags=None, total_count=None):
        if addresses and not isinstance(addresses, list):
            raise TypeError("Expected argument 'addresses' to be a list")
        pulumi.set(__self__, "addresses", addresses)
        if associated_instance_id and not isinstance(associated_instance_id, str):
            raise TypeError("Expected argument 'associated_instance_id' to be a str")
        pulumi.set(__self__, "associated_instance_id", associated_instance_id)
        if associated_instance_type and not isinstance(associated_instance_type, str):
            raise TypeError("Expected argument 'associated_instance_type' to be a str")
        pulumi.set(__self__, "associated_instance_type", associated_instance_type)
        if eip_addresses and not isinstance(eip_addresses, list):
            raise TypeError("Expected argument 'eip_addresses' to be a list")
        pulumi.set(__self__, "eip_addresses", eip_addresses)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if isp and not isinstance(isp, str):
            raise TypeError("Expected argument 'isp' to be a str")
        pulumi.set(__self__, "isp", isp)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence['outputs.AddressesAddressResult']:
        """
        The collection of EIP addresses.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="associatedInstanceId")
    def associated_instance_id(self) -> Optional[str]:
        return pulumi.get(self, "associated_instance_id")

    @property
    @pulumi.getter(name="associatedInstanceType")
    def associated_instance_type(self) -> Optional[str]:
        return pulumi.get(self, "associated_instance_type")

    @property
    @pulumi.getter(name="eipAddresses")
    def eip_addresses(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "eip_addresses")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def isp(self) -> Optional[str]:
        """
        The ISP of EIP Address.
        """
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the EIP.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        """
        The ProjectName of the EIP.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the EIP.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.AddressesTagResult']]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of EIP addresses query.
        """
        return pulumi.get(self, "total_count")


class AwaitableAddressesResult(AddressesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return AddressesResult(
            addresses=self.addresses,
            associated_instance_id=self.associated_instance_id,
            associated_instance_type=self.associated_instance_type,
            eip_addresses=self.eip_addresses,
            id=self.id,
            ids=self.ids,
            isp=self.isp,
            name=self.name,
            output_file=self.output_file,
            project_name=self.project_name,
            status=self.status,
            tags=self.tags,
            total_count=self.total_count)


def addresses(associated_instance_id: Optional[str] = None,
              associated_instance_type: Optional[str] = None,
              eip_addresses: Optional[Sequence[str]] = None,
              ids: Optional[Sequence[str]] = None,
              isp: Optional[str] = None,
              name: Optional[str] = None,
              output_file: Optional[str] = None,
              project_name: Optional[str] = None,
              status: Optional[str] = None,
              tags: Optional[Sequence[pulumi.InputType['AddressesTagArgs']]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableAddressesResult:
    """
    Use this data source to query detailed information of eip addresses
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_address = volcengine.eip.Address("fooAddress", billing_type="PostPaidByTraffic")
    foo_addresses = volcengine.eip.addresses_output(ids=[foo_address.id])
    ```


    :param str associated_instance_id: An id of associated instance.
    :param str associated_instance_type: A type of associated instance, the value can be `Nat`, `NetworkInterface`, `ClbInstance`, `AlbInstance`, `HaVip` or `EcsInstance`.
    :param Sequence[str] eip_addresses: A list of EIP ip address that you want to query.
    :param Sequence[str] ids: A list of EIP allocation ids.
    :param str isp: An ISP of EIP Address, the value can be `BGP` or `ChinaMobile` or `ChinaUnicom` or `ChinaTelecom`.
    :param str name: A name of EIP.
    :param str output_file: File name where to save data source results.
    :param str project_name: The ProjectName of EIP.
    :param str status: A status of EIP, the value can be `Attaching` or `Detaching` or `Attached` or `Available`.
    :param Sequence[pulumi.InputType['AddressesTagArgs']] tags: Tags.
    """
    __args__ = dict()
    __args__['associatedInstanceId'] = associated_instance_id
    __args__['associatedInstanceType'] = associated_instance_type
    __args__['eipAddresses'] = eip_addresses
    __args__['ids'] = ids
    __args__['isp'] = isp
    __args__['name'] = name
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    __args__['status'] = status
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:eip/addresses:Addresses', __args__, opts=opts, typ=AddressesResult).value

    return AwaitableAddressesResult(
        addresses=pulumi.get(__ret__, 'addresses'),
        associated_instance_id=pulumi.get(__ret__, 'associated_instance_id'),
        associated_instance_type=pulumi.get(__ret__, 'associated_instance_type'),
        eip_addresses=pulumi.get(__ret__, 'eip_addresses'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        isp=pulumi.get(__ret__, 'isp'),
        name=pulumi.get(__ret__, 'name'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_name=pulumi.get(__ret__, 'project_name'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(addresses)
def addresses_output(associated_instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                     associated_instance_type: Optional[pulumi.Input[Optional[str]]] = None,
                     eip_addresses: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     isp: Optional[pulumi.Input[Optional[str]]] = None,
                     name: Optional[pulumi.Input[Optional[str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                     project_name: Optional[pulumi.Input[Optional[str]]] = None,
                     status: Optional[pulumi.Input[Optional[str]]] = None,
                     tags: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['AddressesTagArgs']]]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[AddressesResult]:
    """
    Use this data source to query detailed information of eip addresses
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_address = volcengine.eip.Address("fooAddress", billing_type="PostPaidByTraffic")
    foo_addresses = volcengine.eip.addresses_output(ids=[foo_address.id])
    ```


    :param str associated_instance_id: An id of associated instance.
    :param str associated_instance_type: A type of associated instance, the value can be `Nat`, `NetworkInterface`, `ClbInstance`, `AlbInstance`, `HaVip` or `EcsInstance`.
    :param Sequence[str] eip_addresses: A list of EIP ip address that you want to query.
    :param Sequence[str] ids: A list of EIP allocation ids.
    :param str isp: An ISP of EIP Address, the value can be `BGP` or `ChinaMobile` or `ChinaUnicom` or `ChinaTelecom`.
    :param str name: A name of EIP.
    :param str output_file: File name where to save data source results.
    :param str project_name: The ProjectName of EIP.
    :param str status: A status of EIP, the value can be `Attaching` or `Detaching` or `Attached` or `Available`.
    :param Sequence[pulumi.InputType['AddressesTagArgs']] tags: Tags.
    """
    ...
