# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'InstanceInstanceConfiguration',
    'InstanceInstanceConfigurationNodeSpecsAssign',
    'InstancesInstanceResult',
    'InstancesInstanceInstanceConfigurationResult',
    'InstancesInstanceInstanceConfigurationHotNodeResourceSpecResult',
    'InstancesInstanceInstanceConfigurationHotNodeStorageSpecResult',
    'InstancesInstanceInstanceConfigurationKibanaNodeResourceSpecResult',
    'InstancesInstanceInstanceConfigurationKibanaNodeStorageSpecResult',
    'InstancesInstanceInstanceConfigurationMasterNodeResourceSpecResult',
    'InstancesInstanceInstanceConfigurationMasterNodeStorageSpecResult',
    'InstancesInstanceInstanceConfigurationSubnetResult',
    'InstancesInstanceInstanceConfigurationVpcResult',
    'InstancesInstanceNodeResult',
    'InstancesInstanceNodeResourceSpecResult',
    'InstancesInstanceNodeStorageSpecResult',
    'InstancesInstancePluginResult',
    'RegionsRegionResult',
    'ZonesZoneResult',
]

@pulumi.output_type
class InstanceInstanceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPassword":
            suggest = "admin_password"
        elif key == "adminUserName":
            suggest = "admin_user_name"
        elif key == "chargeType":
            suggest = "charge_type"
        elif key == "configurationCode":
            suggest = "configuration_code"
        elif key == "enableHttps":
            suggest = "enable_https"
        elif key == "enablePureMaster":
            suggest = "enable_pure_master"
        elif key == "nodeSpecsAssigns":
            suggest = "node_specs_assigns"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "zoneNumber":
            suggest = "zone_number"
        elif key == "forceRestartAfterScale":
            suggest = "force_restart_after_scale"
        elif key == "instanceName":
            suggest = "instance_name"
        elif key == "maintenanceDays":
            suggest = "maintenance_days"
        elif key == "maintenanceTime":
            suggest = "maintenance_time"
        elif key == "projectName":
            suggest = "project_name"
        elif key == "regionId":
            suggest = "region_id"
        elif key == "zoneId":
            suggest = "zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceInstanceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceInstanceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceInstanceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_password: str,
                 admin_user_name: str,
                 charge_type: str,
                 configuration_code: str,
                 enable_https: bool,
                 enable_pure_master: bool,
                 node_specs_assigns: Sequence['outputs.InstanceInstanceConfigurationNodeSpecsAssign'],
                 subnet_id: str,
                 version: str,
                 zone_number: int,
                 force_restart_after_scale: Optional[bool] = None,
                 instance_name: Optional[str] = None,
                 maintenance_days: Optional[Sequence[str]] = None,
                 maintenance_time: Optional[str] = None,
                 project_name: Optional[str] = None,
                 region_id: Optional[str] = None,
                 zone_id: Optional[str] = None):
        """
        :param str admin_password: The password of administrator account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param str admin_user_name: The name of administrator account(should be admin).
        :param str charge_type: The charge type of ESCloud instance, the value can be PostPaid or PrePaid.
        :param str configuration_code: Configuration code used for billing.
        :param bool enable_https: Whether Https access is enabled.
        :param bool enable_pure_master: Whether the Master node is independent.
        :param Sequence['InstanceInstanceConfigurationNodeSpecsAssignArgs'] node_specs_assigns: The number and configuration of various ESCloud instance node. Kibana NodeSpecsAssign should not be modified.
        :param str subnet_id: The ID of subnet, the subnet must belong to the AZ selected.
        :param str version: The version of ESCloud instance, the value is V6_7 or V7_10.
        :param int zone_number: The zone count of the ESCloud instance used.
        :param bool force_restart_after_scale: Whether to force restart when changes are made. If true, it means that the cluster will be forced to restart without paying attention to instance availability. Works only on modified the node_specs_assigns field.
        :param str instance_name: The name of ESCloud instance.
        :param Sequence[str] maintenance_days: The maintainable date for the instance. Works only on modified scenes.
        :param str maintenance_time: The maintainable time period for the instance. Works only on modified scenes.
        :param str project_name: The project name  to which the ESCloud instance belongs.
        :param str region_id: The region ID of ESCloud instance.
        :param str zone_id: The available zone ID of ESCloud instance.
        """
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "admin_user_name", admin_user_name)
        pulumi.set(__self__, "charge_type", charge_type)
        pulumi.set(__self__, "configuration_code", configuration_code)
        pulumi.set(__self__, "enable_https", enable_https)
        pulumi.set(__self__, "enable_pure_master", enable_pure_master)
        pulumi.set(__self__, "node_specs_assigns", node_specs_assigns)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "zone_number", zone_number)
        if force_restart_after_scale is not None:
            pulumi.set(__self__, "force_restart_after_scale", force_restart_after_scale)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if maintenance_days is not None:
            pulumi.set(__self__, "maintenance_days", maintenance_days)
        if maintenance_time is not None:
            pulumi.set(__self__, "maintenance_time", maintenance_time)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> str:
        """
        The password of administrator account. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> str:
        """
        The name of administrator account(should be admin).
        """
        return pulumi.get(self, "admin_user_name")

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> str:
        """
        The charge type of ESCloud instance, the value can be PostPaid or PrePaid.
        """
        return pulumi.get(self, "charge_type")

    @property
    @pulumi.getter(name="configurationCode")
    def configuration_code(self) -> str:
        """
        Configuration code used for billing.
        """
        return pulumi.get(self, "configuration_code")

    @property
    @pulumi.getter(name="enableHttps")
    def enable_https(self) -> bool:
        """
        Whether Https access is enabled.
        """
        return pulumi.get(self, "enable_https")

    @property
    @pulumi.getter(name="enablePureMaster")
    def enable_pure_master(self) -> bool:
        """
        Whether the Master node is independent.
        """
        return pulumi.get(self, "enable_pure_master")

    @property
    @pulumi.getter(name="nodeSpecsAssigns")
    def node_specs_assigns(self) -> Sequence['outputs.InstanceInstanceConfigurationNodeSpecsAssign']:
        """
        The number and configuration of various ESCloud instance node. Kibana NodeSpecsAssign should not be modified.
        """
        return pulumi.get(self, "node_specs_assigns")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The ID of subnet, the subnet must belong to the AZ selected.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of ESCloud instance, the value is V6_7 or V7_10.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="zoneNumber")
    def zone_number(self) -> int:
        """
        The zone count of the ESCloud instance used.
        """
        return pulumi.get(self, "zone_number")

    @property
    @pulumi.getter(name="forceRestartAfterScale")
    def force_restart_after_scale(self) -> Optional[bool]:
        """
        Whether to force restart when changes are made. If true, it means that the cluster will be forced to restart without paying attention to instance availability. Works only on modified the node_specs_assigns field.
        """
        return pulumi.get(self, "force_restart_after_scale")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[str]:
        """
        The name of ESCloud instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="maintenanceDays")
    def maintenance_days(self) -> Optional[Sequence[str]]:
        """
        The maintainable date for the instance. Works only on modified scenes.
        """
        return pulumi.get(self, "maintenance_days")

    @property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> Optional[str]:
        """
        The maintainable time period for the instance. Works only on modified scenes.
        """
        return pulumi.get(self, "maintenance_time")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        """
        The project name  to which the ESCloud instance belongs.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[str]:
        """
        The region ID of ESCloud instance.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[str]:
        """
        The available zone ID of ESCloud instance.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class InstanceInstanceConfigurationNodeSpecsAssign(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceSpecName":
            suggest = "resource_spec_name"
        elif key == "storageSize":
            suggest = "storage_size"
        elif key == "storageSpecName":
            suggest = "storage_spec_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceInstanceConfigurationNodeSpecsAssign. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceInstanceConfigurationNodeSpecsAssign.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceInstanceConfigurationNodeSpecsAssign.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 number: int,
                 resource_spec_name: str,
                 type: str,
                 storage_size: Optional[int] = None,
                 storage_spec_name: Optional[str] = None):
        """
        :param int number: The number of node.
        :param str resource_spec_name: The name of compute resource spec, the value is `kibana.x2.small` or `es.x4.medium` or `es.x4.large` or `es.x4.xlarge` or `es.x2.2xlarge` or `es.x4.2xlarge` or `es.x2.3xlarge`.
        :param str type: The type of node, the value is `Master` or `Hot` or `Kibana`.
        :param int storage_size: The size of storage. Kibana NodeSpecsAssign should not specify this field.
        :param str storage_spec_name: The name of storage spec. Kibana NodeSpecsAssign should not specify this field.
        """
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "resource_spec_name", resource_spec_name)
        pulumi.set(__self__, "type", type)
        if storage_size is not None:
            pulumi.set(__self__, "storage_size", storage_size)
        if storage_spec_name is not None:
            pulumi.set(__self__, "storage_spec_name", storage_spec_name)

    @property
    @pulumi.getter
    def number(self) -> int:
        """
        The number of node.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter(name="resourceSpecName")
    def resource_spec_name(self) -> str:
        """
        The name of compute resource spec, the value is `kibana.x2.small` or `es.x4.medium` or `es.x4.large` or `es.x4.xlarge` or `es.x2.2xlarge` or `es.x4.2xlarge` or `es.x2.3xlarge`.
        """
        return pulumi.get(self, "resource_spec_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of node, the value is `Master` or `Hot` or `Kibana`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="storageSize")
    def storage_size(self) -> Optional[int]:
        """
        The size of storage. Kibana NodeSpecsAssign should not specify this field.
        """
        return pulumi.get(self, "storage_size")

    @property
    @pulumi.getter(name="storageSpecName")
    def storage_spec_name(self) -> Optional[str]:
        """
        The name of storage spec. Kibana NodeSpecsAssign should not specify this field.
        """
        return pulumi.get(self, "storage_spec_name")


@pulumi.output_type
class InstancesInstanceResult(dict):
    def __init__(__self__, *,
                 charge_enabled: bool,
                 create_time: str,
                 enable_es_private_network: bool,
                 enable_es_public_network: bool,
                 enable_kibana_private_network: bool,
                 enable_kibana_public_network: bool,
                 es_inner_endpoint: str,
                 es_private_domain: str,
                 es_private_endpoint: str,
                 es_public_domain: str,
                 es_public_endpoint: str,
                 expire_date: str,
                 id: str,
                 instance_configuration: 'outputs.InstancesInstanceInstanceConfigurationResult',
                 instance_id: str,
                 kibana_private_domain: str,
                 kibana_public_domain: str,
                 maintenance_days: Sequence[str],
                 maintenance_time: str,
                 namespace: str,
                 nodes: Sequence['outputs.InstancesInstanceNodeResult'],
                 plugins: Sequence['outputs.InstancesInstancePluginResult'],
                 status: str,
                 total_nodes: int,
                 user_id: str):
        """
        :param bool charge_enabled: The charge status of instance.
        :param str create_time: The create time of instance.
        :param bool enable_es_private_network: whether enable es private network.
        :param bool enable_es_public_network: whether enable es public network.
        :param bool enable_kibana_private_network: whether enable kibana private network.
        :param bool enable_kibana_public_network: whether enable kibana public network.
        :param str es_inner_endpoint: The es inner endpoint of instance.
        :param str es_private_domain: The es private domain of instance.
        :param str es_private_endpoint: The es private endpoint of instance.
        :param str es_public_domain: The es public domain of instance.
        :param str es_public_endpoint: The es public endpoint of instance.
        :param str expire_date: The expire time of instance.
        :param str id: The Id of instance.
        :param 'InstancesInstanceInstanceConfigurationArgs' instance_configuration: The configuration of instance.
        :param str instance_id: The Id of instance.
        :param str kibana_private_domain: The kibana private domain of instance.
        :param str kibana_public_domain: The kibana public domain of instance.
        :param Sequence[str] maintenance_days: The maintenance day of instance.
        :param str maintenance_time: The maintenance time of instance.
        :param str namespace: The namespace of instance.
        :param Sequence['InstancesInstanceNodeArgs'] nodes: The nodes info of instance.
        :param Sequence['InstancesInstancePluginArgs'] plugins: The plugin info of instance.
        :param str status: The status of instance.
        :param int total_nodes: The total nodes of instance.
        :param str user_id: The user id of instance.
        """
        pulumi.set(__self__, "charge_enabled", charge_enabled)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "enable_es_private_network", enable_es_private_network)
        pulumi.set(__self__, "enable_es_public_network", enable_es_public_network)
        pulumi.set(__self__, "enable_kibana_private_network", enable_kibana_private_network)
        pulumi.set(__self__, "enable_kibana_public_network", enable_kibana_public_network)
        pulumi.set(__self__, "es_inner_endpoint", es_inner_endpoint)
        pulumi.set(__self__, "es_private_domain", es_private_domain)
        pulumi.set(__self__, "es_private_endpoint", es_private_endpoint)
        pulumi.set(__self__, "es_public_domain", es_public_domain)
        pulumi.set(__self__, "es_public_endpoint", es_public_endpoint)
        pulumi.set(__self__, "expire_date", expire_date)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_configuration", instance_configuration)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "kibana_private_domain", kibana_private_domain)
        pulumi.set(__self__, "kibana_public_domain", kibana_public_domain)
        pulumi.set(__self__, "maintenance_days", maintenance_days)
        pulumi.set(__self__, "maintenance_time", maintenance_time)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "plugins", plugins)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "total_nodes", total_nodes)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="chargeEnabled")
    def charge_enabled(self) -> bool:
        """
        The charge status of instance.
        """
        return pulumi.get(self, "charge_enabled")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The create time of instance.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="enableEsPrivateNetwork")
    def enable_es_private_network(self) -> bool:
        """
        whether enable es private network.
        """
        return pulumi.get(self, "enable_es_private_network")

    @property
    @pulumi.getter(name="enableEsPublicNetwork")
    def enable_es_public_network(self) -> bool:
        """
        whether enable es public network.
        """
        return pulumi.get(self, "enable_es_public_network")

    @property
    @pulumi.getter(name="enableKibanaPrivateNetwork")
    def enable_kibana_private_network(self) -> bool:
        """
        whether enable kibana private network.
        """
        return pulumi.get(self, "enable_kibana_private_network")

    @property
    @pulumi.getter(name="enableKibanaPublicNetwork")
    def enable_kibana_public_network(self) -> bool:
        """
        whether enable kibana public network.
        """
        return pulumi.get(self, "enable_kibana_public_network")

    @property
    @pulumi.getter(name="esInnerEndpoint")
    def es_inner_endpoint(self) -> str:
        """
        The es inner endpoint of instance.
        """
        return pulumi.get(self, "es_inner_endpoint")

    @property
    @pulumi.getter(name="esPrivateDomain")
    def es_private_domain(self) -> str:
        """
        The es private domain of instance.
        """
        return pulumi.get(self, "es_private_domain")

    @property
    @pulumi.getter(name="esPrivateEndpoint")
    def es_private_endpoint(self) -> str:
        """
        The es private endpoint of instance.
        """
        return pulumi.get(self, "es_private_endpoint")

    @property
    @pulumi.getter(name="esPublicDomain")
    def es_public_domain(self) -> str:
        """
        The es public domain of instance.
        """
        return pulumi.get(self, "es_public_domain")

    @property
    @pulumi.getter(name="esPublicEndpoint")
    def es_public_endpoint(self) -> str:
        """
        The es public endpoint of instance.
        """
        return pulumi.get(self, "es_public_endpoint")

    @property
    @pulumi.getter(name="expireDate")
    def expire_date(self) -> str:
        """
        The expire time of instance.
        """
        return pulumi.get(self, "expire_date")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Id of instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceConfiguration")
    def instance_configuration(self) -> 'outputs.InstancesInstanceInstanceConfigurationResult':
        """
        The configuration of instance.
        """
        return pulumi.get(self, "instance_configuration")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The Id of instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="kibanaPrivateDomain")
    def kibana_private_domain(self) -> str:
        """
        The kibana private domain of instance.
        """
        return pulumi.get(self, "kibana_private_domain")

    @property
    @pulumi.getter(name="kibanaPublicDomain")
    def kibana_public_domain(self) -> str:
        """
        The kibana public domain of instance.
        """
        return pulumi.get(self, "kibana_public_domain")

    @property
    @pulumi.getter(name="maintenanceDays")
    def maintenance_days(self) -> Sequence[str]:
        """
        The maintenance day of instance.
        """
        return pulumi.get(self, "maintenance_days")

    @property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> str:
        """
        The maintenance time of instance.
        """
        return pulumi.get(self, "maintenance_time")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace of instance.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.InstancesInstanceNodeResult']:
        """
        The nodes info of instance.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def plugins(self) -> Sequence['outputs.InstancesInstancePluginResult']:
        """
        The plugin info of instance.
        """
        return pulumi.get(self, "plugins")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="totalNodes")
    def total_nodes(self) -> int:
        """
        The total nodes of instance.
        """
        return pulumi.get(self, "total_nodes")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The user id of instance.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class InstancesInstanceInstanceConfigurationResult(dict):
    def __init__(__self__, *,
                 admin_user_name: str,
                 charge_type: str,
                 enable_https: bool,
                 enable_pure_master: bool,
                 hot_node_number: int,
                 hot_node_resource_spec: 'outputs.InstancesInstanceInstanceConfigurationHotNodeResourceSpecResult',
                 hot_node_storage_spec: 'outputs.InstancesInstanceInstanceConfigurationHotNodeStorageSpecResult',
                 instance_name: str,
                 kibana_node_number: int,
                 kibana_node_resource_spec: 'outputs.InstancesInstanceInstanceConfigurationKibanaNodeResourceSpecResult',
                 kibana_node_storage_spec: 'outputs.InstancesInstanceInstanceConfigurationKibanaNodeStorageSpecResult',
                 master_node_number: int,
                 master_node_resource_spec: 'outputs.InstancesInstanceInstanceConfigurationMasterNodeResourceSpecResult',
                 master_node_storage_spec: 'outputs.InstancesInstanceInstanceConfigurationMasterNodeStorageSpecResult',
                 period: int,
                 project_name: str,
                 region_id: str,
                 subnet: 'outputs.InstancesInstanceInstanceConfigurationSubnetResult',
                 version: str,
                 vpc: 'outputs.InstancesInstanceInstanceConfigurationVpcResult',
                 zone_id: str,
                 zone_number: int):
        """
        :param str admin_user_name: The user name of instance.
        :param str charge_type: The charge type of instance.
        :param bool enable_https: whether enable https.
        :param bool enable_pure_master: Whether enable pure master.
        :param int hot_node_number: The node number of host.
        :param 'InstancesInstanceInstanceConfigurationHotNodeResourceSpecArgs' hot_node_resource_spec: The node resource spec of host.
        :param 'InstancesInstanceInstanceConfigurationHotNodeStorageSpecArgs' hot_node_storage_spec: The node storage spec of host.
        :param str instance_name: The name of instance.
        :param int kibana_node_number: The node number of kibana.
        :param 'InstancesInstanceInstanceConfigurationKibanaNodeResourceSpecArgs' kibana_node_resource_spec: The node resource spec of kibana.
        :param 'InstancesInstanceInstanceConfigurationKibanaNodeStorageSpecArgs' kibana_node_storage_spec: The node storage spec of kibana.
        :param int master_node_number: The node number of master.
        :param 'InstancesInstanceInstanceConfigurationMasterNodeResourceSpecArgs' master_node_resource_spec: The node resource spec of master.
        :param 'InstancesInstanceInstanceConfigurationMasterNodeStorageSpecArgs' master_node_storage_spec: The node storage spec of master.
        :param int period: The period of project.
        :param str project_name: The name of project.
        :param str region_id: The region info of instance.
        :param 'InstancesInstanceInstanceConfigurationSubnetArgs' subnet: The subnet info.
        :param str version: The version of plugin.
        :param 'InstancesInstanceInstanceConfigurationVpcArgs' vpc: The vpc info.
        :param str zone_id: The zoneId of instance.
        :param int zone_number: The zone number of instance.
        """
        pulumi.set(__self__, "admin_user_name", admin_user_name)
        pulumi.set(__self__, "charge_type", charge_type)
        pulumi.set(__self__, "enable_https", enable_https)
        pulumi.set(__self__, "enable_pure_master", enable_pure_master)
        pulumi.set(__self__, "hot_node_number", hot_node_number)
        pulumi.set(__self__, "hot_node_resource_spec", hot_node_resource_spec)
        pulumi.set(__self__, "hot_node_storage_spec", hot_node_storage_spec)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "kibana_node_number", kibana_node_number)
        pulumi.set(__self__, "kibana_node_resource_spec", kibana_node_resource_spec)
        pulumi.set(__self__, "kibana_node_storage_spec", kibana_node_storage_spec)
        pulumi.set(__self__, "master_node_number", master_node_number)
        pulumi.set(__self__, "master_node_resource_spec", master_node_resource_spec)
        pulumi.set(__self__, "master_node_storage_spec", master_node_storage_spec)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "vpc", vpc)
        pulumi.set(__self__, "zone_id", zone_id)
        pulumi.set(__self__, "zone_number", zone_number)

    @property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> str:
        """
        The user name of instance.
        """
        return pulumi.get(self, "admin_user_name")

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> str:
        """
        The charge type of instance.
        """
        return pulumi.get(self, "charge_type")

    @property
    @pulumi.getter(name="enableHttps")
    def enable_https(self) -> bool:
        """
        whether enable https.
        """
        return pulumi.get(self, "enable_https")

    @property
    @pulumi.getter(name="enablePureMaster")
    def enable_pure_master(self) -> bool:
        """
        Whether enable pure master.
        """
        return pulumi.get(self, "enable_pure_master")

    @property
    @pulumi.getter(name="hotNodeNumber")
    def hot_node_number(self) -> int:
        """
        The node number of host.
        """
        return pulumi.get(self, "hot_node_number")

    @property
    @pulumi.getter(name="hotNodeResourceSpec")
    def hot_node_resource_spec(self) -> 'outputs.InstancesInstanceInstanceConfigurationHotNodeResourceSpecResult':
        """
        The node resource spec of host.
        """
        return pulumi.get(self, "hot_node_resource_spec")

    @property
    @pulumi.getter(name="hotNodeStorageSpec")
    def hot_node_storage_spec(self) -> 'outputs.InstancesInstanceInstanceConfigurationHotNodeStorageSpecResult':
        """
        The node storage spec of host.
        """
        return pulumi.get(self, "hot_node_storage_spec")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The name of instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="kibanaNodeNumber")
    def kibana_node_number(self) -> int:
        """
        The node number of kibana.
        """
        return pulumi.get(self, "kibana_node_number")

    @property
    @pulumi.getter(name="kibanaNodeResourceSpec")
    def kibana_node_resource_spec(self) -> 'outputs.InstancesInstanceInstanceConfigurationKibanaNodeResourceSpecResult':
        """
        The node resource spec of kibana.
        """
        return pulumi.get(self, "kibana_node_resource_spec")

    @property
    @pulumi.getter(name="kibanaNodeStorageSpec")
    def kibana_node_storage_spec(self) -> 'outputs.InstancesInstanceInstanceConfigurationKibanaNodeStorageSpecResult':
        """
        The node storage spec of kibana.
        """
        return pulumi.get(self, "kibana_node_storage_spec")

    @property
    @pulumi.getter(name="masterNodeNumber")
    def master_node_number(self) -> int:
        """
        The node number of master.
        """
        return pulumi.get(self, "master_node_number")

    @property
    @pulumi.getter(name="masterNodeResourceSpec")
    def master_node_resource_spec(self) -> 'outputs.InstancesInstanceInstanceConfigurationMasterNodeResourceSpecResult':
        """
        The node resource spec of master.
        """
        return pulumi.get(self, "master_node_resource_spec")

    @property
    @pulumi.getter(name="masterNodeStorageSpec")
    def master_node_storage_spec(self) -> 'outputs.InstancesInstanceInstanceConfigurationMasterNodeStorageSpecResult':
        """
        The node storage spec of master.
        """
        return pulumi.get(self, "master_node_storage_spec")

    @property
    @pulumi.getter
    def period(self) -> int:
        """
        The period of project.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> str:
        """
        The name of project.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        The region info of instance.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter
    def subnet(self) -> 'outputs.InstancesInstanceInstanceConfigurationSubnetResult':
        """
        The subnet info.
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of plugin.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def vpc(self) -> 'outputs.InstancesInstanceInstanceConfigurationVpcResult':
        """
        The vpc info.
        """
        return pulumi.get(self, "vpc")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zoneId of instance.
        """
        return pulumi.get(self, "zone_id")

    @property
    @pulumi.getter(name="zoneNumber")
    def zone_number(self) -> int:
        """
        The zone number of instance.
        """
        return pulumi.get(self, "zone_number")


@pulumi.output_type
class InstancesInstanceInstanceConfigurationHotNodeResourceSpecResult(dict):
    def __init__(__self__, *,
                 cpu: int,
                 description: str,
                 display_name: str,
                 memory: int,
                 name: str):
        """
        :param int cpu: The cpu info of resource spec.
        :param str description: The description of plugin.
        :param str display_name: The show name of storage spec.
        :param int memory: The memory info of resource spec.
        :param str name: The name of storage spec.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def cpu(self) -> int:
        """
        The cpu info of resource spec.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of plugin.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The show name of storage spec.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        The memory info of resource spec.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of storage spec.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InstancesInstanceInstanceConfigurationHotNodeStorageSpecResult(dict):
    def __init__(__self__, *,
                 description: str,
                 display_name: str,
                 max_size: int,
                 min_size: int,
                 name: str,
                 size: int,
                 type: str):
        """
        :param str description: The description of plugin.
        :param str display_name: The show name of storage spec.
        :param int max_size: The max size of storage spec.
        :param int min_size: The min size of storage spec.
        :param str name: The name of storage spec.
        :param int size: The size of storage spec.
        :param str type: The type of storage spec.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of plugin.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The show name of storage spec.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> int:
        """
        The max size of storage spec.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> int:
        """
        The min size of storage spec.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of storage spec.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of storage spec.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of storage spec.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InstancesInstanceInstanceConfigurationKibanaNodeResourceSpecResult(dict):
    def __init__(__self__, *,
                 cpu: int,
                 description: str,
                 display_name: str,
                 memory: int,
                 name: str):
        """
        :param int cpu: The cpu info of resource spec.
        :param str description: The description of plugin.
        :param str display_name: The show name of storage spec.
        :param int memory: The memory info of resource spec.
        :param str name: The name of storage spec.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def cpu(self) -> int:
        """
        The cpu info of resource spec.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of plugin.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The show name of storage spec.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        The memory info of resource spec.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of storage spec.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InstancesInstanceInstanceConfigurationKibanaNodeStorageSpecResult(dict):
    def __init__(__self__, *,
                 description: str,
                 display_name: str,
                 max_size: int,
                 min_size: int,
                 name: str,
                 size: int,
                 type: str):
        """
        :param str description: The description of plugin.
        :param str display_name: The show name of storage spec.
        :param int max_size: The max size of storage spec.
        :param int min_size: The min size of storage spec.
        :param str name: The name of storage spec.
        :param int size: The size of storage spec.
        :param str type: The type of storage spec.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of plugin.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The show name of storage spec.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> int:
        """
        The max size of storage spec.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> int:
        """
        The min size of storage spec.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of storage spec.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of storage spec.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of storage spec.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InstancesInstanceInstanceConfigurationMasterNodeResourceSpecResult(dict):
    def __init__(__self__, *,
                 cpu: int,
                 description: str,
                 display_name: str,
                 memory: int,
                 name: str):
        """
        :param int cpu: The cpu info of resource spec.
        :param str description: The description of plugin.
        :param str display_name: The show name of storage spec.
        :param int memory: The memory info of resource spec.
        :param str name: The name of storage spec.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def cpu(self) -> int:
        """
        The cpu info of resource spec.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of plugin.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The show name of storage spec.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        The memory info of resource spec.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of storage spec.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InstancesInstanceInstanceConfigurationMasterNodeStorageSpecResult(dict):
    def __init__(__self__, *,
                 description: str,
                 display_name: str,
                 max_size: int,
                 min_size: int,
                 name: str,
                 size: int,
                 type: str):
        """
        :param str description: The description of plugin.
        :param str display_name: The show name of storage spec.
        :param int max_size: The max size of storage spec.
        :param int min_size: The min size of storage spec.
        :param str name: The name of storage spec.
        :param int size: The size of storage spec.
        :param str type: The type of storage spec.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of plugin.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The show name of storage spec.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> int:
        """
        The max size of storage spec.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> int:
        """
        The min size of storage spec.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of storage spec.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of storage spec.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of storage spec.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InstancesInstanceInstanceConfigurationSubnetResult(dict):
    def __init__(__self__, *,
                 subnet_id: str,
                 subnet_name: str):
        """
        :param str subnet_id: The id of subnet.
        :param str subnet_name: The name of subnet.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "subnet_name", subnet_name)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The id of subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> str:
        """
        The name of subnet.
        """
        return pulumi.get(self, "subnet_name")


@pulumi.output_type
class InstancesInstanceInstanceConfigurationVpcResult(dict):
    def __init__(__self__, *,
                 vpc_id: str,
                 vpc_name: str):
        """
        :param str vpc_id: The id of vpc.
        :param str vpc_name: The name of vpc.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_name", vpc_name)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The id of vpc.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> str:
        """
        The name of vpc.
        """
        return pulumi.get(self, "vpc_name")


@pulumi.output_type
class InstancesInstanceNodeResult(dict):
    def __init__(__self__, *,
                 is_cold: bool,
                 is_hot: bool,
                 is_kibana: bool,
                 is_master: bool,
                 is_warm: bool,
                 node_display_name: str,
                 node_name: str,
                 resource_spec: 'outputs.InstancesInstanceNodeResourceSpecResult',
                 restart_number: int,
                 start_time: str,
                 status: str,
                 storage_spec: 'outputs.InstancesInstanceNodeStorageSpecResult'):
        """
        :param bool is_cold: Is cold node.
        :param bool is_hot: Is hot node.
        :param bool is_kibana: Is kibana node.
        :param bool is_master: Is master node.
        :param bool is_warm: Is warm node.
        :param str node_display_name: The show name of node.
        :param str node_name: The name of node.
        :param 'InstancesInstanceNodeResourceSpecArgs' resource_spec: The node resource spec of master.
        :param int restart_number: The restart times of node.
        :param str start_time: The start time of node.
        :param str status: The status of instance.
        :param 'InstancesInstanceNodeStorageSpecArgs' storage_spec: The node storage spec of master.
        """
        pulumi.set(__self__, "is_cold", is_cold)
        pulumi.set(__self__, "is_hot", is_hot)
        pulumi.set(__self__, "is_kibana", is_kibana)
        pulumi.set(__self__, "is_master", is_master)
        pulumi.set(__self__, "is_warm", is_warm)
        pulumi.set(__self__, "node_display_name", node_display_name)
        pulumi.set(__self__, "node_name", node_name)
        pulumi.set(__self__, "resource_spec", resource_spec)
        pulumi.set(__self__, "restart_number", restart_number)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage_spec", storage_spec)

    @property
    @pulumi.getter(name="isCold")
    def is_cold(self) -> bool:
        """
        Is cold node.
        """
        return pulumi.get(self, "is_cold")

    @property
    @pulumi.getter(name="isHot")
    def is_hot(self) -> bool:
        """
        Is hot node.
        """
        return pulumi.get(self, "is_hot")

    @property
    @pulumi.getter(name="isKibana")
    def is_kibana(self) -> bool:
        """
        Is kibana node.
        """
        return pulumi.get(self, "is_kibana")

    @property
    @pulumi.getter(name="isMaster")
    def is_master(self) -> bool:
        """
        Is master node.
        """
        return pulumi.get(self, "is_master")

    @property
    @pulumi.getter(name="isWarm")
    def is_warm(self) -> bool:
        """
        Is warm node.
        """
        return pulumi.get(self, "is_warm")

    @property
    @pulumi.getter(name="nodeDisplayName")
    def node_display_name(self) -> str:
        """
        The show name of node.
        """
        return pulumi.get(self, "node_display_name")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> str:
        """
        The name of node.
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="resourceSpec")
    def resource_spec(self) -> 'outputs.InstancesInstanceNodeResourceSpecResult':
        """
        The node resource spec of master.
        """
        return pulumi.get(self, "resource_spec")

    @property
    @pulumi.getter(name="restartNumber")
    def restart_number(self) -> int:
        """
        The restart times of node.
        """
        return pulumi.get(self, "restart_number")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time of node.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageSpec")
    def storage_spec(self) -> 'outputs.InstancesInstanceNodeStorageSpecResult':
        """
        The node storage spec of master.
        """
        return pulumi.get(self, "storage_spec")


@pulumi.output_type
class InstancesInstanceNodeResourceSpecResult(dict):
    def __init__(__self__, *,
                 cpu: int,
                 description: str,
                 display_name: str,
                 memory: int,
                 name: str):
        """
        :param int cpu: The cpu info of resource spec.
        :param str description: The description of plugin.
        :param str display_name: The show name of storage spec.
        :param int memory: The memory info of resource spec.
        :param str name: The name of storage spec.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def cpu(self) -> int:
        """
        The cpu info of resource spec.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of plugin.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The show name of storage spec.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        The memory info of resource spec.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of storage spec.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InstancesInstanceNodeStorageSpecResult(dict):
    def __init__(__self__, *,
                 description: str,
                 display_name: str,
                 max_size: int,
                 min_size: int,
                 name: str,
                 size: int,
                 type: str):
        """
        :param str description: The description of plugin.
        :param str display_name: The show name of storage spec.
        :param int max_size: The max size of storage spec.
        :param int min_size: The min size of storage spec.
        :param str name: The name of storage spec.
        :param int size: The size of storage spec.
        :param str type: The type of storage spec.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of plugin.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The show name of storage spec.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> int:
        """
        The max size of storage spec.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> int:
        """
        The min size of storage spec.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of storage spec.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of storage spec.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of storage spec.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InstancesInstancePluginResult(dict):
    def __init__(__self__, *,
                 description: str,
                 plugin_name: str,
                 version: str):
        """
        :param str description: The description of plugin.
        :param str plugin_name: The name of plugin.
        :param str version: The version of plugin.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "plugin_name", plugin_name)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of plugin.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="pluginName")
    def plugin_name(self) -> str:
        """
        The name of plugin.
        """
        return pulumi.get(self, "plugin_name")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of plugin.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RegionsRegionResult(dict):
    def __init__(__self__, *,
                 region_id: str,
                 region_name: str):
        """
        :param str region_id: The id of the region.
        :param str region_name: The name of region.
        """
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        The id of the region.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> str:
        """
        The name of region.
        """
        return pulumi.get(self, "region_name")


@pulumi.output_type
class ZonesZoneResult(dict):
    def __init__(__self__, *,
                 id: str,
                 zone_id: str,
                 zone_name: str):
        """
        :param str id: The id of the zone.
        :param str zone_id: The id of the zone.
        :param str zone_name: The name of the zone.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "zone_id", zone_id)
        pulumi.set(__self__, "zone_name", zone_name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the zone.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The id of the zone.
        """
        return pulumi.get(self, "zone_id")

    @property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> str:
        """
        The name of the zone.
        """
        return pulumi.get(self, "zone_name")


