# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['LoginProfileArgs', 'LoginProfile']

@pulumi.input_type
class LoginProfileArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 user_name: pulumi.Input[str],
                 login_allowed: Optional[pulumi.Input[bool]] = None,
                 password_reset_required: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a LoginProfile resource.
        :param pulumi.Input[str] password: The password.
        :param pulumi.Input[str] user_name: The user name.
        :param pulumi.Input[bool] login_allowed: The flag of login allowed.
        :param pulumi.Input[bool] password_reset_required: Is required reset password when next time login in.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user_name", user_name)
        if login_allowed is not None:
            pulumi.set(__self__, "login_allowed", login_allowed)
        if password_reset_required is not None:
            pulumi.set(__self__, "password_reset_required", password_reset_required)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        """
        The user name.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="loginAllowed")
    def login_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag of login allowed.
        """
        return pulumi.get(self, "login_allowed")

    @login_allowed.setter
    def login_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "login_allowed", value)

    @property
    @pulumi.getter(name="passwordResetRequired")
    def password_reset_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Is required reset password when next time login in.
        """
        return pulumi.get(self, "password_reset_required")

    @password_reset_required.setter
    def password_reset_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_reset_required", value)


@pulumi.input_type
class _LoginProfileState:
    def __init__(__self__, *,
                 login_allowed: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_reset_required: Optional[pulumi.Input[bool]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LoginProfile resources.
        :param pulumi.Input[bool] login_allowed: The flag of login allowed.
        :param pulumi.Input[str] password: The password.
        :param pulumi.Input[bool] password_reset_required: Is required reset password when next time login in.
        :param pulumi.Input[str] user_name: The user name.
        """
        if login_allowed is not None:
            pulumi.set(__self__, "login_allowed", login_allowed)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_reset_required is not None:
            pulumi.set(__self__, "password_reset_required", password_reset_required)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="loginAllowed")
    def login_allowed(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag of login allowed.
        """
        return pulumi.get(self, "login_allowed")

    @login_allowed.setter
    def login_allowed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "login_allowed", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordResetRequired")
    def password_reset_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Is required reset password when next time login in.
        """
        return pulumi.get(self, "password_reset_required")

    @password_reset_required.setter
    def password_reset_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_reset_required", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user name.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


class LoginProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 login_allowed: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_reset_required: Optional[pulumi.Input[bool]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage iam login profile
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_user = volcengine.iam.User("fooUser",
            user_name="acc-test-user",
            description="acc-test",
            display_name="name")
        foo_login_profile = volcengine.iam.LoginProfile("fooLoginProfile",
            user_name=foo_user.user_name,
            password="93f0cb0614Aab12",
            login_allowed=True,
            password_reset_required=False)
        ```

        ## Import

        Login profile can be imported using the UserName, e.g.

        ```sh
         $ pulumi import volcengine:iam/loginProfile:LoginProfile default user_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] login_allowed: The flag of login allowed.
        :param pulumi.Input[str] password: The password.
        :param pulumi.Input[bool] password_reset_required: Is required reset password when next time login in.
        :param pulumi.Input[str] user_name: The user name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoginProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage iam login profile
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_user = volcengine.iam.User("fooUser",
            user_name="acc-test-user",
            description="acc-test",
            display_name="name")
        foo_login_profile = volcengine.iam.LoginProfile("fooLoginProfile",
            user_name=foo_user.user_name,
            password="93f0cb0614Aab12",
            login_allowed=True,
            password_reset_required=False)
        ```

        ## Import

        Login profile can be imported using the UserName, e.g.

        ```sh
         $ pulumi import volcengine:iam/loginProfile:LoginProfile default user_name
        ```

        :param str resource_name: The name of the resource.
        :param LoginProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoginProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 login_allowed: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_reset_required: Optional[pulumi.Input[bool]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoginProfileArgs.__new__(LoginProfileArgs)

            __props__.__dict__["login_allowed"] = login_allowed
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["password_reset_required"] = password_reset_required
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(LoginProfile, __self__).__init__(
            'volcengine:iam/loginProfile:LoginProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            login_allowed: Optional[pulumi.Input[bool]] = None,
            password: Optional[pulumi.Input[str]] = None,
            password_reset_required: Optional[pulumi.Input[bool]] = None,
            user_name: Optional[pulumi.Input[str]] = None) -> 'LoginProfile':
        """
        Get an existing LoginProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] login_allowed: The flag of login allowed.
        :param pulumi.Input[str] password: The password.
        :param pulumi.Input[bool] password_reset_required: Is required reset password when next time login in.
        :param pulumi.Input[str] user_name: The user name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoginProfileState.__new__(_LoginProfileState)

        __props__.__dict__["login_allowed"] = login_allowed
        __props__.__dict__["password"] = password
        __props__.__dict__["password_reset_required"] = password_reset_required
        __props__.__dict__["user_name"] = user_name
        return LoginProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="loginAllowed")
    def login_allowed(self) -> pulumi.Output[Optional[bool]]:
        """
        The flag of login allowed.
        """
        return pulumi.get(self, "login_allowed")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        The password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordResetRequired")
    def password_reset_required(self) -> pulumi.Output[Optional[bool]]:
        """
        Is required reset password when next time login in.
        """
        return pulumi.get(self, "password_reset_required")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[str]:
        """
        The user name.
        """
        return pulumi.get(self, "user_name")

