# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'RolesResult',
    'AwaitableRolesResult',
    'roles',
    'roles_output',
]

@pulumi.output_type
class RolesResult:
    """
    A collection of values returned by Roles.
    """
    def __init__(__self__, id=None, name_regex=None, output_file=None, query=None, role_name=None, roles=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if query and not isinstance(query, str):
            raise TypeError("Expected argument 'query' to be a str")
        pulumi.set(__self__, "query", query)
        if role_name and not isinstance(role_name, str):
            raise TypeError("Expected argument 'role_name' to be a str")
        pulumi.set(__self__, "role_name", role_name)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[str]:
        """
        The name of the Role.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter
    def roles(self) -> Sequence['outputs.RolesRoleResult']:
        """
        The collection of Role query.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of Role query.
        """
        return pulumi.get(self, "total_count")


class AwaitableRolesResult(RolesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return RolesResult(
            id=self.id,
            name_regex=self.name_regex,
            output_file=self.output_file,
            query=self.query,
            role_name=self.role_name,
            roles=self.roles,
            total_count=self.total_count)


def roles(name_regex: Optional[str] = None,
          output_file: Optional[str] = None,
          query: Optional[str] = None,
          role_name: Optional[str] = None,
          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableRolesResult:
    """
    Use this data source to query detailed information of iam roles
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo1 = volcengine.iam.Role("foo1",
        description="acc-test1",
        display_name="acc-test1",
        max_session_duration=3600,
        role_name="acc-test-role1",
        trust_policy_document="{\\"Statement\\":[{\\"Effect\\":\\"Allow\\",\\"Action\\":[\\"sts:AssumeRole\\"],\\"Principal\\":{\\"Service\\":[\\"auto_scaling\\"]}}]}")
    foo2 = volcengine.iam.Role("foo2",
        description="acc-test2",
        display_name="acc-test2",
        max_session_duration=3600,
        role_name="acc-test-role2",
        trust_policy_document="{\\"Statement\\":[{\\"Effect\\":\\"Allow\\",\\"Action\\":[\\"sts:AssumeRole\\"],\\"Principal\\":{\\"Service\\":[\\"ecs\\"]}}]}")
    foo = volcengine.iam.roles_output(role_name=pulumi.Output.all(foo1.role_name, foo2.role_name).apply(lambda foo1Role_name, foo2Role_name: f"{foo1_role_name},{foo2_role_name}"))
    ```


    :param str name_regex: A Name Regex of Role.
    :param str output_file: File name where to save data source results.
    :param str query: The query field of Role.
    :param str role_name: The name of the Role, comma separated.
    """
    __args__ = dict()
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['query'] = query
    __args__['roleName'] = role_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:iam/roles:Roles', __args__, opts=opts, typ=RolesResult).value

    return AwaitableRolesResult(
        id=pulumi.get(__ret__, 'id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        query=pulumi.get(__ret__, 'query'),
        role_name=pulumi.get(__ret__, 'role_name'),
        roles=pulumi.get(__ret__, 'roles'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(roles)
def roles_output(name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                 output_file: Optional[pulumi.Input[Optional[str]]] = None,
                 query: Optional[pulumi.Input[Optional[str]]] = None,
                 role_name: Optional[pulumi.Input[Optional[str]]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[RolesResult]:
    """
    Use this data source to query detailed information of iam roles
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo1 = volcengine.iam.Role("foo1",
        description="acc-test1",
        display_name="acc-test1",
        max_session_duration=3600,
        role_name="acc-test-role1",
        trust_policy_document="{\\"Statement\\":[{\\"Effect\\":\\"Allow\\",\\"Action\\":[\\"sts:AssumeRole\\"],\\"Principal\\":{\\"Service\\":[\\"auto_scaling\\"]}}]}")
    foo2 = volcengine.iam.Role("foo2",
        description="acc-test2",
        display_name="acc-test2",
        max_session_duration=3600,
        role_name="acc-test-role2",
        trust_policy_document="{\\"Statement\\":[{\\"Effect\\":\\"Allow\\",\\"Action\\":[\\"sts:AssumeRole\\"],\\"Principal\\":{\\"Service\\":[\\"ecs\\"]}}]}")
    foo = volcengine.iam.roles_output(role_name=pulumi.Output.all(foo1.role_name, foo2.role_name).apply(lambda foo1Role_name, foo2Role_name: f"{foo1_role_name},{foo2_role_name}"))
    ```


    :param str name_regex: A Name Regex of Role.
    :param str output_file: File name where to save data source results.
    :param str query: The query field of Role.
    :param str role_name: The name of the Role, comma separated.
    """
    ...
