# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 user_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 mobile_phone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[str] user_name: The name of the user.
        :param pulumi.Input[str] description: The description of the user.
        :param pulumi.Input[str] display_name: The display name of the user.
        :param pulumi.Input[str] email: The email of the user.
        :param pulumi.Input[str] mobile_phone: The mobile phone of the user.
        """
        pulumi.set(__self__, "user_name", user_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if mobile_phone is not None:
            pulumi.set(__self__, "mobile_phone", mobile_phone)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        """
        The name of the user.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the user.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> Optional[pulumi.Input[str]]:
        """
        The mobile phone of the user.
        """
        return pulumi.get(self, "mobile_phone")

    @mobile_phone.setter
    def mobile_phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mobile_phone", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 create_date: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 email_is_verify: Optional[pulumi.Input[bool]] = None,
                 mobile_phone: Optional[pulumi.Input[str]] = None,
                 mobile_phone_is_verify: Optional[pulumi.Input[bool]] = None,
                 trn: Optional[pulumi.Input[str]] = None,
                 update_date: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[str] account_id: Main account ID to which the sub-user belongs.
        :param pulumi.Input[str] create_date: The create date of the user.
        :param pulumi.Input[str] description: The description of the user.
        :param pulumi.Input[str] display_name: The display name of the user.
        :param pulumi.Input[str] email: The email of the user.
        :param pulumi.Input[bool] email_is_verify: Whether the email has been verified.
        :param pulumi.Input[str] mobile_phone: The mobile phone of the user.
        :param pulumi.Input[bool] mobile_phone_is_verify: Whether the phone number has been verified.
        :param pulumi.Input[str] trn: The trn of the user.
        :param pulumi.Input[str] update_date: The update date of the user.
        :param pulumi.Input[str] user_id: The id of the user.
        :param pulumi.Input[str] user_name: The name of the user.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if create_date is not None:
            pulumi.set(__self__, "create_date", create_date)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if email_is_verify is not None:
            pulumi.set(__self__, "email_is_verify", email_is_verify)
        if mobile_phone is not None:
            pulumi.set(__self__, "mobile_phone", mobile_phone)
        if mobile_phone_is_verify is not None:
            pulumi.set(__self__, "mobile_phone_is_verify", mobile_phone_is_verify)
        if trn is not None:
            pulumi.set(__self__, "trn", trn)
        if update_date is not None:
            pulumi.set(__self__, "update_date", update_date)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Main account ID to which the sub-user belongs.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="createDate")
    def create_date(self) -> Optional[pulumi.Input[str]]:
        """
        The create date of the user.
        """
        return pulumi.get(self, "create_date")

    @create_date.setter
    def create_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_date", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the user.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the user.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="emailIsVerify")
    def email_is_verify(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the email has been verified.
        """
        return pulumi.get(self, "email_is_verify")

    @email_is_verify.setter
    def email_is_verify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "email_is_verify", value)

    @property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> Optional[pulumi.Input[str]]:
        """
        The mobile phone of the user.
        """
        return pulumi.get(self, "mobile_phone")

    @mobile_phone.setter
    def mobile_phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mobile_phone", value)

    @property
    @pulumi.getter(name="mobilePhoneIsVerify")
    def mobile_phone_is_verify(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the phone number has been verified.
        """
        return pulumi.get(self, "mobile_phone_is_verify")

    @mobile_phone_is_verify.setter
    def mobile_phone_is_verify(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mobile_phone_is_verify", value)

    @property
    @pulumi.getter
    def trn(self) -> Optional[pulumi.Input[str]]:
        """
        The trn of the user.
        """
        return pulumi.get(self, "trn")

    @trn.setter
    def trn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trn", value)

    @property
    @pulumi.getter(name="updateDate")
    def update_date(self) -> Optional[pulumi.Input[str]]:
        """
        The update date of the user.
        """
        return pulumi.get(self, "update_date")

    @update_date.setter
    def update_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_date", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 mobile_phone: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage iam user
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.iam.User("foo",
            description="test",
            display_name="name",
            user_name="tf-test")
        ```

        ## Import

        Iam user can be imported using the UserName, e.g.

        ```sh
         $ pulumi import volcengine:iam/user:User default user_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the user.
        :param pulumi.Input[str] display_name: The display name of the user.
        :param pulumi.Input[str] email: The email of the user.
        :param pulumi.Input[str] mobile_phone: The mobile phone of the user.
        :param pulumi.Input[str] user_name: The name of the user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage iam user
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.iam.User("foo",
            description="test",
            display_name="name",
            user_name="tf-test")
        ```

        ## Import

        Iam user can be imported using the UserName, e.g.

        ```sh
         $ pulumi import volcengine:iam/user:User default user_name
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 mobile_phone: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["email"] = email
            __props__.__dict__["mobile_phone"] = mobile_phone
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["account_id"] = None
            __props__.__dict__["create_date"] = None
            __props__.__dict__["email_is_verify"] = None
            __props__.__dict__["mobile_phone_is_verify"] = None
            __props__.__dict__["trn"] = None
            __props__.__dict__["update_date"] = None
            __props__.__dict__["user_id"] = None
        super(User, __self__).__init__(
            'volcengine:iam/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            create_date: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            email_is_verify: Optional[pulumi.Input[bool]] = None,
            mobile_phone: Optional[pulumi.Input[str]] = None,
            mobile_phone_is_verify: Optional[pulumi.Input[bool]] = None,
            trn: Optional[pulumi.Input[str]] = None,
            update_date: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None,
            user_name: Optional[pulumi.Input[str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Main account ID to which the sub-user belongs.
        :param pulumi.Input[str] create_date: The create date of the user.
        :param pulumi.Input[str] description: The description of the user.
        :param pulumi.Input[str] display_name: The display name of the user.
        :param pulumi.Input[str] email: The email of the user.
        :param pulumi.Input[bool] email_is_verify: Whether the email has been verified.
        :param pulumi.Input[str] mobile_phone: The mobile phone of the user.
        :param pulumi.Input[bool] mobile_phone_is_verify: Whether the phone number has been verified.
        :param pulumi.Input[str] trn: The trn of the user.
        :param pulumi.Input[str] update_date: The update date of the user.
        :param pulumi.Input[str] user_id: The id of the user.
        :param pulumi.Input[str] user_name: The name of the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["create_date"] = create_date
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["email"] = email
        __props__.__dict__["email_is_verify"] = email_is_verify
        __props__.__dict__["mobile_phone"] = mobile_phone
        __props__.__dict__["mobile_phone_is_verify"] = mobile_phone_is_verify
        __props__.__dict__["trn"] = trn
        __props__.__dict__["update_date"] = update_date
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["user_name"] = user_name
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        Main account ID to which the sub-user belongs.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="createDate")
    def create_date(self) -> pulumi.Output[str]:
        """
        The create date of the user.
        """
        return pulumi.get(self, "create_date")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the user.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        The display name of the user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[str]]:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="emailIsVerify")
    def email_is_verify(self) -> pulumi.Output[bool]:
        """
        Whether the email has been verified.
        """
        return pulumi.get(self, "email_is_verify")

    @property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> pulumi.Output[Optional[str]]:
        """
        The mobile phone of the user.
        """
        return pulumi.get(self, "mobile_phone")

    @property
    @pulumi.getter(name="mobilePhoneIsVerify")
    def mobile_phone_is_verify(self) -> pulumi.Output[bool]:
        """
        Whether the phone number has been verified.
        """
        return pulumi.get(self, "mobile_phone_is_verify")

    @property
    @pulumi.getter
    def trn(self) -> pulumi.Output[str]:
        """
        The trn of the user.
        """
        return pulumi.get(self, "trn")

    @property
    @pulumi.getter(name="updateDate")
    def update_date(self) -> pulumi.Output[str]:
        """
        The update date of the user.
        """
        return pulumi.get(self, "update_date")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        The id of the user.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[str]:
        """
        The name of the user.
        """
        return pulumi.get(self, "user_name")

