# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'UserGroupPolicyAttachmentsResult',
    'AwaitableUserGroupPolicyAttachmentsResult',
    'user_group_policy_attachments',
    'user_group_policy_attachments_output',
]

@pulumi.output_type
class UserGroupPolicyAttachmentsResult:
    """
    A collection of values returned by UserGroupPolicyAttachments.
    """
    def __init__(__self__, id=None, output_file=None, policies=None, total_count=None, user_group_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if policies and not isinstance(policies, list):
            raise TypeError("Expected argument 'policies' to be a list")
        pulumi.set(__self__, "policies", policies)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if user_group_name and not isinstance(user_group_name, str):
            raise TypeError("Expected argument 'user_group_name' to be a str")
        pulumi.set(__self__, "user_group_name", user_group_name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.UserGroupPolicyAttachmentsPolicyResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="userGroupName")
    def user_group_name(self) -> str:
        return pulumi.get(self, "user_group_name")


class AwaitableUserGroupPolicyAttachmentsResult(UserGroupPolicyAttachmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return UserGroupPolicyAttachmentsResult(
            id=self.id,
            output_file=self.output_file,
            policies=self.policies,
            total_count=self.total_count,
            user_group_name=self.user_group_name)


def user_group_policy_attachments(output_file: Optional[str] = None,
                                  user_group_name: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableUserGroupPolicyAttachmentsResult:
    """
    Use this data source to query detailed information of iam user group policy attachments
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_policy = volcengine.iam.Policy("fooPolicy",
        policy_name="acc-test-policy",
        description="acc-test",
        policy_document="{\\"Statement\\":[{\\"Effect\\":\\"Allow\\",\\"Action\\":[\\"auto_scaling:DescribeScalingGroups\\"],\\"Resource\\":[\\"*\\"]}]}")
    foo_user_group = volcengine.iam.UserGroup("fooUserGroup",
        user_group_name="acc-test-group",
        description="acc-test",
        display_name="acc-test")
    foo_user_group_policy_attachment = volcengine.iam.UserGroupPolicyAttachment("fooUserGroupPolicyAttachment",
        policy_name=foo_policy.policy_name,
        policy_type="Custom",
        user_group_name=foo_user_group.user_group_name)
    foo_user_group_policy_attachments = volcengine.iam.user_group_policy_attachments_output(user_group_name=foo_user_group_policy_attachment.user_group_name)
    ```


    :param str output_file: File name where to save data source results.
    :param str user_group_name: A name of user group.
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    __args__['userGroupName'] = user_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:iam/userGroupPolicyAttachments:UserGroupPolicyAttachments', __args__, opts=opts, typ=UserGroupPolicyAttachmentsResult).value

    return AwaitableUserGroupPolicyAttachmentsResult(
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        policies=pulumi.get(__ret__, 'policies'),
        total_count=pulumi.get(__ret__, 'total_count'),
        user_group_name=pulumi.get(__ret__, 'user_group_name'))


@_utilities.lift_output_func(user_group_policy_attachments)
def user_group_policy_attachments_output(output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                         user_group_name: Optional[pulumi.Input[str]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[UserGroupPolicyAttachmentsResult]:
    """
    Use this data source to query detailed information of iam user group policy attachments
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_policy = volcengine.iam.Policy("fooPolicy",
        policy_name="acc-test-policy",
        description="acc-test",
        policy_document="{\\"Statement\\":[{\\"Effect\\":\\"Allow\\",\\"Action\\":[\\"auto_scaling:DescribeScalingGroups\\"],\\"Resource\\":[\\"*\\"]}]}")
    foo_user_group = volcengine.iam.UserGroup("fooUserGroup",
        user_group_name="acc-test-group",
        description="acc-test",
        display_name="acc-test")
    foo_user_group_policy_attachment = volcengine.iam.UserGroupPolicyAttachment("fooUserGroupPolicyAttachment",
        policy_name=foo_policy.policy_name,
        policy_type="Custom",
        user_group_name=foo_user_group.user_group_name)
    foo_user_group_policy_attachments = volcengine.iam.user_group_policy_attachments_output(user_group_name=foo_user_group_policy_attachment.user_group_name)
    ```


    :param str output_file: File name where to save data source results.
    :param str user_group_name: A name of user group.
    """
    ...
