# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'UserGroupsResult',
    'AwaitableUserGroupsResult',
    'user_groups',
    'user_groups_output',
]

@pulumi.output_type
class UserGroupsResult:
    """
    A collection of values returned by UserGroups.
    """
    def __init__(__self__, id=None, output_file=None, query=None, total_count=None, user_groups=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if query and not isinstance(query, str):
            raise TypeError("Expected argument 'query' to be a str")
        pulumi.set(__self__, "query", query)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if user_groups and not isinstance(user_groups, list):
            raise TypeError("Expected argument 'user_groups' to be a list")
        pulumi.set(__self__, "user_groups", user_groups)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def query(self) -> Optional[str]:
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> Sequence['outputs.UserGroupsUserGroupResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "user_groups")


class AwaitableUserGroupsResult(UserGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return UserGroupsResult(
            id=self.id,
            output_file=self.output_file,
            query=self.query,
            total_count=self.total_count,
            user_groups=self.user_groups)


def user_groups(output_file: Optional[str] = None,
                query: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableUserGroupsResult:
    """
    Use this data source to query detailed information of iam user groups
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_user_group = volcengine.iam.UserGroup("fooUserGroup",
        description="acc-test",
        display_name="acc-test",
        user_group_name="acc-test-group")
    foo_user_groups = volcengine.iam.user_groups(query="acc-test")
    ```


    :param str output_file: File name where to save data source results.
    :param str query: Fuzzy search, supports searching for user group names, display names, and remarks.
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    __args__['query'] = query
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:iam/userGroups:UserGroups', __args__, opts=opts, typ=UserGroupsResult).value

    return AwaitableUserGroupsResult(
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        query=pulumi.get(__ret__, 'query'),
        total_count=pulumi.get(__ret__, 'total_count'),
        user_groups=pulumi.get(__ret__, 'user_groups'))


@_utilities.lift_output_func(user_groups)
def user_groups_output(output_file: Optional[pulumi.Input[Optional[str]]] = None,
                       query: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[UserGroupsResult]:
    """
    Use this data source to query detailed information of iam user groups
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_user_group = volcengine.iam.UserGroup("fooUserGroup",
        description="acc-test",
        display_name="acc-test",
        user_group_name="acc-test-group")
    foo_user_groups = volcengine.iam.user_groups(query="acc-test")
    ```


    :param str output_file: File name where to save data source results.
    :param str query: Fuzzy search, supports searching for user group names, display names, and remarks.
    """
    ...
