# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['EndpointArgs', 'Endpoint']

@pulumi.input_type
class EndpointArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 eip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mongos_node_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Endpoint resource.
        :param pulumi.Input[str] instance_id: The instance where the endpoint resides.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] eip_ids: A list of EIP IDs that need to be bound when applying for endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mongos_node_ids: A list of the Mongos node that needs to apply for the endpoint.
        :param pulumi.Input[str] network_type: The network type of endpoint.
        :param pulumi.Input[str] object_id: The object ID corresponding to the endpoint.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if eip_ids is not None:
            pulumi.set(__self__, "eip_ids", eip_ids)
        if mongos_node_ids is not None:
            pulumi.set(__self__, "mongos_node_ids", mongos_node_ids)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The instance where the endpoint resides.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="eipIds")
    def eip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of EIP IDs that need to be bound when applying for endpoint.
        """
        return pulumi.get(self, "eip_ids")

    @eip_ids.setter
    def eip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "eip_ids", value)

    @property
    @pulumi.getter(name="mongosNodeIds")
    def mongos_node_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the Mongos node that needs to apply for the endpoint.
        """
        return pulumi.get(self, "mongos_node_ids")

    @mongos_node_ids.setter
    def mongos_node_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mongos_node_ids", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[str]]:
        """
        The network type of endpoint.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        The object ID corresponding to the endpoint.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)


@pulumi.input_type
class _EndpointState:
    def __init__(__self__, *,
                 eip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 mongos_node_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Endpoint resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] eip_ids: A list of EIP IDs that need to be bound when applying for endpoint.
        :param pulumi.Input[str] endpoint_id: The id of endpoint.
        :param pulumi.Input[str] instance_id: The instance where the endpoint resides.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mongos_node_ids: A list of the Mongos node that needs to apply for the endpoint.
        :param pulumi.Input[str] network_type: The network type of endpoint.
        :param pulumi.Input[str] object_id: The object ID corresponding to the endpoint.
        """
        if eip_ids is not None:
            pulumi.set(__self__, "eip_ids", eip_ids)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if mongos_node_ids is not None:
            pulumi.set(__self__, "mongos_node_ids", mongos_node_ids)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @property
    @pulumi.getter(name="eipIds")
    def eip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of EIP IDs that need to be bound when applying for endpoint.
        """
        return pulumi.get(self, "eip_ids")

    @eip_ids.setter
    def eip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "eip_ids", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The instance where the endpoint resides.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="mongosNodeIds")
    def mongos_node_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the Mongos node that needs to apply for the endpoint.
        """
        return pulumi.get(self, "mongos_node_ids")

    @mongos_node_ids.setter
    def mongos_node_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mongos_node_ids", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[str]]:
        """
        The network type of endpoint.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        The object ID corresponding to the endpoint.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)


class Endpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 eip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 mongos_node_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage mongodb endpoint
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_address = []
        for range in [{"value": i} for i in range(0, 2)]:
            foo_address.append(volcengine.eip.Address(f"fooAddress-{range['value']}",
                billing_type="PostPaidByBandwidth",
                bandwidth=1,
                isp="ChinaUnicom",
                description="acc-test",
                project_name="default"))
        replica_set = volcengine.mongodb.Instance("replica-set",
            db_engine_version="MongoDB_4_0",
            instance_type="ReplicaSet",
            super_account_password="@acc-test-123",
            node_spec="mongo.2c4g",
            mongos_node_spec="mongo.mongos.2c4g",
            instance_name="acc-test-mongo-replica",
            charge_type="PostPaid",
            project_name="default",
            mongos_node_number=2,
            shard_number=3,
            storage_space_gb=20,
            subnet_id=foo_subnet.id,
            zone_id=foo_zones.zones[0].id,
            tags=[volcengine.mongodb.InstanceTagArgs(
                key="k1",
                value="v1",
            )])
        replica_set_public_endpoint = volcengine.mongodb.Endpoint("replica-set-public-endpoint",
            instance_id=replica_set.id,
            network_type="Public",
            eip_ids=[__item.id for __item in foo_address])
        sharded_cluster = volcengine.mongodb.Instance("sharded-cluster",
            db_engine_version="MongoDB_4_0",
            instance_type="ShardedCluster",
            super_account_password="@acc-test-123",
            node_spec="mongo.shard.1c2g",
            mongos_node_spec="mongo.mongos.1c2g",
            instance_name="acc-test-mongo-shard",
            charge_type="PostPaid",
            project_name="default",
            mongos_node_number=2,
            shard_number=2,
            storage_space_gb=20,
            subnet_id=foo_subnet.id,
            zone_id=foo_zones.zones[0].id,
            tags=[volcengine.mongodb.InstanceTagArgs(
                key="k1",
                value="v1",
            )])
        sharded_cluster_private_endpoint = volcengine.mongodb.Endpoint("sharded-cluster-private-endpoint",
            instance_id=sharded_cluster.id,
            network_type="Private",
            object_id=sharded_cluster.shards[0].shard_id)
        ```

        ## Import

        mongodb endpoint can be imported using the instanceId:endpointId `instanceId`represents the instance that endpoint related to. `endpointId`the id of endpoint. e.g.

        ```sh
         $ pulumi import volcengine:mongodb/endpoint:Endpoint default mongo-replica-e405f8e2****:BRhFA0pDAk0XXkxCZQ
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] eip_ids: A list of EIP IDs that need to be bound when applying for endpoint.
        :param pulumi.Input[str] instance_id: The instance where the endpoint resides.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mongos_node_ids: A list of the Mongos node that needs to apply for the endpoint.
        :param pulumi.Input[str] network_type: The network type of endpoint.
        :param pulumi.Input[str] object_id: The object ID corresponding to the endpoint.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage mongodb endpoint
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_address = []
        for range in [{"value": i} for i in range(0, 2)]:
            foo_address.append(volcengine.eip.Address(f"fooAddress-{range['value']}",
                billing_type="PostPaidByBandwidth",
                bandwidth=1,
                isp="ChinaUnicom",
                description="acc-test",
                project_name="default"))
        replica_set = volcengine.mongodb.Instance("replica-set",
            db_engine_version="MongoDB_4_0",
            instance_type="ReplicaSet",
            super_account_password="@acc-test-123",
            node_spec="mongo.2c4g",
            mongos_node_spec="mongo.mongos.2c4g",
            instance_name="acc-test-mongo-replica",
            charge_type="PostPaid",
            project_name="default",
            mongos_node_number=2,
            shard_number=3,
            storage_space_gb=20,
            subnet_id=foo_subnet.id,
            zone_id=foo_zones.zones[0].id,
            tags=[volcengine.mongodb.InstanceTagArgs(
                key="k1",
                value="v1",
            )])
        replica_set_public_endpoint = volcengine.mongodb.Endpoint("replica-set-public-endpoint",
            instance_id=replica_set.id,
            network_type="Public",
            eip_ids=[__item.id for __item in foo_address])
        sharded_cluster = volcengine.mongodb.Instance("sharded-cluster",
            db_engine_version="MongoDB_4_0",
            instance_type="ShardedCluster",
            super_account_password="@acc-test-123",
            node_spec="mongo.shard.1c2g",
            mongos_node_spec="mongo.mongos.1c2g",
            instance_name="acc-test-mongo-shard",
            charge_type="PostPaid",
            project_name="default",
            mongos_node_number=2,
            shard_number=2,
            storage_space_gb=20,
            subnet_id=foo_subnet.id,
            zone_id=foo_zones.zones[0].id,
            tags=[volcengine.mongodb.InstanceTagArgs(
                key="k1",
                value="v1",
            )])
        sharded_cluster_private_endpoint = volcengine.mongodb.Endpoint("sharded-cluster-private-endpoint",
            instance_id=sharded_cluster.id,
            network_type="Private",
            object_id=sharded_cluster.shards[0].shard_id)
        ```

        ## Import

        mongodb endpoint can be imported using the instanceId:endpointId `instanceId`represents the instance that endpoint related to. `endpointId`the id of endpoint. e.g.

        ```sh
         $ pulumi import volcengine:mongodb/endpoint:Endpoint default mongo-replica-e405f8e2****:BRhFA0pDAk0XXkxCZQ
        ```

        :param str resource_name: The name of the resource.
        :param EndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 eip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 mongos_node_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointArgs.__new__(EndpointArgs)

            __props__.__dict__["eip_ids"] = eip_ids
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["mongos_node_ids"] = mongos_node_ids
            __props__.__dict__["network_type"] = network_type
            __props__.__dict__["object_id"] = object_id
            __props__.__dict__["endpoint_id"] = None
        super(Endpoint, __self__).__init__(
            'volcengine:mongodb/endpoint:Endpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            eip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            endpoint_id: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            mongos_node_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            network_type: Optional[pulumi.Input[str]] = None,
            object_id: Optional[pulumi.Input[str]] = None) -> 'Endpoint':
        """
        Get an existing Endpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] eip_ids: A list of EIP IDs that need to be bound when applying for endpoint.
        :param pulumi.Input[str] endpoint_id: The id of endpoint.
        :param pulumi.Input[str] instance_id: The instance where the endpoint resides.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mongos_node_ids: A list of the Mongos node that needs to apply for the endpoint.
        :param pulumi.Input[str] network_type: The network type of endpoint.
        :param pulumi.Input[str] object_id: The object ID corresponding to the endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointState.__new__(_EndpointState)

        __props__.__dict__["eip_ids"] = eip_ids
        __props__.__dict__["endpoint_id"] = endpoint_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["mongos_node_ids"] = mongos_node_ids
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["object_id"] = object_id
        return Endpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="eipIds")
    def eip_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of EIP IDs that need to be bound when applying for endpoint.
        """
        return pulumi.get(self, "eip_ids")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> pulumi.Output[str]:
        """
        The id of endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The instance where the endpoint resides.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="mongosNodeIds")
    def mongos_node_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of the Mongos node that needs to apply for the endpoint.
        """
        return pulumi.get(self, "mongos_node_ids")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[Optional[str]]:
        """
        The network type of endpoint.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[str]:
        """
        The object ID corresponding to the endpoint.
        """
        return pulumi.get(self, "object_id")

