# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'EndpointsResult',
    'AwaitableEndpointsResult',
    'endpoints',
    'endpoints_output',
]

@pulumi.output_type
class EndpointsResult:
    """
    A collection of values returned by Endpoints.
    """
    def __init__(__self__, endpoints=None, id=None, instance_id=None, output_file=None, total_count=None):
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.EndpointsEndpointResult']:
        """
        The collection of mongodb endpoints query.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of mongodb endpoint query.
        """
        return pulumi.get(self, "total_count")


class AwaitableEndpointsResult(EndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return EndpointsResult(
            endpoints=self.endpoints,
            id=self.id,
            instance_id=self.instance_id,
            output_file=self.output_file,
            total_count=self.total_count)


def endpoints(instance_id: Optional[str] = None,
              output_file: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableEndpointsResult:
    """
    Use this data source to query detailed information of mongodb endpoints
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_instance = volcengine.mongodb.Instance("fooInstance",
        db_engine_version="MongoDB_4_0",
        instance_type="ShardedCluster",
        super_account_password="@acc-test-123",
        node_spec="mongo.shard.1c2g",
        mongos_node_spec="mongo.mongos.1c2g",
        instance_name="acc-test-mongo-shard",
        charge_type="PostPaid",
        project_name="default",
        mongos_node_number=2,
        shard_number=2,
        storage_space_gb=20,
        subnet_id=foo_subnet.id,
        zone_id=foo_zones.zones[0].id,
        tags=[volcengine.mongodb.InstanceTagArgs(
            key="k1",
            value="v1",
        )])
    foo_address = []
    for range in [{"value": i} for i in range(0, 2)]:
        foo_address.append(volcengine.eip.Address(f"fooAddress-{range['value']}",
            billing_type="PostPaidByBandwidth",
            bandwidth=1,
            isp="ChinaUnicom",
            description="acc-test",
            project_name="default"))
    foo_public = volcengine.mongodb.Endpoint("fooPublic",
        instance_id=foo_instance.id,
        network_type="Public",
        object_id=foo_instance.mongos_id,
        mongos_node_ids=[
            foo_instance.mongos[0].mongos_node_id,
            foo_instance.mongos[1].mongos_node_id,
        ],
        eip_ids=[__item.id for __item in foo_address])
    foo_private = volcengine.mongodb.Endpoint("fooPrivate",
        instance_id=foo_instance.id,
        network_type="Private",
        object_id=foo_instance.config_servers_id)
    foo_endpoints = volcengine.mongodb.endpoints_output(instance_id=foo_instance.id)
    ```


    :param str instance_id: The instance ID to query.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:mongodb/endpoints:Endpoints', __args__, opts=opts, typ=EndpointsResult).value

    return AwaitableEndpointsResult(
        endpoints=pulumi.get(__ret__, 'endpoints'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(endpoints)
def endpoints_output(instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[EndpointsResult]:
    """
    Use this data source to query detailed information of mongodb endpoints
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_instance = volcengine.mongodb.Instance("fooInstance",
        db_engine_version="MongoDB_4_0",
        instance_type="ShardedCluster",
        super_account_password="@acc-test-123",
        node_spec="mongo.shard.1c2g",
        mongos_node_spec="mongo.mongos.1c2g",
        instance_name="acc-test-mongo-shard",
        charge_type="PostPaid",
        project_name="default",
        mongos_node_number=2,
        shard_number=2,
        storage_space_gb=20,
        subnet_id=foo_subnet.id,
        zone_id=foo_zones.zones[0].id,
        tags=[volcengine.mongodb.InstanceTagArgs(
            key="k1",
            value="v1",
        )])
    foo_address = []
    for range in [{"value": i} for i in range(0, 2)]:
        foo_address.append(volcengine.eip.Address(f"fooAddress-{range['value']}",
            billing_type="PostPaidByBandwidth",
            bandwidth=1,
            isp="ChinaUnicom",
            description="acc-test",
            project_name="default"))
    foo_public = volcengine.mongodb.Endpoint("fooPublic",
        instance_id=foo_instance.id,
        network_type="Public",
        object_id=foo_instance.mongos_id,
        mongos_node_ids=[
            foo_instance.mongos[0].mongos_node_id,
            foo_instance.mongos[1].mongos_node_id,
        ],
        eip_ids=[__item.id for __item in foo_address])
    foo_private = volcengine.mongodb.Endpoint("fooPrivate",
        instance_id=foo_instance.id,
        network_type="Private",
        object_id=foo_instance.config_servers_id)
    foo_endpoints = volcengine.mongodb.endpoints_output(instance_id=foo_instance.id)
    ```


    :param str instance_id: The instance ID to query.
    :param str output_file: File name where to save data source results.
    """
    ...
