# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 node_spec: pulumi.Input[str],
                 storage_space_gb: pulumi.Input[int],
                 subnet_id: pulumi.Input[str],
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 charge_type: Optional[pulumi.Input[str]] = None,
                 db_engine_version: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 mongos_node_number: Optional[pulumi.Input[int]] = None,
                 mongos_node_spec: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 shard_number: Optional[pulumi.Input[int]] = None,
                 super_account_password: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] node_spec: The spec of node.
        :param pulumi.Input[int] storage_space_gb: The total storage space of a replica set instance, or the storage space of a single shard in a sharded cluster, in GiB.
        :param pulumi.Input[str] subnet_id: The subnet id of instance.
        :param pulumi.Input[bool] auto_renew: Whether to enable automatic renewal.
        :param pulumi.Input[str] charge_type: The charge type of instance, valid value contains `Prepaid` or `PostPaid`.
        :param pulumi.Input[str] db_engine_version: The version of db engine, valid value contains `MongoDB_4_0`, `MongoDB_5_0`.
        :param pulumi.Input[str] instance_name: The instance name.
        :param pulumi.Input[str] instance_type: The type of instance,the valid value contains `ReplicaSet` or `ShardedCluster`.
        :param pulumi.Input[int] mongos_node_number: The mongos node number of shard cluster,value range is `2~23`, this parameter is required when `InstanceType` is `ShardedCluster`.
        :param pulumi.Input[str] mongos_node_spec: The mongos node spec of shard cluster, this parameter is required when `InstanceType` is `ShardedCluster`.
        :param pulumi.Input[int] period: The instance purchase duration,the value range is `1~3` when `PeriodUtil` is `Year`, the value range is `1~9` when `PeriodUtil` is `Month`, this parameter is required when `ChargeType` is `Prepaid`.
        :param pulumi.Input[str] period_unit: The period unit,valid value contains `Year` or `Month`, this parameter is required when `ChargeType` is `Prepaid`.
        :param pulumi.Input[str] project_name: The project name to which the instance belongs.
        :param pulumi.Input[int] shard_number: The number of shards in shard cluster,value range is `2~32`, this parameter is required when `InstanceType` is `ShardedCluster`.
        :param pulumi.Input[str] super_account_password: The password of database account.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]] tags: Tags.
        :param pulumi.Input[str] vpc_id: The vpc ID.
        :param pulumi.Input[str] zone_id: The zone ID of instance.
        """
        pulumi.set(__self__, "node_spec", node_spec)
        pulumi.set(__self__, "storage_space_gb", storage_space_gb)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charge_type is not None:
            pulumi.set(__self__, "charge_type", charge_type)
        if db_engine_version is not None:
            pulumi.set(__self__, "db_engine_version", db_engine_version)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if mongos_node_number is not None:
            pulumi.set(__self__, "mongos_node_number", mongos_node_number)
        if mongos_node_spec is not None:
            pulumi.set(__self__, "mongos_node_spec", mongos_node_spec)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if shard_number is not None:
            pulumi.set(__self__, "shard_number", shard_number)
        if super_account_password is not None:
            pulumi.set(__self__, "super_account_password", super_account_password)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> pulumi.Input[str]:
        """
        The spec of node.
        """
        return pulumi.get(self, "node_spec")

    @node_spec.setter
    def node_spec(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_spec", value)

    @property
    @pulumi.getter(name="storageSpaceGb")
    def storage_space_gb(self) -> pulumi.Input[int]:
        """
        The total storage space of a replica set instance, or the storage space of a single shard in a sharded cluster, in GiB.
        """
        return pulumi.get(self, "storage_space_gb")

    @storage_space_gb.setter
    def storage_space_gb(self, value: pulumi.Input[int]):
        pulumi.set(self, "storage_space_gb", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The subnet id of instance.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable automatic renewal.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The charge type of instance, valid value contains `Prepaid` or `PostPaid`.
        """
        return pulumi.get(self, "charge_type")

    @charge_type.setter
    def charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charge_type", value)

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of db engine, valid value contains `MongoDB_4_0`, `MongoDB_5_0`.
        """
        return pulumi.get(self, "db_engine_version")

    @db_engine_version.setter
    def db_engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_engine_version", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The instance name.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of instance,the valid value contains `ReplicaSet` or `ShardedCluster`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="mongosNodeNumber")
    def mongos_node_number(self) -> Optional[pulumi.Input[int]]:
        """
        The mongos node number of shard cluster,value range is `2~23`, this parameter is required when `InstanceType` is `ShardedCluster`.
        """
        return pulumi.get(self, "mongos_node_number")

    @mongos_node_number.setter
    def mongos_node_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mongos_node_number", value)

    @property
    @pulumi.getter(name="mongosNodeSpec")
    def mongos_node_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The mongos node spec of shard cluster, this parameter is required when `InstanceType` is `ShardedCluster`.
        """
        return pulumi.get(self, "mongos_node_spec")

    @mongos_node_spec.setter
    def mongos_node_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mongos_node_spec", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The instance purchase duration,the value range is `1~3` when `PeriodUtil` is `Year`, the value range is `1~9` when `PeriodUtil` is `Month`, this parameter is required when `ChargeType` is `Prepaid`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The period unit,valid value contains `Year` or `Month`, this parameter is required when `ChargeType` is `Prepaid`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name to which the instance belongs.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="shardNumber")
    def shard_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of shards in shard cluster,value range is `2~32`, this parameter is required when `InstanceType` is `ShardedCluster`.
        """
        return pulumi.get(self, "shard_number")

    @shard_number.setter
    def shard_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shard_number", value)

    @property
    @pulumi.getter(name="superAccountPassword")
    def super_account_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of database account.
        """
        return pulumi.get(self, "super_account_password")

    @super_account_password.setter
    def super_account_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "super_account_password", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vpc ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID of instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 charge_type: Optional[pulumi.Input[str]] = None,
                 config_servers_id: Optional[pulumi.Input[str]] = None,
                 db_engine_version: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 mongos: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMongoArgs']]]] = None,
                 mongos_id: Optional[pulumi.Input[str]] = None,
                 mongos_node_number: Optional[pulumi.Input[int]] = None,
                 mongos_node_spec: Optional[pulumi.Input[str]] = None,
                 node_spec: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 shard_number: Optional[pulumi.Input[int]] = None,
                 shards: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceShardArgs']]]] = None,
                 storage_space_gb: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 super_account_password: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[bool] auto_renew: Whether to enable automatic renewal.
        :param pulumi.Input[str] charge_type: The charge type of instance, valid value contains `Prepaid` or `PostPaid`.
        :param pulumi.Input[str] config_servers_id: The config servers id of the ShardedCluster instance.
        :param pulumi.Input[str] db_engine_version: The version of db engine, valid value contains `MongoDB_4_0`, `MongoDB_5_0`.
        :param pulumi.Input[str] instance_name: The instance name.
        :param pulumi.Input[str] instance_type: The type of instance,the valid value contains `ReplicaSet` or `ShardedCluster`.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceMongoArgs']]] mongos: The mongos information of the ShardedCluster instance.
        :param pulumi.Input[str] mongos_id: The mongos id of the ShardedCluster instance.
        :param pulumi.Input[int] mongos_node_number: The mongos node number of shard cluster,value range is `2~23`, this parameter is required when `InstanceType` is `ShardedCluster`.
        :param pulumi.Input[str] mongos_node_spec: The mongos node spec of shard cluster, this parameter is required when `InstanceType` is `ShardedCluster`.
        :param pulumi.Input[str] node_spec: The spec of node.
        :param pulumi.Input[int] period: The instance purchase duration,the value range is `1~3` when `PeriodUtil` is `Year`, the value range is `1~9` when `PeriodUtil` is `Month`, this parameter is required when `ChargeType` is `Prepaid`.
        :param pulumi.Input[str] period_unit: The period unit,valid value contains `Year` or `Month`, this parameter is required when `ChargeType` is `Prepaid`.
        :param pulumi.Input[str] project_name: The project name to which the instance belongs.
        :param pulumi.Input[int] shard_number: The number of shards in shard cluster,value range is `2~32`, this parameter is required when `InstanceType` is `ShardedCluster`.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceShardArgs']]] shards: The shards information of the ShardedCluster instance.
        :param pulumi.Input[int] storage_space_gb: The total storage space of a replica set instance, or the storage space of a single shard in a sharded cluster, in GiB.
        :param pulumi.Input[str] subnet_id: The subnet id of instance.
        :param pulumi.Input[str] super_account_password: The password of database account.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]] tags: Tags.
        :param pulumi.Input[str] vpc_id: The vpc ID.
        :param pulumi.Input[str] zone_id: The zone ID of instance.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charge_type is not None:
            pulumi.set(__self__, "charge_type", charge_type)
        if config_servers_id is not None:
            pulumi.set(__self__, "config_servers_id", config_servers_id)
        if db_engine_version is not None:
            pulumi.set(__self__, "db_engine_version", db_engine_version)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if mongos is not None:
            pulumi.set(__self__, "mongos", mongos)
        if mongos_id is not None:
            pulumi.set(__self__, "mongos_id", mongos_id)
        if mongos_node_number is not None:
            pulumi.set(__self__, "mongos_node_number", mongos_node_number)
        if mongos_node_spec is not None:
            pulumi.set(__self__, "mongos_node_spec", mongos_node_spec)
        if node_spec is not None:
            pulumi.set(__self__, "node_spec", node_spec)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if shard_number is not None:
            pulumi.set(__self__, "shard_number", shard_number)
        if shards is not None:
            pulumi.set(__self__, "shards", shards)
        if storage_space_gb is not None:
            pulumi.set(__self__, "storage_space_gb", storage_space_gb)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if super_account_password is not None:
            pulumi.set(__self__, "super_account_password", super_account_password)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable automatic renewal.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The charge type of instance, valid value contains `Prepaid` or `PostPaid`.
        """
        return pulumi.get(self, "charge_type")

    @charge_type.setter
    def charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charge_type", value)

    @property
    @pulumi.getter(name="configServersId")
    def config_servers_id(self) -> Optional[pulumi.Input[str]]:
        """
        The config servers id of the ShardedCluster instance.
        """
        return pulumi.get(self, "config_servers_id")

    @config_servers_id.setter
    def config_servers_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_servers_id", value)

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of db engine, valid value contains `MongoDB_4_0`, `MongoDB_5_0`.
        """
        return pulumi.get(self, "db_engine_version")

    @db_engine_version.setter
    def db_engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_engine_version", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The instance name.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of instance,the valid value contains `ReplicaSet` or `ShardedCluster`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter
    def mongos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMongoArgs']]]]:
        """
        The mongos information of the ShardedCluster instance.
        """
        return pulumi.get(self, "mongos")

    @mongos.setter
    def mongos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMongoArgs']]]]):
        pulumi.set(self, "mongos", value)

    @property
    @pulumi.getter(name="mongosId")
    def mongos_id(self) -> Optional[pulumi.Input[str]]:
        """
        The mongos id of the ShardedCluster instance.
        """
        return pulumi.get(self, "mongos_id")

    @mongos_id.setter
    def mongos_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mongos_id", value)

    @property
    @pulumi.getter(name="mongosNodeNumber")
    def mongos_node_number(self) -> Optional[pulumi.Input[int]]:
        """
        The mongos node number of shard cluster,value range is `2~23`, this parameter is required when `InstanceType` is `ShardedCluster`.
        """
        return pulumi.get(self, "mongos_node_number")

    @mongos_node_number.setter
    def mongos_node_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mongos_node_number", value)

    @property
    @pulumi.getter(name="mongosNodeSpec")
    def mongos_node_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The mongos node spec of shard cluster, this parameter is required when `InstanceType` is `ShardedCluster`.
        """
        return pulumi.get(self, "mongos_node_spec")

    @mongos_node_spec.setter
    def mongos_node_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mongos_node_spec", value)

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The spec of node.
        """
        return pulumi.get(self, "node_spec")

    @node_spec.setter
    def node_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_spec", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The instance purchase duration,the value range is `1~3` when `PeriodUtil` is `Year`, the value range is `1~9` when `PeriodUtil` is `Month`, this parameter is required when `ChargeType` is `Prepaid`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The period unit,valid value contains `Year` or `Month`, this parameter is required when `ChargeType` is `Prepaid`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name to which the instance belongs.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="shardNumber")
    def shard_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of shards in shard cluster,value range is `2~32`, this parameter is required when `InstanceType` is `ShardedCluster`.
        """
        return pulumi.get(self, "shard_number")

    @shard_number.setter
    def shard_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shard_number", value)

    @property
    @pulumi.getter
    def shards(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceShardArgs']]]]:
        """
        The shards information of the ShardedCluster instance.
        """
        return pulumi.get(self, "shards")

    @shards.setter
    def shards(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceShardArgs']]]]):
        pulumi.set(self, "shards", value)

    @property
    @pulumi.getter(name="storageSpaceGb")
    def storage_space_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The total storage space of a replica set instance, or the storage space of a single shard in a sharded cluster, in GiB.
        """
        return pulumi.get(self, "storage_space_gb")

    @storage_space_gb.setter
    def storage_space_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_space_gb", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet id of instance.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="superAccountPassword")
    def super_account_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of database account.
        """
        return pulumi.get(self, "super_account_password")

    @super_account_password.setter
    def super_account_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "super_account_password", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vpc ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID of instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 charge_type: Optional[pulumi.Input[str]] = None,
                 db_engine_version: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 mongos_node_number: Optional[pulumi.Input[int]] = None,
                 mongos_node_spec: Optional[pulumi.Input[str]] = None,
                 node_spec: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 shard_number: Optional[pulumi.Input[int]] = None,
                 storage_space_gb: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 super_account_password: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTagArgs']]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.mongodb.Instance("foo",
            charge_type="PostPaid",
            db_engine_version="MongoDB_4_0",
            instance_name="mongo-replica-be9995d32e4a",
            instance_type="ReplicaSet",
            node_spec="mongo.2c4g",
            project_name="default",
            storage_space_gb=20,
            subnet_id="subnet-rrx4ns6abw1sv0x57wq6h47",
            super_account_password="******",
            tags=[volcengine.mongodb.InstanceTagArgs(
                key="k1",
                value="v1",
            )],
            zone_id="cn-beijing-a")
        ```

        ## Import

        mongodb instance can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:mongodb/instance:Instance default mongo-replica-e405f8e2****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_renew: Whether to enable automatic renewal.
        :param pulumi.Input[str] charge_type: The charge type of instance, valid value contains `Prepaid` or `PostPaid`.
        :param pulumi.Input[str] db_engine_version: The version of db engine, valid value contains `MongoDB_4_0`, `MongoDB_5_0`.
        :param pulumi.Input[str] instance_name: The instance name.
        :param pulumi.Input[str] instance_type: The type of instance,the valid value contains `ReplicaSet` or `ShardedCluster`.
        :param pulumi.Input[int] mongos_node_number: The mongos node number of shard cluster,value range is `2~23`, this parameter is required when `InstanceType` is `ShardedCluster`.
        :param pulumi.Input[str] mongos_node_spec: The mongos node spec of shard cluster, this parameter is required when `InstanceType` is `ShardedCluster`.
        :param pulumi.Input[str] node_spec: The spec of node.
        :param pulumi.Input[int] period: The instance purchase duration,the value range is `1~3` when `PeriodUtil` is `Year`, the value range is `1~9` when `PeriodUtil` is `Month`, this parameter is required when `ChargeType` is `Prepaid`.
        :param pulumi.Input[str] period_unit: The period unit,valid value contains `Year` or `Month`, this parameter is required when `ChargeType` is `Prepaid`.
        :param pulumi.Input[str] project_name: The project name to which the instance belongs.
        :param pulumi.Input[int] shard_number: The number of shards in shard cluster,value range is `2~32`, this parameter is required when `InstanceType` is `ShardedCluster`.
        :param pulumi.Input[int] storage_space_gb: The total storage space of a replica set instance, or the storage space of a single shard in a sharded cluster, in GiB.
        :param pulumi.Input[str] subnet_id: The subnet id of instance.
        :param pulumi.Input[str] super_account_password: The password of database account.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTagArgs']]]] tags: Tags.
        :param pulumi.Input[str] vpc_id: The vpc ID.
        :param pulumi.Input[str] zone_id: The zone ID of instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.mongodb.Instance("foo",
            charge_type="PostPaid",
            db_engine_version="MongoDB_4_0",
            instance_name="mongo-replica-be9995d32e4a",
            instance_type="ReplicaSet",
            node_spec="mongo.2c4g",
            project_name="default",
            storage_space_gb=20,
            subnet_id="subnet-rrx4ns6abw1sv0x57wq6h47",
            super_account_password="******",
            tags=[volcengine.mongodb.InstanceTagArgs(
                key="k1",
                value="v1",
            )],
            zone_id="cn-beijing-a")
        ```

        ## Import

        mongodb instance can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:mongodb/instance:Instance default mongo-replica-e405f8e2****
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 charge_type: Optional[pulumi.Input[str]] = None,
                 db_engine_version: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 mongos_node_number: Optional[pulumi.Input[int]] = None,
                 mongos_node_spec: Optional[pulumi.Input[str]] = None,
                 node_spec: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 shard_number: Optional[pulumi.Input[int]] = None,
                 storage_space_gb: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 super_account_password: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTagArgs']]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["charge_type"] = charge_type
            __props__.__dict__["db_engine_version"] = db_engine_version
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["mongos_node_number"] = mongos_node_number
            __props__.__dict__["mongos_node_spec"] = mongos_node_spec
            if node_spec is None and not opts.urn:
                raise TypeError("Missing required property 'node_spec'")
            __props__.__dict__["node_spec"] = node_spec
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["shard_number"] = shard_number
            if storage_space_gb is None and not opts.urn:
                raise TypeError("Missing required property 'storage_space_gb'")
            __props__.__dict__["storage_space_gb"] = storage_space_gb
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["super_account_password"] = None if super_account_password is None else pulumi.Output.secret(super_account_password)
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["config_servers_id"] = None
            __props__.__dict__["mongos"] = None
            __props__.__dict__["mongos_id"] = None
            __props__.__dict__["shards"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["superAccountPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'volcengine:mongodb/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            charge_type: Optional[pulumi.Input[str]] = None,
            config_servers_id: Optional[pulumi.Input[str]] = None,
            db_engine_version: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            mongos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceMongoArgs']]]]] = None,
            mongos_id: Optional[pulumi.Input[str]] = None,
            mongos_node_number: Optional[pulumi.Input[int]] = None,
            mongos_node_spec: Optional[pulumi.Input[str]] = None,
            node_spec: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            shard_number: Optional[pulumi.Input[int]] = None,
            shards: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceShardArgs']]]]] = None,
            storage_space_gb: Optional[pulumi.Input[int]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            super_account_password: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTagArgs']]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_renew: Whether to enable automatic renewal.
        :param pulumi.Input[str] charge_type: The charge type of instance, valid value contains `Prepaid` or `PostPaid`.
        :param pulumi.Input[str] config_servers_id: The config servers id of the ShardedCluster instance.
        :param pulumi.Input[str] db_engine_version: The version of db engine, valid value contains `MongoDB_4_0`, `MongoDB_5_0`.
        :param pulumi.Input[str] instance_name: The instance name.
        :param pulumi.Input[str] instance_type: The type of instance,the valid value contains `ReplicaSet` or `ShardedCluster`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceMongoArgs']]]] mongos: The mongos information of the ShardedCluster instance.
        :param pulumi.Input[str] mongos_id: The mongos id of the ShardedCluster instance.
        :param pulumi.Input[int] mongos_node_number: The mongos node number of shard cluster,value range is `2~23`, this parameter is required when `InstanceType` is `ShardedCluster`.
        :param pulumi.Input[str] mongos_node_spec: The mongos node spec of shard cluster, this parameter is required when `InstanceType` is `ShardedCluster`.
        :param pulumi.Input[str] node_spec: The spec of node.
        :param pulumi.Input[int] period: The instance purchase duration,the value range is `1~3` when `PeriodUtil` is `Year`, the value range is `1~9` when `PeriodUtil` is `Month`, this parameter is required when `ChargeType` is `Prepaid`.
        :param pulumi.Input[str] period_unit: The period unit,valid value contains `Year` or `Month`, this parameter is required when `ChargeType` is `Prepaid`.
        :param pulumi.Input[str] project_name: The project name to which the instance belongs.
        :param pulumi.Input[int] shard_number: The number of shards in shard cluster,value range is `2~32`, this parameter is required when `InstanceType` is `ShardedCluster`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceShardArgs']]]] shards: The shards information of the ShardedCluster instance.
        :param pulumi.Input[int] storage_space_gb: The total storage space of a replica set instance, or the storage space of a single shard in a sharded cluster, in GiB.
        :param pulumi.Input[str] subnet_id: The subnet id of instance.
        :param pulumi.Input[str] super_account_password: The password of database account.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTagArgs']]]] tags: Tags.
        :param pulumi.Input[str] vpc_id: The vpc ID.
        :param pulumi.Input[str] zone_id: The zone ID of instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["charge_type"] = charge_type
        __props__.__dict__["config_servers_id"] = config_servers_id
        __props__.__dict__["db_engine_version"] = db_engine_version
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["mongos"] = mongos
        __props__.__dict__["mongos_id"] = mongos_id
        __props__.__dict__["mongos_node_number"] = mongos_node_number
        __props__.__dict__["mongos_node_spec"] = mongos_node_spec
        __props__.__dict__["node_spec"] = node_spec
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["shard_number"] = shard_number
        __props__.__dict__["shards"] = shards
        __props__.__dict__["storage_space_gb"] = storage_space_gb
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["super_account_password"] = super_account_password
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["zone_id"] = zone_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[bool]:
        """
        Whether to enable automatic renewal.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> pulumi.Output[str]:
        """
        The charge type of instance, valid value contains `Prepaid` or `PostPaid`.
        """
        return pulumi.get(self, "charge_type")

    @property
    @pulumi.getter(name="configServersId")
    def config_servers_id(self) -> pulumi.Output[str]:
        """
        The config servers id of the ShardedCluster instance.
        """
        return pulumi.get(self, "config_servers_id")

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> pulumi.Output[str]:
        """
        The version of db engine, valid value contains `MongoDB_4_0`, `MongoDB_5_0`.
        """
        return pulumi.get(self, "db_engine_version")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[str]:
        """
        The instance name.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        The type of instance,the valid value contains `ReplicaSet` or `ShardedCluster`.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def mongos(self) -> pulumi.Output[Sequence['outputs.InstanceMongo']]:
        """
        The mongos information of the ShardedCluster instance.
        """
        return pulumi.get(self, "mongos")

    @property
    @pulumi.getter(name="mongosId")
    def mongos_id(self) -> pulumi.Output[str]:
        """
        The mongos id of the ShardedCluster instance.
        """
        return pulumi.get(self, "mongos_id")

    @property
    @pulumi.getter(name="mongosNodeNumber")
    def mongos_node_number(self) -> pulumi.Output[Optional[int]]:
        """
        The mongos node number of shard cluster,value range is `2~23`, this parameter is required when `InstanceType` is `ShardedCluster`.
        """
        return pulumi.get(self, "mongos_node_number")

    @property
    @pulumi.getter(name="mongosNodeSpec")
    def mongos_node_spec(self) -> pulumi.Output[Optional[str]]:
        """
        The mongos node spec of shard cluster, this parameter is required when `InstanceType` is `ShardedCluster`.
        """
        return pulumi.get(self, "mongos_node_spec")

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> pulumi.Output[str]:
        """
        The spec of node.
        """
        return pulumi.get(self, "node_spec")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[int]:
        """
        The instance purchase duration,the value range is `1~3` when `PeriodUtil` is `Year`, the value range is `1~9` when `PeriodUtil` is `Month`, this parameter is required when `ChargeType` is `Prepaid`.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[str]:
        """
        The period unit,valid value contains `Year` or `Month`, this parameter is required when `ChargeType` is `Prepaid`.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The project name to which the instance belongs.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="shardNumber")
    def shard_number(self) -> pulumi.Output[Optional[int]]:
        """
        The number of shards in shard cluster,value range is `2~32`, this parameter is required when `InstanceType` is `ShardedCluster`.
        """
        return pulumi.get(self, "shard_number")

    @property
    @pulumi.getter
    def shards(self) -> pulumi.Output[Sequence['outputs.InstanceShard']]:
        """
        The shards information of the ShardedCluster instance.
        """
        return pulumi.get(self, "shards")

    @property
    @pulumi.getter(name="storageSpaceGb")
    def storage_space_gb(self) -> pulumi.Output[int]:
        """
        The total storage space of a replica set instance, or the storage space of a single shard in a sharded cluster, in GiB.
        """
        return pulumi.get(self, "storage_space_gb")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The subnet id of instance.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="superAccountPassword")
    def super_account_password(self) -> pulumi.Output[Optional[str]]:
        """
        The password of database account.
        """
        return pulumi.get(self, "super_account_password")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceTag']]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The vpc ID.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone ID of instance.
        """
        return pulumi.get(self, "zone_id")

