# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'InstanceParametersResult',
    'AwaitableInstanceParametersResult',
    'instance_parameters',
    'instance_parameters_output',
]

@pulumi.output_type
class InstanceParametersResult:
    """
    A collection of values returned by InstanceParameters.
    """
    def __init__(__self__, id=None, instance_id=None, instance_parameters=None, output_file=None, parameter_names=None, parameter_role=None, parameters=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if instance_parameters and not isinstance(instance_parameters, list):
            raise TypeError("Expected argument 'instance_parameters' to be a list")
        pulumi.set(__self__, "instance_parameters", instance_parameters)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if parameter_names and not isinstance(parameter_names, str):
            raise TypeError("Expected argument 'parameter_names' to be a str")
        pulumi.set(__self__, "parameter_names", parameter_names)
        if parameter_role and not isinstance(parameter_role, str):
            raise TypeError("Expected argument 'parameter_role' to be a str")
        pulumi.set(__self__, "parameter_role", parameter_role)
        if parameters and not isinstance(parameters, list):
            raise TypeError("Expected argument 'parameters' to be a list")
        pulumi.set(__self__, "parameters", parameters)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The instance ID.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceParameters")
    def instance_parameters(self) -> Sequence['outputs.InstanceParametersInstanceParameterResult']:
        """
        The list of parameters.
        """
        return pulumi.get(self, "instance_parameters")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="parameterNames")
    def parameter_names(self) -> Optional[str]:
        return pulumi.get(self, "parameter_names")

    @property
    @pulumi.getter(name="parameterRole")
    def parameter_role(self) -> Optional[str]:
        """
        The node type to which the parameter belongs.
        """
        return pulumi.get(self, "parameter_role")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.InstanceParametersParameterResult']:
        """
        (**Deprecated**) This field has been deprecated and it is recommended to use instance_parameters. The collection of parameter query.
        """
        warnings.warn("""This field has been deprecated and it is recommended to use instance_parameters.""", DeprecationWarning)
        pulumi.log.warn("""parameters is deprecated: This field has been deprecated and it is recommended to use instance_parameters.""")

        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of mongodb instance parameter query.
        """
        return pulumi.get(self, "total_count")


class AwaitableInstanceParametersResult(InstanceParametersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return InstanceParametersResult(
            id=self.id,
            instance_id=self.instance_id,
            instance_parameters=self.instance_parameters,
            output_file=self.output_file,
            parameter_names=self.parameter_names,
            parameter_role=self.parameter_role,
            parameters=self.parameters,
            total_count=self.total_count)


def instance_parameters(instance_id: Optional[str] = None,
                        output_file: Optional[str] = None,
                        parameter_names: Optional[str] = None,
                        parameter_role: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableInstanceParametersResult:
    """
    Use this data source to query detailed information of mongodb instance parameters
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_instance = volcengine.mongodb.Instance("fooInstance",
        db_engine_version="MongoDB_4_0",
        instance_type="ReplicaSet",
        super_account_password="@acc-test-123",
        node_spec="mongo.2c4g",
        mongos_node_spec="mongo.mongos.2c4g",
        instance_name="acc-test-mongo-replica",
        charge_type="PostPaid",
        project_name="default",
        mongos_node_number=32,
        shard_number=3,
        storage_space_gb=20,
        subnet_id=foo_subnet.id,
        zone_id=foo_zones.zones[0].id,
        tags=[volcengine.mongodb.InstanceTagArgs(
            key="k1",
            value="v1",
        )])
    foo_instance_parameter = volcengine.mongodb.InstanceParameter("fooInstanceParameter",
        instance_id=foo_instance.id,
        parameter_name="cursorTimeoutMillis",
        parameter_role="Node",
        parameter_value="600111")
    foo_instance_parameters = volcengine.mongodb.instance_parameters_output(instance_id=foo_instance.id,
        parameter_names="cursorTimeoutMillis",
        parameter_role="Node")
    ```


    :param str instance_id: The instance ID to query.
    :param str output_file: File name where to save data source results.
    :param str parameter_names: The parameter names, support fuzzy query, case insensitive.
    :param str parameter_role: The node type of instance parameter, valid value contains `Node`, `Shard`, `ConfigServer`, `Mongos`.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['outputFile'] = output_file
    __args__['parameterNames'] = parameter_names
    __args__['parameterRole'] = parameter_role
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:mongodb/instanceParameters:InstanceParameters', __args__, opts=opts, typ=InstanceParametersResult).value

    return AwaitableInstanceParametersResult(
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        instance_parameters=pulumi.get(__ret__, 'instance_parameters'),
        output_file=pulumi.get(__ret__, 'output_file'),
        parameter_names=pulumi.get(__ret__, 'parameter_names'),
        parameter_role=pulumi.get(__ret__, 'parameter_role'),
        parameters=pulumi.get(__ret__, 'parameters'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(instance_parameters)
def instance_parameters_output(instance_id: Optional[pulumi.Input[str]] = None,
                               output_file: Optional[pulumi.Input[Optional[str]]] = None,
                               parameter_names: Optional[pulumi.Input[Optional[str]]] = None,
                               parameter_role: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[InstanceParametersResult]:
    """
    Use this data source to query detailed information of mongodb instance parameters
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_instance = volcengine.mongodb.Instance("fooInstance",
        db_engine_version="MongoDB_4_0",
        instance_type="ReplicaSet",
        super_account_password="@acc-test-123",
        node_spec="mongo.2c4g",
        mongos_node_spec="mongo.mongos.2c4g",
        instance_name="acc-test-mongo-replica",
        charge_type="PostPaid",
        project_name="default",
        mongos_node_number=32,
        shard_number=3,
        storage_space_gb=20,
        subnet_id=foo_subnet.id,
        zone_id=foo_zones.zones[0].id,
        tags=[volcengine.mongodb.InstanceTagArgs(
            key="k1",
            value="v1",
        )])
    foo_instance_parameter = volcengine.mongodb.InstanceParameter("fooInstanceParameter",
        instance_id=foo_instance.id,
        parameter_name="cursorTimeoutMillis",
        parameter_role="Node",
        parameter_value="600111")
    foo_instance_parameters = volcengine.mongodb.instance_parameters_output(instance_id=foo_instance.id,
        parameter_names="cursorTimeoutMillis",
        parameter_role="Node")
    ```


    :param str instance_id: The instance ID to query.
    :param str output_file: File name where to save data source results.
    :param str parameter_names: The parameter names, support fuzzy query, case insensitive.
    :param str parameter_role: The node type of instance parameter, valid value contains `Node`, `Shard`, `ConfigServer`, `Mongos`.
    """
    ...
