# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'InstancesResult',
    'AwaitableInstancesResult',
    'instances',
    'instances_output',
]

@pulumi.output_type
class InstancesResult:
    """
    A collection of values returned by Instances.
    """
    def __init__(__self__, create_end_time=None, create_start_time=None, db_engine=None, db_engine_version=None, id=None, instance_id=None, instance_name=None, instance_status=None, instance_type=None, instances=None, name_regex=None, output_file=None, tags=None, total_count=None, update_end_time=None, update_start_time=None, vpc_id=None, zone_id=None):
        if create_end_time and not isinstance(create_end_time, str):
            raise TypeError("Expected argument 'create_end_time' to be a str")
        pulumi.set(__self__, "create_end_time", create_end_time)
        if create_start_time and not isinstance(create_start_time, str):
            raise TypeError("Expected argument 'create_start_time' to be a str")
        pulumi.set(__self__, "create_start_time", create_start_time)
        if db_engine and not isinstance(db_engine, str):
            raise TypeError("Expected argument 'db_engine' to be a str")
        pulumi.set(__self__, "db_engine", db_engine)
        if db_engine_version and not isinstance(db_engine_version, str):
            raise TypeError("Expected argument 'db_engine_version' to be a str")
        pulumi.set(__self__, "db_engine_version", db_engine_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if instance_name and not isinstance(instance_name, str):
            raise TypeError("Expected argument 'instance_name' to be a str")
        pulumi.set(__self__, "instance_name", instance_name)
        if instance_status and not isinstance(instance_status, str):
            raise TypeError("Expected argument 'instance_status' to be a str")
        pulumi.set(__self__, "instance_status", instance_status)
        if instance_type and not isinstance(instance_type, str):
            raise TypeError("Expected argument 'instance_type' to be a str")
        pulumi.set(__self__, "instance_type", instance_type)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if update_end_time and not isinstance(update_end_time, str):
            raise TypeError("Expected argument 'update_end_time' to be a str")
        pulumi.set(__self__, "update_end_time", update_end_time)
        if update_start_time and not isinstance(update_start_time, str):
            raise TypeError("Expected argument 'update_start_time' to be a str")
        pulumi.set(__self__, "update_start_time", update_start_time)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="createEndTime")
    def create_end_time(self) -> Optional[str]:
        return pulumi.get(self, "create_end_time")

    @property
    @pulumi.getter(name="createStartTime")
    def create_start_time(self) -> Optional[str]:
        return pulumi.get(self, "create_start_time")

    @property
    @pulumi.getter(name="dbEngine")
    def db_engine(self) -> Optional[str]:
        """
        The db engine.
        """
        return pulumi.get(self, "db_engine")

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> Optional[str]:
        """
        The version of database engine.
        """
        return pulumi.get(self, "db_engine_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The instance ID.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[str]:
        """
        The instance name.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceStatus")
    def instance_status(self) -> Optional[str]:
        """
        The instance status.
        """
        return pulumi.get(self, "instance_status")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        The instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.InstancesInstanceResult']:
        """
        The collection of mongodb instances query.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.InstancesTagResult']]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of mongodb instances query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="updateEndTime")
    def update_end_time(self) -> Optional[str]:
        return pulumi.get(self, "update_end_time")

    @property
    @pulumi.getter(name="updateStartTime")
    def update_start_time(self) -> Optional[str]:
        return pulumi.get(self, "update_start_time")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The vpc ID.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[str]:
        """
        The zone ID of instance.
        """
        return pulumi.get(self, "zone_id")


class AwaitableInstancesResult(InstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return InstancesResult(
            create_end_time=self.create_end_time,
            create_start_time=self.create_start_time,
            db_engine=self.db_engine,
            db_engine_version=self.db_engine_version,
            id=self.id,
            instance_id=self.instance_id,
            instance_name=self.instance_name,
            instance_status=self.instance_status,
            instance_type=self.instance_type,
            instances=self.instances,
            name_regex=self.name_regex,
            output_file=self.output_file,
            tags=self.tags,
            total_count=self.total_count,
            update_end_time=self.update_end_time,
            update_start_time=self.update_start_time,
            vpc_id=self.vpc_id,
            zone_id=self.zone_id)


def instances(create_end_time: Optional[str] = None,
              create_start_time: Optional[str] = None,
              db_engine: Optional[str] = None,
              db_engine_version: Optional[str] = None,
              instance_id: Optional[str] = None,
              instance_name: Optional[str] = None,
              instance_status: Optional[str] = None,
              instance_type: Optional[str] = None,
              name_regex: Optional[str] = None,
              output_file: Optional[str] = None,
              tags: Optional[Sequence[pulumi.InputType['InstancesTagArgs']]] = None,
              update_end_time: Optional[str] = None,
              update_start_time: Optional[str] = None,
              vpc_id: Optional[str] = None,
              zone_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableInstancesResult:
    """
    Use this data source to query detailed information of mongodb instances
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.mongodb.instances(instance_id="mongo-replica-xxx")
    ```


    :param str create_end_time: The end time of creation to query.
    :param str create_start_time: The start time of creation to query.
    :param str db_engine: The db engine to query, valid value contains `MongoDB`.
    :param str db_engine_version: The version of db engine to query, valid value contains `MongoDB_4_0`.
    :param str instance_id: The instance ID to query.
    :param str instance_name: The instance name to query.
    :param str instance_status: The instance status to query.
    :param str instance_type: The type of instance to query, the valid value contains `ReplicaSet` or `ShardedCluster`.
    :param str name_regex: A Name Regex of DB instance.
    :param str output_file: File name where to save data source results.
    :param Sequence[pulumi.InputType['InstancesTagArgs']] tags: Tags.
    :param str update_end_time: The end time of update to query.
    :param str update_start_time: The start time of update to query.
    :param str vpc_id: The vpc id of instance to query.
    :param str zone_id: The zone ID to query.
    """
    __args__ = dict()
    __args__['createEndTime'] = create_end_time
    __args__['createStartTime'] = create_start_time
    __args__['dbEngine'] = db_engine
    __args__['dbEngineVersion'] = db_engine_version
    __args__['instanceId'] = instance_id
    __args__['instanceName'] = instance_name
    __args__['instanceStatus'] = instance_status
    __args__['instanceType'] = instance_type
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['tags'] = tags
    __args__['updateEndTime'] = update_end_time
    __args__['updateStartTime'] = update_start_time
    __args__['vpcId'] = vpc_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:mongodb/instances:Instances', __args__, opts=opts, typ=InstancesResult).value

    return AwaitableInstancesResult(
        create_end_time=pulumi.get(__ret__, 'create_end_time'),
        create_start_time=pulumi.get(__ret__, 'create_start_time'),
        db_engine=pulumi.get(__ret__, 'db_engine'),
        db_engine_version=pulumi.get(__ret__, 'db_engine_version'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        instance_name=pulumi.get(__ret__, 'instance_name'),
        instance_status=pulumi.get(__ret__, 'instance_status'),
        instance_type=pulumi.get(__ret__, 'instance_type'),
        instances=pulumi.get(__ret__, 'instances'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        tags=pulumi.get(__ret__, 'tags'),
        total_count=pulumi.get(__ret__, 'total_count'),
        update_end_time=pulumi.get(__ret__, 'update_end_time'),
        update_start_time=pulumi.get(__ret__, 'update_start_time'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))


@_utilities.lift_output_func(instances)
def instances_output(create_end_time: Optional[pulumi.Input[Optional[str]]] = None,
                     create_start_time: Optional[pulumi.Input[Optional[str]]] = None,
                     db_engine: Optional[pulumi.Input[Optional[str]]] = None,
                     db_engine_version: Optional[pulumi.Input[Optional[str]]] = None,
                     instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                     instance_name: Optional[pulumi.Input[Optional[str]]] = None,
                     instance_status: Optional[pulumi.Input[Optional[str]]] = None,
                     instance_type: Optional[pulumi.Input[Optional[str]]] = None,
                     name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                     tags: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['InstancesTagArgs']]]]] = None,
                     update_end_time: Optional[pulumi.Input[Optional[str]]] = None,
                     update_start_time: Optional[pulumi.Input[Optional[str]]] = None,
                     vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                     zone_id: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[InstancesResult]:
    """
    Use this data source to query detailed information of mongodb instances
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.mongodb.instances(instance_id="mongo-replica-xxx")
    ```


    :param str create_end_time: The end time of creation to query.
    :param str create_start_time: The start time of creation to query.
    :param str db_engine: The db engine to query, valid value contains `MongoDB`.
    :param str db_engine_version: The version of db engine to query, valid value contains `MongoDB_4_0`.
    :param str instance_id: The instance ID to query.
    :param str instance_name: The instance name to query.
    :param str instance_status: The instance status to query.
    :param str instance_type: The type of instance to query, the valid value contains `ReplicaSet` or `ShardedCluster`.
    :param str name_regex: A Name Regex of DB instance.
    :param str output_file: File name where to save data source results.
    :param Sequence[pulumi.InputType['InstancesTagArgs']] tags: Tags.
    :param str update_end_time: The end time of update to query.
    :param str update_start_time: The start time of update to query.
    :param str vpc_id: The vpc id of instance to query.
    :param str zone_id: The zone ID to query.
    """
    ...
