# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['MongoAllowListAssociateArgs', 'MongoAllowListAssociate']

@pulumi.input_type
class MongoAllowListAssociateArgs:
    def __init__(__self__, *,
                 allow_list_id: pulumi.Input[str],
                 instance_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a MongoAllowListAssociate resource.
        :param pulumi.Input[str] allow_list_id: Id of allow list to associate.
        :param pulumi.Input[str] instance_id: Id of instance to associate.
        """
        pulumi.set(__self__, "allow_list_id", allow_list_id)
        pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="allowListId")
    def allow_list_id(self) -> pulumi.Input[str]:
        """
        Id of allow list to associate.
        """
        return pulumi.get(self, "allow_list_id")

    @allow_list_id.setter
    def allow_list_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "allow_list_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Id of instance to associate.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)


@pulumi.input_type
class _MongoAllowListAssociateState:
    def __init__(__self__, *,
                 allow_list_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MongoAllowListAssociate resources.
        :param pulumi.Input[str] allow_list_id: Id of allow list to associate.
        :param pulumi.Input[str] instance_id: Id of instance to associate.
        """
        if allow_list_id is not None:
            pulumi.set(__self__, "allow_list_id", allow_list_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="allowListId")
    def allow_list_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of allow list to associate.
        """
        return pulumi.get(self, "allow_list_id")

    @allow_list_id.setter
    def allow_list_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allow_list_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of instance to associate.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)


class MongoAllowListAssociate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_list_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage mongodb allow list associate
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_instance = volcengine.mongodb.Instance("fooInstance",
            db_engine_version="MongoDB_4_0",
            instance_type="ReplicaSet",
            super_account_password="@acc-test-123",
            node_spec="mongo.2c4g",
            mongos_node_spec="mongo.mongos.2c4g",
            instance_name="acc-test-mongo-replica",
            charge_type="PostPaid",
            project_name="default",
            mongos_node_number=32,
            shard_number=3,
            storage_space_gb=20,
            subnet_id=foo_subnet.id,
            zone_id=foo_zones.zones[0].id,
            tags=[volcengine.mongodb.InstanceTagArgs(
                key="k1",
                value="v1",
            )])
        foo_mongo_allow_list = volcengine.mongodb.MongoAllowList("fooMongoAllowList",
            allow_list_name="acc-test",
            allow_list_desc="acc-test",
            allow_list_type="IPv4",
            allow_list="10.1.1.3,10.2.3.0/24,10.1.1.1")
        foo_mongo_allow_list_associate = volcengine.mongodb.MongoAllowListAssociate("fooMongoAllowListAssociate",
            allow_list_id=foo_mongo_allow_list.id,
            instance_id=foo_instance.id)
        ```

        ## Import

        mongodb allow list associate can be imported using the instanceId:allowListId, e.g.

        ```sh
         $ pulumi import volcengine:mongodb/mongoAllowListAssociate:MongoAllowListAssociate default mongo-replica-e405f8e2****:acl-d1fd76693bd54e658912e7337d5b****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allow_list_id: Id of allow list to associate.
        :param pulumi.Input[str] instance_id: Id of instance to associate.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MongoAllowListAssociateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage mongodb allow list associate
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_instance = volcengine.mongodb.Instance("fooInstance",
            db_engine_version="MongoDB_4_0",
            instance_type="ReplicaSet",
            super_account_password="@acc-test-123",
            node_spec="mongo.2c4g",
            mongos_node_spec="mongo.mongos.2c4g",
            instance_name="acc-test-mongo-replica",
            charge_type="PostPaid",
            project_name="default",
            mongos_node_number=32,
            shard_number=3,
            storage_space_gb=20,
            subnet_id=foo_subnet.id,
            zone_id=foo_zones.zones[0].id,
            tags=[volcengine.mongodb.InstanceTagArgs(
                key="k1",
                value="v1",
            )])
        foo_mongo_allow_list = volcengine.mongodb.MongoAllowList("fooMongoAllowList",
            allow_list_name="acc-test",
            allow_list_desc="acc-test",
            allow_list_type="IPv4",
            allow_list="10.1.1.3,10.2.3.0/24,10.1.1.1")
        foo_mongo_allow_list_associate = volcengine.mongodb.MongoAllowListAssociate("fooMongoAllowListAssociate",
            allow_list_id=foo_mongo_allow_list.id,
            instance_id=foo_instance.id)
        ```

        ## Import

        mongodb allow list associate can be imported using the instanceId:allowListId, e.g.

        ```sh
         $ pulumi import volcengine:mongodb/mongoAllowListAssociate:MongoAllowListAssociate default mongo-replica-e405f8e2****:acl-d1fd76693bd54e658912e7337d5b****
        ```

        :param str resource_name: The name of the resource.
        :param MongoAllowListAssociateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MongoAllowListAssociateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_list_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MongoAllowListAssociateArgs.__new__(MongoAllowListAssociateArgs)

            if allow_list_id is None and not opts.urn:
                raise TypeError("Missing required property 'allow_list_id'")
            __props__.__dict__["allow_list_id"] = allow_list_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
        super(MongoAllowListAssociate, __self__).__init__(
            'volcengine:mongodb/mongoAllowListAssociate:MongoAllowListAssociate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_list_id: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None) -> 'MongoAllowListAssociate':
        """
        Get an existing MongoAllowListAssociate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allow_list_id: Id of allow list to associate.
        :param pulumi.Input[str] instance_id: Id of instance to associate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MongoAllowListAssociateState.__new__(_MongoAllowListAssociateState)

        __props__.__dict__["allow_list_id"] = allow_list_id
        __props__.__dict__["instance_id"] = instance_id
        return MongoAllowListAssociate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowListId")
    def allow_list_id(self) -> pulumi.Output[str]:
        """
        Id of allow list to associate.
        """
        return pulumi.get(self, "allow_list_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Id of instance to associate.
        """
        return pulumi.get(self, "instance_id")

