# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'MongoAllowListsResult',
    'AwaitableMongoAllowListsResult',
    'mongo_allow_lists',
    'mongo_allow_lists_output',
]

@pulumi.output_type
class MongoAllowListsResult:
    """
    A collection of values returned by MongoAllowLists.
    """
    def __init__(__self__, allow_list_ids=None, allow_lists=None, id=None, instance_id=None, output_file=None, region_id=None, total_count=None):
        if allow_list_ids and not isinstance(allow_list_ids, list):
            raise TypeError("Expected argument 'allow_list_ids' to be a list")
        pulumi.set(__self__, "allow_list_ids", allow_list_ids)
        if allow_lists and not isinstance(allow_lists, list):
            raise TypeError("Expected argument 'allow_lists' to be a list")
        pulumi.set(__self__, "allow_lists", allow_lists)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if region_id and not isinstance(region_id, str):
            raise TypeError("Expected argument 'region_id' to be a str")
        pulumi.set(__self__, "region_id", region_id)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="allowListIds")
    def allow_list_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "allow_list_ids")

    @property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> Sequence['outputs.MongoAllowListsAllowListResult']:
        """
        The collection of mongodb allow list query.
        """
        return pulumi.get(self, "allow_lists")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The instance id that bound to the allow list.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of mongodb allow lists query.
        """
        return pulumi.get(self, "total_count")


class AwaitableMongoAllowListsResult(MongoAllowListsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return MongoAllowListsResult(
            allow_list_ids=self.allow_list_ids,
            allow_lists=self.allow_lists,
            id=self.id,
            instance_id=self.instance_id,
            output_file=self.output_file,
            region_id=self.region_id,
            total_count=self.total_count)


def mongo_allow_lists(allow_list_ids: Optional[Sequence[str]] = None,
                      instance_id: Optional[str] = None,
                      output_file: Optional[str] = None,
                      region_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableMongoAllowListsResult:
    """
    Use this data source to query detailed information of mongodb allow lists
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_mongo_allow_list = volcengine.mongodb.MongoAllowList("fooMongoAllowList",
        allow_list_name="acc-test",
        allow_list_desc="acc-test",
        allow_list_type="IPv4",
        allow_list="10.1.1.3,10.2.3.0/24,10.1.1.1")
    foo_mongo_allow_lists = volcengine.mongodb.mongo_allow_lists_output(allow_list_ids=[foo_mongo_allow_list.id],
        region_id="cn-beijing")
    ```


    :param Sequence[str] allow_list_ids: The allow list IDs to query.
    :param str instance_id: The instance ID to query.
    :param str output_file: File name where to save data source results.
    :param str region_id: The region ID.
    """
    __args__ = dict()
    __args__['allowListIds'] = allow_list_ids
    __args__['instanceId'] = instance_id
    __args__['outputFile'] = output_file
    __args__['regionId'] = region_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:mongodb/mongoAllowLists:MongoAllowLists', __args__, opts=opts, typ=MongoAllowListsResult).value

    return AwaitableMongoAllowListsResult(
        allow_list_ids=pulumi.get(__ret__, 'allow_list_ids'),
        allow_lists=pulumi.get(__ret__, 'allow_lists'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        region_id=pulumi.get(__ret__, 'region_id'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(mongo_allow_lists)
def mongo_allow_lists_output(allow_list_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                             instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                             output_file: Optional[pulumi.Input[Optional[str]]] = None,
                             region_id: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[MongoAllowListsResult]:
    """
    Use this data source to query detailed information of mongodb allow lists
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_mongo_allow_list = volcengine.mongodb.MongoAllowList("fooMongoAllowList",
        allow_list_name="acc-test",
        allow_list_desc="acc-test",
        allow_list_type="IPv4",
        allow_list="10.1.1.3,10.2.3.0/24,10.1.1.1")
    foo_mongo_allow_lists = volcengine.mongodb.mongo_allow_lists_output(allow_list_ids=[foo_mongo_allow_list.id],
        region_id="cn-beijing")
    ```


    :param Sequence[str] allow_list_ids: The allow list IDs to query.
    :param str instance_id: The instance ID to query.
    :param str output_file: File name where to save data source results.
    :param str region_id: The region ID.
    """
    ...
