# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AccountsAccountResult',
    'AccountsAccountAccountPrivilegeResult',
    'EndpointsEndpointResult',
    'EndpointsEndpointDbAddressResult',
    'InstanceMongo',
    'InstanceParameterLogsParameterChangeLogsResult',
    'InstanceParametersInstanceParameterResult',
    'InstanceParametersParameterResult',
    'InstanceParametersParameterInstanceParameterResult',
    'InstanceShard',
    'InstanceTag',
    'InstancesInstanceResult',
    'InstancesInstanceConfigServerResult',
    'InstancesInstanceMongoResult',
    'InstancesInstanceNodeResult',
    'InstancesInstanceShardResult',
    'InstancesInstanceShardNodeResult',
    'InstancesInstanceTagResult',
    'InstancesTagResult',
    'MongoAllowListsAllowListResult',
    'MongoAllowListsAllowListAssociatedInstanceResult',
    'RegionsRegionResult',
    'SpecsSpecsResult',
    'SpecsSpecsMongosNodeSpecResult',
    'SpecsSpecsNodeSpecResult',
    'SpecsSpecsShardNodeSpecResult',
    'SslStatesSslStateResult',
    'ZonesZoneResult',
]

@pulumi.output_type
class AccountsAccountResult(dict):
    def __init__(__self__, *,
                 account_name: str,
                 account_privileges: Sequence['outputs.AccountsAccountAccountPrivilegeResult'],
                 account_type: str):
        """
        :param str account_name: The name of account, current support only `root`.
        :param Sequence['AccountsAccountAccountPrivilegeArgs'] account_privileges: The privilege info of mongo instance.
        :param str account_type: The type of account.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "account_privileges", account_privileges)
        pulumi.set(__self__, "account_type", account_type)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        The name of account, current support only `root`.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="accountPrivileges")
    def account_privileges(self) -> Sequence['outputs.AccountsAccountAccountPrivilegeResult']:
        """
        The privilege info of mongo instance.
        """
        return pulumi.get(self, "account_privileges")

    @property
    @pulumi.getter(name="accountType")
    def account_type(self) -> str:
        """
        The type of account.
        """
        return pulumi.get(self, "account_type")


@pulumi.output_type
class AccountsAccountAccountPrivilegeResult(dict):
    def __init__(__self__, *,
                 db_name: str,
                 role_name: str):
        """
        :param str db_name: The Name of DB.
        :param str role_name: The Name of role.
        """
        pulumi.set(__self__, "db_name", db_name)
        pulumi.set(__self__, "role_name", role_name)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> str:
        """
        The Name of DB.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> str:
        """
        The Name of role.
        """
        return pulumi.get(self, "role_name")


@pulumi.output_type
class EndpointsEndpointResult(dict):
    def __init__(__self__, *,
                 db_addresses: Sequence['outputs.EndpointsEndpointDbAddressResult'],
                 endpoint_id: str,
                 endpoint_str: str,
                 endpoint_type: str,
                 network_type: str,
                 object_id: str,
                 subnet_id: str,
                 vpc_id: str):
        """
        :param Sequence['EndpointsEndpointDbAddressArgs'] db_addresses: The list of mongodb addresses.
        :param str endpoint_id: The ID of endpoint.
        :param str endpoint_str: The endpoint information.
        :param str endpoint_type: The node type corresponding to the endpoint.
        :param str network_type: The network type of endpoint.
        :param str object_id: The object ID corresponding to the endpoint.
        :param str subnet_id: The subnet ID.
        :param str vpc_id: The VPC ID.
        """
        pulumi.set(__self__, "db_addresses", db_addresses)
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "endpoint_str", endpoint_str)
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="dbAddresses")
    def db_addresses(self) -> Sequence['outputs.EndpointsEndpointDbAddressResult']:
        """
        The list of mongodb addresses.
        """
        return pulumi.get(self, "db_addresses")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> str:
        """
        The ID of endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter(name="endpointStr")
    def endpoint_str(self) -> str:
        """
        The endpoint information.
        """
        return pulumi.get(self, "endpoint_str")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        The node type corresponding to the endpoint.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        The network type of endpoint.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> str:
        """
        The object ID corresponding to the endpoint.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet ID.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class EndpointsEndpointDbAddressResult(dict):
    def __init__(__self__, *,
                 address_domain: str,
                 address_ip: str,
                 address_port: str,
                 address_type: str,
                 eip_id: str,
                 node_id: str):
        """
        :param str address_domain: The domain of mongodb connection.
        :param str address_ip: The IP of mongodb connection.
        :param str address_port: The port of mongodb connection.
        :param str address_type: The connection type of mongodb.
        :param str eip_id: The EIP ID bound to the instance's public network address.
        :param str node_id: The node ID.
        """
        pulumi.set(__self__, "address_domain", address_domain)
        pulumi.set(__self__, "address_ip", address_ip)
        pulumi.set(__self__, "address_port", address_port)
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "eip_id", eip_id)
        pulumi.set(__self__, "node_id", node_id)

    @property
    @pulumi.getter(name="addressDomain")
    def address_domain(self) -> str:
        """
        The domain of mongodb connection.
        """
        return pulumi.get(self, "address_domain")

    @property
    @pulumi.getter(name="addressIp")
    def address_ip(self) -> str:
        """
        The IP of mongodb connection.
        """
        return pulumi.get(self, "address_ip")

    @property
    @pulumi.getter(name="addressPort")
    def address_port(self) -> str:
        """
        The port of mongodb connection.
        """
        return pulumi.get(self, "address_port")

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> str:
        """
        The connection type of mongodb.
        """
        return pulumi.get(self, "address_type")

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> str:
        """
        The EIP ID bound to the instance's public network address.
        """
        return pulumi.get(self, "eip_id")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        The node ID.
        """
        return pulumi.get(self, "node_id")


@pulumi.output_type
class InstanceMongo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mongosNodeId":
            suggest = "mongos_node_id"
        elif key == "nodeSpec":
            suggest = "node_spec"
        elif key == "nodeStatus":
            suggest = "node_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMongo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMongo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMongo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mongos_node_id: Optional[str] = None,
                 node_spec: Optional[str] = None,
                 node_status: Optional[str] = None):
        """
        :param str mongos_node_id: The mongos node ID.
        :param str node_spec: The spec of node.
        :param str node_status: The node status.
        """
        if mongos_node_id is not None:
            pulumi.set(__self__, "mongos_node_id", mongos_node_id)
        if node_spec is not None:
            pulumi.set(__self__, "node_spec", node_spec)
        if node_status is not None:
            pulumi.set(__self__, "node_status", node_status)

    @property
    @pulumi.getter(name="mongosNodeId")
    def mongos_node_id(self) -> Optional[str]:
        """
        The mongos node ID.
        """
        return pulumi.get(self, "mongos_node_id")

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> Optional[str]:
        """
        The spec of node.
        """
        return pulumi.get(self, "node_spec")

    @property
    @pulumi.getter(name="nodeStatus")
    def node_status(self) -> Optional[str]:
        """
        The node status.
        """
        return pulumi.get(self, "node_status")


@pulumi.output_type
class InstanceParameterLogsParameterChangeLogsResult(dict):
    def __init__(__self__, *,
                 modify_time: str,
                 new_parameter_value: str,
                 old_parameter_value: str,
                 parameter_name: str,
                 parameter_role: str,
                 parameter_status: str):
        """
        :param str modify_time: The modifying time of parameter.
        :param str new_parameter_value: The new parameter value.
        :param str old_parameter_value: The old parameter value.
        :param str parameter_name: The parameter name.
        :param str parameter_role: The node type to which the parameter belongs.
        :param str parameter_status: The status of parameter change.
        """
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "new_parameter_value", new_parameter_value)
        pulumi.set(__self__, "old_parameter_value", old_parameter_value)
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_role", parameter_role)
        pulumi.set(__self__, "parameter_status", parameter_status)

    @property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> str:
        """
        The modifying time of parameter.
        """
        return pulumi.get(self, "modify_time")

    @property
    @pulumi.getter(name="newParameterValue")
    def new_parameter_value(self) -> str:
        """
        The new parameter value.
        """
        return pulumi.get(self, "new_parameter_value")

    @property
    @pulumi.getter(name="oldParameterValue")
    def old_parameter_value(self) -> str:
        """
        The old parameter value.
        """
        return pulumi.get(self, "old_parameter_value")

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> str:
        """
        The parameter name.
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter(name="parameterRole")
    def parameter_role(self) -> str:
        """
        The node type to which the parameter belongs.
        """
        return pulumi.get(self, "parameter_role")

    @property
    @pulumi.getter(name="parameterStatus")
    def parameter_status(self) -> str:
        """
        The status of parameter change.
        """
        return pulumi.get(self, "parameter_status")


@pulumi.output_type
class InstanceParametersInstanceParameterResult(dict):
    def __init__(__self__, *,
                 checking_code: str,
                 force_modify: bool,
                 force_restart: bool,
                 parameter_default_value: str,
                 parameter_description: str,
                 parameter_name: str,
                 parameter_role: str,
                 parameter_type: str,
                 parameter_value: str):
        """
        :param str checking_code: The checking code of parameter.
        :param bool force_modify: Whether the parameter supports modifying.
        :param bool force_restart: Does the new parameter value need to restart the instance to take effect after modification.
        :param str parameter_default_value: The default value of parameter.
        :param str parameter_description: The description of parameter.
        :param str parameter_name: The name of parameter.
        :param str parameter_role: The node type of instance parameter, valid value contains `Node`, `Shard`, `ConfigServer`, `Mongos`.
        :param str parameter_type: The type of parameter value.
        :param str parameter_value: The value of parameter.
        """
        pulumi.set(__self__, "checking_code", checking_code)
        pulumi.set(__self__, "force_modify", force_modify)
        pulumi.set(__self__, "force_restart", force_restart)
        pulumi.set(__self__, "parameter_default_value", parameter_default_value)
        pulumi.set(__self__, "parameter_description", parameter_description)
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_role", parameter_role)
        pulumi.set(__self__, "parameter_type", parameter_type)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="checkingCode")
    def checking_code(self) -> str:
        """
        The checking code of parameter.
        """
        return pulumi.get(self, "checking_code")

    @property
    @pulumi.getter(name="forceModify")
    def force_modify(self) -> bool:
        """
        Whether the parameter supports modifying.
        """
        return pulumi.get(self, "force_modify")

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> bool:
        """
        Does the new parameter value need to restart the instance to take effect after modification.
        """
        return pulumi.get(self, "force_restart")

    @property
    @pulumi.getter(name="parameterDefaultValue")
    def parameter_default_value(self) -> str:
        """
        The default value of parameter.
        """
        return pulumi.get(self, "parameter_default_value")

    @property
    @pulumi.getter(name="parameterDescription")
    def parameter_description(self) -> str:
        """
        The description of parameter.
        """
        return pulumi.get(self, "parameter_description")

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> str:
        """
        The name of parameter.
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter(name="parameterRole")
    def parameter_role(self) -> str:
        """
        The node type of instance parameter, valid value contains `Node`, `Shard`, `ConfigServer`, `Mongos`.
        """
        return pulumi.get(self, "parameter_role")

    @property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> str:
        """
        The type of parameter value.
        """
        return pulumi.get(self, "parameter_type")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> str:
        """
        The value of parameter.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class InstanceParametersParameterResult(dict):
    def __init__(__self__, *,
                 db_engine: str,
                 db_engine_version: str,
                 instance_id: str,
                 instance_parameters: Sequence['outputs.InstanceParametersParameterInstanceParameterResult'],
                 total: str):
        """
        :param str db_engine: The database engine.
        :param str db_engine_version: The database engine version.
        :param str instance_id: The instance ID to query.
        :param Sequence['InstanceParametersParameterInstanceParameterArgs'] instance_parameters: The list of parameters.
        :param str total: The total parameters queried.
        """
        pulumi.set(__self__, "db_engine", db_engine)
        pulumi.set(__self__, "db_engine_version", db_engine_version)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_parameters", instance_parameters)
        pulumi.set(__self__, "total", total)

    @property
    @pulumi.getter(name="dbEngine")
    def db_engine(self) -> str:
        """
        The database engine.
        """
        return pulumi.get(self, "db_engine")

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> str:
        """
        The database engine version.
        """
        return pulumi.get(self, "db_engine_version")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The instance ID to query.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceParameters")
    def instance_parameters(self) -> Sequence['outputs.InstanceParametersParameterInstanceParameterResult']:
        """
        The list of parameters.
        """
        return pulumi.get(self, "instance_parameters")

    @property
    @pulumi.getter
    def total(self) -> str:
        """
        The total parameters queried.
        """
        return pulumi.get(self, "total")


@pulumi.output_type
class InstanceParametersParameterInstanceParameterResult(dict):
    def __init__(__self__, *,
                 checking_code: str,
                 force_modify: bool,
                 force_restart: bool,
                 parameter_default_value: str,
                 parameter_description: str,
                 parameter_name: str,
                 parameter_role: str,
                 parameter_type: str,
                 parameter_value: str):
        """
        :param str checking_code: The checking code of parameter.
        :param bool force_modify: Whether the parameter supports modifying.
        :param bool force_restart: Does the new parameter value need to restart the instance to take effect after modification.
        :param str parameter_default_value: The default value of parameter.
        :param str parameter_description: The description of parameter.
        :param str parameter_name: The name of parameter.
        :param str parameter_role: The node type of instance parameter, valid value contains `Node`, `Shard`, `ConfigServer`, `Mongos`.
        :param str parameter_type: The type of parameter value.
        :param str parameter_value: The value of parameter.
        """
        pulumi.set(__self__, "checking_code", checking_code)
        pulumi.set(__self__, "force_modify", force_modify)
        pulumi.set(__self__, "force_restart", force_restart)
        pulumi.set(__self__, "parameter_default_value", parameter_default_value)
        pulumi.set(__self__, "parameter_description", parameter_description)
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_role", parameter_role)
        pulumi.set(__self__, "parameter_type", parameter_type)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="checkingCode")
    def checking_code(self) -> str:
        """
        The checking code of parameter.
        """
        return pulumi.get(self, "checking_code")

    @property
    @pulumi.getter(name="forceModify")
    def force_modify(self) -> bool:
        """
        Whether the parameter supports modifying.
        """
        return pulumi.get(self, "force_modify")

    @property
    @pulumi.getter(name="forceRestart")
    def force_restart(self) -> bool:
        """
        Does the new parameter value need to restart the instance to take effect after modification.
        """
        return pulumi.get(self, "force_restart")

    @property
    @pulumi.getter(name="parameterDefaultValue")
    def parameter_default_value(self) -> str:
        """
        The default value of parameter.
        """
        return pulumi.get(self, "parameter_default_value")

    @property
    @pulumi.getter(name="parameterDescription")
    def parameter_description(self) -> str:
        """
        The description of parameter.
        """
        return pulumi.get(self, "parameter_description")

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> str:
        """
        The name of parameter.
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter(name="parameterRole")
    def parameter_role(self) -> str:
        """
        The node type of instance parameter, valid value contains `Node`, `Shard`, `ConfigServer`, `Mongos`.
        """
        return pulumi.get(self, "parameter_role")

    @property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> str:
        """
        The type of parameter value.
        """
        return pulumi.get(self, "parameter_type")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> str:
        """
        The value of parameter.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class InstanceShard(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shardId":
            suggest = "shard_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceShard. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceShard.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceShard.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 shard_id: Optional[str] = None):
        """
        :param str shard_id: The shard id.
        """
        if shard_id is not None:
            pulumi.set(__self__, "shard_id", shard_id)

    @property
    @pulumi.getter(name="shardId")
    def shard_id(self) -> Optional[str]:
        """
        The shard id.
        """
        return pulumi.get(self, "shard_id")


@pulumi.output_type
class InstanceTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The Key of Tags.
        :param str value: The Value of Tags.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The Key of Tags.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The Value of Tags.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InstancesInstanceResult(dict):
    def __init__(__self__, *,
                 auto_renew: bool,
                 charge_status: str,
                 charge_type: str,
                 closed_time: str,
                 config_servers: Sequence['outputs.InstancesInstanceConfigServerResult'],
                 config_servers_id: str,
                 create_time: str,
                 db_engine: str,
                 db_engine_version: str,
                 db_engine_version_str: str,
                 expired_time: str,
                 instance_id: str,
                 instance_name: str,
                 instance_status: str,
                 instance_type: str,
                 mongos: Sequence['outputs.InstancesInstanceMongoResult'],
                 mongos_id: str,
                 nodes: Sequence['outputs.InstancesInstanceNodeResult'],
                 project_name: str,
                 reclaim_time: str,
                 shards: Sequence['outputs.InstancesInstanceShardResult'],
                 ssl_enable: bool,
                 ssl_expire_time: str,
                 ssl_is_valid: bool,
                 storage_type: str,
                 subnet_id: str,
                 tags: Sequence['outputs.InstancesInstanceTagResult'],
                 update_time: str,
                 vpc_id: str,
                 zone_id: str):
        """
        :param bool auto_renew: Whether to enable automatic renewal.
        :param str charge_status: The charge status.
        :param str charge_type: The charge type of instance.
        :param str closed_time: The planned close time.
        :param Sequence['InstancesInstanceConfigServerArgs'] config_servers: The list of config servers.
        :param str config_servers_id: The ID of config servers.
        :param str create_time: The creation time of instance.
        :param str db_engine: The db engine to query, valid value contains `MongoDB`.
        :param str db_engine_version: The version of db engine to query, valid value contains `MongoDB_4_0`.
        :param str db_engine_version_str: The version string of database engine.
        :param str expired_time: The expired time of instance.
        :param str instance_id: The instance ID to query.
        :param str instance_name: The instance name to query.
        :param str instance_status: The instance status to query.
        :param str instance_type: The type of instance to query, the valid value contains `ReplicaSet` or `ShardedCluster`.
        :param Sequence['InstancesInstanceMongoArgs'] mongos: The list of mongos.
        :param str mongos_id: The ID of mongos.
        :param Sequence['InstancesInstanceNodeArgs'] nodes: The node information.
        :param str project_name: The project name to which the instance belongs.
        :param str reclaim_time: The planned reclaim time of instance.
        :param Sequence['InstancesInstanceShardArgs'] shards: The list of shards.
        :param bool ssl_enable: Whether ssl enabled.
        :param str ssl_expire_time: The ssl expire time.
        :param bool ssl_is_valid: Whether ssl is valid.
        :param str storage_type: The storage type of instance.
        :param str subnet_id: The subnet id of instance.
        :param Sequence['InstancesInstanceTagArgs'] tags: Tags.
        :param str update_time: The update time of instance.
        :param str vpc_id: The vpc id of instance to query.
        :param str zone_id: The zone ID to query.
        """
        pulumi.set(__self__, "auto_renew", auto_renew)
        pulumi.set(__self__, "charge_status", charge_status)
        pulumi.set(__self__, "charge_type", charge_type)
        pulumi.set(__self__, "closed_time", closed_time)
        pulumi.set(__self__, "config_servers", config_servers)
        pulumi.set(__self__, "config_servers_id", config_servers_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "db_engine", db_engine)
        pulumi.set(__self__, "db_engine_version", db_engine_version)
        pulumi.set(__self__, "db_engine_version_str", db_engine_version_str)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_status", instance_status)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "mongos", mongos)
        pulumi.set(__self__, "mongos_id", mongos_id)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "reclaim_time", reclaim_time)
        pulumi.set(__self__, "shards", shards)
        pulumi.set(__self__, "ssl_enable", ssl_enable)
        pulumi.set(__self__, "ssl_expire_time", ssl_expire_time)
        pulumi.set(__self__, "ssl_is_valid", ssl_is_valid)
        pulumi.set(__self__, "storage_type", storage_type)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> bool:
        """
        Whether to enable automatic renewal.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="chargeStatus")
    def charge_status(self) -> str:
        """
        The charge status.
        """
        return pulumi.get(self, "charge_status")

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> str:
        """
        The charge type of instance.
        """
        return pulumi.get(self, "charge_type")

    @property
    @pulumi.getter(name="closedTime")
    def closed_time(self) -> str:
        """
        The planned close time.
        """
        return pulumi.get(self, "closed_time")

    @property
    @pulumi.getter(name="configServers")
    def config_servers(self) -> Sequence['outputs.InstancesInstanceConfigServerResult']:
        """
        The list of config servers.
        """
        return pulumi.get(self, "config_servers")

    @property
    @pulumi.getter(name="configServersId")
    def config_servers_id(self) -> str:
        """
        The ID of config servers.
        """
        return pulumi.get(self, "config_servers_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of instance.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dbEngine")
    def db_engine(self) -> str:
        """
        The db engine to query, valid value contains `MongoDB`.
        """
        return pulumi.get(self, "db_engine")

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> str:
        """
        The version of db engine to query, valid value contains `MongoDB_4_0`.
        """
        return pulumi.get(self, "db_engine_version")

    @property
    @pulumi.getter(name="dbEngineVersionStr")
    def db_engine_version_str(self) -> str:
        """
        The version string of database engine.
        """
        return pulumi.get(self, "db_engine_version_str")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        """
        The expired time of instance.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The instance ID to query.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The instance name to query.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceStatus")
    def instance_status(self) -> str:
        """
        The instance status to query.
        """
        return pulumi.get(self, "instance_status")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The type of instance to query, the valid value contains `ReplicaSet` or `ShardedCluster`.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def mongos(self) -> Sequence['outputs.InstancesInstanceMongoResult']:
        """
        The list of mongos.
        """
        return pulumi.get(self, "mongos")

    @property
    @pulumi.getter(name="mongosId")
    def mongos_id(self) -> str:
        """
        The ID of mongos.
        """
        return pulumi.get(self, "mongos_id")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.InstancesInstanceNodeResult']:
        """
        The node information.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> str:
        """
        The project name to which the instance belongs.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="reclaimTime")
    def reclaim_time(self) -> str:
        """
        The planned reclaim time of instance.
        """
        return pulumi.get(self, "reclaim_time")

    @property
    @pulumi.getter
    def shards(self) -> Sequence['outputs.InstancesInstanceShardResult']:
        """
        The list of shards.
        """
        return pulumi.get(self, "shards")

    @property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> bool:
        """
        Whether ssl enabled.
        """
        return pulumi.get(self, "ssl_enable")

    @property
    @pulumi.getter(name="sslExpireTime")
    def ssl_expire_time(self) -> str:
        """
        The ssl expire time.
        """
        return pulumi.get(self, "ssl_expire_time")

    @property
    @pulumi.getter(name="sslIsValid")
    def ssl_is_valid(self) -> bool:
        """
        Whether ssl is valid.
        """
        return pulumi.get(self, "ssl_is_valid")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        The storage type of instance.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet id of instance.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.InstancesInstanceTagResult']:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The update time of instance.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The vpc id of instance to query.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zone ID to query.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class InstancesInstanceConfigServerResult(dict):
    def __init__(__self__, *,
                 config_server_node_id: str,
                 node_role: str,
                 node_status: str,
                 total_memory_gb: float,
                 total_vcpu: float,
                 used_memory_gb: float,
                 used_vcpu: float,
                 zone_id: str):
        """
        :param str config_server_node_id: The config server node ID.
        :param str node_role: The nod role.
        :param str node_status: The node status.
        :param float total_memory_gb: The total memory in GB.
        :param float total_vcpu: The total vCPU.
        :param float used_memory_gb: The used memory in GB.
        :param float used_vcpu: The used vCPU.
        :param str zone_id: The zone ID to query.
        """
        pulumi.set(__self__, "config_server_node_id", config_server_node_id)
        pulumi.set(__self__, "node_role", node_role)
        pulumi.set(__self__, "node_status", node_status)
        pulumi.set(__self__, "total_memory_gb", total_memory_gb)
        pulumi.set(__self__, "total_vcpu", total_vcpu)
        pulumi.set(__self__, "used_memory_gb", used_memory_gb)
        pulumi.set(__self__, "used_vcpu", used_vcpu)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="configServerNodeId")
    def config_server_node_id(self) -> str:
        """
        The config server node ID.
        """
        return pulumi.get(self, "config_server_node_id")

    @property
    @pulumi.getter(name="nodeRole")
    def node_role(self) -> str:
        """
        The nod role.
        """
        return pulumi.get(self, "node_role")

    @property
    @pulumi.getter(name="nodeStatus")
    def node_status(self) -> str:
        """
        The node status.
        """
        return pulumi.get(self, "node_status")

    @property
    @pulumi.getter(name="totalMemoryGb")
    def total_memory_gb(self) -> float:
        """
        The total memory in GB.
        """
        return pulumi.get(self, "total_memory_gb")

    @property
    @pulumi.getter(name="totalVcpu")
    def total_vcpu(self) -> float:
        """
        The total vCPU.
        """
        return pulumi.get(self, "total_vcpu")

    @property
    @pulumi.getter(name="usedMemoryGb")
    def used_memory_gb(self) -> float:
        """
        The used memory in GB.
        """
        return pulumi.get(self, "used_memory_gb")

    @property
    @pulumi.getter(name="usedVcpu")
    def used_vcpu(self) -> float:
        """
        The used vCPU.
        """
        return pulumi.get(self, "used_vcpu")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zone ID to query.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class InstancesInstanceMongoResult(dict):
    def __init__(__self__, *,
                 mongos_node_id: str,
                 node_spec: str,
                 node_status: str,
                 total_memory_gb: float,
                 total_vcpu: float,
                 used_memory_gb: float,
                 used_vcpu: float,
                 zone_id: str):
        """
        :param str mongos_node_id: The mongos node ID.
        :param str node_spec: The node spec.
        :param str node_status: The node status.
        :param float total_memory_gb: The total memory in GB.
        :param float total_vcpu: The total vCPU.
        :param float used_memory_gb: The used memory in GB.
        :param float used_vcpu: The used vCPU.
        :param str zone_id: The zone ID to query.
        """
        pulumi.set(__self__, "mongos_node_id", mongos_node_id)
        pulumi.set(__self__, "node_spec", node_spec)
        pulumi.set(__self__, "node_status", node_status)
        pulumi.set(__self__, "total_memory_gb", total_memory_gb)
        pulumi.set(__self__, "total_vcpu", total_vcpu)
        pulumi.set(__self__, "used_memory_gb", used_memory_gb)
        pulumi.set(__self__, "used_vcpu", used_vcpu)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="mongosNodeId")
    def mongos_node_id(self) -> str:
        """
        The mongos node ID.
        """
        return pulumi.get(self, "mongos_node_id")

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> str:
        """
        The node spec.
        """
        return pulumi.get(self, "node_spec")

    @property
    @pulumi.getter(name="nodeStatus")
    def node_status(self) -> str:
        """
        The node status.
        """
        return pulumi.get(self, "node_status")

    @property
    @pulumi.getter(name="totalMemoryGb")
    def total_memory_gb(self) -> float:
        """
        The total memory in GB.
        """
        return pulumi.get(self, "total_memory_gb")

    @property
    @pulumi.getter(name="totalVcpu")
    def total_vcpu(self) -> float:
        """
        The total vCPU.
        """
        return pulumi.get(self, "total_vcpu")

    @property
    @pulumi.getter(name="usedMemoryGb")
    def used_memory_gb(self) -> float:
        """
        The used memory in GB.
        """
        return pulumi.get(self, "used_memory_gb")

    @property
    @pulumi.getter(name="usedVcpu")
    def used_vcpu(self) -> float:
        """
        The used vCPU.
        """
        return pulumi.get(self, "used_vcpu")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zone ID to query.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class InstancesInstanceNodeResult(dict):
    def __init__(__self__, *,
                 node_delay_time: int,
                 node_id: str,
                 node_role: str,
                 node_spec: str,
                 node_status: str,
                 total_memory_gb: float,
                 total_storage_gb: float,
                 total_vcpu: float,
                 used_memory_gb: float,
                 used_storage_gb: float,
                 used_vcpu: float,
                 zone_id: str):
        """
        :param int node_delay_time: The master-slave delay time.
        :param str node_id: The node ID.
        :param str node_role: The nod role.
        :param str node_spec: The node spec.
        :param str node_status: The node status.
        :param float total_memory_gb: The total memory in GB.
        :param float total_storage_gb: The total storage in GB.
        :param float total_vcpu: The total vCPU.
        :param float used_memory_gb: The used memory in GB.
        :param float used_storage_gb: The used storage in GB.
        :param float used_vcpu: The used vCPU.
        :param str zone_id: The zone ID to query.
        """
        pulumi.set(__self__, "node_delay_time", node_delay_time)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_role", node_role)
        pulumi.set(__self__, "node_spec", node_spec)
        pulumi.set(__self__, "node_status", node_status)
        pulumi.set(__self__, "total_memory_gb", total_memory_gb)
        pulumi.set(__self__, "total_storage_gb", total_storage_gb)
        pulumi.set(__self__, "total_vcpu", total_vcpu)
        pulumi.set(__self__, "used_memory_gb", used_memory_gb)
        pulumi.set(__self__, "used_storage_gb", used_storage_gb)
        pulumi.set(__self__, "used_vcpu", used_vcpu)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="nodeDelayTime")
    def node_delay_time(self) -> int:
        """
        The master-slave delay time.
        """
        return pulumi.get(self, "node_delay_time")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        The node ID.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeRole")
    def node_role(self) -> str:
        """
        The nod role.
        """
        return pulumi.get(self, "node_role")

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> str:
        """
        The node spec.
        """
        return pulumi.get(self, "node_spec")

    @property
    @pulumi.getter(name="nodeStatus")
    def node_status(self) -> str:
        """
        The node status.
        """
        return pulumi.get(self, "node_status")

    @property
    @pulumi.getter(name="totalMemoryGb")
    def total_memory_gb(self) -> float:
        """
        The total memory in GB.
        """
        return pulumi.get(self, "total_memory_gb")

    @property
    @pulumi.getter(name="totalStorageGb")
    def total_storage_gb(self) -> float:
        """
        The total storage in GB.
        """
        return pulumi.get(self, "total_storage_gb")

    @property
    @pulumi.getter(name="totalVcpu")
    def total_vcpu(self) -> float:
        """
        The total vCPU.
        """
        return pulumi.get(self, "total_vcpu")

    @property
    @pulumi.getter(name="usedMemoryGb")
    def used_memory_gb(self) -> float:
        """
        The used memory in GB.
        """
        return pulumi.get(self, "used_memory_gb")

    @property
    @pulumi.getter(name="usedStorageGb")
    def used_storage_gb(self) -> float:
        """
        The used storage in GB.
        """
        return pulumi.get(self, "used_storage_gb")

    @property
    @pulumi.getter(name="usedVcpu")
    def used_vcpu(self) -> float:
        """
        The used vCPU.
        """
        return pulumi.get(self, "used_vcpu")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zone ID to query.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class InstancesInstanceShardResult(dict):
    def __init__(__self__, *,
                 nodes: Sequence['outputs.InstancesInstanceShardNodeResult'],
                 shard_id: str):
        """
        :param Sequence['InstancesInstanceShardNodeArgs'] nodes: The node information.
        :param str shard_id: The shard ID.
        """
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "shard_id", shard_id)

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.InstancesInstanceShardNodeResult']:
        """
        The node information.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="shardId")
    def shard_id(self) -> str:
        """
        The shard ID.
        """
        return pulumi.get(self, "shard_id")


@pulumi.output_type
class InstancesInstanceShardNodeResult(dict):
    def __init__(__self__, *,
                 node_delay_time: int,
                 node_id: str,
                 node_role: str,
                 node_spec: str,
                 node_status: str,
                 total_memory_gb: float,
                 total_storage_gb: float,
                 total_vcpu: float,
                 used_memory_gb: float,
                 used_storage_gb: float,
                 used_vcpu: float,
                 zone_id: str):
        """
        :param int node_delay_time: The master-slave delay time.
        :param str node_id: The node ID.
        :param str node_role: The nod role.
        :param str node_spec: The node spec.
        :param str node_status: The node status.
        :param float total_memory_gb: The total memory in GB.
        :param float total_storage_gb: The total storage in GB.
        :param float total_vcpu: The total vCPU.
        :param float used_memory_gb: The used memory in GB.
        :param float used_storage_gb: The used storage in GB.
        :param float used_vcpu: The used vCPU.
        :param str zone_id: The zone ID to query.
        """
        pulumi.set(__self__, "node_delay_time", node_delay_time)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_role", node_role)
        pulumi.set(__self__, "node_spec", node_spec)
        pulumi.set(__self__, "node_status", node_status)
        pulumi.set(__self__, "total_memory_gb", total_memory_gb)
        pulumi.set(__self__, "total_storage_gb", total_storage_gb)
        pulumi.set(__self__, "total_vcpu", total_vcpu)
        pulumi.set(__self__, "used_memory_gb", used_memory_gb)
        pulumi.set(__self__, "used_storage_gb", used_storage_gb)
        pulumi.set(__self__, "used_vcpu", used_vcpu)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="nodeDelayTime")
    def node_delay_time(self) -> int:
        """
        The master-slave delay time.
        """
        return pulumi.get(self, "node_delay_time")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        The node ID.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeRole")
    def node_role(self) -> str:
        """
        The nod role.
        """
        return pulumi.get(self, "node_role")

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> str:
        """
        The node spec.
        """
        return pulumi.get(self, "node_spec")

    @property
    @pulumi.getter(name="nodeStatus")
    def node_status(self) -> str:
        """
        The node status.
        """
        return pulumi.get(self, "node_status")

    @property
    @pulumi.getter(name="totalMemoryGb")
    def total_memory_gb(self) -> float:
        """
        The total memory in GB.
        """
        return pulumi.get(self, "total_memory_gb")

    @property
    @pulumi.getter(name="totalStorageGb")
    def total_storage_gb(self) -> float:
        """
        The total storage in GB.
        """
        return pulumi.get(self, "total_storage_gb")

    @property
    @pulumi.getter(name="totalVcpu")
    def total_vcpu(self) -> float:
        """
        The total vCPU.
        """
        return pulumi.get(self, "total_vcpu")

    @property
    @pulumi.getter(name="usedMemoryGb")
    def used_memory_gb(self) -> float:
        """
        The used memory in GB.
        """
        return pulumi.get(self, "used_memory_gb")

    @property
    @pulumi.getter(name="usedStorageGb")
    def used_storage_gb(self) -> float:
        """
        The used storage in GB.
        """
        return pulumi.get(self, "used_storage_gb")

    @property
    @pulumi.getter(name="usedVcpu")
    def used_vcpu(self) -> float:
        """
        The used vCPU.
        """
        return pulumi.get(self, "used_vcpu")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zone ID to query.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class InstancesInstanceTagResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The Key of Tags.
        :param str value: The Value of Tags.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The Key of Tags.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The Value of Tags.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InstancesTagResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The Key of Tags.
        :param str value: The Value of Tags.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The Key of Tags.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The Value of Tags.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MongoAllowListsAllowListResult(dict):
    def __init__(__self__, *,
                 allow_list: str,
                 allow_list_desc: str,
                 allow_list_id: str,
                 allow_list_ip_num: int,
                 allow_list_name: str,
                 allow_list_type: str,
                 associated_instance_num: int,
                 associated_instances: Sequence['outputs.MongoAllowListsAllowListAssociatedInstanceResult']):
        """
        :param str allow_list: The list of IP address in allow list.
        :param str allow_list_desc: The description of allow list.
        :param str allow_list_id: The ID of allow list.
        :param int allow_list_ip_num: The number of allow list IPs.
        :param str allow_list_name: The allow list name.
        :param str allow_list_type: The IP address type in allow list.
        :param int associated_instance_num: The total number of instances bound under the allow list.
        :param Sequence['MongoAllowListsAllowListAssociatedInstanceArgs'] associated_instances: The list of associated instances.
        """
        pulumi.set(__self__, "allow_list", allow_list)
        pulumi.set(__self__, "allow_list_desc", allow_list_desc)
        pulumi.set(__self__, "allow_list_id", allow_list_id)
        pulumi.set(__self__, "allow_list_ip_num", allow_list_ip_num)
        pulumi.set(__self__, "allow_list_name", allow_list_name)
        pulumi.set(__self__, "allow_list_type", allow_list_type)
        pulumi.set(__self__, "associated_instance_num", associated_instance_num)
        pulumi.set(__self__, "associated_instances", associated_instances)

    @property
    @pulumi.getter(name="allowList")
    def allow_list(self) -> str:
        """
        The list of IP address in allow list.
        """
        return pulumi.get(self, "allow_list")

    @property
    @pulumi.getter(name="allowListDesc")
    def allow_list_desc(self) -> str:
        """
        The description of allow list.
        """
        return pulumi.get(self, "allow_list_desc")

    @property
    @pulumi.getter(name="allowListId")
    def allow_list_id(self) -> str:
        """
        The ID of allow list.
        """
        return pulumi.get(self, "allow_list_id")

    @property
    @pulumi.getter(name="allowListIpNum")
    def allow_list_ip_num(self) -> int:
        """
        The number of allow list IPs.
        """
        return pulumi.get(self, "allow_list_ip_num")

    @property
    @pulumi.getter(name="allowListName")
    def allow_list_name(self) -> str:
        """
        The allow list name.
        """
        return pulumi.get(self, "allow_list_name")

    @property
    @pulumi.getter(name="allowListType")
    def allow_list_type(self) -> str:
        """
        The IP address type in allow list.
        """
        return pulumi.get(self, "allow_list_type")

    @property
    @pulumi.getter(name="associatedInstanceNum")
    def associated_instance_num(self) -> int:
        """
        The total number of instances bound under the allow list.
        """
        return pulumi.get(self, "associated_instance_num")

    @property
    @pulumi.getter(name="associatedInstances")
    def associated_instances(self) -> Sequence['outputs.MongoAllowListsAllowListAssociatedInstanceResult']:
        """
        The list of associated instances.
        """
        return pulumi.get(self, "associated_instances")


@pulumi.output_type
class MongoAllowListsAllowListAssociatedInstanceResult(dict):
    def __init__(__self__, *,
                 instance_id: str,
                 instance_name: str,
                 vpc: str):
        """
        :param str instance_id: The instance ID to query.
        :param str instance_name: The instance name that bound to the allow list.
        :param str vpc: The VPC ID.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The instance ID to query.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The instance name that bound to the allow list.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter
    def vpc(self) -> str:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc")


@pulumi.output_type
class RegionsRegionResult(dict):
    def __init__(__self__, *,
                 region_id: str,
                 region_name: str):
        """
        :param str region_id: The id of the region.
        :param str region_name: The name of region.
        """
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        The id of the region.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> str:
        """
        The name of region.
        """
        return pulumi.get(self, "region_name")


@pulumi.output_type
class SpecsSpecsResult(dict):
    def __init__(__self__, *,
                 mongos_node_specs: Sequence['outputs.SpecsSpecsMongosNodeSpecResult'],
                 node_specs: Sequence['outputs.SpecsSpecsNodeSpecResult'],
                 shard_node_specs: Sequence['outputs.SpecsSpecsShardNodeSpecResult']):
        """
        :param Sequence['SpecsSpecsMongosNodeSpecArgs'] mongos_node_specs: The collection of mongos node specs.
        :param Sequence['SpecsSpecsNodeSpecArgs'] node_specs: The collection of node specs.
        :param Sequence['SpecsSpecsShardNodeSpecArgs'] shard_node_specs: The collection of shard node specs.
        """
        pulumi.set(__self__, "mongos_node_specs", mongos_node_specs)
        pulumi.set(__self__, "node_specs", node_specs)
        pulumi.set(__self__, "shard_node_specs", shard_node_specs)

    @property
    @pulumi.getter(name="mongosNodeSpecs")
    def mongos_node_specs(self) -> Sequence['outputs.SpecsSpecsMongosNodeSpecResult']:
        """
        The collection of mongos node specs.
        """
        return pulumi.get(self, "mongos_node_specs")

    @property
    @pulumi.getter(name="nodeSpecs")
    def node_specs(self) -> Sequence['outputs.SpecsSpecsNodeSpecResult']:
        """
        The collection of node specs.
        """
        return pulumi.get(self, "node_specs")

    @property
    @pulumi.getter(name="shardNodeSpecs")
    def shard_node_specs(self) -> Sequence['outputs.SpecsSpecsShardNodeSpecResult']:
        """
        The collection of shard node specs.
        """
        return pulumi.get(self, "shard_node_specs")


@pulumi.output_type
class SpecsSpecsMongosNodeSpecResult(dict):
    def __init__(__self__, *,
                 cpu_num: float,
                 max_conn: int,
                 mem_in_gb: float,
                 spec_name: str):
        """
        :param float cpu_num: The cpu cores.
        :param int max_conn: The max connections.
        :param float mem_in_gb: The memory in GB.
        :param str spec_name: The shard node spec name.
        """
        pulumi.set(__self__, "cpu_num", cpu_num)
        pulumi.set(__self__, "max_conn", max_conn)
        pulumi.set(__self__, "mem_in_gb", mem_in_gb)
        pulumi.set(__self__, "spec_name", spec_name)

    @property
    @pulumi.getter(name="cpuNum")
    def cpu_num(self) -> float:
        """
        The cpu cores.
        """
        return pulumi.get(self, "cpu_num")

    @property
    @pulumi.getter(name="maxConn")
    def max_conn(self) -> int:
        """
        The max connections.
        """
        return pulumi.get(self, "max_conn")

    @property
    @pulumi.getter(name="memInGb")
    def mem_in_gb(self) -> float:
        """
        The memory in GB.
        """
        return pulumi.get(self, "mem_in_gb")

    @property
    @pulumi.getter(name="specName")
    def spec_name(self) -> str:
        """
        The shard node spec name.
        """
        return pulumi.get(self, "spec_name")


@pulumi.output_type
class SpecsSpecsNodeSpecResult(dict):
    def __init__(__self__, *,
                 cpu_num: float,
                 max_conn: int,
                 max_storage: int,
                 mem_in_db: float,
                 spec_name: str):
        """
        :param float cpu_num: The cpu cores.
        :param int max_conn: The max connections.
        :param int max_storage: The max storage.
        :param float mem_in_db: The memory in GB.
        :param str spec_name: The shard node spec name.
        """
        pulumi.set(__self__, "cpu_num", cpu_num)
        pulumi.set(__self__, "max_conn", max_conn)
        pulumi.set(__self__, "max_storage", max_storage)
        pulumi.set(__self__, "mem_in_db", mem_in_db)
        pulumi.set(__self__, "spec_name", spec_name)

    @property
    @pulumi.getter(name="cpuNum")
    def cpu_num(self) -> float:
        """
        The cpu cores.
        """
        return pulumi.get(self, "cpu_num")

    @property
    @pulumi.getter(name="maxConn")
    def max_conn(self) -> int:
        """
        The max connections.
        """
        return pulumi.get(self, "max_conn")

    @property
    @pulumi.getter(name="maxStorage")
    def max_storage(self) -> int:
        """
        The max storage.
        """
        return pulumi.get(self, "max_storage")

    @property
    @pulumi.getter(name="memInDb")
    def mem_in_db(self) -> float:
        """
        The memory in GB.
        """
        return pulumi.get(self, "mem_in_db")

    @property
    @pulumi.getter(name="specName")
    def spec_name(self) -> str:
        """
        The shard node spec name.
        """
        return pulumi.get(self, "spec_name")


@pulumi.output_type
class SpecsSpecsShardNodeSpecResult(dict):
    def __init__(__self__, *,
                 cpu_num: float,
                 max_conn: int,
                 max_storage: int,
                 mem_in_gb: int,
                 spec_name: str):
        """
        :param float cpu_num: The cpu cores.
        :param int max_conn: The max connections.
        :param int max_storage: The max storage.
        :param int mem_in_gb: The memory in GB.
        :param str spec_name: The shard node spec name.
        """
        pulumi.set(__self__, "cpu_num", cpu_num)
        pulumi.set(__self__, "max_conn", max_conn)
        pulumi.set(__self__, "max_storage", max_storage)
        pulumi.set(__self__, "mem_in_gb", mem_in_gb)
        pulumi.set(__self__, "spec_name", spec_name)

    @property
    @pulumi.getter(name="cpuNum")
    def cpu_num(self) -> float:
        """
        The cpu cores.
        """
        return pulumi.get(self, "cpu_num")

    @property
    @pulumi.getter(name="maxConn")
    def max_conn(self) -> int:
        """
        The max connections.
        """
        return pulumi.get(self, "max_conn")

    @property
    @pulumi.getter(name="maxStorage")
    def max_storage(self) -> int:
        """
        The max storage.
        """
        return pulumi.get(self, "max_storage")

    @property
    @pulumi.getter(name="memInGb")
    def mem_in_gb(self) -> int:
        """
        The memory in GB.
        """
        return pulumi.get(self, "mem_in_gb")

    @property
    @pulumi.getter(name="specName")
    def spec_name(self) -> str:
        """
        The shard node spec name.
        """
        return pulumi.get(self, "spec_name")


@pulumi.output_type
class SslStatesSslStateResult(dict):
    def __init__(__self__, *,
                 instance_id: str,
                 is_valid: bool,
                 ssl_enable: bool,
                 ssl_expired_time: str):
        """
        :param str instance_id: The mongodb instance ID to query.
        :param bool is_valid: Whetehr SSL is valid.
        :param bool ssl_enable: Whether SSL is enabled.
        :param str ssl_expired_time: The expire time of SSL.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "is_valid", is_valid)
        pulumi.set(__self__, "ssl_enable", ssl_enable)
        pulumi.set(__self__, "ssl_expired_time", ssl_expired_time)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The mongodb instance ID to query.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="isValid")
    def is_valid(self) -> bool:
        """
        Whetehr SSL is valid.
        """
        return pulumi.get(self, "is_valid")

    @property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> bool:
        """
        Whether SSL is enabled.
        """
        return pulumi.get(self, "ssl_enable")

    @property
    @pulumi.getter(name="sslExpiredTime")
    def ssl_expired_time(self) -> str:
        """
        The expire time of SSL.
        """
        return pulumi.get(self, "ssl_expired_time")


@pulumi.output_type
class ZonesZoneResult(dict):
    def __init__(__self__, *,
                 id: str,
                 zone_id: str,
                 zone_name: str):
        """
        :param str id: The id of the zone.
        :param str zone_id: The id of the zone.
        :param str zone_name: The name of the zone.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "zone_id", zone_id)
        pulumi.set(__self__, "zone_name", zone_name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the zone.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The id of the zone.
        """
        return pulumi.get(self, "zone_id")

    @property
    @pulumi.getter(name="zoneName")
    def zone_name(self) -> str:
        """
        The name of the zone.
        """
        return pulumi.get(self, "zone_name")


