# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SslStateArgs', 'SslState']

@pulumi.input_type
class SslStateArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 ssl_action: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SslState resource.
        :param pulumi.Input[str] instance_id: The ID of mongodb instance.
        :param pulumi.Input[str] ssl_action: The action of ssl, valid value contains `Update`. Set `ssl_action` to `Update` will will trigger an SSL update operation when executing `pulumi up`.When the current time is less than 30 days from the `ssl_expired_time`, executing `pulumi up` will automatically renew the SSL.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if ssl_action is not None:
            pulumi.set(__self__, "ssl_action", ssl_action)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The ID of mongodb instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="sslAction")
    def ssl_action(self) -> Optional[pulumi.Input[str]]:
        """
        The action of ssl, valid value contains `Update`. Set `ssl_action` to `Update` will will trigger an SSL update operation when executing `pulumi up`.When the current time is less than 30 days from the `ssl_expired_time`, executing `pulumi up` will automatically renew the SSL.
        """
        return pulumi.get(self, "ssl_action")

    @ssl_action.setter
    def ssl_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_action", value)


@pulumi.input_type
class _SslStateState:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 is_valid: Optional[pulumi.Input[bool]] = None,
                 ssl_action: Optional[pulumi.Input[str]] = None,
                 ssl_enable: Optional[pulumi.Input[bool]] = None,
                 ssl_expired_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SslState resources.
        :param pulumi.Input[str] instance_id: The ID of mongodb instance.
        :param pulumi.Input[bool] is_valid: Whetehr SSL is valid.
        :param pulumi.Input[str] ssl_action: The action of ssl, valid value contains `Update`. Set `ssl_action` to `Update` will will trigger an SSL update operation when executing `pulumi up`.When the current time is less than 30 days from the `ssl_expired_time`, executing `pulumi up` will automatically renew the SSL.
        :param pulumi.Input[bool] ssl_enable: Whether SSL is enabled.
        :param pulumi.Input[str] ssl_expired_time: The expire time of SSL.
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if is_valid is not None:
            pulumi.set(__self__, "is_valid", is_valid)
        if ssl_action is not None:
            pulumi.set(__self__, "ssl_action", ssl_action)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if ssl_expired_time is not None:
            pulumi.set(__self__, "ssl_expired_time", ssl_expired_time)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of mongodb instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="isValid")
    def is_valid(self) -> Optional[pulumi.Input[bool]]:
        """
        Whetehr SSL is valid.
        """
        return pulumi.get(self, "is_valid")

    @is_valid.setter
    def is_valid(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_valid", value)

    @property
    @pulumi.getter(name="sslAction")
    def ssl_action(self) -> Optional[pulumi.Input[str]]:
        """
        The action of ssl, valid value contains `Update`. Set `ssl_action` to `Update` will will trigger an SSL update operation when executing `pulumi up`.When the current time is less than 30 days from the `ssl_expired_time`, executing `pulumi up` will automatically renew the SSL.
        """
        return pulumi.get(self, "ssl_action")

    @ssl_action.setter
    def ssl_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_action", value)

    @property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether SSL is enabled.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl_enable", value)

    @property
    @pulumi.getter(name="sslExpiredTime")
    def ssl_expired_time(self) -> Optional[pulumi.Input[str]]:
        """
        The expire time of SSL.
        """
        return pulumi.get(self, "ssl_expired_time")

    @ssl_expired_time.setter
    def ssl_expired_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_expired_time", value)


class SslState(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 ssl_action: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage mongodb ssl state
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_instance = volcengine.mongodb.Instance("fooInstance",
            db_engine_version="MongoDB_4_0",
            instance_type="ReplicaSet",
            super_account_password="@acc-test-123",
            node_spec="mongo.2c4g",
            mongos_node_spec="mongo.mongos.2c4g",
            instance_name="acc-test-mongo-replica",
            charge_type="PostPaid",
            project_name="default",
            mongos_node_number=2,
            shard_number=3,
            storage_space_gb=20,
            subnet_id=foo_subnet.id,
            zone_id=foo_zones.zones[0].id,
            tags=[volcengine.mongodb.InstanceTagArgs(
                key="k1",
                value="v1",
            )])
        foo_ssl_state = volcengine.mongodb.SslState("fooSslState", instance_id=foo_instance.id)
        ```

        ## Import

        mongodb ssl state can be imported using the ssl:instanceId, e.g.

        ```sh
         $ pulumi import volcengine:mongodb/sslState:SslState default ssl:mongo-shard-d050db19xxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_id: The ID of mongodb instance.
        :param pulumi.Input[str] ssl_action: The action of ssl, valid value contains `Update`. Set `ssl_action` to `Update` will will trigger an SSL update operation when executing `pulumi up`.When the current time is less than 30 days from the `ssl_expired_time`, executing `pulumi up` will automatically renew the SSL.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SslStateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage mongodb ssl state
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_instance = volcengine.mongodb.Instance("fooInstance",
            db_engine_version="MongoDB_4_0",
            instance_type="ReplicaSet",
            super_account_password="@acc-test-123",
            node_spec="mongo.2c4g",
            mongos_node_spec="mongo.mongos.2c4g",
            instance_name="acc-test-mongo-replica",
            charge_type="PostPaid",
            project_name="default",
            mongos_node_number=2,
            shard_number=3,
            storage_space_gb=20,
            subnet_id=foo_subnet.id,
            zone_id=foo_zones.zones[0].id,
            tags=[volcengine.mongodb.InstanceTagArgs(
                key="k1",
                value="v1",
            )])
        foo_ssl_state = volcengine.mongodb.SslState("fooSslState", instance_id=foo_instance.id)
        ```

        ## Import

        mongodb ssl state can be imported using the ssl:instanceId, e.g.

        ```sh
         $ pulumi import volcengine:mongodb/sslState:SslState default ssl:mongo-shard-d050db19xxx
        ```

        :param str resource_name: The name of the resource.
        :param SslStateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SslStateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 ssl_action: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SslStateArgs.__new__(SslStateArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["ssl_action"] = ssl_action
            __props__.__dict__["is_valid"] = None
            __props__.__dict__["ssl_enable"] = None
            __props__.__dict__["ssl_expired_time"] = None
        super(SslState, __self__).__init__(
            'volcengine:mongodb/sslState:SslState',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            is_valid: Optional[pulumi.Input[bool]] = None,
            ssl_action: Optional[pulumi.Input[str]] = None,
            ssl_enable: Optional[pulumi.Input[bool]] = None,
            ssl_expired_time: Optional[pulumi.Input[str]] = None) -> 'SslState':
        """
        Get an existing SslState resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_id: The ID of mongodb instance.
        :param pulumi.Input[bool] is_valid: Whetehr SSL is valid.
        :param pulumi.Input[str] ssl_action: The action of ssl, valid value contains `Update`. Set `ssl_action` to `Update` will will trigger an SSL update operation when executing `pulumi up`.When the current time is less than 30 days from the `ssl_expired_time`, executing `pulumi up` will automatically renew the SSL.
        :param pulumi.Input[bool] ssl_enable: Whether SSL is enabled.
        :param pulumi.Input[str] ssl_expired_time: The expire time of SSL.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SslStateState.__new__(_SslStateState)

        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["is_valid"] = is_valid
        __props__.__dict__["ssl_action"] = ssl_action
        __props__.__dict__["ssl_enable"] = ssl_enable
        __props__.__dict__["ssl_expired_time"] = ssl_expired_time
        return SslState(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The ID of mongodb instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="isValid")
    def is_valid(self) -> pulumi.Output[bool]:
        """
        Whetehr SSL is valid.
        """
        return pulumi.get(self, "is_valid")

    @property
    @pulumi.getter(name="sslAction")
    def ssl_action(self) -> pulumi.Output[Optional[str]]:
        """
        The action of ssl, valid value contains `Update`. Set `ssl_action` to `Update` will will trigger an SSL update operation when executing `pulumi up`.When the current time is less than 30 days from the `ssl_expired_time`, executing `pulumi up` will automatically renew the SSL.
        """
        return pulumi.get(self, "ssl_action")

    @property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> pulumi.Output[bool]:
        """
        Whether SSL is enabled.
        """
        return pulumi.get(self, "ssl_enable")

    @property
    @pulumi.getter(name="sslExpiredTime")
    def ssl_expired_time(self) -> pulumi.Output[str]:
        """
        The expire time of SSL.
        """
        return pulumi.get(self, "ssl_expired_time")

