# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['MountPointArgs', 'MountPoint']

@pulumi.input_type
class MountPointArgs:
    def __init__(__self__, *,
                 file_system_id: pulumi.Input[str],
                 mount_point_name: pulumi.Input[str],
                 permission_group_id: pulumi.Input[str],
                 subnet_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a MountPoint resource.
        :param pulumi.Input[str] file_system_id: The file system id.
        :param pulumi.Input[str] mount_point_name: The mount point name.
        :param pulumi.Input[str] permission_group_id: The permission group id.
        :param pulumi.Input[str] subnet_id: The subnet id.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "mount_point_name", mount_point_name)
        pulumi.set(__self__, "permission_group_id", permission_group_id)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Input[str]:
        """
        The file system id.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter(name="mountPointName")
    def mount_point_name(self) -> pulumi.Input[str]:
        """
        The mount point name.
        """
        return pulumi.get(self, "mount_point_name")

    @mount_point_name.setter
    def mount_point_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_point_name", value)

    @property
    @pulumi.getter(name="permissionGroupId")
    def permission_group_id(self) -> pulumi.Input[str]:
        """
        The permission group id.
        """
        return pulumi.get(self, "permission_group_id")

    @permission_group_id.setter
    def permission_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "permission_group_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class _MountPointState:
    def __init__(__self__, *,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 mount_point_id: Optional[pulumi.Input[str]] = None,
                 mount_point_name: Optional[pulumi.Input[str]] = None,
                 permission_group_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MountPoint resources.
        :param pulumi.Input[str] file_system_id: The file system id.
        :param pulumi.Input[str] mount_point_id: The mount point id.
        :param pulumi.Input[str] mount_point_name: The mount point name.
        :param pulumi.Input[str] permission_group_id: The permission group id.
        :param pulumi.Input[str] subnet_id: The subnet id.
        """
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if mount_point_id is not None:
            pulumi.set(__self__, "mount_point_id", mount_point_id)
        if mount_point_name is not None:
            pulumi.set(__self__, "mount_point_name", mount_point_name)
        if permission_group_id is not None:
            pulumi.set(__self__, "permission_group_id", permission_group_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The file system id.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter(name="mountPointId")
    def mount_point_id(self) -> Optional[pulumi.Input[str]]:
        """
        The mount point id.
        """
        return pulumi.get(self, "mount_point_id")

    @mount_point_id.setter
    def mount_point_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_point_id", value)

    @property
    @pulumi.getter(name="mountPointName")
    def mount_point_name(self) -> Optional[pulumi.Input[str]]:
        """
        The mount point name.
        """
        return pulumi.get(self, "mount_point_name")

    @mount_point_name.setter
    def mount_point_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_point_name", value)

    @property
    @pulumi.getter(name="permissionGroupId")
    def permission_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The permission group id.
        """
        return pulumi.get(self, "permission_group_id")

    @permission_group_id.setter
    def permission_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission_group_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


class MountPoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 mount_point_name: Optional[pulumi.Input[str]] = None,
                 permission_group_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage nas mount point

        ## Import

        Nas Mount Point can be imported using the file system id and mount point id, e.g.

        ```sh
         $ pulumi import volcengine:nas/mountPoint:MountPoint default enas-cnbj18bcb923****:mount-a6ee****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] file_system_id: The file system id.
        :param pulumi.Input[str] mount_point_name: The mount point name.
        :param pulumi.Input[str] permission_group_id: The permission group id.
        :param pulumi.Input[str] subnet_id: The subnet id.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MountPointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage nas mount point

        ## Import

        Nas Mount Point can be imported using the file system id and mount point id, e.g.

        ```sh
         $ pulumi import volcengine:nas/mountPoint:MountPoint default enas-cnbj18bcb923****:mount-a6ee****
        ```

        :param str resource_name: The name of the resource.
        :param MountPointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MountPointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 mount_point_name: Optional[pulumi.Input[str]] = None,
                 permission_group_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MountPointArgs.__new__(MountPointArgs)

            if file_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_id'")
            __props__.__dict__["file_system_id"] = file_system_id
            if mount_point_name is None and not opts.urn:
                raise TypeError("Missing required property 'mount_point_name'")
            __props__.__dict__["mount_point_name"] = mount_point_name
            if permission_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'permission_group_id'")
            __props__.__dict__["permission_group_id"] = permission_group_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["mount_point_id"] = None
        super(MountPoint, __self__).__init__(
            'volcengine:nas/mountPoint:MountPoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            file_system_id: Optional[pulumi.Input[str]] = None,
            mount_point_id: Optional[pulumi.Input[str]] = None,
            mount_point_name: Optional[pulumi.Input[str]] = None,
            permission_group_id: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None) -> 'MountPoint':
        """
        Get an existing MountPoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] file_system_id: The file system id.
        :param pulumi.Input[str] mount_point_id: The mount point id.
        :param pulumi.Input[str] mount_point_name: The mount point name.
        :param pulumi.Input[str] permission_group_id: The permission group id.
        :param pulumi.Input[str] subnet_id: The subnet id.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MountPointState.__new__(_MountPointState)

        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["mount_point_id"] = mount_point_id
        __props__.__dict__["mount_point_name"] = mount_point_name
        __props__.__dict__["permission_group_id"] = permission_group_id
        __props__.__dict__["subnet_id"] = subnet_id
        return MountPoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[str]:
        """
        The file system id.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="mountPointId")
    def mount_point_id(self) -> pulumi.Output[str]:
        """
        The mount point id.
        """
        return pulumi.get(self, "mount_point_id")

    @property
    @pulumi.getter(name="mountPointName")
    def mount_point_name(self) -> pulumi.Output[str]:
        """
        The mount point name.
        """
        return pulumi.get(self, "mount_point_name")

    @property
    @pulumi.getter(name="permissionGroupId")
    def permission_group_id(self) -> pulumi.Output[str]:
        """
        The permission group id.
        """
        return pulumi.get(self, "permission_group_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

