# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PermissionGroupArgs', 'PermissionGroup']

@pulumi.input_type
class PermissionGroupArgs:
    def __init__(__self__, *,
                 permission_group_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 permission_rules: Optional[pulumi.Input[Sequence[pulumi.Input['PermissionGroupPermissionRuleArgs']]]] = None):
        """
        The set of arguments for constructing a PermissionGroup resource.
        :param pulumi.Input[str] permission_group_name: The name of the permission group.
        :param pulumi.Input[str] description: The description of the permission group.
        :param pulumi.Input[Sequence[pulumi.Input['PermissionGroupPermissionRuleArgs']]] permission_rules: The list of permissions rules.
        """
        pulumi.set(__self__, "permission_group_name", permission_group_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if permission_rules is not None:
            pulumi.set(__self__, "permission_rules", permission_rules)

    @property
    @pulumi.getter(name="permissionGroupName")
    def permission_group_name(self) -> pulumi.Input[str]:
        """
        The name of the permission group.
        """
        return pulumi.get(self, "permission_group_name")

    @permission_group_name.setter
    def permission_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "permission_group_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the permission group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="permissionRules")
    def permission_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PermissionGroupPermissionRuleArgs']]]]:
        """
        The list of permissions rules.
        """
        return pulumi.get(self, "permission_rules")

    @permission_rules.setter
    def permission_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PermissionGroupPermissionRuleArgs']]]]):
        pulumi.set(self, "permission_rules", value)


@pulumi.input_type
class _PermissionGroupState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 permission_group_id: Optional[pulumi.Input[str]] = None,
                 permission_group_name: Optional[pulumi.Input[str]] = None,
                 permission_rules: Optional[pulumi.Input[Sequence[pulumi.Input['PermissionGroupPermissionRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering PermissionGroup resources.
        :param pulumi.Input[str] description: The description of the permission group.
        :param pulumi.Input[str] permission_group_id: The id of the permission group.
        :param pulumi.Input[str] permission_group_name: The name of the permission group.
        :param pulumi.Input[Sequence[pulumi.Input['PermissionGroupPermissionRuleArgs']]] permission_rules: The list of permissions rules.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if permission_group_id is not None:
            pulumi.set(__self__, "permission_group_id", permission_group_id)
        if permission_group_name is not None:
            pulumi.set(__self__, "permission_group_name", permission_group_name)
        if permission_rules is not None:
            pulumi.set(__self__, "permission_rules", permission_rules)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the permission group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="permissionGroupId")
    def permission_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the permission group.
        """
        return pulumi.get(self, "permission_group_id")

    @permission_group_id.setter
    def permission_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission_group_id", value)

    @property
    @pulumi.getter(name="permissionGroupName")
    def permission_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the permission group.
        """
        return pulumi.get(self, "permission_group_name")

    @permission_group_name.setter
    def permission_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission_group_name", value)

    @property
    @pulumi.getter(name="permissionRules")
    def permission_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PermissionGroupPermissionRuleArgs']]]]:
        """
        The list of permissions rules.
        """
        return pulumi.get(self, "permission_rules")

    @permission_rules.setter
    def permission_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PermissionGroupPermissionRuleArgs']]]]):
        pulumi.set(self, "permission_rules", value)


class PermissionGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 permission_group_name: Optional[pulumi.Input[str]] = None,
                 permission_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PermissionGroupPermissionRuleArgs']]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage nas permission group
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.nas.PermissionGroup("foo",
            description="acctest1",
            permission_group_name="acc-test1",
            permission_rules=[
                volcengine.nas.PermissionGroupPermissionRuleArgs(
                    cidr_ip="*",
                    rw_mode="RW",
                    use_mode="All_squash",
                ),
                volcengine.nas.PermissionGroupPermissionRuleArgs(
                    cidr_ip="192.168.0.0",
                    rw_mode="RO",
                    use_mode="No_all_squash",
                ),
            ])
        ```

        ## Import

        Nas Permission Group can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:nas/permissionGroup:PermissionGroup default pgroup-1f85db2c****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the permission group.
        :param pulumi.Input[str] permission_group_name: The name of the permission group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PermissionGroupPermissionRuleArgs']]]] permission_rules: The list of permissions rules.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PermissionGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage nas permission group
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.nas.PermissionGroup("foo",
            description="acctest1",
            permission_group_name="acc-test1",
            permission_rules=[
                volcengine.nas.PermissionGroupPermissionRuleArgs(
                    cidr_ip="*",
                    rw_mode="RW",
                    use_mode="All_squash",
                ),
                volcengine.nas.PermissionGroupPermissionRuleArgs(
                    cidr_ip="192.168.0.0",
                    rw_mode="RO",
                    use_mode="No_all_squash",
                ),
            ])
        ```

        ## Import

        Nas Permission Group can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:nas/permissionGroup:PermissionGroup default pgroup-1f85db2c****
        ```

        :param str resource_name: The name of the resource.
        :param PermissionGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PermissionGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 permission_group_name: Optional[pulumi.Input[str]] = None,
                 permission_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PermissionGroupPermissionRuleArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PermissionGroupArgs.__new__(PermissionGroupArgs)

            __props__.__dict__["description"] = description
            if permission_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'permission_group_name'")
            __props__.__dict__["permission_group_name"] = permission_group_name
            __props__.__dict__["permission_rules"] = permission_rules
            __props__.__dict__["permission_group_id"] = None
        super(PermissionGroup, __self__).__init__(
            'volcengine:nas/permissionGroup:PermissionGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            permission_group_id: Optional[pulumi.Input[str]] = None,
            permission_group_name: Optional[pulumi.Input[str]] = None,
            permission_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PermissionGroupPermissionRuleArgs']]]]] = None) -> 'PermissionGroup':
        """
        Get an existing PermissionGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the permission group.
        :param pulumi.Input[str] permission_group_id: The id of the permission group.
        :param pulumi.Input[str] permission_group_name: The name of the permission group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PermissionGroupPermissionRuleArgs']]]] permission_rules: The list of permissions rules.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PermissionGroupState.__new__(_PermissionGroupState)

        __props__.__dict__["description"] = description
        __props__.__dict__["permission_group_id"] = permission_group_id
        __props__.__dict__["permission_group_name"] = permission_group_name
        __props__.__dict__["permission_rules"] = permission_rules
        return PermissionGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the permission group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="permissionGroupId")
    def permission_group_id(self) -> pulumi.Output[str]:
        """
        The id of the permission group.
        """
        return pulumi.get(self, "permission_group_id")

    @property
    @pulumi.getter(name="permissionGroupName")
    def permission_group_name(self) -> pulumi.Output[str]:
        """
        The name of the permission group.
        """
        return pulumi.get(self, "permission_group_name")

    @property
    @pulumi.getter(name="permissionRules")
    def permission_rules(self) -> pulumi.Output[Optional[Sequence['outputs.PermissionGroupPermissionRule']]]:
        """
        The list of permissions rules.
        """
        return pulumi.get(self, "permission_rules")

