# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'PermissionGroupsResult',
    'AwaitablePermissionGroupsResult',
    'permission_groups',
    'permission_groups_output',
]

@pulumi.output_type
class PermissionGroupsResult:
    """
    A collection of values returned by PermissionGroups.
    """
    def __init__(__self__, filters=None, id=None, output_file=None, permission_groups=None, total_count=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if permission_groups and not isinstance(permission_groups, list):
            raise TypeError("Expected argument 'permission_groups' to be a list")
        pulumi.set(__self__, "permission_groups", permission_groups)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.PermissionGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="permissionGroups")
    def permission_groups(self) -> Sequence['outputs.PermissionGroupsPermissionGroupResult']:
        """
        The list of permissions groups.
        """
        return pulumi.get(self, "permission_groups")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of nas permission groups query.
        """
        return pulumi.get(self, "total_count")


class AwaitablePermissionGroupsResult(PermissionGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return PermissionGroupsResult(
            filters=self.filters,
            id=self.id,
            output_file=self.output_file,
            permission_groups=self.permission_groups,
            total_count=self.total_count)


def permission_groups(filters: Optional[Sequence[pulumi.InputType['PermissionGroupsFilterArgs']]] = None,
                      output_file: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitablePermissionGroupsResult:
    """
    Use this data source to query detailed information of nas permission groups
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.nas.PermissionGroup("foo",
        permission_group_name="acc-test",
        description="acctest",
        permission_rules=[
            volcengine.nas.PermissionGroupPermissionRuleArgs(
                cidr_ip="*",
                rw_mode="RW",
                use_mode="All_squash",
            ),
            volcengine.nas.PermissionGroupPermissionRuleArgs(
                cidr_ip="192.168.0.0",
                rw_mode="RO",
                use_mode="All_squash",
            ),
        ])
    default = volcengine.nas.permission_groups_output(filters=[volcengine.nas.PermissionGroupsFilterArgs(
        key="PermissionGroupId",
        value=foo.id,
    )])
    ```


    :param Sequence[pulumi.InputType['PermissionGroupsFilterArgs']] filters: Filter permission groups for specified characteristics.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:nas/permissionGroups:PermissionGroups', __args__, opts=opts, typ=PermissionGroupsResult).value

    return AwaitablePermissionGroupsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        permission_groups=pulumi.get(__ret__, 'permission_groups'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(permission_groups)
def permission_groups_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['PermissionGroupsFilterArgs']]]]] = None,
                             output_file: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[PermissionGroupsResult]:
    """
    Use this data source to query detailed information of nas permission groups
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.nas.PermissionGroup("foo",
        permission_group_name="acc-test",
        description="acctest",
        permission_rules=[
            volcengine.nas.PermissionGroupPermissionRuleArgs(
                cidr_ip="*",
                rw_mode="RW",
                use_mode="All_squash",
            ),
            volcengine.nas.PermissionGroupPermissionRuleArgs(
                cidr_ip="192.168.0.0",
                rw_mode="RO",
                use_mode="All_squash",
            ),
        ])
    default = volcengine.nas.permission_groups_output(filters=[volcengine.nas.PermissionGroupsFilterArgs(
        key="PermissionGroupId",
        value=foo.id,
    )])
    ```


    :param Sequence[pulumi.InputType['PermissionGroupsFilterArgs']] filters: Filter permission groups for specified characteristics.
    :param str output_file: File name where to save data source results.
    """
    ...
