# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SnapshotArgs', 'Snapshot']

@pulumi.input_type
class SnapshotArgs:
    def __init__(__self__, *,
                 file_system_id: pulumi.Input[str],
                 snapshot_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Snapshot resource.
        :param pulumi.Input[str] file_system_id: The ID of the file system.
        :param pulumi.Input[str] snapshot_name: The name of snapshot.
        :param pulumi.Input[str] description: The description of snapshot.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "snapshot_name", snapshot_name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Input[str]:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> pulumi.Input[str]:
        """
        The name of snapshot.
        """
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "snapshot_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of snapshot.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _SnapshotState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 file_system_name: Optional[pulumi.Input[str]] = None,
                 is_encrypt: Optional[pulumi.Input[bool]] = None,
                 progress: Optional[pulumi.Input[str]] = None,
                 snapshot_name: Optional[pulumi.Input[str]] = None,
                 snapshot_type: Optional[pulumi.Input[str]] = None,
                 source_size: Optional[pulumi.Input[int]] = None,
                 source_version: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Snapshot resources.
        :param pulumi.Input[str] create_time: The create time of snapshot.
        :param pulumi.Input[str] description: The description of snapshot.
        :param pulumi.Input[str] file_system_id: The ID of the file system.
        :param pulumi.Input[str] file_system_name: The name of file system.
        :param pulumi.Input[bool] is_encrypt: Whether is encrypt.
        :param pulumi.Input[str] progress: The progress of snapshot.
        :param pulumi.Input[str] snapshot_name: The name of snapshot.
        :param pulumi.Input[str] snapshot_type: The type of snapshot.
        :param pulumi.Input[int] source_size: The size of source.
        :param pulumi.Input[str] source_version: The source version info.
        :param pulumi.Input[str] status: The status of snapshot.
        :param pulumi.Input[str] zone_id: The ID of zone.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if file_system_name is not None:
            pulumi.set(__self__, "file_system_name", file_system_name)
        if is_encrypt is not None:
            pulumi.set(__self__, "is_encrypt", is_encrypt)
        if progress is not None:
            pulumi.set(__self__, "progress", progress)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)
        if snapshot_type is not None:
            pulumi.set(__self__, "snapshot_type", snapshot_type)
        if source_size is not None:
            pulumi.set(__self__, "source_size", source_size)
        if source_version is not None:
            pulumi.set(__self__, "source_version", source_version)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of snapshot.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of snapshot.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of file system.
        """
        return pulumi.get(self, "file_system_name")

    @file_system_name.setter
    def file_system_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_name", value)

    @property
    @pulumi.getter(name="isEncrypt")
    def is_encrypt(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether is encrypt.
        """
        return pulumi.get(self, "is_encrypt")

    @is_encrypt.setter
    def is_encrypt(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_encrypt", value)

    @property
    @pulumi.getter
    def progress(self) -> Optional[pulumi.Input[str]]:
        """
        The progress of snapshot.
        """
        return pulumi.get(self, "progress")

    @progress.setter
    def progress(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "progress", value)

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of snapshot.
        """
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_name", value)

    @property
    @pulumi.getter(name="snapshotType")
    def snapshot_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of snapshot.
        """
        return pulumi.get(self, "snapshot_type")

    @snapshot_type.setter
    def snapshot_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_type", value)

    @property
    @pulumi.getter(name="sourceSize")
    def source_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of source.
        """
        return pulumi.get(self, "source_size")

    @source_size.setter
    def source_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "source_size", value)

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> Optional[pulumi.Input[str]]:
        """
        The source version info.
        """
        return pulumi.get(self, "source_version")

    @source_version.setter
    def source_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_version", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of snapshot.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class Snapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 snapshot_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage nas snapshot
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.nas.Snapshot("foo",
            description="desc2",
            file_system_id="enas-cnbj5c18f02afe0e",
            snapshot_name="tfsnap3")
        ```

        ## Import

        Nas Snapshot can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:nas/snapshot:Snapshot default snap-472a716f****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of snapshot.
        :param pulumi.Input[str] file_system_id: The ID of the file system.
        :param pulumi.Input[str] snapshot_name: The name of snapshot.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnapshotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage nas snapshot
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.nas.Snapshot("foo",
            description="desc2",
            file_system_id="enas-cnbj5c18f02afe0e",
            snapshot_name="tfsnap3")
        ```

        ## Import

        Nas Snapshot can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:nas/snapshot:Snapshot default snap-472a716f****
        ```

        :param str resource_name: The name of the resource.
        :param SnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 snapshot_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnapshotArgs.__new__(SnapshotArgs)

            __props__.__dict__["description"] = description
            if file_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'file_system_id'")
            __props__.__dict__["file_system_id"] = file_system_id
            if snapshot_name is None and not opts.urn:
                raise TypeError("Missing required property 'snapshot_name'")
            __props__.__dict__["snapshot_name"] = snapshot_name
            __props__.__dict__["create_time"] = None
            __props__.__dict__["file_system_name"] = None
            __props__.__dict__["is_encrypt"] = None
            __props__.__dict__["progress"] = None
            __props__.__dict__["snapshot_type"] = None
            __props__.__dict__["source_size"] = None
            __props__.__dict__["source_version"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["zone_id"] = None
        super(Snapshot, __self__).__init__(
            'volcengine:nas/snapshot:Snapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            file_system_id: Optional[pulumi.Input[str]] = None,
            file_system_name: Optional[pulumi.Input[str]] = None,
            is_encrypt: Optional[pulumi.Input[bool]] = None,
            progress: Optional[pulumi.Input[str]] = None,
            snapshot_name: Optional[pulumi.Input[str]] = None,
            snapshot_type: Optional[pulumi.Input[str]] = None,
            source_size: Optional[pulumi.Input[int]] = None,
            source_version: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'Snapshot':
        """
        Get an existing Snapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: The create time of snapshot.
        :param pulumi.Input[str] description: The description of snapshot.
        :param pulumi.Input[str] file_system_id: The ID of the file system.
        :param pulumi.Input[str] file_system_name: The name of file system.
        :param pulumi.Input[bool] is_encrypt: Whether is encrypt.
        :param pulumi.Input[str] progress: The progress of snapshot.
        :param pulumi.Input[str] snapshot_name: The name of snapshot.
        :param pulumi.Input[str] snapshot_type: The type of snapshot.
        :param pulumi.Input[int] source_size: The size of source.
        :param pulumi.Input[str] source_version: The source version info.
        :param pulumi.Input[str] status: The status of snapshot.
        :param pulumi.Input[str] zone_id: The ID of zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnapshotState.__new__(_SnapshotState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["file_system_id"] = file_system_id
        __props__.__dict__["file_system_name"] = file_system_name
        __props__.__dict__["is_encrypt"] = is_encrypt
        __props__.__dict__["progress"] = progress
        __props__.__dict__["snapshot_name"] = snapshot_name
        __props__.__dict__["snapshot_type"] = snapshot_type
        __props__.__dict__["source_size"] = source_size
        __props__.__dict__["source_version"] = source_version
        __props__.__dict__["status"] = status
        __props__.__dict__["zone_id"] = zone_id
        return Snapshot(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The create time of snapshot.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of snapshot.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> pulumi.Output[str]:
        """
        The ID of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="fileSystemName")
    def file_system_name(self) -> pulumi.Output[str]:
        """
        The name of file system.
        """
        return pulumi.get(self, "file_system_name")

    @property
    @pulumi.getter(name="isEncrypt")
    def is_encrypt(self) -> pulumi.Output[bool]:
        """
        Whether is encrypt.
        """
        return pulumi.get(self, "is_encrypt")

    @property
    @pulumi.getter
    def progress(self) -> pulumi.Output[str]:
        """
        The progress of snapshot.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> pulumi.Output[str]:
        """
        The name of snapshot.
        """
        return pulumi.get(self, "snapshot_name")

    @property
    @pulumi.getter(name="snapshotType")
    def snapshot_type(self) -> pulumi.Output[str]:
        """
        The type of snapshot.
        """
        return pulumi.get(self, "snapshot_type")

    @property
    @pulumi.getter(name="sourceSize")
    def source_size(self) -> pulumi.Output[int]:
        """
        The size of source.
        """
        return pulumi.get(self, "source_size")

    @property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> pulumi.Output[str]:
        """
        The source version info.
        """
        return pulumi.get(self, "source_version")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of snapshot.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The ID of zone.
        """
        return pulumi.get(self, "zone_id")

