# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'SnapshotsResult',
    'AwaitableSnapshotsResult',
    'snapshots',
    'snapshots_output',
]

@pulumi.output_type
class SnapshotsResult:
    """
    A collection of values returned by Snapshots.
    """
    def __init__(__self__, file_system_id=None, id=None, ids=None, output_file=None, snapshot_name=None, snapshot_type=None, snapshots=None, status=None, total_count=None):
        if file_system_id and not isinstance(file_system_id, str):
            raise TypeError("Expected argument 'file_system_id' to be a str")
        pulumi.set(__self__, "file_system_id", file_system_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if snapshot_name and not isinstance(snapshot_name, str):
            raise TypeError("Expected argument 'snapshot_name' to be a str")
        pulumi.set(__self__, "snapshot_name", snapshot_name)
        if snapshot_type and not isinstance(snapshot_type, str):
            raise TypeError("Expected argument 'snapshot_type' to be a str")
        pulumi.set(__self__, "snapshot_type", snapshot_type)
        if snapshots and not isinstance(snapshots, list):
            raise TypeError("Expected argument 'snapshots' to be a list")
        pulumi.set(__self__, "snapshots", snapshots)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[str]:
        """
        The id of file system.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[str]:
        """
        The name of snapshot.
        """
        return pulumi.get(self, "snapshot_name")

    @property
    @pulumi.getter(name="snapshotType")
    def snapshot_type(self) -> Optional[str]:
        """
        The type of snapshot.
        """
        return pulumi.get(self, "snapshot_type")

    @property
    @pulumi.getter
    def snapshots(self) -> Sequence['outputs.SnapshotsSnapshotResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "snapshots")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of snapshot.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")


class AwaitableSnapshotsResult(SnapshotsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return SnapshotsResult(
            file_system_id=self.file_system_id,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            snapshot_name=self.snapshot_name,
            snapshot_type=self.snapshot_type,
            snapshots=self.snapshots,
            status=self.status,
            total_count=self.total_count)


def snapshots(file_system_id: Optional[str] = None,
              ids: Optional[Sequence[str]] = None,
              output_file: Optional[str] = None,
              snapshot_name: Optional[str] = None,
              snapshot_type: Optional[str] = None,
              status: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableSnapshotsResult:
    """
    Use this data source to query detailed information of nas snapshots
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.nas.snapshots(file_system_id="enas-cnbj5c18f02afe0e",
        ids=[
            "snap-022c648fed8b",
            "snap-e53591b05fbd",
        ])
    ```


    :param str file_system_id: The ID of file system.
    :param Sequence[str] ids: A list of Snapshot IDs.
    :param str output_file: File name where to save data source results.
    :param str snapshot_name: The name of snapshot.
    :param str snapshot_type: The type of snapshot.
    :param str status: The status of snapshot.
    """
    __args__ = dict()
    __args__['fileSystemId'] = file_system_id
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['snapshotName'] = snapshot_name
    __args__['snapshotType'] = snapshot_type
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:nas/snapshots:Snapshots', __args__, opts=opts, typ=SnapshotsResult).value

    return AwaitableSnapshotsResult(
        file_system_id=pulumi.get(__ret__, 'file_system_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        snapshot_name=pulumi.get(__ret__, 'snapshot_name'),
        snapshot_type=pulumi.get(__ret__, 'snapshot_type'),
        snapshots=pulumi.get(__ret__, 'snapshots'),
        status=pulumi.get(__ret__, 'status'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(snapshots)
def snapshots_output(file_system_id: Optional[pulumi.Input[Optional[str]]] = None,
                     ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                     snapshot_name: Optional[pulumi.Input[Optional[str]]] = None,
                     snapshot_type: Optional[pulumi.Input[Optional[str]]] = None,
                     status: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[SnapshotsResult]:
    """
    Use this data source to query detailed information of nas snapshots
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.nas.snapshots(file_system_id="enas-cnbj5c18f02afe0e",
        ids=[
            "snap-022c648fed8b",
            "snap-e53591b05fbd",
        ])
    ```


    :param str file_system_id: The ID of file system.
    :param Sequence[str] ids: A list of Snapshot IDs.
    :param str output_file: File name where to save data source results.
    :param str snapshot_name: The name of snapshot.
    :param str snapshot_type: The type of snapshot.
    :param str status: The status of snapshot.
    """
    ...
