# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DnatEntriesResult',
    'AwaitableDnatEntriesResult',
    'dnat_entries',
    'dnat_entries_output',
]

@pulumi.output_type
class DnatEntriesResult:
    """
    A collection of values returned by DnatEntries.
    """
    def __init__(__self__, dnat_entries=None, dnat_entry_name=None, external_ip=None, external_port=None, id=None, ids=None, internal_ip=None, internal_port=None, nat_gateway_id=None, output_file=None, protocol=None, total_count=None):
        if dnat_entries and not isinstance(dnat_entries, list):
            raise TypeError("Expected argument 'dnat_entries' to be a list")
        pulumi.set(__self__, "dnat_entries", dnat_entries)
        if dnat_entry_name and not isinstance(dnat_entry_name, str):
            raise TypeError("Expected argument 'dnat_entry_name' to be a str")
        pulumi.set(__self__, "dnat_entry_name", dnat_entry_name)
        if external_ip and not isinstance(external_ip, str):
            raise TypeError("Expected argument 'external_ip' to be a str")
        pulumi.set(__self__, "external_ip", external_ip)
        if external_port and not isinstance(external_port, str):
            raise TypeError("Expected argument 'external_port' to be a str")
        pulumi.set(__self__, "external_port", external_port)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if internal_ip and not isinstance(internal_ip, str):
            raise TypeError("Expected argument 'internal_ip' to be a str")
        pulumi.set(__self__, "internal_ip", internal_ip)
        if internal_port and not isinstance(internal_port, str):
            raise TypeError("Expected argument 'internal_port' to be a str")
        pulumi.set(__self__, "internal_port", internal_port)
        if nat_gateway_id and not isinstance(nat_gateway_id, str):
            raise TypeError("Expected argument 'nat_gateway_id' to be a str")
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="dnatEntries")
    def dnat_entries(self) -> Sequence['outputs.DnatEntriesDnatEntryResult']:
        """
        List of DNAT entries.
        """
        return pulumi.get(self, "dnat_entries")

    @property
    @pulumi.getter(name="dnatEntryName")
    def dnat_entry_name(self) -> Optional[str]:
        """
        The name of the DNAT entry.
        """
        return pulumi.get(self, "dnat_entry_name")

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> Optional[str]:
        """
        Provides the public IP address for public network access.
        """
        return pulumi.get(self, "external_ip")

    @property
    @pulumi.getter(name="externalPort")
    def external_port(self) -> Optional[str]:
        """
        The port or port segment that receives requests from the public network. If InternalPort is passed into the port segment, ExternalPort must also be passed into the port segment.
        """
        return pulumi.get(self, "external_port")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> Optional[str]:
        """
        Provides the internal IP address.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter(name="internalPort")
    def internal_port(self) -> Optional[str]:
        """
        The port or port segment on which the cloud server instance provides services to the public network.
        """
        return pulumi.get(self, "internal_port")

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[str]:
        """
        The ID of the NAT gateway.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The network protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of snat entries query.
        """
        return pulumi.get(self, "total_count")


class AwaitableDnatEntriesResult(DnatEntriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return DnatEntriesResult(
            dnat_entries=self.dnat_entries,
            dnat_entry_name=self.dnat_entry_name,
            external_ip=self.external_ip,
            external_port=self.external_port,
            id=self.id,
            ids=self.ids,
            internal_ip=self.internal_ip,
            internal_port=self.internal_port,
            nat_gateway_id=self.nat_gateway_id,
            output_file=self.output_file,
            protocol=self.protocol,
            total_count=self.total_count)


def dnat_entries(dnat_entry_name: Optional[str] = None,
                 external_ip: Optional[str] = None,
                 external_port: Optional[str] = None,
                 ids: Optional[Sequence[str]] = None,
                 internal_ip: Optional[str] = None,
                 internal_port: Optional[str] = None,
                 nat_gateway_id: Optional[str] = None,
                 output_file: Optional[str] = None,
                 protocol: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableDnatEntriesResult:
    """
    Use this data source to query detailed information of dnat entries
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_gateway = volcengine.nat.Gateway("fooGateway",
        vpc_id=foo_vpc.id,
        subnet_id=foo_subnet.id,
        spec="Small",
        nat_gateway_name="acc-test-ng",
        description="acc-test",
        billing_type="PostPaid",
        project_name="default",
        tags=[volcengine.nat.GatewayTagArgs(
            key="k1",
            value="v1",
        )])
    foo_address = volcengine.eip.Address("fooAddress",
        description="acc-test",
        bandwidth=1,
        billing_type="PostPaidByBandwidth",
        isp="BGP")
    foo_associate = volcengine.eip.Associate("fooAssociate",
        allocation_id=foo_address.id,
        instance_id=foo_gateway.id,
        instance_type="Nat")
    foo_dnat_entry = volcengine.nat.DnatEntry("fooDnatEntry",
        dnat_entry_name="acc-test-dnat-entry",
        external_ip=foo_address.eip_address,
        external_port="80",
        internal_ip="172.16.0.10",
        internal_port="80",
        nat_gateway_id=foo_gateway.id,
        protocol="tcp",
        opts=pulumi.ResourceOptions(depends_on=[foo_associate]))
    foo_dnat_entries = volcengine.nat.dnat_entries_output(ids=[foo_dnat_entry.id])
    ```


    :param str dnat_entry_name: The name of the DNAT entry.
    :param str external_ip: Provides the public IP address for public network access.
    :param str external_port: The port or port segment that receives requests from the public network. If InternalPort is passed into the port segment, ExternalPort must also be passed into the port segment.
    :param Sequence[str] ids: A list of DNAT entry ids.
    :param str internal_ip: Provides the internal IP address.
    :param str internal_port: The port or port segment on which the cloud server instance provides services to the public network.
    :param str nat_gateway_id: The id of the NAT gateway.
    :param str output_file: File name where to save data source results.
    :param str protocol: The network protocol.
    """
    __args__ = dict()
    __args__['dnatEntryName'] = dnat_entry_name
    __args__['externalIp'] = external_ip
    __args__['externalPort'] = external_port
    __args__['ids'] = ids
    __args__['internalIp'] = internal_ip
    __args__['internalPort'] = internal_port
    __args__['natGatewayId'] = nat_gateway_id
    __args__['outputFile'] = output_file
    __args__['protocol'] = protocol
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:nat/dnatEntries:DnatEntries', __args__, opts=opts, typ=DnatEntriesResult).value

    return AwaitableDnatEntriesResult(
        dnat_entries=pulumi.get(__ret__, 'dnat_entries'),
        dnat_entry_name=pulumi.get(__ret__, 'dnat_entry_name'),
        external_ip=pulumi.get(__ret__, 'external_ip'),
        external_port=pulumi.get(__ret__, 'external_port'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        internal_ip=pulumi.get(__ret__, 'internal_ip'),
        internal_port=pulumi.get(__ret__, 'internal_port'),
        nat_gateway_id=pulumi.get(__ret__, 'nat_gateway_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        protocol=pulumi.get(__ret__, 'protocol'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(dnat_entries)
def dnat_entries_output(dnat_entry_name: Optional[pulumi.Input[Optional[str]]] = None,
                        external_ip: Optional[pulumi.Input[Optional[str]]] = None,
                        external_port: Optional[pulumi.Input[Optional[str]]] = None,
                        ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                        internal_ip: Optional[pulumi.Input[Optional[str]]] = None,
                        internal_port: Optional[pulumi.Input[Optional[str]]] = None,
                        nat_gateway_id: Optional[pulumi.Input[Optional[str]]] = None,
                        output_file: Optional[pulumi.Input[Optional[str]]] = None,
                        protocol: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[DnatEntriesResult]:
    """
    Use this data source to query detailed information of dnat entries
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_gateway = volcengine.nat.Gateway("fooGateway",
        vpc_id=foo_vpc.id,
        subnet_id=foo_subnet.id,
        spec="Small",
        nat_gateway_name="acc-test-ng",
        description="acc-test",
        billing_type="PostPaid",
        project_name="default",
        tags=[volcengine.nat.GatewayTagArgs(
            key="k1",
            value="v1",
        )])
    foo_address = volcengine.eip.Address("fooAddress",
        description="acc-test",
        bandwidth=1,
        billing_type="PostPaidByBandwidth",
        isp="BGP")
    foo_associate = volcengine.eip.Associate("fooAssociate",
        allocation_id=foo_address.id,
        instance_id=foo_gateway.id,
        instance_type="Nat")
    foo_dnat_entry = volcengine.nat.DnatEntry("fooDnatEntry",
        dnat_entry_name="acc-test-dnat-entry",
        external_ip=foo_address.eip_address,
        external_port="80",
        internal_ip="172.16.0.10",
        internal_port="80",
        nat_gateway_id=foo_gateway.id,
        protocol="tcp",
        opts=pulumi.ResourceOptions(depends_on=[foo_associate]))
    foo_dnat_entries = volcengine.nat.dnat_entries_output(ids=[foo_dnat_entry.id])
    ```


    :param str dnat_entry_name: The name of the DNAT entry.
    :param str external_ip: Provides the public IP address for public network access.
    :param str external_port: The port or port segment that receives requests from the public network. If InternalPort is passed into the port segment, ExternalPort must also be passed into the port segment.
    :param Sequence[str] ids: A list of DNAT entry ids.
    :param str internal_ip: Provides the internal IP address.
    :param str internal_port: The port or port segment on which the cloud server instance provides services to the public network.
    :param str nat_gateway_id: The id of the NAT gateway.
    :param str output_file: File name where to save data source results.
    :param str protocol: The network protocol.
    """
    ...
