# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SnatEntryArgs', 'SnatEntry']

@pulumi.input_type
class SnatEntryArgs:
    def __init__(__self__, *,
                 eip_id: pulumi.Input[str],
                 nat_gateway_id: pulumi.Input[str],
                 snat_entry_name: Optional[pulumi.Input[str]] = None,
                 source_cidr: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SnatEntry resource.
        :param pulumi.Input[str] eip_id: The id of the public ip address used by the SNAT entry.
        :param pulumi.Input[str] nat_gateway_id: The id of the nat gateway to which the entry belongs.
        :param pulumi.Input[str] snat_entry_name: The name of the SNAT entry.
        :param pulumi.Input[str] source_cidr: The SourceCidr of the SNAT entry. Only one of `subnet_id,source_cidr` can be specified.
        :param pulumi.Input[str] subnet_id: The id of the subnet that is required to access the internet. Only one of `subnet_id,source_cidr` can be specified.
        """
        pulumi.set(__self__, "eip_id", eip_id)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if snat_entry_name is not None:
            pulumi.set(__self__, "snat_entry_name", snat_entry_name)
        if source_cidr is not None:
            pulumi.set(__self__, "source_cidr", source_cidr)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> pulumi.Input[str]:
        """
        The id of the public ip address used by the SNAT entry.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "eip_id", value)

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Input[str]:
        """
        The id of the nat gateway to which the entry belongs.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "nat_gateway_id", value)

    @property
    @pulumi.getter(name="snatEntryName")
    def snat_entry_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SNAT entry.
        """
        return pulumi.get(self, "snat_entry_name")

    @snat_entry_name.setter
    def snat_entry_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snat_entry_name", value)

    @property
    @pulumi.getter(name="sourceCidr")
    def source_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The SourceCidr of the SNAT entry. Only one of `subnet_id,source_cidr` can be specified.
        """
        return pulumi.get(self, "source_cidr")

    @source_cidr.setter
    def source_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_cidr", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the subnet that is required to access the internet. Only one of `subnet_id,source_cidr` can be specified.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class _SnatEntryState:
    def __init__(__self__, *,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[str]] = None,
                 snat_entry_name: Optional[pulumi.Input[str]] = None,
                 source_cidr: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SnatEntry resources.
        :param pulumi.Input[str] eip_id: The id of the public ip address used by the SNAT entry.
        :param pulumi.Input[str] nat_gateway_id: The id of the nat gateway to which the entry belongs.
        :param pulumi.Input[str] snat_entry_name: The name of the SNAT entry.
        :param pulumi.Input[str] source_cidr: The SourceCidr of the SNAT entry. Only one of `subnet_id,source_cidr` can be specified.
        :param pulumi.Input[str] status: The status of the SNAT entry.
        :param pulumi.Input[str] subnet_id: The id of the subnet that is required to access the internet. Only one of `subnet_id,source_cidr` can be specified.
        """
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if nat_gateway_id is not None:
            pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if snat_entry_name is not None:
            pulumi.set(__self__, "snat_entry_name", snat_entry_name)
        if source_cidr is not None:
            pulumi.set(__self__, "source_cidr", source_cidr)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the public ip address used by the SNAT entry.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_id", value)

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the nat gateway to which the entry belongs.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_gateway_id", value)

    @property
    @pulumi.getter(name="snatEntryName")
    def snat_entry_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SNAT entry.
        """
        return pulumi.get(self, "snat_entry_name")

    @snat_entry_name.setter
    def snat_entry_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snat_entry_name", value)

    @property
    @pulumi.getter(name="sourceCidr")
    def source_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The SourceCidr of the SNAT entry. Only one of `subnet_id,source_cidr` can be specified.
        """
        return pulumi.get(self, "source_cidr")

    @source_cidr.setter
    def source_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_cidr", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the SNAT entry.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the subnet that is required to access the internet. Only one of `subnet_id,source_cidr` can be specified.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


class SnatEntry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[str]] = None,
                 snat_entry_name: Optional[pulumi.Input[str]] = None,
                 source_cidr: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage snat entry
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_gateway = volcengine.nat.Gateway("fooGateway",
            vpc_id=foo_vpc.id,
            subnet_id=foo_subnet.id,
            spec="Small",
            nat_gateway_name="acc-test-ng",
            description="acc-test",
            billing_type="PostPaid",
            project_name="default",
            tags=[volcengine.nat.GatewayTagArgs(
                key="k1",
                value="v1",
            )])
        foo_address = volcengine.eip.Address("fooAddress",
            description="acc-test",
            bandwidth=1,
            billing_type="PostPaidByBandwidth",
            isp="BGP")
        foo_associate = volcengine.eip.Associate("fooAssociate",
            allocation_id=foo_address.id,
            instance_id=foo_gateway.id,
            instance_type="Nat")
        foo_snat_entry = volcengine.nat.SnatEntry("fooSnatEntry",
            snat_entry_name="acc-test-snat-entry",
            nat_gateway_id=foo_gateway.id,
            eip_id=foo_address.id,
            source_cidr="172.16.0.0/24",
            opts=pulumi.ResourceOptions(depends_on=["volcengine_eip_associate.foo"]))
        ```

        ## Import

        Snat entry can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:nat/snatEntry:SnatEntry default snat-3fvhk47kf56****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] eip_id: The id of the public ip address used by the SNAT entry.
        :param pulumi.Input[str] nat_gateway_id: The id of the nat gateway to which the entry belongs.
        :param pulumi.Input[str] snat_entry_name: The name of the SNAT entry.
        :param pulumi.Input[str] source_cidr: The SourceCidr of the SNAT entry. Only one of `subnet_id,source_cidr` can be specified.
        :param pulumi.Input[str] subnet_id: The id of the subnet that is required to access the internet. Only one of `subnet_id,source_cidr` can be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnatEntryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage snat entry
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_gateway = volcengine.nat.Gateway("fooGateway",
            vpc_id=foo_vpc.id,
            subnet_id=foo_subnet.id,
            spec="Small",
            nat_gateway_name="acc-test-ng",
            description="acc-test",
            billing_type="PostPaid",
            project_name="default",
            tags=[volcengine.nat.GatewayTagArgs(
                key="k1",
                value="v1",
            )])
        foo_address = volcengine.eip.Address("fooAddress",
            description="acc-test",
            bandwidth=1,
            billing_type="PostPaidByBandwidth",
            isp="BGP")
        foo_associate = volcengine.eip.Associate("fooAssociate",
            allocation_id=foo_address.id,
            instance_id=foo_gateway.id,
            instance_type="Nat")
        foo_snat_entry = volcengine.nat.SnatEntry("fooSnatEntry",
            snat_entry_name="acc-test-snat-entry",
            nat_gateway_id=foo_gateway.id,
            eip_id=foo_address.id,
            source_cidr="172.16.0.0/24",
            opts=pulumi.ResourceOptions(depends_on=["volcengine_eip_associate.foo"]))
        ```

        ## Import

        Snat entry can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:nat/snatEntry:SnatEntry default snat-3fvhk47kf56****
        ```

        :param str resource_name: The name of the resource.
        :param SnatEntryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnatEntryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[str]] = None,
                 snat_entry_name: Optional[pulumi.Input[str]] = None,
                 source_cidr: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnatEntryArgs.__new__(SnatEntryArgs)

            if eip_id is None and not opts.urn:
                raise TypeError("Missing required property 'eip_id'")
            __props__.__dict__["eip_id"] = eip_id
            if nat_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'nat_gateway_id'")
            __props__.__dict__["nat_gateway_id"] = nat_gateway_id
            __props__.__dict__["snat_entry_name"] = snat_entry_name
            __props__.__dict__["source_cidr"] = source_cidr
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["status"] = None
        super(SnatEntry, __self__).__init__(
            'volcengine:nat/snatEntry:SnatEntry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            eip_id: Optional[pulumi.Input[str]] = None,
            nat_gateway_id: Optional[pulumi.Input[str]] = None,
            snat_entry_name: Optional[pulumi.Input[str]] = None,
            source_cidr: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None) -> 'SnatEntry':
        """
        Get an existing SnatEntry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] eip_id: The id of the public ip address used by the SNAT entry.
        :param pulumi.Input[str] nat_gateway_id: The id of the nat gateway to which the entry belongs.
        :param pulumi.Input[str] snat_entry_name: The name of the SNAT entry.
        :param pulumi.Input[str] source_cidr: The SourceCidr of the SNAT entry. Only one of `subnet_id,source_cidr` can be specified.
        :param pulumi.Input[str] status: The status of the SNAT entry.
        :param pulumi.Input[str] subnet_id: The id of the subnet that is required to access the internet. Only one of `subnet_id,source_cidr` can be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnatEntryState.__new__(_SnatEntryState)

        __props__.__dict__["eip_id"] = eip_id
        __props__.__dict__["nat_gateway_id"] = nat_gateway_id
        __props__.__dict__["snat_entry_name"] = snat_entry_name
        __props__.__dict__["source_cidr"] = source_cidr
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        return SnatEntry(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> pulumi.Output[str]:
        """
        The id of the public ip address used by the SNAT entry.
        """
        return pulumi.get(self, "eip_id")

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Output[str]:
        """
        The id of the nat gateway to which the entry belongs.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="snatEntryName")
    def snat_entry_name(self) -> pulumi.Output[str]:
        """
        The name of the SNAT entry.
        """
        return pulumi.get(self, "snat_entry_name")

    @property
    @pulumi.getter(name="sourceCidr")
    def source_cidr(self) -> pulumi.Output[str]:
        """
        The SourceCidr of the SNAT entry. Only one of `subnet_id,source_cidr` can be specified.
        """
        return pulumi.get(self, "source_cidr")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the SNAT entry.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The id of the subnet that is required to access the internet. Only one of `subnet_id,source_cidr` can be specified.
        """
        return pulumi.get(self, "subnet_id")

