# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VpcEndpointArgs', 'VpcEndpoint']

@pulumi.input_type
class VpcEndpointArgs:
    def __init__(__self__, *,
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 service_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VpcEndpoint resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: the security group ids of vpc endpoint.
        :param pulumi.Input[str] service_id: The id of vpc endpoint service.
        :param pulumi.Input[str] description: The description of vpc endpoint.
        :param pulumi.Input[str] endpoint_name: The name of vpc endpoint.
        :param pulumi.Input[str] service_name: The name of vpc endpoint service.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "service_id", service_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        the security group ids of vpc endpoint.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[str]:
        """
        The id of vpc endpoint service.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of vpc endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of vpc endpoint.
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of vpc endpoint service.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class _VpcEndpointState:
    def __init__(__self__, *,
                 business_status: Optional[pulumi.Input[str]] = None,
                 connection_status: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 deleted_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint_domain: Optional[pulumi.Input[str]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VpcEndpoint resources.
        :param pulumi.Input[str] business_status: Whether the vpc endpoint is locked.
        :param pulumi.Input[str] connection_status: The connection  status of vpc endpoint.
        :param pulumi.Input[str] creation_time: The create time of vpc endpoint.
        :param pulumi.Input[str] deleted_time: The delete time of vpc endpoint.
        :param pulumi.Input[str] description: The description of vpc endpoint.
        :param pulumi.Input[str] endpoint_domain: The domain of vpc endpoint.
        :param pulumi.Input[str] endpoint_name: The name of vpc endpoint.
        :param pulumi.Input[str] endpoint_type: The type of vpc endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: the security group ids of vpc endpoint.
        :param pulumi.Input[str] service_id: The id of vpc endpoint service.
        :param pulumi.Input[str] service_name: The name of vpc endpoint service.
        :param pulumi.Input[str] status: The status of vpc endpoint.
        :param pulumi.Input[str] update_time: The update time of vpc endpoint.
        :param pulumi.Input[str] vpc_id: The vpc id of vpc endpoint.
        """
        if business_status is not None:
            pulumi.set(__self__, "business_status", business_status)
        if connection_status is not None:
            pulumi.set(__self__, "connection_status", connection_status)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if deleted_time is not None:
            pulumi.set(__self__, "deleted_time", deleted_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint_domain is not None:
            pulumi.set(__self__, "endpoint_domain", endpoint_domain)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the vpc endpoint is locked.
        """
        return pulumi.get(self, "business_status")

    @business_status.setter
    def business_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "business_status", value)

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> Optional[pulumi.Input[str]]:
        """
        The connection  status of vpc endpoint.
        """
        return pulumi.get(self, "connection_status")

    @connection_status.setter
    def connection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_status", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of vpc endpoint.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="deletedTime")
    def deleted_time(self) -> Optional[pulumi.Input[str]]:
        """
        The delete time of vpc endpoint.
        """
        return pulumi.get(self, "deleted_time")

    @deleted_time.setter
    def deleted_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deleted_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of vpc endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endpointDomain")
    def endpoint_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain of vpc endpoint.
        """
        return pulumi.get(self, "endpoint_domain")

    @endpoint_domain.setter
    def endpoint_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_domain", value)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of vpc endpoint.
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of vpc endpoint.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        the security group ids of vpc endpoint.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of vpc endpoint service.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of vpc endpoint service.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of vpc endpoint.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of vpc endpoint.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vpc id of vpc endpoint.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class VpcEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage privatelink vpc endpoint
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        endpoint = volcengine.privatelink.VpcEndpoint("endpoint",
            security_group_ids=["sg-2d5z8cr53k45c58ozfdum****"],
            service_id="epsvc-2byz5nzgiansw2dx0eehh****",
            endpoint_name="tf-test-ep",
            description="tf-test")
        zone = volcengine.privatelink.VpcEndpointZone("zone",
            endpoint_id=endpoint.id,
            subnet_id="subnet-2bz47q19zhx4w2dx0eevn****",
            private_ip_address="172.16.0.252")
        ```

        ## Import

        VpcEndpoint can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:privatelink/vpcEndpoint:VpcEndpoint default ep-3rel74u229dz45zsk2i6l****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of vpc endpoint.
        :param pulumi.Input[str] endpoint_name: The name of vpc endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: the security group ids of vpc endpoint.
        :param pulumi.Input[str] service_id: The id of vpc endpoint service.
        :param pulumi.Input[str] service_name: The name of vpc endpoint service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage privatelink vpc endpoint
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        endpoint = volcengine.privatelink.VpcEndpoint("endpoint",
            security_group_ids=["sg-2d5z8cr53k45c58ozfdum****"],
            service_id="epsvc-2byz5nzgiansw2dx0eehh****",
            endpoint_name="tf-test-ep",
            description="tf-test")
        zone = volcengine.privatelink.VpcEndpointZone("zone",
            endpoint_id=endpoint.id,
            subnet_id="subnet-2bz47q19zhx4w2dx0eevn****",
            private_ip_address="172.16.0.252")
        ```

        ## Import

        VpcEndpoint can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:privatelink/vpcEndpoint:VpcEndpoint default ep-3rel74u229dz45zsk2i6l****
        ```

        :param str resource_name: The name of the resource.
        :param VpcEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcEndpointArgs.__new__(VpcEndpointArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["endpoint_name"] = endpoint_name
            if security_group_ids is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_ids'")
            __props__.__dict__["security_group_ids"] = security_group_ids
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["business_status"] = None
            __props__.__dict__["connection_status"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["deleted_time"] = None
            __props__.__dict__["endpoint_domain"] = None
            __props__.__dict__["endpoint_type"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["vpc_id"] = None
        super(VpcEndpoint, __self__).__init__(
            'volcengine:privatelink/vpcEndpoint:VpcEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            business_status: Optional[pulumi.Input[str]] = None,
            connection_status: Optional[pulumi.Input[str]] = None,
            creation_time: Optional[pulumi.Input[str]] = None,
            deleted_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            endpoint_domain: Optional[pulumi.Input[str]] = None,
            endpoint_name: Optional[pulumi.Input[str]] = None,
            endpoint_type: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            service_id: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'VpcEndpoint':
        """
        Get an existing VpcEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] business_status: Whether the vpc endpoint is locked.
        :param pulumi.Input[str] connection_status: The connection  status of vpc endpoint.
        :param pulumi.Input[str] creation_time: The create time of vpc endpoint.
        :param pulumi.Input[str] deleted_time: The delete time of vpc endpoint.
        :param pulumi.Input[str] description: The description of vpc endpoint.
        :param pulumi.Input[str] endpoint_domain: The domain of vpc endpoint.
        :param pulumi.Input[str] endpoint_name: The name of vpc endpoint.
        :param pulumi.Input[str] endpoint_type: The type of vpc endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: the security group ids of vpc endpoint.
        :param pulumi.Input[str] service_id: The id of vpc endpoint service.
        :param pulumi.Input[str] service_name: The name of vpc endpoint service.
        :param pulumi.Input[str] status: The status of vpc endpoint.
        :param pulumi.Input[str] update_time: The update time of vpc endpoint.
        :param pulumi.Input[str] vpc_id: The vpc id of vpc endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcEndpointState.__new__(_VpcEndpointState)

        __props__.__dict__["business_status"] = business_status
        __props__.__dict__["connection_status"] = connection_status
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["deleted_time"] = deleted_time
        __props__.__dict__["description"] = description
        __props__.__dict__["endpoint_domain"] = endpoint_domain
        __props__.__dict__["endpoint_name"] = endpoint_name
        __props__.__dict__["endpoint_type"] = endpoint_type
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["status"] = status
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vpc_id"] = vpc_id
        return VpcEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> pulumi.Output[str]:
        """
        Whether the vpc endpoint is locked.
        """
        return pulumi.get(self, "business_status")

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> pulumi.Output[str]:
        """
        The connection  status of vpc endpoint.
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The create time of vpc endpoint.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deletedTime")
    def deleted_time(self) -> pulumi.Output[str]:
        """
        The delete time of vpc endpoint.
        """
        return pulumi.get(self, "deleted_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of vpc endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endpointDomain")
    def endpoint_domain(self) -> pulumi.Output[str]:
        """
        The domain of vpc endpoint.
        """
        return pulumi.get(self, "endpoint_domain")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Output[str]:
        """
        The name of vpc endpoint.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[str]:
        """
        The type of vpc endpoint.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        the security group ids of vpc endpoint.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[str]:
        """
        The id of vpc endpoint service.
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        The name of vpc endpoint service.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of vpc endpoint.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The update time of vpc endpoint.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The vpc id of vpc endpoint.
        """
        return pulumi.get(self, "vpc_id")

