# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcEndpointConnectionArgs', 'VpcEndpointConnection']

@pulumi.input_type
class VpcEndpointConnectionArgs:
    def __init__(__self__, *,
                 endpoint_id: pulumi.Input[str],
                 service_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a VpcEndpointConnection resource.
        :param pulumi.Input[str] endpoint_id: The id of the endpoint.
        :param pulumi.Input[str] service_id: The id of the security group.
        """
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "service_id", service_id)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> pulumi.Input[str]:
        """
        The id of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[str]:
        """
        The id of the security group.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_id", value)


@pulumi.input_type
class _VpcEndpointConnectionState:
    def __init__(__self__, *,
                 connection_status: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 endpoint_owner_account_id: Optional[pulumi.Input[str]] = None,
                 endpoint_vpc_id: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointConnectionZoneArgs']]]] = None):
        """
        Input properties used for looking up and filtering VpcEndpointConnection resources.
        :param pulumi.Input[str] connection_status: The status of the connection.
        :param pulumi.Input[str] creation_time: The create time of the connection.
        :param pulumi.Input[str] endpoint_id: The id of the endpoint.
        :param pulumi.Input[str] endpoint_owner_account_id: The account id of the vpc endpoint.
        :param pulumi.Input[str] endpoint_vpc_id: The vpc id of the vpc endpoint.
        :param pulumi.Input[str] service_id: The id of the security group.
        :param pulumi.Input[str] update_time: The update time of the connection.
        :param pulumi.Input[Sequence[pulumi.Input['VpcEndpointConnectionZoneArgs']]] zones: The available zones.
        """
        if connection_status is not None:
            pulumi.set(__self__, "connection_status", connection_status)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if endpoint_owner_account_id is not None:
            pulumi.set(__self__, "endpoint_owner_account_id", endpoint_owner_account_id)
        if endpoint_vpc_id is not None:
            pulumi.set(__self__, "endpoint_vpc_id", endpoint_vpc_id)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the connection.
        """
        return pulumi.get(self, "connection_status")

    @connection_status.setter
    def connection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_status", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of the connection.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter(name="endpointOwnerAccountId")
    def endpoint_owner_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account id of the vpc endpoint.
        """
        return pulumi.get(self, "endpoint_owner_account_id")

    @endpoint_owner_account_id.setter
    def endpoint_owner_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_owner_account_id", value)

    @property
    @pulumi.getter(name="endpointVpcId")
    def endpoint_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vpc id of the vpc endpoint.
        """
        return pulumi.get(self, "endpoint_vpc_id")

    @endpoint_vpc_id.setter
    def endpoint_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_vpc_id", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the security group.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of the connection.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointConnectionZoneArgs']]]]:
        """
        The available zones.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointConnectionZoneArgs']]]]):
        pulumi.set(self, "zones", value)


class VpcEndpointConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage privatelink vpc endpoint connection
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.privatelink.VpcEndpointConnection("foo",
            endpoint_id="ep-3rel74u229dz45zsk2i6l69qa",
            service_id="epsvc-2byz5mykk9y4g2dx0efs4aqz3")
        ```

        ## Import

        PrivateLink Vpc Endpoint Connection Service can be imported using the endpoint id and service id, e.g.

        ```sh
         $ pulumi import volcengine:privatelink/vpcEndpointConnection:VpcEndpointConnection default ep-3rel74u229dz45zsk2i6l69qa:epsvc-2byz5mykk9y4g2dx0efs4aqz3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] endpoint_id: The id of the endpoint.
        :param pulumi.Input[str] service_id: The id of the security group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcEndpointConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage privatelink vpc endpoint connection
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.privatelink.VpcEndpointConnection("foo",
            endpoint_id="ep-3rel74u229dz45zsk2i6l69qa",
            service_id="epsvc-2byz5mykk9y4g2dx0efs4aqz3")
        ```

        ## Import

        PrivateLink Vpc Endpoint Connection Service can be imported using the endpoint id and service id, e.g.

        ```sh
         $ pulumi import volcengine:privatelink/vpcEndpointConnection:VpcEndpointConnection default ep-3rel74u229dz45zsk2i6l69qa:epsvc-2byz5mykk9y4g2dx0efs4aqz3
        ```

        :param str resource_name: The name of the resource.
        :param VpcEndpointConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcEndpointConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint_id: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcEndpointConnectionArgs.__new__(VpcEndpointConnectionArgs)

            if endpoint_id is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_id'")
            __props__.__dict__["endpoint_id"] = endpoint_id
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
            __props__.__dict__["connection_status"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["endpoint_owner_account_id"] = None
            __props__.__dict__["endpoint_vpc_id"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["zones"] = None
        super(VpcEndpointConnection, __self__).__init__(
            'volcengine:privatelink/vpcEndpointConnection:VpcEndpointConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_status: Optional[pulumi.Input[str]] = None,
            creation_time: Optional[pulumi.Input[str]] = None,
            endpoint_id: Optional[pulumi.Input[str]] = None,
            endpoint_owner_account_id: Optional[pulumi.Input[str]] = None,
            endpoint_vpc_id: Optional[pulumi.Input[str]] = None,
            service_id: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcEndpointConnectionZoneArgs']]]]] = None) -> 'VpcEndpointConnection':
        """
        Get an existing VpcEndpointConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_status: The status of the connection.
        :param pulumi.Input[str] creation_time: The create time of the connection.
        :param pulumi.Input[str] endpoint_id: The id of the endpoint.
        :param pulumi.Input[str] endpoint_owner_account_id: The account id of the vpc endpoint.
        :param pulumi.Input[str] endpoint_vpc_id: The vpc id of the vpc endpoint.
        :param pulumi.Input[str] service_id: The id of the security group.
        :param pulumi.Input[str] update_time: The update time of the connection.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcEndpointConnectionZoneArgs']]]] zones: The available zones.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcEndpointConnectionState.__new__(_VpcEndpointConnectionState)

        __props__.__dict__["connection_status"] = connection_status
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["endpoint_id"] = endpoint_id
        __props__.__dict__["endpoint_owner_account_id"] = endpoint_owner_account_id
        __props__.__dict__["endpoint_vpc_id"] = endpoint_vpc_id
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["zones"] = zones
        return VpcEndpointConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> pulumi.Output[str]:
        """
        The status of the connection.
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The create time of the connection.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> pulumi.Output[str]:
        """
        The id of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter(name="endpointOwnerAccountId")
    def endpoint_owner_account_id(self) -> pulumi.Output[str]:
        """
        The account id of the vpc endpoint.
        """
        return pulumi.get(self, "endpoint_owner_account_id")

    @property
    @pulumi.getter(name="endpointVpcId")
    def endpoint_vpc_id(self) -> pulumi.Output[str]:
        """
        The vpc id of the vpc endpoint.
        """
        return pulumi.get(self, "endpoint_vpc_id")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[str]:
        """
        The id of the security group.
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The update time of the connection.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Sequence['outputs.VpcEndpointConnectionZone']]:
        """
        The available zones.
        """
        return pulumi.get(self, "zones")

