# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcEndpointServiceArgs', 'VpcEndpointService']

@pulumi.input_type
class VpcEndpointServiceArgs:
    def __init__(__self__, *,
                 resources: pulumi.Input[Sequence[pulumi.Input['VpcEndpointServiceResourceArgs']]],
                 auto_accept_enabled: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VpcEndpointService resource.
        :param pulumi.Input[Sequence[pulumi.Input['VpcEndpointServiceResourceArgs']]] resources: The resources info. When create vpc endpoint service, the resource must exist.
        :param pulumi.Input[bool] auto_accept_enabled: Whether auto accept node connect.
        :param pulumi.Input[str] description: The description of service.
        """
        pulumi.set(__self__, "resources", resources)
        if auto_accept_enabled is not None:
            pulumi.set(__self__, "auto_accept_enabled", auto_accept_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Input[Sequence[pulumi.Input['VpcEndpointServiceResourceArgs']]]:
        """
        The resources info. When create vpc endpoint service, the resource must exist.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input[Sequence[pulumi.Input['VpcEndpointServiceResourceArgs']]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="autoAcceptEnabled")
    def auto_accept_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether auto accept node connect.
        """
        return pulumi.get(self, "auto_accept_enabled")

    @auto_accept_enabled.setter
    def auto_accept_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_accept_enabled", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _VpcEndpointServiceState:
    def __init__(__self__, *,
                 auto_accept_enabled: Optional[pulumi.Input[bool]] = None,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointServiceResourceArgs']]]] = None,
                 service_domain: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 service_resource_type: Optional[pulumi.Input[str]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering VpcEndpointService resources.
        :param pulumi.Input[bool] auto_accept_enabled: Whether auto accept node connect.
        :param pulumi.Input[str] creation_time: The create time of service.
        :param pulumi.Input[str] description: The description of service.
        :param pulumi.Input[Sequence[pulumi.Input['VpcEndpointServiceResourceArgs']]] resources: The resources info. When create vpc endpoint service, the resource must exist.
        :param pulumi.Input[str] service_domain: The domain of service.
        :param pulumi.Input[str] service_id: The Id of service.
        :param pulumi.Input[str] service_name: The name of service.
        :param pulumi.Input[str] service_resource_type: The resource type of service.
        :param pulumi.Input[str] service_type: The type of service.
        :param pulumi.Input[str] status: The status of service.
        :param pulumi.Input[str] update_time: The update time of service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zone_ids: The IDs of zones.
        """
        if auto_accept_enabled is not None:
            pulumi.set(__self__, "auto_accept_enabled", auto_accept_enabled)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if service_domain is not None:
            pulumi.set(__self__, "service_domain", service_domain)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if service_resource_type is not None:
            pulumi.set(__self__, "service_resource_type", service_resource_type)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if zone_ids is not None:
            pulumi.set(__self__, "zone_ids", zone_ids)

    @property
    @pulumi.getter(name="autoAcceptEnabled")
    def auto_accept_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether auto accept node connect.
        """
        return pulumi.get(self, "auto_accept_enabled")

    @auto_accept_enabled.setter
    def auto_accept_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_accept_enabled", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of service.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointServiceResourceArgs']]]]:
        """
        The resources info. When create vpc endpoint service, the resource must exist.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointServiceResourceArgs']]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="serviceDomain")
    def service_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain of service.
        """
        return pulumi.get(self, "service_domain")

    @service_domain.setter
    def service_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_domain", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of service.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of service.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="serviceResourceType")
    def service_resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        The resource type of service.
        """
        return pulumi.get(self, "service_resource_type")

    @service_resource_type.setter
    def service_resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_resource_type", value)

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of service.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of service.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs of zones.
        """
        return pulumi.get(self, "zone_ids")

    @zone_ids.setter
    def zone_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zone_ids", value)


class VpcEndpointService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_accept_enabled: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcEndpointServiceResourceArgs']]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage privatelink vpc endpoint service
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.privatelink.VpcEndpointService("foo",
            auto_accept_enabled=True,
            description="tftest",
            resources=[volcengine.privatelink.VpcEndpointServiceResourceArgs(
                resource_id="clb-2bzxccdjo9uyo2dx0eg0orzla",
                resource_type="CLB",
            )])
        ```

        ## Import

        VpcEndpointService can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:privatelink/vpcEndpointService:VpcEndpointService default epsvc-2fe630gurkl37k5gfuy33****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_accept_enabled: Whether auto accept node connect.
        :param pulumi.Input[str] description: The description of service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcEndpointServiceResourceArgs']]]] resources: The resources info. When create vpc endpoint service, the resource must exist.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcEndpointServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage privatelink vpc endpoint service
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.privatelink.VpcEndpointService("foo",
            auto_accept_enabled=True,
            description="tftest",
            resources=[volcengine.privatelink.VpcEndpointServiceResourceArgs(
                resource_id="clb-2bzxccdjo9uyo2dx0eg0orzla",
                resource_type="CLB",
            )])
        ```

        ## Import

        VpcEndpointService can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:privatelink/vpcEndpointService:VpcEndpointService default epsvc-2fe630gurkl37k5gfuy33****
        ```

        :param str resource_name: The name of the resource.
        :param VpcEndpointServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcEndpointServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_accept_enabled: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcEndpointServiceResourceArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcEndpointServiceArgs.__new__(VpcEndpointServiceArgs)

            __props__.__dict__["auto_accept_enabled"] = auto_accept_enabled
            __props__.__dict__["description"] = description
            if resources is None and not opts.urn:
                raise TypeError("Missing required property 'resources'")
            __props__.__dict__["resources"] = resources
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["service_domain"] = None
            __props__.__dict__["service_id"] = None
            __props__.__dict__["service_name"] = None
            __props__.__dict__["service_resource_type"] = None
            __props__.__dict__["service_type"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["zone_ids"] = None
        super(VpcEndpointService, __self__).__init__(
            'volcengine:privatelink/vpcEndpointService:VpcEndpointService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_accept_enabled: Optional[pulumi.Input[bool]] = None,
            creation_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcEndpointServiceResourceArgs']]]]] = None,
            service_domain: Optional[pulumi.Input[str]] = None,
            service_id: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            service_resource_type: Optional[pulumi.Input[str]] = None,
            service_type: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'VpcEndpointService':
        """
        Get an existing VpcEndpointService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_accept_enabled: Whether auto accept node connect.
        :param pulumi.Input[str] creation_time: The create time of service.
        :param pulumi.Input[str] description: The description of service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VpcEndpointServiceResourceArgs']]]] resources: The resources info. When create vpc endpoint service, the resource must exist.
        :param pulumi.Input[str] service_domain: The domain of service.
        :param pulumi.Input[str] service_id: The Id of service.
        :param pulumi.Input[str] service_name: The name of service.
        :param pulumi.Input[str] service_resource_type: The resource type of service.
        :param pulumi.Input[str] service_type: The type of service.
        :param pulumi.Input[str] status: The status of service.
        :param pulumi.Input[str] update_time: The update time of service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zone_ids: The IDs of zones.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcEndpointServiceState.__new__(_VpcEndpointServiceState)

        __props__.__dict__["auto_accept_enabled"] = auto_accept_enabled
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["description"] = description
        __props__.__dict__["resources"] = resources
        __props__.__dict__["service_domain"] = service_domain
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["service_resource_type"] = service_resource_type
        __props__.__dict__["service_type"] = service_type
        __props__.__dict__["status"] = status
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["zone_ids"] = zone_ids
        return VpcEndpointService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoAcceptEnabled")
    def auto_accept_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether auto accept node connect.
        """
        return pulumi.get(self, "auto_accept_enabled")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The create time of service.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of service.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Sequence['outputs.VpcEndpointServiceResource']]:
        """
        The resources info. When create vpc endpoint service, the resource must exist.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="serviceDomain")
    def service_domain(self) -> pulumi.Output[str]:
        """
        The domain of service.
        """
        return pulumi.get(self, "service_domain")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[str]:
        """
        The Id of service.
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        The name of service.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="serviceResourceType")
    def service_resource_type(self) -> pulumi.Output[str]:
        """
        The resource type of service.
        """
        return pulumi.get(self, "service_resource_type")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[str]:
        """
        The type of service.
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of service.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The update time of service.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The IDs of zones.
        """
        return pulumi.get(self, "zone_ids")

