# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'VpcEndpointServicePermissionsResult',
    'AwaitableVpcEndpointServicePermissionsResult',
    'vpc_endpoint_service_permissions',
    'vpc_endpoint_service_permissions_output',
]

@pulumi.output_type
class VpcEndpointServicePermissionsResult:
    """
    A collection of values returned by VpcEndpointServicePermissions.
    """
    def __init__(__self__, id=None, output_file=None, permissions=None, permit_account_id=None, service_id=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if permissions and not isinstance(permissions, list):
            raise TypeError("Expected argument 'permissions' to be a list")
        pulumi.set(__self__, "permissions", permissions)
        if permit_account_id and not isinstance(permit_account_id, str):
            raise TypeError("Expected argument 'permit_account_id' to be a str")
        pulumi.set(__self__, "permit_account_id", permit_account_id)
        if service_id and not isinstance(service_id, str):
            raise TypeError("Expected argument 'service_id' to be a str")
        pulumi.set(__self__, "service_id", service_id)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def permissions(self) -> Sequence['outputs.VpcEndpointServicePermissionsPermissionResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="permitAccountId")
    def permit_account_id(self) -> Optional[str]:
        """
        The permit account id.
        """
        return pulumi.get(self, "permit_account_id")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> str:
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        Returns the total amount of the data list.
        """
        return pulumi.get(self, "total_count")


class AwaitableVpcEndpointServicePermissionsResult(VpcEndpointServicePermissionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return VpcEndpointServicePermissionsResult(
            id=self.id,
            output_file=self.output_file,
            permissions=self.permissions,
            permit_account_id=self.permit_account_id,
            service_id=self.service_id,
            total_count=self.total_count)


def vpc_endpoint_service_permissions(output_file: Optional[str] = None,
                                     permit_account_id: Optional[str] = None,
                                     service_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableVpcEndpointServicePermissionsResult:
    """
    Use this data source to query detailed information of privatelink vpc endpoint service permissions
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.privatelink.vpc_endpoint_service_permissions(service_id="epsvc-3rel73uf2ewao5zsk2j2l58ro")
    ```


    :param str output_file: File name where to save data source results.
    :param str permit_account_id: The Id of permit account.
    :param str service_id: The Id of service.
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    __args__['permitAccountId'] = permit_account_id
    __args__['serviceId'] = service_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:privatelink/vpcEndpointServicePermissions:VpcEndpointServicePermissions', __args__, opts=opts, typ=VpcEndpointServicePermissionsResult).value

    return AwaitableVpcEndpointServicePermissionsResult(
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        permissions=pulumi.get(__ret__, 'permissions'),
        permit_account_id=pulumi.get(__ret__, 'permit_account_id'),
        service_id=pulumi.get(__ret__, 'service_id'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(vpc_endpoint_service_permissions)
def vpc_endpoint_service_permissions_output(output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                            permit_account_id: Optional[pulumi.Input[Optional[str]]] = None,
                                            service_id: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[VpcEndpointServicePermissionsResult]:
    """
    Use this data source to query detailed information of privatelink vpc endpoint service permissions
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.privatelink.vpc_endpoint_service_permissions(service_id="epsvc-3rel73uf2ewao5zsk2j2l58ro")
    ```


    :param str output_file: File name where to save data source results.
    :param str permit_account_id: The Id of permit account.
    :param str service_id: The Id of service.
    """
    ...
