# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'VpcEndpointServicesResult',
    'AwaitableVpcEndpointServicesResult',
    'vpc_endpoint_services',
    'vpc_endpoint_services_output',
]

@pulumi.output_type
class VpcEndpointServicesResult:
    """
    A collection of values returned by VpcEndpointServices.
    """
    def __init__(__self__, id=None, ids=None, name_regex=None, output_file=None, service_name=None, services=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if services and not isinstance(services, list):
            raise TypeError("Expected argument 'services' to be a list")
        pulumi.set(__self__, "services", services)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        The name of service.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def services(self) -> Sequence['outputs.VpcEndpointServicesServiceResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        Returns the total amount of the data list.
        """
        return pulumi.get(self, "total_count")


class AwaitableVpcEndpointServicesResult(VpcEndpointServicesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return VpcEndpointServicesResult(
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            output_file=self.output_file,
            service_name=self.service_name,
            services=self.services,
            total_count=self.total_count)


def vpc_endpoint_services(ids: Optional[Sequence[str]] = None,
                          name_regex: Optional[str] = None,
                          output_file: Optional[str] = None,
                          service_name: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableVpcEndpointServicesResult:
    """
    Use this data source to query detailed information of privatelink vpc endpoint services
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.privatelink.vpc_endpoint_services(ids=[
        "epsvc-3rel73uf2ewao5zsk2j2l58ro",
        "epsvc-2d72mxjgq02yo58ozfe5tndeh",
    ])
    ```


    :param Sequence[str] ids: The IDs of vpc endpoint service.
    :param str name_regex: A Name Regex of vpc endpoint service.
    :param str output_file: File name where to save data source results.
    :param str service_name: The name of vpc endpoint service.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:privatelink/vpcEndpointServices:VpcEndpointServices', __args__, opts=opts, typ=VpcEndpointServicesResult).value

    return AwaitableVpcEndpointServicesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        service_name=pulumi.get(__ret__, 'service_name'),
        services=pulumi.get(__ret__, 'services'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(vpc_endpoint_services)
def vpc_endpoint_services_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                                 output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                 service_name: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[VpcEndpointServicesResult]:
    """
    Use this data source to query detailed information of privatelink vpc endpoint services
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.privatelink.vpc_endpoint_services(ids=[
        "epsvc-3rel73uf2ewao5zsk2j2l58ro",
        "epsvc-2d72mxjgq02yo58ozfe5tndeh",
    ])
    ```


    :param Sequence[str] ids: The IDs of vpc endpoint service.
    :param str name_regex: A Name Regex of vpc endpoint service.
    :param str output_file: File name where to save data source results.
    :param str service_name: The name of vpc endpoint service.
    """
    ...
