# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'VpcEndpointsResult',
    'AwaitableVpcEndpointsResult',
    'vpc_endpoints',
    'vpc_endpoints_output',
]

@pulumi.output_type
class VpcEndpointsResult:
    """
    A collection of values returned by VpcEndpoints.
    """
    def __init__(__self__, endpoint_name=None, id=None, ids=None, name_regex=None, output_file=None, service_name=None, status=None, total_count=None, vpc_endpoints=None, vpc_id=None):
        if endpoint_name and not isinstance(endpoint_name, str):
            raise TypeError("Expected argument 'endpoint_name' to be a str")
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if vpc_endpoints and not isinstance(vpc_endpoints, list):
            raise TypeError("Expected argument 'vpc_endpoints' to be a list")
        pulumi.set(__self__, "vpc_endpoints", vpc_endpoints)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[str]:
        """
        The name of vpc endpoint.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[str]:
        """
        The name of vpc endpoint service.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of vpc endpoint.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        Returns the total amount of the data list.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="vpcEndpoints")
    def vpc_endpoints(self) -> Sequence['outputs.VpcEndpointsVpcEndpointResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "vpc_endpoints")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The vpc id of vpc endpoint.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableVpcEndpointsResult(VpcEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return VpcEndpointsResult(
            endpoint_name=self.endpoint_name,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            output_file=self.output_file,
            service_name=self.service_name,
            status=self.status,
            total_count=self.total_count,
            vpc_endpoints=self.vpc_endpoints,
            vpc_id=self.vpc_id)


def vpc_endpoints(endpoint_name: Optional[str] = None,
                  ids: Optional[Sequence[str]] = None,
                  name_regex: Optional[str] = None,
                  output_file: Optional[str] = None,
                  service_name: Optional[str] = None,
                  status: Optional[str] = None,
                  vpc_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableVpcEndpointsResult:
    """
    Use this data source to query detailed information of privatelink vpc endpoints
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.privatelink.vpc_endpoints(ids=["ep-3rel74u229dz45zsk2i6l****"])
    ```


    :param str endpoint_name: The name of vpc endpoint.
    :param Sequence[str] ids: The IDs of vpc endpoint.
    :param str name_regex: A Name Regex of vpc endpoint.
    :param str output_file: File name where to save data source results.
    :param str service_name: The name of vpc endpoint service.
    :param str status: The status of vpc endpoint. Valid values: `Creating`, `Pending`, `Available`, `Deleting`, `Inactive`.
    :param str vpc_id: The vpc id of vpc endpoint.
    """
    __args__ = dict()
    __args__['endpointName'] = endpoint_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['serviceName'] = service_name
    __args__['status'] = status
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:privatelink/vpcEndpoints:VpcEndpoints', __args__, opts=opts, typ=VpcEndpointsResult).value

    return AwaitableVpcEndpointsResult(
        endpoint_name=pulumi.get(__ret__, 'endpoint_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        service_name=pulumi.get(__ret__, 'service_name'),
        status=pulumi.get(__ret__, 'status'),
        total_count=pulumi.get(__ret__, 'total_count'),
        vpc_endpoints=pulumi.get(__ret__, 'vpc_endpoints'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))


@_utilities.lift_output_func(vpc_endpoints)
def vpc_endpoints_output(endpoint_name: Optional[pulumi.Input[Optional[str]]] = None,
                         ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                         name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                         output_file: Optional[pulumi.Input[Optional[str]]] = None,
                         service_name: Optional[pulumi.Input[Optional[str]]] = None,
                         status: Optional[pulumi.Input[Optional[str]]] = None,
                         vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[VpcEndpointsResult]:
    """
    Use this data source to query detailed information of privatelink vpc endpoints
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.privatelink.vpc_endpoints(ids=["ep-3rel74u229dz45zsk2i6l****"])
    ```


    :param str endpoint_name: The name of vpc endpoint.
    :param Sequence[str] ids: The IDs of vpc endpoint.
    :param str name_regex: A Name Regex of vpc endpoint.
    :param str output_file: File name where to save data source results.
    :param str service_name: The name of vpc endpoint service.
    :param str status: The status of vpc endpoint. Valid values: `Creating`, `Pending`, `Available`, `Deleting`, `Inactive`.
    :param str vpc_id: The vpc id of vpc endpoint.
    """
    ...
