# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountPrivilegeArgs', 'AccountPrivilege']

@pulumi.input_type
class AccountPrivilegeArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 db_privileges: pulumi.Input[Sequence[pulumi.Input['AccountPrivilegeDbPrivilegeArgs']]],
                 instance_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a AccountPrivilege resource.
        :param pulumi.Input[str] account_name: Database account name. The rules are as follows:
               Unique name.
               Start with a letter and end with a letter or number.
               Consists of lowercase letters, numbers, or underscores (_).
               The length is 2~32 characters.
               The [keyword list](https://www.volcengine.com/docs/6313/66162) is disabled for database accounts, and certain reserved words, including root, admin, etc., cannot be used.
        :param pulumi.Input[Sequence[pulumi.Input['AccountPrivilegeDbPrivilegeArgs']]] db_privileges: The privileges of the account.
        :param pulumi.Input[str] instance_id: The ID of the RDS instance.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "db_privileges", db_privileges)
        pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        Database account name. The rules are as follows:
        Unique name.
        Start with a letter and end with a letter or number.
        Consists of lowercase letters, numbers, or underscores (_).
        The length is 2~32 characters.
        The [keyword list](https://www.volcengine.com/docs/6313/66162) is disabled for database accounts, and certain reserved words, including root, admin, etc., cannot be used.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="dbPrivileges")
    def db_privileges(self) -> pulumi.Input[Sequence[pulumi.Input['AccountPrivilegeDbPrivilegeArgs']]]:
        """
        The privileges of the account.
        """
        return pulumi.get(self, "db_privileges")

    @db_privileges.setter
    def db_privileges(self, value: pulumi.Input[Sequence[pulumi.Input['AccountPrivilegeDbPrivilegeArgs']]]):
        pulumi.set(self, "db_privileges", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The ID of the RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)


@pulumi.input_type
class _AccountPrivilegeState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[str]] = None,
                 db_privileges: Optional[pulumi.Input[Sequence[pulumi.Input['AccountPrivilegeDbPrivilegeArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AccountPrivilege resources.
        :param pulumi.Input[str] account_name: Database account name. The rules are as follows:
               Unique name.
               Start with a letter and end with a letter or number.
               Consists of lowercase letters, numbers, or underscores (_).
               The length is 2~32 characters.
               The [keyword list](https://www.volcengine.com/docs/6313/66162) is disabled for database accounts, and certain reserved words, including root, admin, etc., cannot be used.
        :param pulumi.Input[Sequence[pulumi.Input['AccountPrivilegeDbPrivilegeArgs']]] db_privileges: The privileges of the account.
        :param pulumi.Input[str] instance_id: The ID of the RDS instance.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if db_privileges is not None:
            pulumi.set(__self__, "db_privileges", db_privileges)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Database account name. The rules are as follows:
        Unique name.
        Start with a letter and end with a letter or number.
        Consists of lowercase letters, numbers, or underscores (_).
        The length is 2~32 characters.
        The [keyword list](https://www.volcengine.com/docs/6313/66162) is disabled for database accounts, and certain reserved words, including root, admin, etc., cannot be used.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="dbPrivileges")
    def db_privileges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountPrivilegeDbPrivilegeArgs']]]]:
        """
        The privileges of the account.
        """
        return pulumi.get(self, "db_privileges")

    @db_privileges.setter
    def db_privileges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountPrivilegeDbPrivilegeArgs']]]]):
        pulumi.set(self, "db_privileges", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)


class AccountPrivilege(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 db_privileges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccountPrivilegeDbPrivilegeArgs']]]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        (Deprecated! Recommend use volcengine_rds_mysql_*** replace) Provides a resource to manage rds account privilege
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        app_name = volcengine.rds.Account("appName",
            instance_id="mysql-0fdd3bab2e7c",
            account_name="terraform-test-app",
            account_password="Aatest123",
            account_type="Normal")
        foo = volcengine.rds.AccountPrivilege("foo",
            instance_id="mysql-0fdd3bab2e7c",
            account_name=app_name.account_name,
            db_privileges=[
                volcengine.rds.AccountPrivilegeDbPrivilegeArgs(
                    db_name="foo",
                    account_privilege="Custom",
                    account_privilege_str="ALTER,ALTER ROUTINE,CREATE,CREATE ROUTINE,CREATE TEMPORARY TABLES",
                ),
                volcengine.rds.AccountPrivilegeDbPrivilegeArgs(
                    db_name="bar",
                    account_privilege="DDLOnly",
                ),
                volcengine.rds.AccountPrivilegeDbPrivilegeArgs(
                    db_name="demo",
                    account_privilege="ReadWrite",
                ),
            ])
        ```

        ## Import

        RDS account privilege can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:rds/accountPrivilege:AccountPrivilege default mysql-42b38c769c4b:account_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: Database account name. The rules are as follows:
               Unique name.
               Start with a letter and end with a letter or number.
               Consists of lowercase letters, numbers, or underscores (_).
               The length is 2~32 characters.
               The [keyword list](https://www.volcengine.com/docs/6313/66162) is disabled for database accounts, and certain reserved words, including root, admin, etc., cannot be used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccountPrivilegeDbPrivilegeArgs']]]] db_privileges: The privileges of the account.
        :param pulumi.Input[str] instance_id: The ID of the RDS instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountPrivilegeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        (Deprecated! Recommend use volcengine_rds_mysql_*** replace) Provides a resource to manage rds account privilege
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        app_name = volcengine.rds.Account("appName",
            instance_id="mysql-0fdd3bab2e7c",
            account_name="terraform-test-app",
            account_password="Aatest123",
            account_type="Normal")
        foo = volcengine.rds.AccountPrivilege("foo",
            instance_id="mysql-0fdd3bab2e7c",
            account_name=app_name.account_name,
            db_privileges=[
                volcengine.rds.AccountPrivilegeDbPrivilegeArgs(
                    db_name="foo",
                    account_privilege="Custom",
                    account_privilege_str="ALTER,ALTER ROUTINE,CREATE,CREATE ROUTINE,CREATE TEMPORARY TABLES",
                ),
                volcengine.rds.AccountPrivilegeDbPrivilegeArgs(
                    db_name="bar",
                    account_privilege="DDLOnly",
                ),
                volcengine.rds.AccountPrivilegeDbPrivilegeArgs(
                    db_name="demo",
                    account_privilege="ReadWrite",
                ),
            ])
        ```

        ## Import

        RDS account privilege can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:rds/accountPrivilege:AccountPrivilege default mysql-42b38c769c4b:account_name
        ```

        :param str resource_name: The name of the resource.
        :param AccountPrivilegeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountPrivilegeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 db_privileges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccountPrivilegeDbPrivilegeArgs']]]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountPrivilegeArgs.__new__(AccountPrivilegeArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            if db_privileges is None and not opts.urn:
                raise TypeError("Missing required property 'db_privileges'")
            __props__.__dict__["db_privileges"] = db_privileges
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
        super(AccountPrivilege, __self__).__init__(
            'volcengine:rds/accountPrivilege:AccountPrivilege',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[str]] = None,
            db_privileges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccountPrivilegeDbPrivilegeArgs']]]]] = None,
            instance_id: Optional[pulumi.Input[str]] = None) -> 'AccountPrivilege':
        """
        Get an existing AccountPrivilege resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: Database account name. The rules are as follows:
               Unique name.
               Start with a letter and end with a letter or number.
               Consists of lowercase letters, numbers, or underscores (_).
               The length is 2~32 characters.
               The [keyword list](https://www.volcengine.com/docs/6313/66162) is disabled for database accounts, and certain reserved words, including root, admin, etc., cannot be used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AccountPrivilegeDbPrivilegeArgs']]]] db_privileges: The privileges of the account.
        :param pulumi.Input[str] instance_id: The ID of the RDS instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountPrivilegeState.__new__(_AccountPrivilegeState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["db_privileges"] = db_privileges
        __props__.__dict__["instance_id"] = instance_id
        return AccountPrivilege(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[str]:
        """
        Database account name. The rules are as follows:
        Unique name.
        Start with a letter and end with a letter or number.
        Consists of lowercase letters, numbers, or underscores (_).
        The length is 2~32 characters.
        The [keyword list](https://www.volcengine.com/docs/6313/66162) is disabled for database accounts, and certain reserved words, including root, admin, etc., cannot be used.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="dbPrivileges")
    def db_privileges(self) -> pulumi.Output[Sequence['outputs.AccountPrivilegeDbPrivilege']]:
        """
        The privileges of the account.
        """
        return pulumi.get(self, "db_privileges")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The ID of the RDS instance.
        """
        return pulumi.get(self, "instance_id")

