# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AccountsResult',
    'AwaitableAccountsResult',
    'accounts',
    'accounts_output',
]

@pulumi.output_type
class AccountsResult:
    """
    A collection of values returned by Accounts.
    """
    def __init__(__self__, account_name=None, id=None, instance_id=None, name_regex=None, output_file=None, rds_accounts=None, total_count=None):
        if account_name and not isinstance(account_name, str):
            raise TypeError("Expected argument 'account_name' to be a str")
        pulumi.set(__self__, "account_name", account_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if rds_accounts and not isinstance(rds_accounts, list):
            raise TypeError("Expected argument 'rds_accounts' to be a list")
        pulumi.set(__self__, "rds_accounts", rds_accounts)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        The name of the database account.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="rdsAccounts")
    def rds_accounts(self) -> Sequence['outputs.AccountsRdsAccountResult']:
        """
        The collection of RDS instance account query.
        """
        return pulumi.get(self, "rds_accounts")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of database account query.
        """
        return pulumi.get(self, "total_count")


class AwaitableAccountsResult(AccountsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return AccountsResult(
            account_name=self.account_name,
            id=self.id,
            instance_id=self.instance_id,
            name_regex=self.name_regex,
            output_file=self.output_file,
            rds_accounts=self.rds_accounts,
            total_count=self.total_count)


def accounts(account_name: Optional[str] = None,
             instance_id: Optional[str] = None,
             name_regex: Optional[str] = None,
             output_file: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableAccountsResult:
    """
    (Deprecated! Recommend use volcengine_rds_mysql_*** replace) Use this data source to query detailed information of rds accounts
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.rds.accounts(instance_id="mysql-0fdd3bab2e7c")
    ```


    :param str account_name: The name of the database account.
    :param str instance_id: The id of the RDS instance.
    :param str name_regex: A Name Regex of database account.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['instanceId'] = instance_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:rds/accounts:Accounts', __args__, opts=opts, typ=AccountsResult).value

    return AwaitableAccountsResult(
        account_name=pulumi.get(__ret__, 'account_name'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        rds_accounts=pulumi.get(__ret__, 'rds_accounts'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(accounts)
def accounts_output(account_name: Optional[pulumi.Input[Optional[str]]] = None,
                    instance_id: Optional[pulumi.Input[str]] = None,
                    name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                    output_file: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[AccountsResult]:
    """
    (Deprecated! Recommend use volcengine_rds_mysql_*** replace) Use this data source to query detailed information of rds accounts
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.rds.accounts(instance_id="mysql-0fdd3bab2e7c")
    ```


    :param str account_name: The name of the database account.
    :param str instance_id: The id of the RDS instance.
    :param str name_regex: A Name Regex of database account.
    :param str output_file: File name where to save data source results.
    """
    ...
