# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DatabasesResult',
    'AwaitableDatabasesResult',
    'databases',
    'databases_output',
]

@pulumi.output_type
class DatabasesResult:
    """
    A collection of values returned by Databases.
    """
    def __init__(__self__, db_status=None, id=None, instance_id=None, name_regex=None, output_file=None, rds_databases=None, total_count=None):
        if db_status and not isinstance(db_status, str):
            raise TypeError("Expected argument 'db_status' to be a str")
        pulumi.set(__self__, "db_status", db_status)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if rds_databases and not isinstance(rds_databases, list):
            raise TypeError("Expected argument 'rds_databases' to be a list")
        pulumi.set(__self__, "rds_databases", rds_databases)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="dbStatus")
    def db_status(self) -> Optional[str]:
        """
        The status of the RDS database.
        """
        return pulumi.get(self, "db_status")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="rdsDatabases")
    def rds_databases(self) -> Sequence['outputs.DatabasesRdsDatabaseResult']:
        """
        The collection of RDS instance account query.
        """
        return pulumi.get(self, "rds_databases")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of RDS database query.
        """
        return pulumi.get(self, "total_count")


class AwaitableDatabasesResult(DatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return DatabasesResult(
            db_status=self.db_status,
            id=self.id,
            instance_id=self.instance_id,
            name_regex=self.name_regex,
            output_file=self.output_file,
            rds_databases=self.rds_databases,
            total_count=self.total_count)


def databases(db_status: Optional[str] = None,
              instance_id: Optional[str] = None,
              name_regex: Optional[str] = None,
              output_file: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableDatabasesResult:
    """
    (Deprecated! Recommend use volcengine_rds_mysql_*** replace) Use this data source to query detailed information of rds databases
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.rds.databases(instance_id="mysql-0fdd3bab2e7c")
    ```


    :param str db_status: The status of the RDS database.
    :param str instance_id: The id of the RDS instance.
    :param str name_regex: A Name Regex of RDS database.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['dbStatus'] = db_status
    __args__['instanceId'] = instance_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:rds/databases:Databases', __args__, opts=opts, typ=DatabasesResult).value

    return AwaitableDatabasesResult(
        db_status=pulumi.get(__ret__, 'db_status'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        rds_databases=pulumi.get(__ret__, 'rds_databases'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(databases)
def databases_output(db_status: Optional[pulumi.Input[Optional[str]]] = None,
                     instance_id: Optional[pulumi.Input[str]] = None,
                     name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[DatabasesResult]:
    """
    (Deprecated! Recommend use volcengine_rds_mysql_*** replace) Use this data source to query detailed information of rds databases
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.rds.databases(instance_id="mysql-0fdd3bab2e7c")
    ```


    :param str db_status: The status of the RDS database.
    :param str instance_id: The id of the RDS instance.
    :param str name_regex: A Name Regex of RDS database.
    :param str output_file: File name where to save data source results.
    """
    ...
