# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 charge_type: pulumi.Input[str],
                 db_engine_version: pulumi.Input[str],
                 instance_spec_name: pulumi.Input[str],
                 instance_type: pulumi.Input[str],
                 storage_space_gb: pulumi.Input[int],
                 storage_type: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 zone: pulumi.Input[str],
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 db_engine: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 prepaid_period: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 super_account_name: Optional[pulumi.Input[str]] = None,
                 super_account_password: Optional[pulumi.Input[str]] = None,
                 supper_account_password: Optional[pulumi.Input[str]] = None,
                 used_time: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] charge_type: Billing type. Value:
               PostPaid: Postpaid (pay-as-you-go).
               Prepaid: Prepaid (yearly and monthly).
        :param pulumi.Input[str] db_engine_version: Instance type. Value:
               MySQL_Community_5_7
               MySQL_8_0.
        :param pulumi.Input[str] instance_spec_name: Instance specification name, you can specify the specification name of the instance to be created. Value:
               rds.mysql.1c2g
               rds.mysql.2c4g
               rds.mysql.4c8g
               rds.mysql.4c16g
               rds.mysql.8c32g
               rds.mysql.16c64g
               rds.mysql.16c128g
               rds.mysql.32c128g
               rds.mysql.32c256g.
        :param pulumi.Input[str] instance_type: Instance type. Value:
               HA: High availability version.
        :param pulumi.Input[int] storage_space_gb: The storage space(GB) of the RDS instance.
        :param pulumi.Input[str] storage_type: Instance storage type. Value:
               LocalSSD: Local SSD disk.
        :param pulumi.Input[str] subnet_id: Subnet ID. The subnet must belong to the selected Availability Zone.
        :param pulumi.Input[str] vpc_id: The vpc ID of the RDS instance.
        :param pulumi.Input[str] zone: The available zone of the RDS instance.
        :param pulumi.Input[bool] auto_renew: Whether to automatically renew. Default: false. Value:
               true: yes.
               false: no. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] db_engine: Database type. Value:
               MySQL (default).
        :param pulumi.Input[str] instance_name: Set the name of the instance. The naming rules are as follows:
               
               Cannot start with a number, a dash (-).
               It can only contain Chinese characters, letters, numbers, underscores (_) and underscores (-).
               The length needs to be within 1~128 characters.
        :param pulumi.Input[str] prepaid_period: The purchase cycle in the prepaid scenario. Value:
               Month: monthly subscription.
               Year: yearly subscription. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] project_name: Select the project to which the instance belongs. If this parameter is left blank, the new instance will not be added to any project. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] region: The region of the RDS instance.
        :param pulumi.Input[str] super_account_name: Fill in the high-privileged user account name. The naming rules are as follows:
               Unique name.
               Start with a letter and end with a letter or number.
               Consists of lowercase letters, numbers, or underscores (_).
               The length is 2~32 characters.
               [Keywords](https://www.volcengine.com/docs/6313/66162) are not allowed for account names.
        :param pulumi.Input[str] super_account_password: Set a high-privilege account password. The rules are as follows:
               Only uppercase and lowercase letters, numbers and the following special characters _#!@$%^*()+=-.
               The length needs to be within 8~32 characters.
               Contains at least 3 of uppercase letters, lowercase letters, numbers or special characters.
        :param pulumi.Input[str] supper_account_password: supper_account_password is deprecated, use super_account_password instead Set a high-privilege account password. The rules are as follows:
               Only uppercase and lowercase letters, numbers and the following special characters _#!@$%^*()+=-.
               The length needs to be within 8~32 characters.
               Contains at least 3 of uppercase letters, lowercase letters, numbers or special characters.
        :param pulumi.Input[int] used_time: The purchase time of RDS instance. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        pulumi.set(__self__, "charge_type", charge_type)
        pulumi.set(__self__, "db_engine_version", db_engine_version)
        pulumi.set(__self__, "instance_spec_name", instance_spec_name)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "storage_space_gb", storage_space_gb)
        pulumi.set(__self__, "storage_type", storage_type)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone", zone)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if db_engine is not None:
            pulumi.set(__self__, "db_engine", db_engine)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if prepaid_period is not None:
            pulumi.set(__self__, "prepaid_period", prepaid_period)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if super_account_name is not None:
            pulumi.set(__self__, "super_account_name", super_account_name)
        if super_account_password is not None:
            pulumi.set(__self__, "super_account_password", super_account_password)
        if supper_account_password is not None:
            warnings.warn("""supper_account_password is deprecated, use super_account_password instead""", DeprecationWarning)
            pulumi.log.warn("""supper_account_password is deprecated: supper_account_password is deprecated, use super_account_password instead""")
        if supper_account_password is not None:
            pulumi.set(__self__, "supper_account_password", supper_account_password)
        if used_time is not None:
            pulumi.set(__self__, "used_time", used_time)

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> pulumi.Input[str]:
        """
        Billing type. Value:
        PostPaid: Postpaid (pay-as-you-go).
        Prepaid: Prepaid (yearly and monthly).
        """
        return pulumi.get(self, "charge_type")

    @charge_type.setter
    def charge_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "charge_type", value)

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> pulumi.Input[str]:
        """
        Instance type. Value:
        MySQL_Community_5_7
        MySQL_8_0.
        """
        return pulumi.get(self, "db_engine_version")

    @db_engine_version.setter
    def db_engine_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_engine_version", value)

    @property
    @pulumi.getter(name="instanceSpecName")
    def instance_spec_name(self) -> pulumi.Input[str]:
        """
        Instance specification name, you can specify the specification name of the instance to be created. Value:
        rds.mysql.1c2g
        rds.mysql.2c4g
        rds.mysql.4c8g
        rds.mysql.4c16g
        rds.mysql.8c32g
        rds.mysql.16c64g
        rds.mysql.16c128g
        rds.mysql.32c128g
        rds.mysql.32c256g.
        """
        return pulumi.get(self, "instance_spec_name")

    @instance_spec_name.setter
    def instance_spec_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_spec_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        Instance type. Value:
        HA: High availability version.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="storageSpaceGb")
    def storage_space_gb(self) -> pulumi.Input[int]:
        """
        The storage space(GB) of the RDS instance.
        """
        return pulumi.get(self, "storage_space_gb")

    @storage_space_gb.setter
    def storage_space_gb(self, value: pulumi.Input[int]):
        pulumi.set(self, "storage_space_gb", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Input[str]:
        """
        Instance storage type. Value:
        LocalSSD: Local SSD disk.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Subnet ID. The subnet must belong to the selected Availability Zone.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The vpc ID of the RDS instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Input[str]:
        """
        The available zone of the RDS instance.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically renew. Default: false. Value:
        true: yes.
        false: no. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="dbEngine")
    def db_engine(self) -> Optional[pulumi.Input[str]]:
        """
        Database type. Value:
        MySQL (default).
        """
        return pulumi.get(self, "db_engine")

    @db_engine.setter
    def db_engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_engine", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        Set the name of the instance. The naming rules are as follows:

        Cannot start with a number, a dash (-).
        It can only contain Chinese characters, letters, numbers, underscores (_) and underscores (-).
        The length needs to be within 1~128 characters.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="prepaidPeriod")
    def prepaid_period(self) -> Optional[pulumi.Input[str]]:
        """
        The purchase cycle in the prepaid scenario. Value:
        Month: monthly subscription.
        Year: yearly subscription. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "prepaid_period")

    @prepaid_period.setter
    def prepaid_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prepaid_period", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        Select the project to which the instance belongs. If this parameter is left blank, the new instance will not be added to any project. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the RDS instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="superAccountName")
    def super_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Fill in the high-privileged user account name. The naming rules are as follows:
        Unique name.
        Start with a letter and end with a letter or number.
        Consists of lowercase letters, numbers, or underscores (_).
        The length is 2~32 characters.
        [Keywords](https://www.volcengine.com/docs/6313/66162) are not allowed for account names.
        """
        return pulumi.get(self, "super_account_name")

    @super_account_name.setter
    def super_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "super_account_name", value)

    @property
    @pulumi.getter(name="superAccountPassword")
    def super_account_password(self) -> Optional[pulumi.Input[str]]:
        """
        Set a high-privilege account password. The rules are as follows:
        Only uppercase and lowercase letters, numbers and the following special characters _#!@$%^*()+=-.
        The length needs to be within 8~32 characters.
        Contains at least 3 of uppercase letters, lowercase letters, numbers or special characters.
        """
        return pulumi.get(self, "super_account_password")

    @super_account_password.setter
    def super_account_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "super_account_password", value)

    @property
    @pulumi.getter(name="supperAccountPassword")
    def supper_account_password(self) -> Optional[pulumi.Input[str]]:
        """
        supper_account_password is deprecated, use super_account_password instead Set a high-privilege account password. The rules are as follows:
        Only uppercase and lowercase letters, numbers and the following special characters _#!@$%^*()+=-.
        The length needs to be within 8~32 characters.
        Contains at least 3 of uppercase letters, lowercase letters, numbers or special characters.
        """
        warnings.warn("""supper_account_password is deprecated, use super_account_password instead""", DeprecationWarning)
        pulumi.log.warn("""supper_account_password is deprecated: supper_account_password is deprecated, use super_account_password instead""")

        return pulumi.get(self, "supper_account_password")

    @supper_account_password.setter
    def supper_account_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "supper_account_password", value)

    @property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> Optional[pulumi.Input[int]]:
        """
        The purchase time of RDS instance. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "used_time")

    @used_time.setter
    def used_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "used_time", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 charge_type: Optional[pulumi.Input[str]] = None,
                 connection_info: Optional[pulumi.Input['InstanceConnectionInfoArgs']] = None,
                 db_engine: Optional[pulumi.Input[str]] = None,
                 db_engine_version: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_spec_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 prepaid_period: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 storage_space_gb: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 super_account_name: Optional[pulumi.Input[str]] = None,
                 super_account_password: Optional[pulumi.Input[str]] = None,
                 supper_account_password: Optional[pulumi.Input[str]] = None,
                 used_time: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[bool] auto_renew: Whether to automatically renew. Default: false. Value:
               true: yes.
               false: no. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] charge_type: Billing type. Value:
               PostPaid: Postpaid (pay-as-you-go).
               Prepaid: Prepaid (yearly and monthly).
        :param pulumi.Input['InstanceConnectionInfoArgs'] connection_info: The connection info ot the RDS instance.
        :param pulumi.Input[str] db_engine: Database type. Value:
               MySQL (default).
        :param pulumi.Input[str] db_engine_version: Instance type. Value:
               MySQL_Community_5_7
               MySQL_8_0.
        :param pulumi.Input[str] instance_name: Set the name of the instance. The naming rules are as follows:
               
               Cannot start with a number, a dash (-).
               It can only contain Chinese characters, letters, numbers, underscores (_) and underscores (-).
               The length needs to be within 1~128 characters.
        :param pulumi.Input[str] instance_spec_name: Instance specification name, you can specify the specification name of the instance to be created. Value:
               rds.mysql.1c2g
               rds.mysql.2c4g
               rds.mysql.4c8g
               rds.mysql.4c16g
               rds.mysql.8c32g
               rds.mysql.16c64g
               rds.mysql.16c128g
               rds.mysql.32c128g
               rds.mysql.32c256g.
        :param pulumi.Input[str] instance_type: Instance type. Value:
               HA: High availability version.
        :param pulumi.Input[str] prepaid_period: The purchase cycle in the prepaid scenario. Value:
               Month: monthly subscription.
               Year: yearly subscription. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] project_name: Select the project to which the instance belongs. If this parameter is left blank, the new instance will not be added to any project. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] region: The region of the RDS instance.
        :param pulumi.Input[int] storage_space_gb: The storage space(GB) of the RDS instance.
        :param pulumi.Input[str] storage_type: Instance storage type. Value:
               LocalSSD: Local SSD disk.
        :param pulumi.Input[str] subnet_id: Subnet ID. The subnet must belong to the selected Availability Zone.
        :param pulumi.Input[str] super_account_name: Fill in the high-privileged user account name. The naming rules are as follows:
               Unique name.
               Start with a letter and end with a letter or number.
               Consists of lowercase letters, numbers, or underscores (_).
               The length is 2~32 characters.
               [Keywords](https://www.volcengine.com/docs/6313/66162) are not allowed for account names.
        :param pulumi.Input[str] super_account_password: Set a high-privilege account password. The rules are as follows:
               Only uppercase and lowercase letters, numbers and the following special characters _#!@$%^*()+=-.
               The length needs to be within 8~32 characters.
               Contains at least 3 of uppercase letters, lowercase letters, numbers or special characters.
        :param pulumi.Input[str] supper_account_password: supper_account_password is deprecated, use super_account_password instead Set a high-privilege account password. The rules are as follows:
               Only uppercase and lowercase letters, numbers and the following special characters _#!@$%^*()+=-.
               The length needs to be within 8~32 characters.
               Contains at least 3 of uppercase letters, lowercase letters, numbers or special characters.
        :param pulumi.Input[int] used_time: The purchase time of RDS instance. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] vpc_id: The vpc ID of the RDS instance.
        :param pulumi.Input[str] zone: The available zone of the RDS instance.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charge_type is not None:
            pulumi.set(__self__, "charge_type", charge_type)
        if connection_info is not None:
            pulumi.set(__self__, "connection_info", connection_info)
        if db_engine is not None:
            pulumi.set(__self__, "db_engine", db_engine)
        if db_engine_version is not None:
            pulumi.set(__self__, "db_engine_version", db_engine_version)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_spec_name is not None:
            pulumi.set(__self__, "instance_spec_name", instance_spec_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if prepaid_period is not None:
            pulumi.set(__self__, "prepaid_period", prepaid_period)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if storage_space_gb is not None:
            pulumi.set(__self__, "storage_space_gb", storage_space_gb)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if super_account_name is not None:
            pulumi.set(__self__, "super_account_name", super_account_name)
        if super_account_password is not None:
            pulumi.set(__self__, "super_account_password", super_account_password)
        if supper_account_password is not None:
            warnings.warn("""supper_account_password is deprecated, use super_account_password instead""", DeprecationWarning)
            pulumi.log.warn("""supper_account_password is deprecated: supper_account_password is deprecated, use super_account_password instead""")
        if supper_account_password is not None:
            pulumi.set(__self__, "supper_account_password", supper_account_password)
        if used_time is not None:
            pulumi.set(__self__, "used_time", used_time)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically renew. Default: false. Value:
        true: yes.
        false: no. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Billing type. Value:
        PostPaid: Postpaid (pay-as-you-go).
        Prepaid: Prepaid (yearly and monthly).
        """
        return pulumi.get(self, "charge_type")

    @charge_type.setter
    def charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charge_type", value)

    @property
    @pulumi.getter(name="connectionInfo")
    def connection_info(self) -> Optional[pulumi.Input['InstanceConnectionInfoArgs']]:
        """
        The connection info ot the RDS instance.
        """
        return pulumi.get(self, "connection_info")

    @connection_info.setter
    def connection_info(self, value: Optional[pulumi.Input['InstanceConnectionInfoArgs']]):
        pulumi.set(self, "connection_info", value)

    @property
    @pulumi.getter(name="dbEngine")
    def db_engine(self) -> Optional[pulumi.Input[str]]:
        """
        Database type. Value:
        MySQL (default).
        """
        return pulumi.get(self, "db_engine")

    @db_engine.setter
    def db_engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_engine", value)

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Instance type. Value:
        MySQL_Community_5_7
        MySQL_8_0.
        """
        return pulumi.get(self, "db_engine_version")

    @db_engine_version.setter
    def db_engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_engine_version", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        Set the name of the instance. The naming rules are as follows:

        Cannot start with a number, a dash (-).
        It can only contain Chinese characters, letters, numbers, underscores (_) and underscores (-).
        The length needs to be within 1~128 characters.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceSpecName")
    def instance_spec_name(self) -> Optional[pulumi.Input[str]]:
        """
        Instance specification name, you can specify the specification name of the instance to be created. Value:
        rds.mysql.1c2g
        rds.mysql.2c4g
        rds.mysql.4c8g
        rds.mysql.4c16g
        rds.mysql.8c32g
        rds.mysql.16c64g
        rds.mysql.16c128g
        rds.mysql.32c128g
        rds.mysql.32c256g.
        """
        return pulumi.get(self, "instance_spec_name")

    @instance_spec_name.setter
    def instance_spec_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_spec_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance type. Value:
        HA: High availability version.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="prepaidPeriod")
    def prepaid_period(self) -> Optional[pulumi.Input[str]]:
        """
        The purchase cycle in the prepaid scenario. Value:
        Month: monthly subscription.
        Year: yearly subscription. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "prepaid_period")

    @prepaid_period.setter
    def prepaid_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prepaid_period", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        Select the project to which the instance belongs. If this parameter is left blank, the new instance will not be added to any project. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the RDS instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="storageSpaceGb")
    def storage_space_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The storage space(GB) of the RDS instance.
        """
        return pulumi.get(self, "storage_space_gb")

    @storage_space_gb.setter
    def storage_space_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_space_gb", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance storage type. Value:
        LocalSSD: Local SSD disk.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet ID. The subnet must belong to the selected Availability Zone.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="superAccountName")
    def super_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Fill in the high-privileged user account name. The naming rules are as follows:
        Unique name.
        Start with a letter and end with a letter or number.
        Consists of lowercase letters, numbers, or underscores (_).
        The length is 2~32 characters.
        [Keywords](https://www.volcengine.com/docs/6313/66162) are not allowed for account names.
        """
        return pulumi.get(self, "super_account_name")

    @super_account_name.setter
    def super_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "super_account_name", value)

    @property
    @pulumi.getter(name="superAccountPassword")
    def super_account_password(self) -> Optional[pulumi.Input[str]]:
        """
        Set a high-privilege account password. The rules are as follows:
        Only uppercase and lowercase letters, numbers and the following special characters _#!@$%^*()+=-.
        The length needs to be within 8~32 characters.
        Contains at least 3 of uppercase letters, lowercase letters, numbers or special characters.
        """
        return pulumi.get(self, "super_account_password")

    @super_account_password.setter
    def super_account_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "super_account_password", value)

    @property
    @pulumi.getter(name="supperAccountPassword")
    def supper_account_password(self) -> Optional[pulumi.Input[str]]:
        """
        supper_account_password is deprecated, use super_account_password instead Set a high-privilege account password. The rules are as follows:
        Only uppercase and lowercase letters, numbers and the following special characters _#!@$%^*()+=-.
        The length needs to be within 8~32 characters.
        Contains at least 3 of uppercase letters, lowercase letters, numbers or special characters.
        """
        warnings.warn("""supper_account_password is deprecated, use super_account_password instead""", DeprecationWarning)
        pulumi.log.warn("""supper_account_password is deprecated: supper_account_password is deprecated, use super_account_password instead""")

        return pulumi.get(self, "supper_account_password")

    @supper_account_password.setter
    def supper_account_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "supper_account_password", value)

    @property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> Optional[pulumi.Input[int]]:
        """
        The purchase time of RDS instance. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "used_time")

    @used_time.setter
    def used_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "used_time", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vpc ID of the RDS instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The available zone of the RDS instance.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 charge_type: Optional[pulumi.Input[str]] = None,
                 db_engine: Optional[pulumi.Input[str]] = None,
                 db_engine_version: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_spec_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 prepaid_period: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 storage_space_gb: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 super_account_name: Optional[pulumi.Input[str]] = None,
                 super_account_password: Optional[pulumi.Input[str]] = None,
                 supper_account_password: Optional[pulumi.Input[str]] = None,
                 used_time: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.rds.Instance("foo",
            charge_type="PostPaid",
            db_engine="MySQL",
            db_engine_version="MySQL_Community_5_7",
            instance_name="tf-test",
            instance_spec_name="rds.mysql.1c2g",
            instance_type="HA",
            region="cn-north-4",
            storage_space_gb=100,
            storage_type="LocalSSD",
            subnet_id="subnet-1g0d4fkh1nabk8ibuxx1jtvss",
            vpc_id="vpc-3cj17x7u9bzeo6c6rrtzfpaeb",
            zone="cn-langfang-b")
        ```

        ## Import

        RDS Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:rds/instance:Instance default mysql-42b38c769c4b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_renew: Whether to automatically renew. Default: false. Value:
               true: yes.
               false: no. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] charge_type: Billing type. Value:
               PostPaid: Postpaid (pay-as-you-go).
               Prepaid: Prepaid (yearly and monthly).
        :param pulumi.Input[str] db_engine: Database type. Value:
               MySQL (default).
        :param pulumi.Input[str] db_engine_version: Instance type. Value:
               MySQL_Community_5_7
               MySQL_8_0.
        :param pulumi.Input[str] instance_name: Set the name of the instance. The naming rules are as follows:
               
               Cannot start with a number, a dash (-).
               It can only contain Chinese characters, letters, numbers, underscores (_) and underscores (-).
               The length needs to be within 1~128 characters.
        :param pulumi.Input[str] instance_spec_name: Instance specification name, you can specify the specification name of the instance to be created. Value:
               rds.mysql.1c2g
               rds.mysql.2c4g
               rds.mysql.4c8g
               rds.mysql.4c16g
               rds.mysql.8c32g
               rds.mysql.16c64g
               rds.mysql.16c128g
               rds.mysql.32c128g
               rds.mysql.32c256g.
        :param pulumi.Input[str] instance_type: Instance type. Value:
               HA: High availability version.
        :param pulumi.Input[str] prepaid_period: The purchase cycle in the prepaid scenario. Value:
               Month: monthly subscription.
               Year: yearly subscription. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] project_name: Select the project to which the instance belongs. If this parameter is left blank, the new instance will not be added to any project. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] region: The region of the RDS instance.
        :param pulumi.Input[int] storage_space_gb: The storage space(GB) of the RDS instance.
        :param pulumi.Input[str] storage_type: Instance storage type. Value:
               LocalSSD: Local SSD disk.
        :param pulumi.Input[str] subnet_id: Subnet ID. The subnet must belong to the selected Availability Zone.
        :param pulumi.Input[str] super_account_name: Fill in the high-privileged user account name. The naming rules are as follows:
               Unique name.
               Start with a letter and end with a letter or number.
               Consists of lowercase letters, numbers, or underscores (_).
               The length is 2~32 characters.
               [Keywords](https://www.volcengine.com/docs/6313/66162) are not allowed for account names.
        :param pulumi.Input[str] super_account_password: Set a high-privilege account password. The rules are as follows:
               Only uppercase and lowercase letters, numbers and the following special characters _#!@$%^*()+=-.
               The length needs to be within 8~32 characters.
               Contains at least 3 of uppercase letters, lowercase letters, numbers or special characters.
        :param pulumi.Input[str] supper_account_password: supper_account_password is deprecated, use super_account_password instead Set a high-privilege account password. The rules are as follows:
               Only uppercase and lowercase letters, numbers and the following special characters _#!@$%^*()+=-.
               The length needs to be within 8~32 characters.
               Contains at least 3 of uppercase letters, lowercase letters, numbers or special characters.
        :param pulumi.Input[int] used_time: The purchase time of RDS instance. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] vpc_id: The vpc ID of the RDS instance.
        :param pulumi.Input[str] zone: The available zone of the RDS instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.rds.Instance("foo",
            charge_type="PostPaid",
            db_engine="MySQL",
            db_engine_version="MySQL_Community_5_7",
            instance_name="tf-test",
            instance_spec_name="rds.mysql.1c2g",
            instance_type="HA",
            region="cn-north-4",
            storage_space_gb=100,
            storage_type="LocalSSD",
            subnet_id="subnet-1g0d4fkh1nabk8ibuxx1jtvss",
            vpc_id="vpc-3cj17x7u9bzeo6c6rrtzfpaeb",
            zone="cn-langfang-b")
        ```

        ## Import

        RDS Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:rds/instance:Instance default mysql-42b38c769c4b
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 charge_type: Optional[pulumi.Input[str]] = None,
                 db_engine: Optional[pulumi.Input[str]] = None,
                 db_engine_version: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_spec_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 prepaid_period: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 storage_space_gb: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 super_account_name: Optional[pulumi.Input[str]] = None,
                 super_account_password: Optional[pulumi.Input[str]] = None,
                 supper_account_password: Optional[pulumi.Input[str]] = None,
                 used_time: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            if charge_type is None and not opts.urn:
                raise TypeError("Missing required property 'charge_type'")
            __props__.__dict__["charge_type"] = charge_type
            __props__.__dict__["db_engine"] = db_engine
            if db_engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'db_engine_version'")
            __props__.__dict__["db_engine_version"] = db_engine_version
            __props__.__dict__["instance_name"] = instance_name
            if instance_spec_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_spec_name'")
            __props__.__dict__["instance_spec_name"] = instance_spec_name
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["prepaid_period"] = prepaid_period
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["region"] = region
            if storage_space_gb is None and not opts.urn:
                raise TypeError("Missing required property 'storage_space_gb'")
            __props__.__dict__["storage_space_gb"] = storage_space_gb
            if storage_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_type'")
            __props__.__dict__["storage_type"] = storage_type
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["super_account_name"] = super_account_name
            __props__.__dict__["super_account_password"] = super_account_password
            if supper_account_password is not None and not opts.urn:
                warnings.warn("""supper_account_password is deprecated, use super_account_password instead""", DeprecationWarning)
                pulumi.log.warn("""supper_account_password is deprecated: supper_account_password is deprecated, use super_account_password instead""")
            __props__.__dict__["supper_account_password"] = supper_account_password
            __props__.__dict__["used_time"] = used_time
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["connection_info"] = None
        super(Instance, __self__).__init__(
            'volcengine:rds/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            charge_type: Optional[pulumi.Input[str]] = None,
            connection_info: Optional[pulumi.Input[pulumi.InputType['InstanceConnectionInfoArgs']]] = None,
            db_engine: Optional[pulumi.Input[str]] = None,
            db_engine_version: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            instance_spec_name: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            prepaid_period: Optional[pulumi.Input[str]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            storage_space_gb: Optional[pulumi.Input[int]] = None,
            storage_type: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            super_account_name: Optional[pulumi.Input[str]] = None,
            super_account_password: Optional[pulumi.Input[str]] = None,
            supper_account_password: Optional[pulumi.Input[str]] = None,
            used_time: Optional[pulumi.Input[int]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_renew: Whether to automatically renew. Default: false. Value:
               true: yes.
               false: no. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] charge_type: Billing type. Value:
               PostPaid: Postpaid (pay-as-you-go).
               Prepaid: Prepaid (yearly and monthly).
        :param pulumi.Input[pulumi.InputType['InstanceConnectionInfoArgs']] connection_info: The connection info ot the RDS instance.
        :param pulumi.Input[str] db_engine: Database type. Value:
               MySQL (default).
        :param pulumi.Input[str] db_engine_version: Instance type. Value:
               MySQL_Community_5_7
               MySQL_8_0.
        :param pulumi.Input[str] instance_name: Set the name of the instance. The naming rules are as follows:
               
               Cannot start with a number, a dash (-).
               It can only contain Chinese characters, letters, numbers, underscores (_) and underscores (-).
               The length needs to be within 1~128 characters.
        :param pulumi.Input[str] instance_spec_name: Instance specification name, you can specify the specification name of the instance to be created. Value:
               rds.mysql.1c2g
               rds.mysql.2c4g
               rds.mysql.4c8g
               rds.mysql.4c16g
               rds.mysql.8c32g
               rds.mysql.16c64g
               rds.mysql.16c128g
               rds.mysql.32c128g
               rds.mysql.32c256g.
        :param pulumi.Input[str] instance_type: Instance type. Value:
               HA: High availability version.
        :param pulumi.Input[str] prepaid_period: The purchase cycle in the prepaid scenario. Value:
               Month: monthly subscription.
               Year: yearly subscription. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] project_name: Select the project to which the instance belongs. If this parameter is left blank, the new instance will not be added to any project. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] region: The region of the RDS instance.
        :param pulumi.Input[int] storage_space_gb: The storage space(GB) of the RDS instance.
        :param pulumi.Input[str] storage_type: Instance storage type. Value:
               LocalSSD: Local SSD disk.
        :param pulumi.Input[str] subnet_id: Subnet ID. The subnet must belong to the selected Availability Zone.
        :param pulumi.Input[str] super_account_name: Fill in the high-privileged user account name. The naming rules are as follows:
               Unique name.
               Start with a letter and end with a letter or number.
               Consists of lowercase letters, numbers, or underscores (_).
               The length is 2~32 characters.
               [Keywords](https://www.volcengine.com/docs/6313/66162) are not allowed for account names.
        :param pulumi.Input[str] super_account_password: Set a high-privilege account password. The rules are as follows:
               Only uppercase and lowercase letters, numbers and the following special characters _#!@$%^*()+=-.
               The length needs to be within 8~32 characters.
               Contains at least 3 of uppercase letters, lowercase letters, numbers or special characters.
        :param pulumi.Input[str] supper_account_password: supper_account_password is deprecated, use super_account_password instead Set a high-privilege account password. The rules are as follows:
               Only uppercase and lowercase letters, numbers and the following special characters _#!@$%^*()+=-.
               The length needs to be within 8~32 characters.
               Contains at least 3 of uppercase letters, lowercase letters, numbers or special characters.
        :param pulumi.Input[int] used_time: The purchase time of RDS instance. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] vpc_id: The vpc ID of the RDS instance.
        :param pulumi.Input[str] zone: The available zone of the RDS instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["charge_type"] = charge_type
        __props__.__dict__["connection_info"] = connection_info
        __props__.__dict__["db_engine"] = db_engine
        __props__.__dict__["db_engine_version"] = db_engine_version
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_spec_name"] = instance_spec_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["prepaid_period"] = prepaid_period
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["region"] = region
        __props__.__dict__["storage_space_gb"] = storage_space_gb
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["super_account_name"] = super_account_name
        __props__.__dict__["super_account_password"] = super_account_password
        __props__.__dict__["supper_account_password"] = supper_account_password
        __props__.__dict__["used_time"] = used_time
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["zone"] = zone
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to automatically renew. Default: false. Value:
        true: yes.
        false: no. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> pulumi.Output[str]:
        """
        Billing type. Value:
        PostPaid: Postpaid (pay-as-you-go).
        Prepaid: Prepaid (yearly and monthly).
        """
        return pulumi.get(self, "charge_type")

    @property
    @pulumi.getter(name="connectionInfo")
    def connection_info(self) -> pulumi.Output['outputs.InstanceConnectionInfo']:
        """
        The connection info ot the RDS instance.
        """
        return pulumi.get(self, "connection_info")

    @property
    @pulumi.getter(name="dbEngine")
    def db_engine(self) -> pulumi.Output[Optional[str]]:
        """
        Database type. Value:
        MySQL (default).
        """
        return pulumi.get(self, "db_engine")

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> pulumi.Output[str]:
        """
        Instance type. Value:
        MySQL_Community_5_7
        MySQL_8_0.
        """
        return pulumi.get(self, "db_engine_version")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[str]]:
        """
        Set the name of the instance. The naming rules are as follows:

        Cannot start with a number, a dash (-).
        It can only contain Chinese characters, letters, numbers, underscores (_) and underscores (-).
        The length needs to be within 1~128 characters.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceSpecName")
    def instance_spec_name(self) -> pulumi.Output[str]:
        """
        Instance specification name, you can specify the specification name of the instance to be created. Value:
        rds.mysql.1c2g
        rds.mysql.2c4g
        rds.mysql.4c8g
        rds.mysql.4c16g
        rds.mysql.8c32g
        rds.mysql.16c64g
        rds.mysql.16c128g
        rds.mysql.32c128g
        rds.mysql.32c256g.
        """
        return pulumi.get(self, "instance_spec_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        Instance type. Value:
        HA: High availability version.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="prepaidPeriod")
    def prepaid_period(self) -> pulumi.Output[Optional[str]]:
        """
        The purchase cycle in the prepaid scenario. Value:
        Month: monthly subscription.
        Year: yearly subscription. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "prepaid_period")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[Optional[str]]:
        """
        Select the project to which the instance belongs. If this parameter is left blank, the new instance will not be added to any project. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The region of the RDS instance.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="storageSpaceGb")
    def storage_space_gb(self) -> pulumi.Output[int]:
        """
        The storage space(GB) of the RDS instance.
        """
        return pulumi.get(self, "storage_space_gb")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[str]:
        """
        Instance storage type. Value:
        LocalSSD: Local SSD disk.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Subnet ID. The subnet must belong to the selected Availability Zone.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="superAccountName")
    def super_account_name(self) -> pulumi.Output[Optional[str]]:
        """
        Fill in the high-privileged user account name. The naming rules are as follows:
        Unique name.
        Start with a letter and end with a letter or number.
        Consists of lowercase letters, numbers, or underscores (_).
        The length is 2~32 characters.
        [Keywords](https://www.volcengine.com/docs/6313/66162) are not allowed for account names.
        """
        return pulumi.get(self, "super_account_name")

    @property
    @pulumi.getter(name="superAccountPassword")
    def super_account_password(self) -> pulumi.Output[Optional[str]]:
        """
        Set a high-privilege account password. The rules are as follows:
        Only uppercase and lowercase letters, numbers and the following special characters _#!@$%^*()+=-.
        The length needs to be within 8~32 characters.
        Contains at least 3 of uppercase letters, lowercase letters, numbers or special characters.
        """
        return pulumi.get(self, "super_account_password")

    @property
    @pulumi.getter(name="supperAccountPassword")
    def supper_account_password(self) -> pulumi.Output[Optional[str]]:
        """
        supper_account_password is deprecated, use super_account_password instead Set a high-privilege account password. The rules are as follows:
        Only uppercase and lowercase letters, numbers and the following special characters _#!@$%^*()+=-.
        The length needs to be within 8~32 characters.
        Contains at least 3 of uppercase letters, lowercase letters, numbers or special characters.
        """
        warnings.warn("""supper_account_password is deprecated, use super_account_password instead""", DeprecationWarning)
        pulumi.log.warn("""supper_account_password is deprecated: supper_account_password is deprecated, use super_account_password instead""")

        return pulumi.get(self, "supper_account_password")

    @property
    @pulumi.getter(name="usedTime")
    def used_time(self) -> pulumi.Output[Optional[int]]:
        """
        The purchase time of RDS instance. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "used_time")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The vpc ID of the RDS instance.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The available zone of the RDS instance.
        """
        return pulumi.get(self, "zone")

