# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['IpListArgs', 'IpList']

@pulumi.input_type
class IpListArgs:
    def __init__(__self__, *,
                 group_name: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 ip_lists: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The set of arguments for constructing a IpList resource.
        :param pulumi.Input[str] group_name: The name of the RDS ip list.
        :param pulumi.Input[str] instance_id: The ID of the RDS instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_lists: The list of IP address.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "ip_lists", ip_lists)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[str]:
        """
        The name of the RDS ip list.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The ID of the RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="ipLists")
    def ip_lists(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of IP address.
        """
        return pulumi.get(self, "ip_lists")

    @ip_lists.setter
    def ip_lists(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "ip_lists", value)


@pulumi.input_type
class _IpListState:
    def __init__(__self__, *,
                 group_name: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering IpList resources.
        :param pulumi.Input[str] group_name: The name of the RDS ip list.
        :param pulumi.Input[str] instance_id: The ID of the RDS instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_lists: The list of IP address.
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if ip_lists is not None:
            pulumi.set(__self__, "ip_lists", ip_lists)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the RDS ip list.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="ipLists")
    def ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of IP address.
        """
        return pulumi.get(self, "ip_lists")

    @ip_lists.setter
    def ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_lists", value)


class IpList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        (Deprecated! Recommend use volcengine_rds_mysql_*** replace) Provides a resource to manage rds ip list
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.rds.IpList("foo",
            group_name="foo",
            instance_id="mysql-0fdd3bab2e7c",
            ip_lists=[
                "1.1.1.1",
                "2.2.2.2",
            ])
        ```

        ## Import

        RDSIPList can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:rds/ipList:IpList default mysql-42b38c769c4b:group_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_name: The name of the RDS ip list.
        :param pulumi.Input[str] instance_id: The ID of the RDS instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_lists: The list of IP address.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        (Deprecated! Recommend use volcengine_rds_mysql_*** replace) Provides a resource to manage rds ip list
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.rds.IpList("foo",
            group_name="foo",
            instance_id="mysql-0fdd3bab2e7c",
            ip_lists=[
                "1.1.1.1",
                "2.2.2.2",
            ])
        ```

        ## Import

        RDSIPList can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:rds/ipList:IpList default mysql-42b38c769c4b:group_name
        ```

        :param str resource_name: The name of the resource.
        :param IpListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpListArgs.__new__(IpListArgs)

            if group_name is None and not opts.urn:
                raise TypeError("Missing required property 'group_name'")
            __props__.__dict__["group_name"] = group_name
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if ip_lists is None and not opts.urn:
                raise TypeError("Missing required property 'ip_lists'")
            __props__.__dict__["ip_lists"] = ip_lists
        super(IpList, __self__).__init__(
            'volcengine:rds/ipList:IpList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_name: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'IpList':
        """
        Get an existing IpList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_name: The name of the RDS ip list.
        :param pulumi.Input[str] instance_id: The ID of the RDS instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_lists: The list of IP address.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpListState.__new__(_IpListState)

        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["ip_lists"] = ip_lists
        return IpList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[str]:
        """
        The name of the RDS ip list.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The ID of the RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="ipLists")
    def ip_lists(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of IP address.
        """
        return pulumi.get(self, "ip_lists")

